#SPEC -realname ''helicoidal curve''

# no shape
if {[llength [.amapi scene]] == 0} return

# it's not a curve
newshape shape [.amapi current]
if {[shape -curve] == 0} return

# set closed flag
set closed [shape -closed]

# call tool ruler (get origin & offset)
set result [ruler]
set orig [.match $result orig -point3d]
set offset [.match $result vector -vector]

# user canceled ruler
if {$offset == "" || $orig == ""} return

# verify origin belongs to curve
set points [shape -points]
for {set i 0} {$i < [llength $points]} {incr i} {
	if {[lindex $points $i] == $orig} break
}
if {$i == [llength $points]} return
set index $i

#calculate new shape
newshape result {
	# if cloded curve
	if {$closed == 1} {
		addpoint [lindex $points $index]
		set ind [expr {$index + 1}]
		set numpts [llength $points]
		
		for {set i 0} {$i < $numpts} {incr i} {
			if {$ind == $numpts} {
				set ind 0
			}
		
			set x [expr {[lindex $offset 0] * ($i + 1) / $numpts}]
			set y [expr {[lindex $offset 1] * ($i + 1) / $numpts}]
			set z [expr {[lindex $offset 2] * ($i + 1) / $numpts}]
			
			addpoint [vertex add [list $x $y $z] [lindex $points $ind]]
			
			incr ind
		}
	} else {
		# first mountain
		set ind 0
		set numpts $index
		for {set i 0} {$i < $numpts} {incr i} {
			set x [expr {[lindex $offset 0] * $i / $numpts}]
			set y [expr {[lindex $offset 1] * $i / $numpts}]
			set z [expr {[lindex $offset 2] * $i / $numpts}]
			addpoint [vertex add [list $x $y $z] [lindex $points $ind]]
			
			incr ind
		}
		
		# second mountain
		set ind $index
		set numpts [expr {[llength $points] - $index - 1}]
		for {set i 0} {$i <= $numpts} {incr i} {
			if {$numpts != 0} {
				set x [expr {[lindex $offset 0] * ($numpts - $i) / $numpts}]
				set y [expr {[lindex $offset 1] * ($numpts - $i) / $numpts}]
				set z [expr {[lindex $offset 2] * ($numpts - $i) / $numpts}]
			} else {
				set x [lindex $offset 0]
				set y [lindex $offset 1]
				set z [lindex $offset 2]
			}
			addpoint [vertex add [list $x $y $z] [lindex $points $ind]]
			
			incr ind
		}
	}
}
result -status open
result -checkin
