#SPEC -realname ''make a cylinder''

set res [getvalue -type1 ''int'' -name1 ''nb tranches'' -value1 10 -type2 ''world'' -name2 ''hauteur'' -value2 5 -type3 ''world'' -name3 ''rayon'' -value3 4]
if {$res == ""} return

set nbslices [.match $res result1 -int]
set high [.match $res result2 -world]
set radiu [.match $res result3 -world]

set oldplane [.amapi plane]
.amapi setplane -viewup
set circ [.match [circle -radius [.world2unit $radiu] -numpts 8 -orig {0 0 0}] shape -shape]
if {$circ == ""} return
newshape mycircle $circ

.amapi setplane -viewfront
set pt1 [lindex [mycircle -points] 0]
set pt2 [list [lindex $pt1 0] [expr [lindex $pt1 1] + $high] [lindex $pt1 2]]

newshape myprofil {
	addpoint $pt1
	addpoint $pt2
}
myprofil -status open 
myprofil -checkin

set prof [myprofil -ref]
set profil [smooth -shape $prof -range $nbslices]

extrude -curve1 $circ -curve2 $profil -close
set newplane [.match $oldplane plane -string]
.amapi setplane $newplane
