#SPEC -realname ''make a cone''

set res [getvalue -type1 ''int'' -name1 ''steps'' -value1 10 -type2 ''world'' -name2 ''height'' -value2 5 -type3 ''world'' -name3 ''radius'' -value3 4]
if {$res == ""} return

set nbslices [.match $res result1 -int]
set high [.match $res result2 -world]
set radiu [.match $res result3 -world]

set oldplane [.amapi plane]
.amapi setplane -viewup
set origin {0 0 0}

set circ [.match [circle -radius [.world2unit $radiu] -numpts $nbslices -orig $origin] shape -shape]
if {$circ == ""} return

newshape mycircle $circ

.amapi setplane -viewfront

set pt1 [list [expr [lindex $origin 0] + $radiu] [lindex $origin 1] [lindex $origin 2]]
set pt2 [list [lindex $origin 0] [expr [lindex $pt1 1] + $high] [lindex $origin 2]]

newshape myprofil {
	addpoint $pt1
	addpoint $pt2
}
myprofil -status open 
myprofil -checkin

set prof [myprofil -ref]
set profil [smooth -shape $prof -range $nbslices]

extrude -curve1 $circ -curve2 $profil -close

set newplane [.match $oldplane plane -string]
.amapi setplane $newplane

