# create a new window
.amapi newwindow

#insert short cut to stop tutorial
binding -insertglobal "s" <> "cd \"$HELPWD\"; source us_close.tcl"

#get running system and set corresponding local messages
set mysystem [.amapi getsystem]
if {$mysystem == "macos"} {
	set ALTmsg "APPLE"
	set OPTIONmsg "OPTION Key + Mouse Button"
}
if {$mysystem == "windows" || $mysystem == "x11" || $mysystem == "pxp"} {
	set ALTmsg "ALT"
	set OPTIONmsg "Right Mouse Button"
}

set tutostopmsg ""
verbose -text ''/left /n /n /n /normal BEGIN OF TUTORIAL \
				/n /n /red ACTION.....: /yellow Mouse Button \
				/n    /red OPTIONS....: /yellow $OPTIONmsg \
				/n    /red VALIDATE...: /yellow "Enter" Key \
				/n    /red TOGGLE.....: /yellow "Space" Key \
				/n    /red CALIBRATE..: /yellow "Tabulation" Key \
				/n    /red PUT ASIDE..: /yellow Drag mouse Outside of the screen by the Right \
				/n /n /normal When you want, you can hit /red 'S' /normal to stop the tutorial \
				/n /n /normal Click to continue ''
verbose -bmap ''bmap_export'' -pos {0 0 0}

# utility hook function to filter key events, ex:
# set filterchar "5"
# .passevent -hook ischar

#set several usefuls hook function to filter events

proc ischar {msg} {
	global filterchar # just set filterchar
	if {$msg == "key"} {
		if {[.event key] == $filterchar} {
			return "rtrn"
		}
	}
	return "forget"
}

# accept and return only event key "s" and event basculate
proc StopandBasculate {msg} {
	if {$msg == "key"} {
		set key [.event key]
		if {$key == "s" || $key == " "} {
			return "accept"
		}
	}
	if {$msg == "basculate"} {
		return "rtrn"
	}
	return "forget"
}

# accept and return only event key "s" and event leftbtn
proc StopandLeftbtn {msg} {
	if {$msg == "key"} {
		set key [.event key]
		if {$key == "s"} {
			return "accept"
		}
	}
	if {$msg == "leftbtn"} {
		return "rtrn"
	}
	return "forget"
}

# accept only event key "s" and passover event leftbtn
proc PassLeftbtn {msg} {
	if {$msg == "key"} {
		set key [.event key]
		if {$key == "s"} {
			return "accept"
		}
	}
	if {$msg == "leftbtn"} {
		return "passover"
	}
	return "forget"
}

# accept and return only event key "s" and event shift
proc StopandShift {msg} {
	if {$msg == "key"} {
		set key [.event key]
		if {$key == "s"} {
			return "accept"
		}
	}
	if {$msg == "shift"} {
		return "rtrn"
	}
	return "forget"
}

# accept and return only event validate
proc OnlyValidate {msg} {
	if {$msg == "key"} {
		set key [.event key]
		if {$key == "return"} {
			return "rtrn"
		}
	}
	return "forget"
}

# accept and return only event edit
proc StopandEdit {msg} {
	if {$msg == "key"} {
		set key [.event key]
		if {$key == "s" || $key == "tab"} {
			return "rtrn"
		}
	}
	return "forget"
}

# accept and return only event key "s" and event cancel
proc StopandCancel {msg} {
	if {$msg == "key"} {
		set key [.event key]
		if {$key == "s"} {
			return "accept"
		}
	}
	if {$msg == "cancel"} {
		return "rtrn"
	}
	return "forget"
}

# accept and return only event key "s" and event cancel
proc StopandDel {msg} {
	if {$msg == "key"} {
		set key [.event key]
		if {$key == "s" || $key == "backspace"} {
			return "rtrn"
		}
	}
	return "forget"
}

# accept and return only event of the arrows key
proc StopandArrows {msg} {
	if {$msg == "key"} {
		set key [.event key]
		if {$key == "s" || $key == "left" || $key == "right" || $key == "up" || $key == "down"} {
			return "rtrn"
		}
	}
	return "forget"
}

# accept and return only event key "s" but pass over the event leftbtn
proc StopandPassLeftbtn {msg} {
	if {$msg == "key"} {
		set key [.event key]
		if {$key == "s"} {
			return "accept"
		}
	}
	if {$msg == "leftbtn"} {
		return "passover"
	}
	return "forget"
}

.passevent -hook StopandPassLeftbtn
