#SPEC -realname ''5 - Shell''

cd $HELPWD
source us_open.tcl

.unit
.angle
	
#set tutomovemsg "/n /normal You can also use arrows \
#				/n to move in the scene"
set tutomovemsg ""

verbose -text ''/left We are going to create a surface from three curves. \
				/n These curves have to be constructed in the 3 conventional planes. \
				/n For that, we have first to move on the left view \
				/n Click on /red ACTION /normal to continue \
				$tutostopmsg''
				
.passevent -hook PassLeftbtn
				
.amapi move3d sidewest

verbose -text ''/left We are going to create an arc of circle in this plane \
				/n this arc will be the SECTION \
				/n Click on /red ACTION /normal to continue \
				$tutostopmsg''

.passevent -hook PassLeftbtn

set refarc [arc -orig {-50 0 0} -radius 20 -numpts 17 -angle -180 -firstpoint {-50 0 -20} -center {-50 0 0}]

set refcurv1 [.match $refarc shape -shape]

newshape curv1 $refcurv1

verbose -text ''/left Now, we move to the top view \
				/n Click on /red ACTION /normal to continue \
				$tutostopmsg''
				
.passevent -hook PassLeftbtn
				
.amapi move3d sideup

verbose -text ''/left We are going to create a curve in this plane \
				/n This will be the OUTLINE \
				/n Click on /red ACTION /normal to continue \
				$tutostopmsg''
				
.passevent -hook PassLeftbtn

newshape curv3 {
	addpoint {-50 0 -20}
	addpoint {-45 0 -15}
	addpoint {45 0 -20}
}

curv3 -status open

set refcurv3 [curv3 -ref]

curv3 -checkin

verbose -text ''/left Let's go now to the front view \
				/n Click on /red ACTION /normal to continue \
				$tutostopmsg''
				
.passevent -hook PassLeftbtn

.amapi move3d sidesouth

verbose -text ''/left A curve will be created in this plane \
				/n This curve will be the PROFILE \
				/n Click on /red ACTION /normal to continue \
				$tutostopmsg''

.passevent -hook PassLeftbtn
				
newshape curv2 {
	addpoint {10 20 0}
	addpoint {30 18 0}
	addpoint {70 15 0}
	addpoint {80 8 0}
	addpoint {90 4 0}
	addpoint {105 1 0}
}

curv2 -status open

set refcurv2 [curv2 -ref]

curv2 -checkin

fitview

verbose -text ''/left We are now going to snap the PROFILE on the SECTION \
				/n Click on /red ACTION /normal to continue \
				$tutomovemsg \
				$tutostopmsg''
				
.passevent -accept {key} -passover {leftbtn}

set refmovecurv2 [move -shape $refcurv2 -move {-60 0 0}]

verbose -text ''/left Now, a SHELL surface is going to be created between these 3 curves \
				/n by clicking, in the order, the SECTION, the PROFILE, and last the OUTLINE \
				/n Click on /red ACTION /normal to continue \
				$tutomovemsg \
				$tutostopmsg''
				
.passevent -accept {key} -passover {leftbtn}

.background hull -shapes $refcurv1 $refmovecurv2 $refcurv3

fitview

verbose -text ''/left That's it ! You know now how to build a SHELL surface from 3 curves \
				/n Click on /red ACTION /normal to continue \
				$tutomovemsg \
				$tutostopmsg''
				
.passevent -accept {key} -passover {leftbtn}

cd $HELPWD
source us_close.tcl
