#SPEC -realname ''4 - Smoothing''

cd $HELPWD
source us_open.tcl
				
cube -base {0 0 0} -dimx 10 -dimy 10 -dimz 10
fitview

#set tutomovemsg "/n /yellow You can also use arrows \
#				/n to move in the scene"
set tutomovemsg ""

verbose -text ''/up You want to smooth the current shape \
				/n for that, we have to use the SMOOTHING tool \
				/n that we have selected for you. \
				/n You see that the smoothing range appears \
				/n To increase it, hit /red the key "PLUS" \
				$tutomovemsg \
				$tutostopmsg''
				
.background smooth

.passevent -accept {key} -rtrn {plus}

verbose -text ''/up You can increase again the smoothing range \
				/n To increase it, hit /red the key "PLUS" \
				$tutomovemsg \
				$tutostopmsg''
				
.passevent -accept {key} -rtrn {plus}

verbose -text ''/up You can now decrease the smoothing range \
				/n For that, hit /red the key "MINUS" \
				$tutomovemsg \
				$tutostopmsg''
				
.passevent -accept {key} -rtrn {minus}

verbose -text ''/up We are now going to set the smoothing range to 8 \
				/n For that, hit /red the CALIBRATE key \
				/n /yellow CALIBRATE key is the TAB key /normal \
				$tutomovemsg \
				$tutostopmsg''
				
.passevent -accept {key} -rtrn {edit}

.event key <> "8"

.event key <> return
		
verbose -text ''/up The smoothing range is now set to 8\
				/n You are going to quit the SMOOTHING tool by /red PUTTING ASIDE \
				$tutomovemsg \
				$tutostopmsg''
				
.passevent -accept {key} -rtrn {shift}

verbose -text ''/up We are now going to use the SMOOTHING tool again, \
				/n by clicking /red ACTION \
				$tutomovemsg \
				$tutostopmsg''

.passevent -accept {key} -rtrn {leftbtn}

.background smooth

verbose -text ''/up You can see that the smoothing range has been kept. \
				/n You can cancel the selected range \
				/n by pressing /red the CANCEL key \
				/n /yellow The cancel key is the key $ALTmsg with the key "Z" /normal \
				$tutomovemsg \
				$tutostopmsg''
				
.passevent -accept {key} -rtrn {cancel}

verbose -text ''/up We are now going to take the SMOOTHING tool again, \
				/n by clicking /red ACTION \
				$tutomovemsg \
				$tutostopmsg''

.passevent -accept {key} -rtrn {leftbtn}

.background smooth

if {$mysystem == "macos"} {
verbose -text ''/up We are now going to select the sharp edges \
				/n with the lasso selection tool \
				/n /normal for that, click on /red OPTIONS \
				/n /yellow OPTIONS is hitting on the OPTION key and click on mouse button /normal \
				$tutomovemsg \
				$tutostopmsg''
} else {
verbose -text ''/up We are now going to select the sharp edges \
				/n with the lasso selection tool \
				/n /normal for that, click on /red OPTIONS \
				/n /yellow OPTIONS is the rightbutton of your mouse /normal \
				$tutomovemsg \
				$tutostopmsg''
}
				
.passevent -accept {key} -rtrn {rightbtn}

verbose -text ''/up Now, select the sharp edges. \
				/n Select the first point \
				/n by clicking on /red ACTION \
				$tutomovemsg \
				$tutostopmsg''
				
.passevent -accept {key} -rtrn {leftbtn}

verbose -text ''/up Select the second point \
				/n by clicking on /red ACTION \
				$tutomovemsg \
				$tutostopmsg''
				
.passevent -accept {key} -rtrn {leftbtn}

verbose -text ''/up Select the third point \
				/n by clicking on /red ACTION \
				$tutomovemsg \
				$tutostopmsg''
				
.passevent -accept {key} -rtrn {leftbtn}

verbose -text ''/up Select the fourth point \
				/n by clicking on /red ACTION \
				$tutomovemsg \
				$tutostopmsg''
				
.passevent -accept {key} -rtrn {leftbtn}

verbose -text ''/up Validate the selection zone \
				/n by pressing on the /red VALIDATE key /normal \
				/n /yellow VALIDATE is the "Enter" key /normal \
				$tutomovemsg \
				$tutostopmsg''
				
.passevent -accept {key} -rtrn {validate}

verbose -text ''/up You can see that the selected edges \
				/n are becomed sharp edges \
				/n To validate this new shape, hit the /red VALIDATE key \
				$tutomovemsg \
				$tutostopmsg''
				
.passevent -accept {key} -rtrn {validate}

verbose -text ''/up We are now going to take the SMOOTHING tool again, \
				/n by clicking on /red ACTION \
				$tutomovemsg \
				$tutostopmsg''

.passevent -accept {key} -rtrn {leftbtn}

.background smooth			
				
verbose -text ''/up You can see that the smoothing range \
				/n AND the sharp edges have been kept. \
				$tutomovemsg \
				$tutostopmsg''

.passevent -accept {key} -rtrn {leftbtn}

cd $HELPWD
source us_close.tcl
