#SPEC -realname ''3 - Lasso''

cd $HELPWD
source us_open.tcl
				
sphere -base {0 0 0} -radius 10 -points 8
.amapi move3d sidesouth
fitview

#set tutomovemsg "/n /yellow You can also use arrows \
#				/n to move in the scene"
set tutomovemsg ""

if {$mysystem == "macos"} {
verbose -text ''/up Choose the LASSO SELECTION tool\
				/n by pressing /red OPTIONS /normal \
				/n /yellow OPTIONS is hitting on the OPTION key and click on mouse button /normal \
				$tutomovemsg \
				$tutostopmsg''
} else {
verbose -text ''/up Choose the LASSO SELECTION tool\
				/n by pressing /red OPTIONS /normal \
				/n /yellow OPTIONS is the rightbutton of your mouse /normal \
				$tutomovemsg \
				$tutostopmsg''
}

.passevent -accept {key} -rtrn {rightbtn}

verbose -text ''/up You are now in the LASSO SELECTION tool \
				/n You can begin to select points \
				/n Select the first point of the lasso \
				/n by clicking on /red ACTION \
				$tutomovemsg \
				$tutostopmsg''
				
.passevent -accept {key} -rtrn {leftbtn}

verbose -text ''/up You are still in the lasso selection tool \
				/n you are going to select the second point of the lasso \
				/n by clicking on /red ACTION \
				$tutomovemsg \
				$tutostopmsg''
				
.passevent -accept {key} -rtrn {leftbtn}

verbose -text ''/up You are still in the lasso selection tool \
				/n you are going to select the third point of the lasso \
				/n by clicking on /red ACTION \
				$tutomovemsg \
				$tutostopmsg''
				
.passevent -accept {key} -rtrn {leftbtn}

set curevt 0
while {$curevt != "validate"} {
	verbose -text ''/up You are still in the lasso selection tool \
					/n you have now got a selection area \
					/n you can expand it by selecting another point \
					/n for that click on /red ACTION \
					/n /normal You can also validate it \
					/n for that, hit the /red VALIDATE key /yellow ("Enter" key) /normal \
					$tutomovemsg \
					$tutostopmsg''
					
	set curevt [.passevent -accept {key} -rtrn {leftbtn validate}]
}

verbose -text ''/up now, you want to stretch this selection \
				/n to do this, we have to use the STRETCH tool \
				/n that we have selected for you. \
				/n To stretch the selection \
				/n click on /red ACTION \
				$tutomovemsg \
				$tutostopmsg''
				
.background strech

.passevent -accept {key} -rtrn {leftbtn}

verbose -text ''/up You want to stretch the selection \
				/n To fix the new location of the stretched selection \
				/n click on /red ACTION \
				$tutomovemsg \
				$tutostopmsg''

.passevent -accept {key} -rtrn {leftbtn}

verbose -text ''/up You can now quit the STRETCH tool\
				/n For that /red PUT ASIDE \
				$tutomovemsg \
				$tutostopmsg''

.passevent -accept {key} -rtrn {shift}

verbose -text ''/up You want now resize the selection \
				/n for that, we have to use the EXPAND tool \
				/n that we have selected for you. \
				/n You can resize vertically or horizontally \
				/n To resize in an other dimension, /red TOGGLE \
				/n /yellow e.g. hit Space Bar /normal \
				$tutomovemsg \
				$tutostopmsg''
				
.background axescale

.passevent -accept {key} -rtrn {basculate}

verbose -text ''/up Now, you want to choose the reference point of the scaling \
				/n for that, click on /red OPTIONS \
				$tutomovemsg \
				$tutostopmsg''
				
.passevent -accept {key} -rtrn {rightbtn}

verbose -text ''/up Fix the reference point of the scaling \
				/n by clicking /red ACTION \
				$tutomovemsg \
				$tutostopmsg''
				
.passevent -accept {key} -rtrn {leftbtn}

verbose -text ''/up Begin the scaling operation \
				/n by clicking on /red ACTION \
				$tutomovemsg \
				$tutostopmsg''
				
.passevent -accept {key} -rtrn {leftbtn}

verbose -text ''/up Choose the size of the scaling \
				/n and validate the operation by clicking on /red ACTION \
				$tutomovemsg \
				$tutostopmsg''
				
.passevent -accept {key} -rtrn {leftbtn}

verbose -text ''Quit the EXPAND tool  \
				/n /red by PUTING ASIDE \
				$tutomovemsg \
				$tutostopmsg''
	
.passevent -accept {key} -rtrn {shift}
.passevent -accept {key} -rtrn {leftbtn}

cd $HELPWD
source us_close.tcl

