#SPEC -realname ''2 - Self training''

cd $HELPWD
source us_open.tcl

#set tutomovemsg "/n /normal You can also use arrows \
#				/n to move in the scene"
set tutomovemsg ""


verbose -text ''/left In this tutorial, we will learn you how to construct an object \
                /n but it's up to you to do it \
                /n We thought creating a hat would be something interesting \
                /n for that we need to use the EXTRUSION tool \
				/n Therefore in order to use this tool we need to create a cross section \
				/n and be in "top view" \
				/n for that use the /red numeric key "5" \
				$tutostopmsg''

set filterchar "5"
.passevent -hook ischar

verbose -text ''/left Now we are going to use the circle as a cross section \
				/n we will launch CIRCLE tool for you \
                /n for that, /red click on ACTION \
				$tutostopmsg''

.passevent -hook PassLeftbtn

#Launch the tool cicle in background with the origin {0 0 0}.
.background circle -orig { 0 0 0 }

verbose -text ''/left Now place the center of the circle \
                /n for that /red click on ACTION \
				$tutostopmsg''

.passevent -hook StopandLeftbtn

verbose -text ''/left And now define the radius \
                /n for that, place a second point \
                /n with a /red click on ACTION \
				$tutostopmsg''

.passevent -hook StopandLeftbtn

set lscene [llength [.amapi scene] ]
while {$lscene == 0} {
    verbose -text ''/left You have clicked at the same place as the center \
                /n Replace the second point \
                /n with a /red click on ACTION \
				$tutostopmsg''

   .passevent -hook StopandLeftbtn
   set lscene [llength [.amapi scene] ]
}

verbose -text ''/left Now you can quit this tool \
                /n /red PUT it ASIDE \
                /n /normal with dragging the mouse outside in the right of the screen \
				$tutostopmsg''

.passevent -hook StopandShift

while {[.event shift] != "right"} {
	.event shift right
	verbose -text ''/left you have not dragged the mouse at right \
                /n /red Put again it aside \
				$tutostopmsg''

	.passevent -hook StopandShift
}

#fitview
verbose -text ''/left To extrude this circle \
                /n you must be in view perpendiculer to the cross section \
				/n so come back in "front view" \
				/n help yourself with the /red numeric key "2" ''

# accept and  only "2" event key
set filterchar "2"
.passevent -hook ischar

verbose -text ''/left Now we will take the EXTRUSION tool \
				/n we will launch it for you \
                /n for that, /red click on ACTION \
				$tutostopmsg''

.passevent -hook PassLeftbtn

#Launch the tool extrusion in background.
.background extrude

verbose -text ''/left Now take the circle \
				/n for that /red click on ACTION \
				$tutostopmsg''

.passevent -hook StopandLeftbtn

verbose -text ''/left If you want, You can extrude only in a given axes, horizontal or vertical, \
				/n do you see how flexible it is? Magic isn't it? \
				/n Try in vertical axe using /red TOGGLE key (space bar) \
				$tutostopmsg''

.passevent -hook StopandBasculate

verbose -text ''/left You are now in horizontal axe \
				/n but you want to be in vertical axe \
				/n so hit again the /red TOGGLE key (space bar)\
				$tutostopmsg''

.passevent -hook StopandBasculate

verbose -text ''/left Now /red click /normal in the scene \
				/n to put the first point of extrusion \
				/n Try to be in proportion for the hat ! \
				$tutostopmsg''

.passevent -hook StopandLeftbtn

verbose -text ''/left Now try horizontal axe with hitting the /red TOGGLE key\
				$tutostopmsg''

.passevent -hook StopandBasculate

verbose -text ''/left you are NOT in horizontal axe \
				/n so hit again the /red TOGGLE key \
				$tutostopmsg''

.passevent -hook StopandBasculate

verbose -text ''/left You are now in horizontal axe \
				/n /red click /normal in the scene \
				/n to put the second point of extrusion \
				/n Try to be again in proportion for the hat! \
				$tutostopmsg''

.passevent -hook StopandLeftbtn

verbose -text ''/left Your hat has yet a design \
				/n You have to /red VALIDATE ("Enter" key) /normal it \
				$tutomovemsg \
				$tutostopmsg''

# accept all event key and return only event validate
.passevent -accept {key} -rtrn {validate}
fitview

verbose -text ''/left You can see that the top and the bottom are red \
				/n It means that they are open \
				/n To close them, click on the one you want to close. \
				/n We will close the bottom \
				/n so /red click on it \
				$tutomovemsg \
				$tutostopmsg''

# accept all event key and return only event leftbtn
.passevent -accept {key} -rtrn {leftbtn}

verbose -text ''/left Now you can quit this tool \
                /n /red PUT it ASIDE \
                /n /normal with dragging the mouse outside in the right of the screen \
				$tutomovemsg \
				$tutostopmsg''

# accept all event key and return only event shift
.passevent -accept {key} -rtrn {shift}

while {[.event shift] != "right"} {
	.event shift right
	verbose -text ''/left you have not dragged the mouse at right \
                /n /red Put again it aside \
				$tutostopmsg''

	.passevent -accept {key} -rtrn {shift}
}

 verbose -text ''/left Now we will take the SMOOTH tool \
				/n to increase mesh definition on the active element \
                /n to launch it, /red click on ACTION \
				$tutomovemsg \
				$tutostopmsg''

.passevent -accept {key} -passover {leftbtn}

#launch the tool smooth in background
.background smooth

 verbose -text ''/left the smooth icone appears on the top left hand corner of the screen \
				/n so, we are in the SMOOTH tool \
                /n the density is 3 by default, you can increase it by hit on /red "PLUS" \
                /n /normal try \
				$tutomovemsg \
				$tutostopmsg''

# accept all event key and return only event plus
.passevent -accept {key} -rtrn {plus}

verbose -text ''/left You can also modify the range with new entry \
				/n hit on the key /red CALIBRATE /normal to enter a new range \
				/n (CALIBRATE key is the TAB key) \
				$tutostopmsg''

# accept all event key and return only event edit
.passevent -hook StopandEdit

verbose -text ''/left For exemple you will enter the range 3 \
                /n Hit on the /red key "3" \
				$tutomovemsg ''

set filterchar "3"
.passevent -hook ischar

verbose -text ''/left Now validate this range \
                /n by hitting on the key /red VALIDATE \
				$tutomovemsg''

# accept all event key and return only event validate
.passevent -hook OnlyValidate

verbose -text ''/left The range of the smooth is now 3 \
                /n Now you can validate the smooth to all the shape \
				/n hit on the key /red VALIDATE /normal to generate the smooth \
				/n You will directly quit the smooth tool \
				$tutomovemsg \
				$tutostopmsg''

# accept all event key and return only event validate
.passevent -accept {key} -rtrn {validate}

verbose -text ''/left Finally, we will SHADE our hat \
				/n /red click on ACTION /normal to launch the FLAT SHADING tool \
				$tutomovemsg \
				$tutostopmsg''

.passevent -accept {key} -passover {leftbtn}

#Launch the tool paint in background.
.background paint

verbose -text ''/left First we will choose a new color \
				/n /red TOGGLE /normal to have the stick \
				$tutomovemsg \
				$tutostopmsg''

.passevent -accept {key} -rtrn {basculate}

verbose -text ''/left /red Click /normal on the shape \
                /n and a dialog with choice of color will appear \
				$tutomovemsg \
				$tutostopmsg''

.passevent -accept {key} -rtrn {leftbtn}

verbose -text ''/left /red Click /normal in the circle of color to choose one color \
				$tutomovemsg \
				$tutostopmsg''

.passevent -passover {leftbtn}

verbose -text ''/left /red Click /normal on OK to validate the choice \
				$tutomovemsg \
				$tutostopmsg''

.passevent -passover {leftbtn}
.event key <> return

verbose -text ''/left Now you have come back to the shape \
				/n /red TOGGLE /normal to come back to the area \
				$tutomovemsg \
				$tutostopmsg''

.passevent -accept {key} -rtrn {basculate}

verbose -text ''/left /red Click on ACTION /normal to place the center of the area \
				$tutomovemsg \
				$tutostopmsg''

.passevent -accept {key} -rtrn {leftbtn}

verbose -text ''/left /red Click on ACTION /normal to fix one corner of the area \
				/n Try to surround all the shape \
				/n This action will paint your hat \
				$tutomovemsg \
				$tutostopmsg''

.passevent -accept {key} -rtrn {leftbtn}

verbose -text ''/left Now you can quit this tool \
                /n /red PUT it ASIDE \
                /n /normal with dragging the mouse outside in the right of the screen \
				$tutomovemsg \
				$tutostopmsg''

.passevent -accept {key} -rtrn {shift}

while {[.event shift] != "right"} {
	.event shift right
	verbose -text ''/left you have not dragged the mouse at right \
                /n /red Put again it aside \
				$tutostopmsg''

	.passevent -accept {key} -rtrn {shift}
}

verbose -text ''/left And for the end, you will clean all the scene \
				/n For that we will launch the DASHBOARD \
				/n to take the laser \
				/n /red put bottom /normal to launch the DASHBOARD \
				/n it means drag the mouse outside of the screen by the bottom  \
				$tutostopmsg''

.passevent -hook StopandShift

while {[.event shift] != "bottom"} {
	.event shift right
	verbose -text ''/left you have not dragged the mouse bottom of the screen \
                /n /red Put again it bottom \
				$tutostopmsg''

	.passevent -hook StopandShift
}

.background cpanel

verbose -text ''/left Then take the laser \
				/n /red click on ACTION /normal to take it \
				$tutostopmsg''

.passevent -hook PassLeftbtn

#Launch the tool laser in background.

.event shift right
.event shift right

.background laser

verbose -text ''/left And now activate the laser \
				/n to delete the active shape \
				/n /red click on ACTION /normal to do it \
				$tutostopmsg''

.passevent -hook StopandLeftbtn

verbose -text ''/left Now you can quit this tool \
                /n /red PUT it ASIDE \
                /n /normal with dragging the mouse outside in the right of the screen \
				$tutomovemsg \
				$tutostopmsg''

# accept all event key and return only event shift
.passevent -accept {key} -rtrn {shift}

while {[.event shift] != "right"} {
	.event shift right
	verbose -text ''/left you have not dragged the mouse at right \
                /n /red Put again it aside \
				$tutostopmsg''

	.passevent -accept {key} -rtrn {shift}
}

verbose -text ''/left Your scene is now clean \
				/n you can go out of the tutorial \
				/n /red click on ACTION /normal to do it \
				$tutostopmsg''

.passevent -hook PassLeftbtn

verbose -text ''/left The next tutorials are there to explain you how to use each tools \
				/n We will do all the action for you and explain you what we are doing \
				/n /red click on ACTION /normal to do it \
				$tutostopmsg''

.passevent -hook PassLeftbtn


cd $HELPWD
source us_close.tcl
