#SPEC -realname ''1 - Getting started''

cd $HELPWD
source us_open.tcl

#set tutomovemsg "/n /normal You can also use arrows \
#				/n to move in the scene"
set tutomovemsg ""

verbose -text ''/left Welcome in the first tutorial. \
                /n We will learn you how to use Amapi the first time. \
				/n How to use the tools and how to move in the scene \
				/n Click on /red ACTION /normal to continue \
				/n /yellow click ACTION means click on the mouse button /normal \
				$tutostopmsg''
				
.passevent -hook PassLeftbtn

verbose -text ''/left AMAPI is one of the most intuitive, \
                /n and easy-to-use 3D Modeling package there is. \
				/n This is not just another 3D Modeler, \
				/n the following Hands-On Tutorial will show you \
				/n how easy it is to create and modify your design, \
				/n and there is nothing quite like AMAPI. \
				/n Click on /red ACTION /normal /yellow (mouse button) /normal to continue \
				$tutostopmsg''
				
.passevent -hook PassLeftbtn

verbose -text ''/left With AMAPI the design process is easy, \
                /n the commands are in pallets and icons that are self explanetory, \
				/n they are placed in, what we call the tool boxes. \
				/n They are three tool boxes \
				/n The first one is the CONSTRUCTION tool box \
				/n you can see it at right \
				/n With this tool box you will create the basic entities \
				/n and objects of your design. \
				/n To see the second tool box, /red PUT ASIDE /normal \
				/n /yellow it means drag the mouse outside of the screen by the right /normal \
				$tutostopmsg''

.passevent -hook StopandShift

while {[.event shift] != "right"} {
	.event shift right
	verbose -text ''/left you have not dragged the mouse at right \
                /n /red Put again it aside \
				$tutostopmsg''
				
	.passevent -hook StopandShift
}

verbose -text ''/left The second tool box is the MODELING tool box \
				/n you can see it at right \
				/n This in other hand will let you modify the entities \
				/n created using the Construction tool box. \
				/n To see the third tool box, /red PUT ASIDE /normal \
				/n /yellow it means drag the mouse outside of the screen by the right /normal \
				$tutostopmsg''

.passevent -hook StopandShift

while {[.event shift] != "right"} {
	.event shift right
	verbose -text ''/left you have not dragged the mouse at right \
                /n /red Put again it aside \
				$tutostopmsg''
				
	.passevent -hook StopandShift
}

verbose -text ''/left The third tool box is the ASSEMBLY tool box \
				/n you can see it at right \
				/n With this tool box \
				/n you will be able to further modify all the elements created previously, \
				/n by welding, copying and rearranging. \
				/n To come back in the first tool box, /red PUT ASIDE \
				$tutostopmsg''

.passevent -hook StopandShift

while {[.event shift] != "right"} {
	.event shift right
	verbose -text ''/left you have not dragged the mouse at right \
                /n /red Put again it aside \
				$tutostopmsg''
				
	.passevent -hook StopandShift
}

verbose -text ''/left With amapi, you can at any time, change the view \
				/n At first we will construct a sphere for you \
				/n Click on /red ACTION /normal to construct it \
				$tutostopmsg''

.passevent -hook StopandPassLeftbtn

sphere -base {0 0 0} -radius 10 -points 8

verbose -text ''/left Now, use the arrow to turn arround the sphere \
                /n /red hit on an arrow /normal to move \
				 $tutostopmsg''

# return all event key
.passevent -hook StopandArrows
.passevent -hook StopandArrows
.passevent -hook StopandArrows
	
verbose -text ''/left You can also look the sphere from the top view \
				 /n /red hit on the key "5" ''

# accept and return only "5" event key
set filterchar "5"
.passevent -hook ischar

verbose -text ''/left You can look the sphere from the front view \
				 /n /red hit on the key "2" ''

# accept and return only "2" event key
set filterchar "2"
.passevent -hook ischar

verbose -text ''/left You have also the possibility to zoom in \
				/n /red hit on the key 3 /normal to see ''

# accept and return only "3" event key
set filterchar "3"
.passevent -hook ischar

verbose -text ''/left You have also the possibility to zoom out \
				/n /red hit on the key '.' /normal to see ''

# accept and return only "." event key
set filterchar "."
.passevent -hook ischar

verbose -text ''/left You have seen the sphere on all the side \
     			/n Now go in MODELING tool \
				/n Remember : /red PUT ASIDE ! \
				$tutostopmsg''

.passevent -hook StopandShift

while {[.event shift] != "right"} {
	.event shift right
	verbose -text ''/left you have not dragged the mouse at right \
                /n /red Put again it aside \
				$tutostopmsg''
				
	.passevent -hook StopandShift
}

verbose -text ''/left  You are now in the MODELING tool box \
				/n we will flatten the sphere \
				/n For that we will take the tool EXPAND \
				/n in clicking in its icone \
				/n /normal /red click on ACTION /normal to continue \
				$tutostopmsg''
				
.passevent -hook StopandPassLeftbtn

#Launch the tool exescale in background.			
.background axescale

verbose -text ''/left You are now in the EXPAND tool \
                /n you can see its icon in top left of the screen \
                /n you will take the shape \
				/n with a click on it \
				/n /red click on ACTION /normal to continue \
				$tutostopmsg''
				
.passevent -accept {key} -rtrn {leftbtn}

verbose -text ''/left And now you will flatten it \
				/n You can see the sphere become flat by moving the mouse \
				/n You must click /normal to fix the flat shape \
				/n /red click on ACTION /normal to continue \
				$tutostopmsg''

.passevent -accept {key} -rtrn {leftbtn}

verbose -text ''/left You can see that your sphere is flatten \
                /n Now it's to you to flat the sphere \
				/n /red click on ACTION /normal to continue \
				$tutostopmsg''

.passevent -accept {key} -passover {leftbtn}
			
set curevt 0
while { $curevt != "shift"} {	
	verbose -text ''/left You can /red TOGGLE /normal the axes \
					/n /yellow TOGGLE means hit the space bar /normal \
    	            /n You can /red hit on the arrows /normal to turn arround it \
     	            /n You can /red click on ACTION /normal to take the sphere and to release it \
        	        /n And if you want to quit /red PUT ASIDE \
					$tutostopmsg''

	set curevt [.passevent -accept {key} -rtrn {leftbtn shift basculate}]
}

while {[.event shift] != "right"} {
	.event shift right
	verbose -text ''/left you have not dragged the mouse at right \
                /n /red Put again it aside \
				$tutostopmsg''
				
	.passevent -hook StopandShift
}

fitview
if {$mysystem == "macos"} {
verbose -text ''/left You have come back in the MODELING tool box \
				/n Now we will select a part of the shape \
				/n Click on /red OPTIONS /normal to see the lasso \
				/n /yellow hitting on the OPTION key and click on mouse button /normal \
				$tutomovemsg \
				$tutostopmsg''
} else {
verbose -text ''/left You have come back in the MODELING tool box \
				/n Now we will select a part of the shape \
				/n Click on /red OPTIONS /normal to see the lasso \
				/n /yellow OPTIONS is the rightbutton of your mouse /normal \
				$tutomovemsg \
				$tutostopmsg''
}
				
.passevent -accept {key} -rtrn {rightbtn}

verbose -text ''/left You are now in the tool lasso \
				/n You can begin to select points \
				/n select the first point of the lasso \
				/n in clicking on /red ACTION \
				$tutomovemsg \
				$tutostopmsg''
				
.passevent -accept {key} -rtrn {leftbtn}

verbose -text ''/left You are still in the tool lasso \
				/n you will select the second point of the lasso \
				/n in clicking on /red ACTION \
				$tutomovemsg \
				$tutostopmsg''
				
.passevent -accept {key} -rtrn {leftbtn}

verbose -text ''/left You are still in the tool lasso \
				/n you will select the third point of the lasso \
				/n in clicking on /red ACTION \
				$tutomovemsg \
				$tutostopmsg''
				
.passevent -accept {key} -rtrn {leftbtn}

set curevt 0
while {$curevt != "validate"} {
	verbose -text ''/left You are still in the tool lasso \
					/n you have now a selection zone \
					/n you can make it larger by selecting an other point \
					/n For that click on /red ACTION \
					/n /normal You can also VALIDATE it\
					/n For that hit on /red VALIDATE /normal /yellow (Enter key) /normal \
					$tutomovemsg \
					$tutostopmsg''
					
	set curevt [.passevent -accept {key} -rtrn {leftbtn validate}]
}

verbose -text ''/left  You have now a selection zone \
                /n And you have come back in the modeling tool box \
				/n and now you will flatten the red part of the shape \
				/n For that we will take the tool EXPAND \
				/n  by clicking in its icone \
				/n /red click on ACTION /normal to continue \
				$tutostopmsg''
				
.passevent -accept {key} -passover {leftbtn}

#Launch the tool exescale in background.			
.background axescale

verbose -text ''/left You are now in the EXPAND tool \
                /n you will do the same operation than before \
                /n but on the part of the shape \
				/n /red click on ACTION /normal to continue \
				$tutostopmsg''
				
.passevent -accept {key} -rtrn {leftbtn}

set curevt 0
while { $curevt != "shift"} {	
	verbose -text ''/left Remember: You can /red TOGGLE /yellow (hit the space bar) /normal the axes  \
    	            /n You can /red hit on the arrows /normal to turn arround it \
     	            /n You can /red click on ACTION /normal to take the sphere and to release it \
        	        /n And if you want to quit /red PUT ASIDE \
					$tutostopmsg''

	set curevt [.passevent -accept {key} -rtrn {leftbtn shift basculate}]
}

while {[.event shift] != "right"} {
	.event shift right
	verbose -text ''/left you have not dragged the mouse at right \
                /n /red Put again it aside \
				$tutostopmsg''
				
	.passevent -accept {key} -rtrn {shift}
}

verbose -text ''/left You have come back in the modeling tool box \
                /n Now you will take the tool SMOOTH \
				/n to increase mesh definition on the active element \
                /n to launch it, /red click on ACTION \
				$tutomovemsg \
				$tutostopmsg''
				
.passevent -accept {key} -passover {leftbtn}

#launch the tool smooth in background
.background smooth

 verbose -text ''/left the SMOOTH icone appears on the top left hand corner of the screen \
				/n so, we are in the tool SMOOTH \
                /n the density is 3 by default, you can increase it by hit on /red "PLUS" \
                /n /normal try \
				$tutomovemsg \
				$tutostopmsg''
				
# accept all event key and return only event plus				
.passevent -accept {key} -rtrn {plus}

verbose -text ''/left You can also modify the range with new entry \
				/n hit on the key /red CALIBRATE /normal to enter a new range \
				/n /yellow CALIBRATE is the TABULATION key /normal \
				$tutostopmsg''
				
# accept all event key and return only event edit				
.passevent -hook StopandEdit

verbose -text ''/left /red Enter a new range. /normal be careful! not to big! \
                /n If you do, you will have to wait! ''
				
.passevent -accept {key} -rtrn {key}

verbose -text ''/left Now validate this range \
                /n by hitting on the key /red VALIDATE \
                /n /yellow VALIDATE is the "Enter" key /normal \
				$tutomovemsg''
				
# accept all event key and return only event validate
.passevent -hook OnlyValidate

verbose -text ''/left The range of the smooth is now the one you have entered \
                /n Now you can validate the smooth to all the shape \
				/n hit on the key /red VALIDATE /normal to generate the smooth \
				/n You will directly quit the smooth tool \
				$tutomovemsg \
				$tutostopmsg''

# accept all event key and return only event validate
.passevent -accept {key} -rtrn {validate}

verbose -text ''/left Now hit on /red CANCEL key /normal to cancel the smooth \
				/n /yellow The cancel key is the key $ALTmsg with the key "Z" /normal \
				$tutostopmsg''

.passevent -hook StopandCancel

verbose -text ''/left And if you want to see again your smooth shape \
     			/n You can help it again \
     			/n Hit on /red REDO key \
				/n /yellow The REDO key is the key $ALTmsg with the key "R" /normal \
				$tutostopmsg''

.passevent -accept {key} -rtrn {redo}

verbose -text ''/left And finally, you can delete your shape \
     			/n hit on /red DELETE key /normal to clean the scene \
				/n /yellow The delete key is the key "BackSpace" /normal \
				$tutostopmsg''

.passevent -hook StopandDel

verbose -text ''/left Now you know the main actions of Amapi \
				/n To learn how to construct a shape \
				/n look the next tutorial "self training" \
				/n /red click on ACTION /normal to continue \
				$tutostopmsg''

.passevent -hook StopandPassLeftbtn

cd $HELPWD
source us_close.tcl
