#SPEC -realname ''couper par plans''

#
# cut the current object by a set of planes
#

#
# searches if a shape belongs to another shape into a list of shapes
# used to check-out duplicated extracted curves
#
proc belongsToShapes {shape listofshapes} {
	newshape thisshape $shape
	for {set i 0} {$i < [llength $listofshapes]} {incr i} {
		if {[thisshape -include [lindex $listofshapes $i]] == 1} {
			return 1
		}
	}
	return 0
}

# no shape to cut
if {[llength [.amapi scene]] == 0} return

# call tool ruler (get origin & end)
set result [ruler]
set orig [.match $result orig -point3d]
set offset [.match $result vector -vector]

# user canceled ruler
if {$offset == "" || $orig == ""} return

# compute length of cutting area
set end [vertex add $offset $orig]
set length [vertex dist $orig $end]

# get cutting plane interval
set value [.world2unit [expr {$length / 10.0}]]
set res [getvalue -type1 ''world'' -name1 ''Interval :'' -value1 "$value"]
if {$res == ""} return
set interval [.match $res result1 -world]

#set unit offset and nbPlanes
set numofplanes [expr {$length / $interval} ]
set vnorm [vertex vnorm $offset]
set offset [vertex mul $vnorm $interval]

# calculate plane (width & height vertex)
set width [vertex rot $offset [expr {$PI / 2.0}]]
set height [vertex cross $offset $width]

# do cutting
set current [.amapi current]
set curves {}
for {set num 0} {$num < $numofplanes} {incr num} {
	# call cut
	set res [cut -copy -shape $current -orig $orig -height [vertex add $height $orig] -width [vertex add $width $orig]]
	
	# offset cutting plane
	set orig [vertex add $offset $orig]
	
	# no cutting made
	if {[llength $res] <= 1} continue
	
	# extract curves & checkout duplicated curves
	for {set j 0} {$j < [llength $res]} {incr j} {
		# extract curves
		set oldcurves $curves
		set curves [extractcurve -extract [lindex $res $j]]
	
		# checkout duplicated curves
		for {set i 0} {$i < [llength $curves]} {incr i} {
			newshape curve [lindex $curves $i]
			if {[belongsToShapes [curve -ref] $oldcurves] == 1} {
				curve -checkout
			}
		}
		newshape shape [lindex $res $j]
		shape -checkout
	}
}

# hide current shape
newshape current $current
current -hide

# fit view into window
fitview
