//--------------------------------------------------------------------------//
// xmtnimage47.cc                                                           //
// Latest revision: 03-24-2001                                              //
// Copyright (C) 2001 by Thomas J. Nelson                                   //
// All rights reserved.                                                     //
// warp                                                                     //
//--------------------------------------------------------------------------//

#include "xmtnimage.h"

extern Globals     g;
extern Image      *z;
extern int         ci;
int ***ggg;
int newino, nnn;
int in_warp = 0;
int warp_direction = 1;

//-------------------------------------------------------------------------//
// warp                                                                    //
// Change shape of image                                                   //
//-------------------------------------------------------------------------//
void warp(void)
{
  static Dialog *dialog;
  int j,k;
  if(in_warp) return;
  dialog = new Dialog;
  if(dialog==NULL){ message(g.nomemory); in_warp = 0; return; }
  in_warp = 1;
  strcpy(dialog->title,"Warping");

  //-----Dialog box to get title & other options------------//

  strcpy(dialog->radio[0][0],"Operation");
  strcpy(dialog->radio[0][1],"1-D warp");
  strcpy(dialog->radio[0][2],"2-D warp");
  strcpy(dialog->radio[0][3],"Restore original");
  dialog->radiono[0]=4;
  dialog->radioset[0] = -1;

  strcpy(dialog->radio[1][0],"Direction");
  strcpy(dialog->radio[1][1],"Vertical");
  strcpy(dialog->radio[1][2],"Horizontal");
  dialog->radiono[1]=3;
  dialog->radioset[1] = warp_direction;

  for(j=0;j<10;j++) for(k=0;k<20;k++) dialog->radiotype[j][k]=RADIO;  

  strcpy(dialog->boxes[0],"2D Warp Parameters");
  strcpy(dialog->boxes[1],"Pixels/grid point");
  dialog->boxtype[0]=LABEL;
  dialog->boxtype[1]=INTCLICKBOX;
  sprintf(dialog->answer[1][0], "%d", g.warp_gridpoints);
  dialog->boxmin[1]=2; dialog->boxmax[1]=200;
   
  dialog->want_changecicb = 0;
  dialog->f1 = warpcheck;
  dialog->f2 = null;
  dialog->f3 = null;
  dialog->f4 = warpfinish;
  dialog->f5 = null;
  dialog->f6 = null;
  dialog->f7 = null;
  dialog->f8 = null;
  dialog->width = 0;  // calculate automatically
  dialog->height = 0; // calculate automatically
  dialog->noofradios = 2;
  dialog->noofboxes = 2;
  dialog->helptopic = 65;
  dialog->transient = 1;

  //// Use a custom format dialog box
  dialog->radiousexy = 0;
  dialog->boxusexy = 0;
  strcpy(dialog->path, ".");
  strcpy(dialog->message, " ");      
  dialog->message_x1 = 160;
  dialog->message_y1 =  78;
  strcpy(dialog->message2, "");      
  dialog->message_x2 =   0;
  dialog->message_y2 =   0;
  dialogbox(dialog);
  return;
}


//--------------------------------------------------------------------------//
//  warpfinish                                                              //
//--------------------------------------------------------------------------//
void warpfinish(dialoginfo *a)
{
   a=a;
   in_warp = 0;
   printstatus(NORMAL);
   XFlush(g.display);
}



//--------------------------------------------------------------------------//
//  warpcheck                                                               //
//--------------------------------------------------------------------------//
void warpcheck(dialoginfo *a, int radio, int box, int boxbutton)
{
   static int inwarpcheck=0;
   if(inwarpcheck) return;  //// XtSetValues->dialogstringcb->fftcheck
   warp_direction = a->radioset[1];
   inwarpcheck=1;
   box=box; boxbutton=boxbutton;
   g.warp_gridpoints = atoi(a->answer[1][0]);
   if(radio==0) switch(a->radioset[0])
   {
        case 1: warp1d(warp_direction); break;
        case 2: dialog_message(a->message_widget, "Press Esc when finished");
                warp2d(g.warp_gridpoints);
                dialog_message(a->message_widget, "");
                break;
        case 3: restoreimage(1); break;
   }
   unset_radio(a, 0);
   inwarpcheck=0;
   XFlush(g.display);
}


//-------------------------------------------------------------------------//
// warp1d                                                                  //
// Change shape of image                                                   //
//-------------------------------------------------------------------------//
void warp1d(int direction)
{
   if(ci<0){  message("Please select an image first\n");  return; }
   if(memorylessthan(16384)){  message(g.nomemory,ERROR); return; } 
   const int NMAX = 1000;
   int *buffer;
   int bpp, ino, d, d2, f, i, i2, j, k, xstart=0, xend, x, y, yalign, xsize, ysize, 
       total;
   for(k=0; k<g.image_count; k++) z[k].hit=0;
   uint value;  
  
   XYData data;
   data.x = new int[NMAX]; if(data.x==NULL){ message(g.nomemory,ERROR); return; }
   data.y = new int[NMAX]; 
          if(data.y==NULL){ delete[] data.x; message(g.nomemory,ERROR); return; }
   data.v = NULL;
   data.n = 0;
   data.dims = 1;
   data.nmin = 0;
   data.nmax = NMAX;
   data.duration = TEMP;
   data.wantpause = 0;
   if(direction==1)  data.type = 0;  // bezier
   if(direction==2)  data.type = 8;  // sketch
   data.win  = 0; // calculate window automatically on drawing area
 
   for(k=0;k<g.xres;k++) g.highest[k]=0;        // Initialize baseline buf.

   ////  bezier_curve_start() sets bezier_state to CURVE.                    
   ////  When user presses a key to stop the Bezier curve, bezier_curve_end()
   ////  sets bezier_state to 'NORMAL'.                                             
   ////  bezier_curve_end() also deallocates arrays x & y.                        

   bezier_curve_start(&data, NULL);
   g.block++;
   while(g.bezier_state==CURVE)
        XtAppProcessEvent(XtWidgetToApplicationContext(g.drawing_area),XtIMAll);
   g.block = max(0,g.block-1);

   xstart = 0;               // Left x coord of user's Bezier
   xend = g.xres;            // Right x coord of user's Bezier

   for(k=0;k<g.xres;k++) if(g.highest[k]!=0) { xstart=k; break; }
   for(k=g.xres;k>=xstart;k--) if(g.highest[k]!=0) { xend=k; break; }

   ////  This section warps all the pixels in the selected image. Pixels outside
   ////  the image are  not affected.
   ////  highest[] is the Bezier curve for each x relative to the left of the 
   ////  screen. Subtract main_xpos to get the coordinate for drawing pixels
   ////  (which may be negative).

   if(direction==1)
   {
        message("Click at y value to align to");
        getpoint(x,y);
        yalign = y;

        for(i=xstart;i<=xend;i++)
        {   
            d = yalign - g.highest[i];    // d is distance to move down
            i2 = i-g.main_xpos;
            if(d>0)                     // Pixels to be moved down 
            {   for(j=z[ci].ypos+z[ci].ysize-1;j>=z[ci].ypos;j--)
                {   if(j-d >= z[ci].ypos)
                      value = readpixelonimage(i2,j-d,bpp,ino);
                    else
                      value = g.bcolor;
                    if(ino>=0)
                    {  if((g.bitsperpixel==8)&&(bpp!=8)&&(z[ino].hitgray==0))
                           z[ino].hit=1;
                       if(!g.wantr || !g.wantg || !g.wantb) z[ino].hit=1;
                       if(bpp==8 || z[ino].colortype==GRAY) z[ino].hit=1;
                    }
                    setpixelonimage(i2,j,value,g.imode,bpp);
                }
            }else                       // Pixels to be moved up
            {   for(j=z[ci].ypos;j<z[ci].ysize+z[ci].ypos;j++)
                {   if(j-d < z[ci].ysize+z[ci].ypos)
                       value = readpixelonimage(i2,j-d,bpp,ino);
                    else
                       value = g.bcolor;
                    if(ino>=0)
                    {  if((g.bitsperpixel==8)&&(bpp!=8)&&(z[ino].hitgray==0))
                           z[ino].hit=1;
                       if(!g.wantr || !g.wantg || !g.wantb) z[ino].hit=1;
                       if(bpp==8 || z[ino].colortype==GRAY) z[ino].hit=1;
                    }
                    setpixelonimage(i2,j,value,g.imode,bpp);
                }
            }
            if(g.getout){ g.getout=0; break;}
        }    
   }
   if(direction==2)
   {  
        smooth(g.highest, xend-xstart, 15);
        smooth(g.highest, xend-xstart, 15);
        ino = ci;
        total = 0;
        xsize = z[ino].xsize;
        ysize = z[ino].ysize;
        for(i=xstart;i<=xend;i++) total += g.highest[i];  
        yalign = cint(total / (xend-xstart)) - g.main_xpos;
        buffer = new int[xend];
        if(buffer==NULL){ message(g.nomemory); return; }
        bpp = z[ino].bpp;
        f = z[ino].cf;

        for(j=0; j<ysize; j++)
        {    for(i=xstart; i<xend; i++)
             {  
                  d2 = g.highest[i] - g.main_xpos; 
                  d = yalign - d2;        // d is distance to move left or right
                  if(between(d+i, 0, xsize-1))
                       buffer[i] = pixelat(z[ino].image[f][j]+(i+d)*g.off[bpp], bpp);
                  else buffer[i] = g.bcolor;
             }
             for(i=xstart,i2=xstart*g.off[bpp]; i<xend; i++,i2+=g.off[bpp])
                  putpixelbytes(z[ino].image[f][j]+i2, buffer[i], 1, bpp, 1);
        }

        delete[] buffer;   
        z[ino].touched=1;
   }

   g.state=NORMAL;
   g.bezier_state=NORMAL;
   delete[] data.x;
   delete[] data.y;
   for(k=0; k<g.image_count; k++) 
   {  if(z[k].hit)
      {    rebuild_display(k); 
           repairimg(k,0,0,z[k].xsize,z[k].ysize); 
           redraw(k); 
      }
   }
  switch_palette(ci);
  rebuild_display(ci); 
  redraw(ci); 
}


//-------------------------------------------------------------------------//
// warp2d                                                                  //
// Change shape of image n = no.of grid points                             //
//-------------------------------------------------------------------------//
void warp2d(int n)
{
   static int in_warp2d = 0;
   static int count=0;   
   if(in_warp2d) return;
   in_warp2d=1;
   int b,bpp,ct,f,ino,x1,y1,x2,y2,xx=0,yy=0,xar,yar,need_redraw;
   int ox1 = 0, ox2 = 0, oy1 = 0, oy2 = 0;
   int gxmin,gxmax,gymin,gymax;
   ino = ci;
   if(!between(ino, 1, g.image_count-1)){ in_warp2d=0; return; }
   int xsize = z[ino].xsize;
   int ysize = z[ino].ysize;
   int xpos = z[ino].xpos;
   int ypos = z[ino].ypos;
   int newxpos = xpos + 100;
   int newypos = ypos + 100;
   int grid_visible = 1;
   char title[100];
   int c;
   void (*oldexposefunc)(void *) = NULL;  
   uchar temp[4];
   uint keysym=0;


   f = z[ino].cf;
   ct = z[ino].colortype;
   newino = ci;
   bpp = z[ino].bpp;
   b = g.off[bpp];
   xar = xsize/n+1;
   yar = ysize/n+1;
   array<int> grid(xar+10, yar+10, 2);
   if(!grid.allocated){ message(g.nomemory); in_warp2d=0; return; }
   ggg = grid.q;
   nnn = n;
   g.key_ascii = 0;

   initialize_grid(grid.q, xar, yar, n);
   duplicate_image(ino, newxpos, newypos, g.want_shell, g.window_border);
   setimagetitle(ci,"Warped");
   z[ci].touched = 1;
   newino = ci;

   message("Drag grid points to destination\nto define the coordinate mapping.\nClick Cancel when ready");
   g.getout = 0;
   if(!between(ino, 1, g.image_count-1)){ in_warp2d=0; return; }

   draw_grid(NULL);  
   g.busy++;
   while(!g.getout)
   {  g.inmenu++;  
      if(grid_visible && between(newino, 0, g.image_count-1))
      {   oldexposefunc = z[newino].exposefunc; 
          z[newino].exposefunc = draw_grid; 
      }
      ox1 = x1; ox2 = x2; oy1 = y1; oy2 = y2;

      getline(x1,y1,x2,y2); // Event can occur here, must check for change in state
      if(g.getout)
      {   g.inmenu--; g.getout=0; g.busy=max(0,g.busy-1); in_warp2d=0; message("Aborted"); return; }
      if(!between(ci,     0, g.image_count-1) ||
         !between(newino, 0, g.image_count-1) || 
         !between(ino,    0, g.image_count-1)) 
      {   g.inmenu--; g.getout=0; g.busy=max(0,g.busy-1); in_warp2d=0; message("Missing image",ERROR); return; }
      if(ci != newino) switchto(newino);

      need_redraw = 0;
      if(grid_visible) z[newino].exposefunc = oldexposefunc; 
      newxpos = z[newino].xpos;                         // Recalculate in case 
      newypos = z[newino].ypos;                         // image was moved

      x1 -= newxpos; y1 -= newypos;
      x2 -= newxpos; y2 -= newypos;
      g.inmenu--;
      if(g.getout) break;
                                                        // Grid point to move
                                                        // xx,yy = closest point
      if((x1!=ox1 || y1!=oy1 || y2!=oy2 || y2!=oy2) ||  // A line was selected  (not a keypress)
         (x1!=x2  || y1!= y2))                          // A line of nonzero length (not a point) 
      {  
         find_closest_point(grid.q, newino, x1, y1, xar, yar, n, xx, yy, 
                            gxmin, gymin, gxmax, gymax); 
      }

      if((x1!=ox1 || y1!=oy1 || y2!=oy2 || y2!=oy2) &&  // A line was selected (not a keypress)
         (x1!=x2  || y1!= y2))                          // A line of nonzero length (not a point)
      {      
         if(between(xx,0,xar) && between(yy,0,yar))
         {   grid.q[0][yy][xx] = x2;                    // Set new grid point
             grid.q[1][yy][xx] = y2;  
             need_redraw = 1;
         }
      }

      c = 0;
      c = getcharacter(); 
      g.key_ascii = 0;                                  // get rid of keystroke
      temp[1] = c & 0xff;
      temp[0] = 255;
      keysym = (uint)temp[0]*256 + (uint)temp[1];
      XSync(g.display, 0);
      switch(c)
      {  case 'r':                                      // restore original grid
              initialize_grid(grid.q, xar, yar, n);
              remap_coordinates(ino, f, newino, grid.q, 0, 0, xar-1, yar-1, n);
              x1=x2=newxpos;
              y1=y2=newypos;
              repair(newino);
              redraw(newino);
              break;
         case 'g':
              grid_visible = 1 - grid_visible;
              gxmin=gymin=0;
              gxmax=xar;
              gymax=yar;
              break;
         case 'c':
              if(!between(newino, 0, g.image_count-1))
              {   message("Missing image",ERROR); g.getout=0; in_warp2d=0; g.busy=max(0,g.busy-1); return; }
              duplicate_image(newino, newxpos+20, newypos+20, g.want_shell, 
                 g.window_border);
              switchto(newino);
              if(g.getout) break;
              break;
         case 27:
              g.getout=1;
      }
      switch(keysym)
      {
         case XK_Left:  grid.q[0][yy][xx]-=4; break;
         case XK_Right: grid.q[0][yy][xx]+=4; break;
         case XK_Up:    grid.q[1][yy][xx]-=4; break;
         case XK_Down:  grid.q[1][yy][xx]+=4; break;     
      }
      if(need_redraw || c) 
      {   remap_coordinates(ino, f, newino, grid.q, gxmin, gymin, gxmax, gymax, n);
          repair(newino);
      }
      c = 0;
   }
   redraw(newino);
   if(g.autoundo) backupimage(newino, 0); 
   sprintf(title, "warped_%d", ++count);
   setimagetitle(newino, title);
   z[newino].touched = 1;
   switchto(newino);
   g.getout = 0;
   g.busy=max(0,g.busy-1);
   in_warp2d=0;
   return;
}


//-------------------------------------------------------------------------//
// initialize_grid                                                         //
//-------------------------------------------------------------------------//
void initialize_grid(int ***g, int xar, int yar, int n)
{
   int i,j;
   for(j=0;j<=yar;j++)
   for(i=0;i<=xar;i++)
   {
      g[0][j][i] = i*n;  // x coord
      g[1][j][i] = j*n;  // y coord
   }
}



//-------------------------------------------------------------------------//
// find_closest_point                                                      //
//-------------------------------------------------------------------------//
void find_closest_point(int ***grid, int ino, int x, int y, int xar, int yar, 
     int n, int &xclosest, int &yclosest, int &gxmin, int &gymin, int &gxmax, 
     int &gymax)
{
   if(!between(ino, 1, g.image_count-1)) return; 
   int d,i,j,cd;
   int dx = z[ino].xsize / n;
   int dy = z[ino].ysize / n;
   xclosest = (x+n/2)/n;  // first approx. is unmoved point
   yclosest = (y+n/2)/n;       
   cd = (x-xclosest)*(x-xclosest) + (y-yclosest)*(y-yclosest);
   for(j=0;j<yar;j++)
   for(i=0;i<xar;i++)
   {
      d = (x-grid[0][j][i]) * (x-grid[0][j][i]) + 
          (y-grid[1][j][i]) * (y-grid[1][j][i]);        
      if(d<cd){ xclosest=i; yclosest=j; cd=d;}
   }

   ////  Find minimum & maximum grid coordinates to redraw
   gxmin = gxmax = xclosest;
   gymin = gymax = yclosest;
   for(j=0;j<yar;j++)
   for(i=0;i<xar;i++)
   {
       if(i<=gxmin && (x <= dx*i)) gxmin = i;
       if(i>=gxmax && (x >= dx*i)) gxmax = i;
       if(j<=gymin && (y <= dy*j)) gymin = j;
       if(j>=gymax && (y >= dy*j)) gymax = j;
   }
   gxmin = max(0,gxmin-1);
   gymin = max(0,gymin-1);
   gxmax = min(xar,gxmax+1);
   gymax = min(yar,gymax+1);
}


//-------------------------------------------------------------------------//
// draw_grid                                                               //
//-------------------------------------------------------------------------//
void draw_grid(void *ptr)
{
   ptr = ptr;
   g.inmenu++;
   int n = nnn;
   int ino = newino;
   if(!between(ino, 1, g.image_count-1)) return; 
   int i,j,x1,y1,x2,y2;
   int xsize = z[ino].xsize;
   int ysize = z[ino].ysize;

   for(j=0;j<=ysize/n;j++)
   for(i=1;i<=xsize/n;i++)
   {  x1 = ggg[0][j][i-1];
      x2 = ggg[0][j][i  ];
      y1 = ggg[1][j][i-1];
      y2 = ggg[1][j][i  ];
      line(x1,y1,x2,y2,255,SET,z[ino].win);
   }
   for(j=1;j<=ysize/n;j++)
   for(i=0;i<=xsize/n;i++)
   {  x1 = ggg[0][j-1][i];
      x2 = ggg[0][j  ][i];
      y1 = ggg[1][j-1][i];
      y2 = ggg[1][j  ][i];
      line(x1,y1,x2,y2,255,SET,z[ino].win);
   }
   g.inmenu--;
}


//-------------------------------------------------------------------------//
// remap_coordinates                                                       //
//-------------------------------------------------------------------------//
void remap_coordinates(int ino, int f, int newino, int ***grid, int gridx1,
     int gridy1, int gridx2, int gridy2, int n)
{
   if(!between(ino, 1, g.image_count-1)) return; 
   if(!between(newino, 1, g.image_count-1)) return; 
   int b,bpp,i,j,k,l,v,x,y,x1,y1,x2,y2,x3,y3,x4,y4;
   int xsrc,ysrc;
   int xsize = z[ino].xsize;
   int ysize = z[ino].ysize;
   double dx,dy,xa,xb,ya,yb; 
   uchar* address;
   bpp = z[ino].bpp;
   b = g.off[bpp];

   for(j=gridy1; j<gridy2; j++)
   for(i=gridx1; i<gridx2; i++)
   {  
       x1 = grid[0][j  ][i  ];  y1 = grid[1][j  ][i  ]; 
       x2 = grid[0][j  ][i+1];  y2 = grid[1][j  ][i+1]; 
       x3 = grid[0][j+1][i  ];  y3 = grid[1][j+1][i  ]; 
       x4 = grid[0][j+1][i+1];  y4 = grid[1][j+1][i+1];   // 4 closest grid pts.

       for(l=0; l<n; l++)
       for(k=0; k<n; k++)
       {
            x = min(xsize-1, k + i*n);     // Destination coordinates 
            y = min(ysize-1, l + j*n);
       
            xb = (double)k / n;    // x fractional offset of point in box 
            yb = (double)l / n;    // y fractional offset of point in box 
            xa = 1 - xb;
            ya = 1 - yb;

            dx = ya * (xa*(x1-x) + xb*(x2-x)) +
                 yb * (xa*(x3-x) + xb*(x4-x));

            dy = xa * (ya*(y1-y) + yb*(y3-y)) +
                 xb * (ya*(y2-y) + yb*(y4-y));
             
            xsrc = x - (int)dx;     // Source coordinates
            ysrc = y - (int)dy; 
            if(between(xsrc,0,xsize-2) && between(ysrc,0,ysize-2))
               v = pixelat(z[ino].image[f][ysrc] + xsrc*b, bpp);
            else v=0;
            address = z[newino].image[0][y] + x*b;
            putpixelbytes(address, v, 1, bpp);
       }
   }
}
