//--------------------------------------------------------------------------//
// xmtnimage35.cc                                                           //
// Latest revision: 08-26-2000                                              //
// Copyright (C) 2000 by Thomas J. Nelson                                   //
// All rights reserved.                                                     //
// brightness, contrast                                                     //
//--------------------------------------------------------------------------//

#include "xmtnimage.h"

extern Globals     g;
extern Image      *z;
extern int         ci;
extern PrinterStruct printer;
static char notcolor[] = "Cannot change RGB of grayscale image\nConvert image to color first"; 

//-------------------------------------------------------------------------//
// changecontrast2                                                         //
//-------------------------------------------------------------------------//
void changecontrast2(int noofargs, char **arg)
{
   if(noofargs>0){ changecontrast(noofargs, arg); return; }
   int i,k;
   char title[128] = "Contrast";
   array<int> ydata(256,3);   
   array<double> xdata(256);
   array<char> ytitle(256,3);
   for(k=0; k<3; k++) ytitle.p[k] = new char[256];
   for(i=0; i<256; i++)
   {   ydata.p[0][i] = i; 
       ydata.p[1][i] = i;
       ydata.p[2][i] = i;   
       xdata.data[i] = i;
   } 
   strcpy(ytitle.p[0]," Red");
   strcpy(ytitle.p[1]," Gren");
   strcpy(ytitle.p[2]," Blue");
   plot(title, "Contrast", ytitle.p, xdata.data, ydata.p, 256, 3, CHANGE, 0, 255,
       null, changecontrastcb, image_bounds, 14);
}


//-------------------------------------------------------------------------//
// change_intensity                                                        //
//-------------------------------------------------------------------------//
void change_intensity(int noofargs, char **arg)
{
   int k;
   if(noofargs>0)
   {    noofargs = 6;
        strcpy(arg[6], arg[1]);
        for(k=1;k<6;k++) strcpy(arg[k], "100");
        changecontrast(noofargs, arg); 
   }else message("Intensity increment not specified");
}
  

//-------------------------------------------------------------------------//
// lighten                                                                 //
//-------------------------------------------------------------------------//
void lighten(int noofargs, char **arg)
{
   int k;
   if(noofargs>0)
   {    noofargs = 6;
        strcpy(arg[6], arg[1]);
        for(k=1;k<6;k++) strcpy(arg[k], "0");
        changebrightness(noofargs, arg); 
   }else message("Brightening increment not specified");
}


//-------------------------------------------------------------------------//
// darken                                                                  //
//-------------------------------------------------------------------------//
void darken(int noofargs, char **arg)
{
   int k;
   if(noofargs>0)
   {    noofargs = 6;
        sprintf(arg[6], "%d", -atoi(arg[1]));
        for(k=1; k<6; k++) strcpy(arg[k], "0");
        changebrightness(noofargs, arg); 
   }else message("Darkening increment not specified");
}

//--------------------------------------------------------------------------//
// image_stats                                                              //
//--------------------------------------------------------------------------//
void image_stats(int x1, int y1, int x2, int y2, int &ino, int &bpp, int &ymin, 
     int &ymax, int &rmin, int &gmin, int &bmin, int &rmax, int &gmax, int &bmax)
{
  int f,i,j,ii,jj,rr,gg,bb,value=0;
  ymax = rmax = gmax = bmax = 0; 
  ymin = rmin = gmin = bmin = MAXINT; 
  for(j=y1;j<=y2;j++)
  for(i=x1;i<=x2;i++)
  {   
     if(!g.selected_is_square && !inside_irregular_region(i,j)) continue;
     ino = whichimage(i, j, bpp);
     f = z[ino].cf;
     jj = j - z[ino].ypos;
     ii = g.off[bpp] * (i - z[ino].xpos);
     value = pixelat(z[ino].image[f][jj]+ii, bpp);
     valuetoRGB(value,rr,gg,bb,bpp);
     ymax = max(ymax, value);
     ymin = min(ymin, value);
     rmax = max(rmax, rr);
     rmin = min(rmin, rr);
     gmax = max(gmax, gg);
     gmin = min(gmin, gg);
     bmax = max(bmax, bb);
     bmin = min(bmin, bb);
  }
}


//--------------------------------------------------------------------------//
// image_bounds - get data for draw_graph                                   //
//--------------------------------------------------------------------------//
void image_bounds(void *p, int n1, int n2)
{
   n1=n1;n2=n2;
   PlotData *pd = (PlotData *)p;
   int x1,y1,x2,y2,ino,bpp,ymin,ymax,rmin,gmin,bmin,rmax,gmax,bmax;
   x1=g.ulx; x2=g.lrx; y1=g.uly; y2=g.lry;
   image_stats(x1,y1,x2,y2,ino,bpp,ymin,ymax,rmin,gmin,bmin,rmax,gmax,bmax);
   //// In anticipation of converting image to 24 bpp
   if(bpp==8){ bpp=24; rmin*=4; rmax=255; gmin*=4; gmax*=4; bmin*=4; bmax*=4; }
   switch(pd->focus)
   {    case 0:  pd->ymin=(double)rmin; 
                 pd->ymax=(double)rmax;
                 pd->ulimit=g.maxred[bpp];
                 break;
        case 1:  pd->ymin=(double)gmin; 
                 pd->ymax=(double)gmax;
                 pd->ulimit=g.maxgreen[bpp];
                 break;
        case 2:  pd->ymin=(double)bmin; 
                 pd->ymax=(double)bmax; 
                 pd->ulimit=g.maxblue[bpp];
                 break;
   }
}


//--------------------------------------------------------------------------//
// changecontrastcb                                                         //
//--------------------------------------------------------------------------//
void changecontrastcb(void *p, int n1, int n2)
{
  int f,focus,hitgray=0,ii,jj,i,j,k,ino,bpp,rr,gg,bb,value,noscreen=1;
  int oinmenu=g.inmenu;
  PlotData *pd = (PlotData*)p;
  int x1=g.ulx;
  int x2=g.lrx;
  int y1=g.uly;
  int y2=g.lry;
  g.inmenu = 0;
  printstatus(CALCULATING);
  focus = pd->focus;
  if(g.selectedimage>0) restoreimage(0); // Don't restore colortype
  ino = g.selectedimage;
  printstatus(BUSY);
    
   //// If in 8bpp mode, just change colormap
  if(g.selectedimage!=-1 && z[g.selectedimage].bpp==8)
  {  
      if(z[ino].colortype == GRAY) hitgray=1;
      else 
      {   for(k=0;k<256;k++)
          switch(focus)
          {   case 0: z[ino].palette[k].red   = (int)pd->data[focus][k]/4; break;
              case 1: z[ino].palette[k].green = (int)pd->data[focus][k]/4; break;
              case 2: z[ino].palette[k].blue  = (int)pd->data[focus][k]/4; break;
          }
          z[ino].hit = 1;
          setpalette(z[ino].palette);
      }
  }else
  {
      for(k=0;k<MAXIMAGES;k++) z[k].hit=0;
      for(j=y1;j<=y2;j++)
      for(i=x1;i<=x2;i++)
      {   
         if(!g.selected_is_square && !inside_irregular_region(i,j)) continue;
         ino = whichimage(i,j,bpp);
         if(z[ino].colortype == GRAY) { hitgray=1; continue; }
         f = z[ino].cf;
         jj = j - z[ino].ypos;
         ii = g.off[bpp] * (i - z[ino].xpos);

         if(ino>=0 && z[ino].hit==0 && z[ino].colortype==INDEXED) 
         {   z[ino].hit=2;    // Must be set before change_image_depth                   
             if(change_image_depth(ino,24,0)!=OK) 
             {   message("Insufficient image buffers available",ERROR);
                 g.getout=1; 
                 return;
             }
             bpp=24;
         }

         if(!z[ino].hit) z[ino].hit=1;
         value = pixelat(z[ino].image[f][jj]+ii,bpp);
         valuetoRGB(value,rr,gg,bb,bpp); 

         switch(focus)
         {   case 0: 
                    if(!between(rr,n1,n2)) continue; 
                    rr = (int)pd->data[0][rr];
                    rr = max(0,min(rr,(int)g.maxred[bpp]));
                    break;
             case 1: 
                    if(!between(gg,n1,n2)) continue; 
                    gg = (int)pd->data[1][gg];
                    gg = max(0,min(gg,(int)g.maxgreen[bpp]));
                    break;
             case 2: 
                    if(!between(bb,n1,n2)) continue; 
                    bb = (int)pd->data[2][bb];
                    bb = max(0,min(bb,(int)g.maxblue[bpp]));
                    break;
         }
         value = RGBvalue(rr,gg,bb,bpp);
         setpixelonimage(i,j,value,g.imode,bpp,-1,noscreen);
         if(ino>=0 && (!z[ino].hit)) z[ino].hit=1;
      }

      for(k=0; k<g.image_count; k++) 
      {   if(z[k].hit==2)
          {   z[k].hit=1;
              change_image_depth(k,8,0);
          }
      }
  }
  if(hitgray) message(notcolor, WARNING);
  g.inmenu = oinmenu;  
  for(k=0;k<MAXIMAGES;k++) if(z[k].hit) { rebuild_display(k); redraw(k); z[k].hit=0; }
  printstatus(NORMAL);
}


//-------------------------------------------------------------------------//
// changecontrast                                                          //
//-------------------------------------------------------------------------//
void changecontrast(int noofargs, char **arg)
{
  int dr=g.rcontrast, dg=g.gcontrast, db=g.bcontrast,
      dh=g.hcontrast, ds=g.scontrast, dv=g.vcontrast;
  if(memorylessthan(16384)){ message(g.nomemory,ERROR); return; }
  int helptopic=14;
  static clickboxinfo* item;
  static int value[10] = { 100,100,100,100,100,100,0,0,0,0 };
  if(ci>=0)
  {    switch_palette(ci);
       memcpy(z[ci].opalette,z[ci].palette,768); 
  }else
       memcpy(g.palette,g.b_palette,768); 

  g.getout=0;
  if(noofargs>0)          // Macro
  {    if(noofargs>=1) value[0]=atoi(arg[1]);
       if(noofargs>=2) value[1]=atoi(arg[2]);
       if(noofargs>=3) value[2]=atoi(arg[3]);
       if(noofargs>=4) value[3]=atoi(arg[4]);
       if(noofargs>=5) value[4]=atoi(arg[5]);
       if(noofargs>=6) value[5]=atoi(arg[6]);
       value[6]=1;        // make permanent
       multiplypalettecolors(value);   
       repair(ci);
  }else
  {    item = new clickboxinfo[6];
       item[0].title = new char[128];        
       item[0].wantpreview=0;
       strcpy(item[0].title,"Red");
       item[0].startval = dr;
       item[0].done = 0;                // Set to 1 if maximize button is clicked
       item[0].k = 0;                   // which button
       item[0].minval = 0;
       item[0].maxval = 1000;           // maximum percentage factor
       item[0].type = BUTTONVALSLIDER;
       item[0].wantdragcb = 0;
       item[0].answers = new int[10];   // Must have 10 for addpalettecolors()
       item[0].answers[0]=0;            // red contrast
       item[0].answers[1]=0;            // green contrast
       item[0].answers[2]=0;            // blue contrast
       item[0].answers[3]=0;            
       item[0].answers[4]=0;
       item[0].answers[5]=0;            // intensity contrast
       item[0].answers[6]=0;            
       item[0].f1 = NULL;
       item[0].f2 = NULL;
       item[0].f3 = NULL;
       item[0].f4 = maximize_contrast;
       item[0].buttonlabel = new char[64];
       item[0].form = NULL;
       item[0].path = NULL;
       strcpy(item[0].buttonlabel,"Maximize");       
       
       item[1].title = new char[128];        
       strcpy(item[1].title,"Green");
       item[1].startval = dg;
       item[1].done = 0;                // Set to 1 if maximize button is clicked
       item[1].k = 1;
       item[1].minval = 0;
       item[1].maxval = 1000;
       item[1].type = BUTTONVALSLIDER;
       item[1].wantdragcb = 0;
       item[1].answers = item[0].answers; // Alias all answers to each other
       item[1].f1 = NULL;
       item[1].f2 = NULL;
       item[1].f3 = NULL;
       item[1].f4 = maximize_contrast;
       item[1].buttonlabel = new char[64];
       item[1].form = NULL;
       item[1].path = NULL;
       strcpy(item[1].buttonlabel,"Maximize");       

       item[2].title = new char[128];        
       strcpy(item[2].title,"Blue");
       item[2].startval = db;
       item[2].done = 0;                // Set to 1 if maximize button is clicked
       item[2].k = 2;
       item[2].minval = 0;
       item[2].maxval = 1000;
       item[2].type = BUTTONVALSLIDER;
       item[2].wantdragcb = 0;
       item[2].answers = item[0].answers; // Alias all answers to each other
       item[2].f1 = NULL;
       item[2].f2 = NULL;
       item[2].f3 = NULL;
       item[2].f4 = maximize_contrast;
       item[2].buttonlabel = new char[64];
       item[2].form = NULL;
       item[2].path = NULL;
       strcpy(item[2].buttonlabel,"Maximize");       

       item[3].title = new char[128];        
       strcpy(item[3].title,"Hue");
       item[3].startval = dh;
       item[3].done = 0;                // Set to 1 if maximize button is clicked
       item[3].k = 3;
       item[3].minval = 0;
       item[3].maxval = 1000;
       item[3].type = BUTTONVALSLIDER;
       item[3].wantdragcb = 0;
       item[3].answers = item[0].answers; // Alias all answers to each other
       item[3].f1 = NULL;
       item[3].f2 = NULL;
       item[3].f3 = NULL;
       item[3].f4 = maximize_contrast;
       item[3].buttonlabel = new char[64];
       item[3].form = NULL;
       item[3].path = NULL;
       strcpy(item[3].buttonlabel,"Maximize");       

       item[4].title = new char[128];        
       strcpy(item[4].title,"Satur.");
       item[4].startval = ds;
       item[4].done = 0;                // Set to 1 if maximize button is clicked
       item[4].k = 4;
       item[4].minval = 0;
       item[4].maxval = 1000;
       item[4].type = BUTTONVALSLIDER;
       item[4].wantdragcb = 0;
       item[4].answers = item[0].answers; // Alias all answers to each other
       item[4].f1 = NULL;
       item[4].f2 = NULL;
       item[4].f3 = NULL;
       item[4].f4 = maximize_contrast;
       item[4].buttonlabel = new char[64];
       item[4].form = NULL;
       item[4].path = NULL;
       strcpy(item[4].buttonlabel,"Maximize");       

       item[5].title = new char[128];        
       strcpy(item[5].title,"Value");
       item[5].startval = dv;
       item[5].done = 0;                // Set to 1 if maximize button is clicked
       item[5].k = 5;
       item[5].minval = 0;
       item[5].maxval = 1000;
       item[5].type = BUTTONVALSLIDER;
       item[5].wantdragcb = 0;
       item[5].answers = item[0].answers; // Alias all answers to each other
       item[5].f1 = NULL;
       item[5].f2 = NULL;
       item[5].f3 = NULL;
       item[5].f4 = maximize_contrast;
       item[5].buttonlabel = new char[64];
       item[5].form = NULL;
       item[5].path = NULL;
       strcpy(item[5].buttonlabel,"Maximize");       

       value[6] = 0;  // Dont make palette change permanent 

       item[0].ino = ci;
       item[0].noofbuttons = 6;
       item[0].f5 = changecontrastok;
       item[0].f6 = changecontrastfinish;
       item[0].f7 = null;
       item[0].f8 = null;
       multiclickbox("Contrast adjustment", 6, item, multiplypalettecolors, helptopic);
   }
}   


//-------------------------------------------------------------------------//
// changecontrastok                                                        //
//-------------------------------------------------------------------------//
void changecontrastok(clickboxinfo *c)
{
   drawselectbox(OFF);
   int *value = c[0].answers;
   g.rcontrast = value[0];
   g.gcontrast = value[1];
   g.bcontrast = value[2];
   g.hcontrast = value[3];
   g.scontrast = value[4];
   g.vcontrast = value[5];

   value[6]=  1;   // Make palette change permanent 
   int ino = c[0].ino;
   multiplypalettecolors(value);   
   if(ino>=0)
   {   memcpy(z[ino].palette,g.palette,768); 
       setpalette(z[ino].palette);
       rebuild_display(ino);
       redraw(ino);
       z[ino].touched = 1;
   }else memcpy(g.b_palette, g.palette, 768); 
   value[6]=  0;   // Make palette change temporary (for slider)
}


//-------------------------------------------------------------------------//
// changecontrastfinish                                                    //
//-------------------------------------------------------------------------//
void changecontrastfinish(clickboxinfo *c)
{
   int k;
   for(k=0; k<6; k++)
   {     delete[] c[k].buttonlabel;
         delete[] c[k].title;
   }
   delete[] c[0].answers;
   delete[] c;          
}


//-------------------------------------------------------------------------//
// maximize_contrast                                                       //
//-------------------------------------------------------------------------//
void maximize_contrast(int noofargs, char **arg)
{
   int button;
   if(noofargs>0) button = atoi(arg[1]); else button=5;
   maximize_contrast(button, (clickboxinfo*) NULL);
}
void maximize_contrast(int button, clickboxinfo *cb)
{
   int d[10];
   int bpp,ino,i,j,x1,y1,x2,y2,rr,gg,bb,hh,ss,vv,
       rmin,gmin,bmin,rmax,gmax,bmax,smin,smax,vmin,vmax,imin,imax,
       value;
   double rfac,gfac,bfac,sfac,vfac;
   printstatus(BUSY);
   x1 = g.ulx;
   x2 = g.lrx;
   y1 = g.uly;
   y2 = g.lry;
   bpp = z[ci].bpp;
   rmax = 0; rmin = g.maxred[bpp];
   gmax = 0; gmin = g.maxgreen[bpp];
   bmax = 0; bmin = g.maxblue[bpp];
   smax = 0; smin = g.maxblue[bpp];
   vmax = 0; vmin = g.maxgray[bpp];
   imax = 0; imin = (int)g.maxvalue[bpp];
   ////  Find smallest & largest r,g,b,i
   for(j=y1;j<y2;j+=2)
   for(i=x1;i<x2;i+=2)
   {    value = readpixelonimage(i,j,bpp,ino);
        valuetoRGB(value,rr,gg,bb,bpp);
        RGBtoHSV(rr,gg,bb,hh,ss,vv,bpp);
        rmin=min(rr,rmin);
        gmin=min(gg,gmin);
        bmin=min(bb,bmin);
        smin=min(ss,smin);
        vmin=min(vv,vmin);
        imin=min(value,imin);

        rmax=max(rr,rmax);
        gmax=max(gg,gmax);
        bmax=max(bb,bmax);
        smax=max(ss,smax);
        vmax=max(vv,vmax);
        imax=max(value,imax);
   }
   if(rmax!=rmin) rfac=(double)g.maxred[bpp]/(double)(rmax-rmin);  else rfac=1.0;
   if(gmax!=gmin) gfac=(double)g.maxgreen[bpp]/(double)(gmax-gmin);else gfac=1.0;
   if(bmax!=bmin) bfac=(double)g.maxblue[bpp]/(double)(bmax-bmin); else bfac=1.0;
   if(smax!=smin) sfac=(double)g.maxgray[bpp]/(double)(smax-smin); else sfac=1.0;
   if(z[ci].colortype==GRAY) 
   {   if(imax>imin) vfac=g.maxvalue[bpp]/(double)(imax-imin);     else vfac=1.0;
       vmin = imin;
       vmax = imax;
   }else
   {   // imin=max(rmin,max(gmin,bmin)); // Doesn't work if one plane is all black
       // imax=min(rmax,min(gmax,bmax));
       vmin = (rmin+gmin+bmin)/3;
       vmax = (rmax+gmax+bmax)/3;
       if(vmax>vmin) vfac=(double)g.maxgreen[bpp]/(double)(vmax-vmin); else vfac=1.0;
   }

   d[0]=0;d[1]=0;d[2]=0;d[3]=0;d[4]=0;d[5]=0;d[6]=1;
   switch(button)
   {   case 0: d[0] = -rmin; break;
       case 1: d[1] = -gmin; break;
       case 2: d[2] = -bmin; break;
       case 3: d[3] =     0; break; // cant maximize hue
       case 4: d[4] = -smin; break;
       case 5: d[5] = -vmin; break;
   }
   addpalettecolors(d);

   d[0]=100;d[1]=100;d[2]=100;d[3]=100;d[4]=100;d[5]=100;d[6]=1;
   switch(button)
   {  case 0: d[0] = int(100*rfac); break;
      case 1: d[1] = int(100*gfac); break;
      case 2: d[2] = int(100*bfac); break;
      case 3: d[3] =           100; break; // cant maximize hue
      case 4: d[4] = int(100*sfac); break;
      case 5: d[5] = int(100*vfac); break;
   }
   multiplypalettecolors(d);
   repair(ci);
   rebuild_display(ci);
   redraw(ci);
   z[ci].touched = 1;

   ////  Change label so slider reads 100%
   char string[256]; 
   if(cb != NULL) 
   {    cb->answer=100;
        itoa(cb->answer, string, 10); 
        XmTextSetString(cb->widget[0], string);
   }
   printstatus(NORMAL);
}


//-------------------------------------------------------------------------//
// addvalue                                                                //
// Change color/intensity of selected region by adding a value.            //
//-------------------------------------------------------------------------//
void addvalue(int noofargs, char **arg)
{
    int dr=g.raddvalue, dg=g.gaddvalue, db=g.baddvalue;
    int darker=g.vaddvalue;
    if(memorylessthan(16384)){ message(g.nomemory,ERROR); return; }
    int k,bpp=0,maxbpp=0,gotbw=0,gotcolor=0,white,maxwhite=0,black,helptopic=14;

    static clickboxinfo* item;
    g.getout=0;
    char temp[128];
    int x1=g.ulx;
    int x2=g.lrx;
    int y1=g.uly;
    int y2=g.lry;

    for(k=0; k<g.image_count; k++) z[k].hit=0;
     
    pointinfo(x1,y1,bpp,gotcolor,gotbw,white,black);
    maxbpp=max(bpp,maxbpp);
    maxwhite=max(white,maxwhite);
    pointinfo(x1,y2,bpp,gotcolor,gotbw,white,black);
    maxbpp=max(bpp,maxbpp);
    maxwhite=max(white,maxwhite);
    pointinfo(x2,y1,bpp,gotcolor,gotbw,white,black);
    maxbpp=max(bpp,maxbpp);
    maxwhite=max(white,maxwhite);
    pointinfo(x2,y2,bpp,gotcolor,gotbw,white,black);
    maxbpp=max(bpp,maxbpp);
    maxwhite=max(white,maxwhite);
    pointinfo((x1+x2)/2,(y1+y2)/2,bpp,gotcolor,gotbw,white,black);
    maxbpp=max(bpp,maxbpp);
    maxwhite=max(white,maxwhite);

    if(noofargs)
    {  if(noofargs>=1) darker=atoi(arg[1]);
       if(noofargs>=2) dr=atoi(arg[2]);
       if(noofargs>=3) dg=atoi(arg[3]);
       if(noofargs>=4) db=atoi(arg[4]);
       clickboxinfo c[3];
       c[0].noofbuttons=3;
       c[0].answer = dr;
       c[1].answer = dg;
       c[2].answer = db;
       addvalueok(c);
    }else
    {  if(gotbw)
       {  strcpy(temp,"Change pixel value");
          if(gotcolor) strcat(temp," in mono. part");
          clickbox(temp, 14, &darker, -maxwhite, maxwhite, null, 
               addvalueok, null, NULL, NULL, helptopic);
       }
       if(gotcolor)
       {   
          item = new clickboxinfo[3];
          item[0].title = new char[128];        
          item[0].wantpreview=0;
          strcpy(item[0].title,"Red");
          item[0].startval = dr;
          item[0].minval = -g.maxred[g.bitsperpixel];
          item[0].maxval = g.maxred[g.bitsperpixel];
          item[0].type = VALSLIDER;
          item[0].wantdragcb = 0;
          item[0].answers = new int[10]; // Must be 10 for multiclickbox cb
          item[0].form = NULL;
          item[0].path = NULL;

          item[1].title = new char[128];        
          strcpy(item[1].title,"Green");
          item[1].startval = dg;
          item[1].minval = -g.maxgreen[g.bitsperpixel];
          item[1].maxval = g.maxgreen[g.bitsperpixel];
          item[1].type = VALSLIDER;
          item[1].wantdragcb = 0;
          item[1].form = NULL;
          item[1].path = NULL;

          item[2].title = new char[128];        
          strcpy(item[2].title,"Blue");
          item[2].startval = db;
          item[2].minval = -g.maxblue[g.bitsperpixel];
          item[2].maxval = g.maxblue[g.bitsperpixel];
          item[2].type = VALSLIDER;
          item[2].wantdragcb = 0;
          item[2].form = NULL;
          item[2].path = NULL;

          strcpy(temp,"Pixel value adjustment");
          if(gotbw) strcat(temp," in color part");

          item[0].ino = ci;
          item[0].noofbuttons = 3;
          item[0].f1 = null;
          item[0].f2 = null;
          item[0].f3 = null;
          item[0].f4 = null;
          item[0].f5 = addvalueok;
          item[0].f6 = addvaluefinish;
          item[0].f7 = null;
          item[0].f8 = null;
          multiclickbox(temp, 3, item, null, helptopic);
       }
    }
}


//-------------------------------------------------------------------------//
// addvalueok                                                              //
//-------------------------------------------------------------------------//
void addvalueok(clickboxinfo *c)
{
   int dr=0,dg=0,db=0,darker=0,ino,j,k,i,rr,gg,bb,bpp=0,obpp=0,noscreen=1,
       value,x1,x2,y1,y2;
   dr = c[0].answer;
   darker = dr;
   if(c[0].noofbuttons >= 2) dg = c[1].answer;
   if(c[0].noofbuttons >= 3) db = c[2].answer;
   drawselectbox(OFF);
   printstatus(BUSY);
   x1 = g.ulx;  y1 = g.uly;
   x2 = g.lrx;  y2 = g.lry;
   printstatus(BUSY);

   g.raddvalue = dr;
   g.gaddvalue = dg;
   g.baddvalue = db;
   g.vaddvalue = darker;

   if(!g.getout)
   {  for(j=y1; j<=y2; j++)
      {  if(keyhit())if(getcharacter()==27)break;  
         for(i=x1; i<=x2; i++)
         {   
             if(!g.selected_is_square && !inside_irregular_region(i,j)) continue;
             value = readpixelonimage(i,j,bpp,ino);
             if(ino>=0)
             {  if(z[ino].hit==0 && z[ino].colortype==INDEXED) 
                {  z[ino].hit=2;  // Must be set before change_image_depth
                   if(change_image_depth(ino, 24, 0)!=OK) 
                   {  message("Insufficient image buffers available",ERROR);
                      g.getout=1; 
                      break;
                   }
                 }
             }
                 
             ////  Crossing boundary to image with different bpp
             if(bpp!=obpp)       
             {  if((ino>=0)&&(bpp==8))   
                {  obpp=bpp; 
                   switch_palette(ino);
                }
             }   
             if(z[ino].hit==0) z[ino].hit=1;
             if((bpp==8)||(ino>=0 && z[ino].colortype==GRAY))
             {  value += darker;
                value = min((uint)g.maxvalue[bpp],(uint)max(0,value));
                setpixelonimage(i,j,value,g.imode,bpp,-1,noscreen);
             }else
             {  valuetoRGB(value,rr,gg,bb,bpp);
                rr = max(0,min((int)g.maxred[bpp],( rr+dr )));
                gg = max(0,min((int)g.maxgreen[bpp], ( gg+dg )));
                bb = max(0,min((int)g.maxblue[bpp], ( bb+db )));
                value = RGBvalue(rr,gg,bb,bpp);
                setpixelonimage(i,j,value,g.imode,bpp,-1,noscreen);
             }
         }
         if(g.getout)break;
      }
           
      ////  Re-palettize any color images touched if in 8-bpp screen mode
      for(k=0; k<g.image_count; k++) 
      {  if(z[k].hit==2) 
         {     z[k].hit=1;
               change_image_depth(k,8,0);
         }
         if(z[k].hit) repair(k);
         z[k].hit = 0;
      }
      g.getout=0;
   }  
   printstatus(NORMAL);
}


//-------------------------------------------------------------------------//
// addvaluefinish                                                          //
//-------------------------------------------------------------------------//
void addvaluefinish(clickboxinfo *c)
{
  delete[] c[0].answers;
  delete[] c[0].title;
  delete[] c[1].title;
  delete[] c[2].title;
  delete[] c;                                   
}


//-------------------------------------------------------------------------//
// changebrightness                                                        //
//-------------------------------------------------------------------------//
void changebrightness(int noofargs, char **arg)
{
  if(memorylessthan(16384)){ message(g.nomemory,ERROR); return; }
  int helptopic=14;
  static clickboxinfo* item;
  int dr=g.radjust, dg=g.gadjust, db=g.badjust, 
      dh=g.hadjust, ds=g.sadjust, dv=g.vadjust;
  int value[10] = { 0,0,0,0,0,0,0,0,0,0 };

  if(ci>=0)
  {   switch_palette(ci);
      memcpy(z[ci].opalette,z[ci].palette,768); 
  }else
      memcpy(g.palette,g.b_palette,768); 

  g.getout=0;
  if(noofargs>0)          // Macro
  {    if(noofargs>=1) value[0]=atoi(arg[1]);  // r
       if(noofargs>=2) value[1]=atoi(arg[2]);  // g
       if(noofargs>=3) value[2]=atoi(arg[3]);  // b
       if(noofargs>=4) value[3]=atoi(arg[4]);  // h
       if(noofargs>=5) value[4]=atoi(arg[5]);  // s
       if(noofargs>=6) value[5]=atoi(arg[6]);  // v
       value[6]=1;        // make permanent
       addpalettecolors(value);   
       repair(ci);
  }else
  {    item = new clickboxinfo[6];
       item[0].wantpreview=0;
       item[0].title = new char[128];
       strcpy(item[0].title,"Red");
       item[0].startval = dr;
       item[0].minval = -g.maxred[g.bitsperpixel];
       item[0].maxval = g.maxred[g.bitsperpixel];
       item[0].type = 2;
       item[0].wantdragcb = 0;
       item[0].answers = new int[10];   // Must have 10 for addpalettecolors()
       item[0].answers[0]=0;
       item[0].answers[1]=0;
       item[0].answers[2]=0;
       item[0].answers[3]=0;
       item[0].answers[4]=0;
       item[0].answers[5]=0;
       item[0].answers[6]=0;
       item[0].form = NULL;
       item[0].path = NULL;

       item[1].title = new char[128];
       strcpy(item[1].title,"Green");
       item[1].startval = dg;
       item[1].minval = -g.maxgreen[g.bitsperpixel];
       item[1].maxval = g.maxgreen[g.bitsperpixel];
       item[1].type = 2;
       item[1].wantdragcb = 0;
       item[1].answers = item[0].answers;
       item[1].form = NULL;
       item[1].path = NULL;

       item[2].title = new char[128];
       strcpy(item[2].title,"Blue");
       item[2].startval = db;
       item[2].minval = -g.maxblue[g.bitsperpixel];
       item[2].maxval = g.maxblue[g.bitsperpixel];
       item[2].type = 2;
       item[2].wantdragcb = 0;
       item[2].answers = item[0].answers;
       item[2].form = NULL;
       item[2].path = NULL;

       item[3].title = new char[128];
       strcpy(item[3].title,"Hue");
       item[3].startval = dh;
       item[3].minval = -360;
       item[3].maxval = 360;
       item[3].type = 2;
       item[3].wantdragcb = 0;
       item[3].answers = item[0].answers;
       item[3].form = NULL;
       item[3].path = NULL;

       item[4].title = new char[128];
       strcpy(item[4].title,"Saturation");
       item[4].startval = ds;
       item[4].minval = -g.maxblue[g.bitsperpixel];
       item[4].maxval = g.maxblue[g.bitsperpixel];
       item[4].type = 2;
       item[4].wantdragcb = 0;
       item[4].answers = item[0].answers;
       item[4].form = NULL;
       item[4].path = NULL;

       item[5].title = new char[128];
       strcpy(item[5].title,"Value");
       item[5].startval = dv;
       if(g.bitsperpixel==8)
       { item[5].minval = -63;
         item[5].maxval = 63;
       }else
       { item[5].minval = -g.maxgray[g.bitsperpixel];
         item[5].maxval = g.maxgray[g.bitsperpixel];
       }
       item[5].type = 2;
       item[5].wantdragcb = 0;
       item[5].answers = item[0].answers;
       item[5].form = NULL;
       item[5].path = NULL;

       item[0].ino = ci;
       item[0].noofbuttons = 6;
       item[0].f1 = null;
       item[0].f2 = null;
       item[0].f3 = null;
       item[0].f4 = null;
       item[0].f5 = changebrightnessok;
       item[0].f6 = changebrightnessfinish;
       item[0].f7 = null;
       item[0].f8 = null;
       multiclickbox("Color adjustment", 6, item, addpalettecolors, helptopic);
  }
}


//-------------------------------------------------------------------------//
// changebrightnessok                                                      //
//-------------------------------------------------------------------------//
void changebrightnessok(clickboxinfo *c)
{
  int *value = c[0].answers;
  int ino = c[0].ino;
  g.radjust = value[0] = c[0].answer;
  g.gadjust = value[1] = c[1].answer;
  g.badjust = value[2] = c[2].answer;
  g.hadjust = value[3] = c[3].answer;
  g.sadjust = value[4] = c[4].answer;
  g.vadjust = value[5] = c[5].answer;
  value[6] = 1;  // Make palette change permanent 
  drawselectbox(OFF);
  addpalettecolors(value);   
  if(ino>=0)
  {   memcpy(z[ino].palette,g.palette,768); 
      setpalette(z[ino].palette);
      rebuild_display(ino);
      redraw(ino);
      z[ino].touched = 1;
  }else memcpy(g.b_palette, g.palette, 768); 
  g.getout=0;
  value[6]=  0;   // Make palette change temporary (for slider)
}


//-------------------------------------------------------------------------//
// changebrightnessfinish                                                  //
//-------------------------------------------------------------------------//
void changebrightnessfinish(clickboxinfo *c)
{
  int k;
  delete[] c[0].answers;
  for(k=0;k<=5;k++) delete[] c[k].title; 
  delete[] c;          
}


//--------------------------------------------------------------------------//
// addpalettecolors - add r,g,b,& i in palette by dr,dg,db,di               //
// d[] is value to add to 0=r 1=g 2=b 3=h 4=s 5=v.                          //
// If value[6] is 1, the change is permanent, otherwise it is temporary.    //
// Compatible with multiclickbox                                            //
//--------------------------------------------------------------------------//
void addpalettecolors(int d[10])
{ 
   RGB opal[256];
   int hitgray=0,f,i,i2,i3,j,k,bpp,ino,value,rr,gg,bb,obpp=0,noscreen=1,xx,yy;
   int x1,y1,x2,y2;
   int dr,dg,db;
   int dh,ds,dv,hh,ss,vv;
   printstatus(BUSY);

   ////  If color, changing 'intensity' should change rg&b
   dr = d[0];
   dg = d[1];
   db = d[2];
   dh = d[3];
   ds = d[4];
   dv = d[5];

   for(k=0; k<g.image_count; k++) z[k].hit=0;
   
   if(d[6]==0)                          // Fast as possible & temporary
   {    if(g.bitsperpixel==8)           // If 8bpp, adjust palette only
        {
            memcpy(opal,g.palette,768);
            for(j=0;j<256;j++) 
            {   g.palette[j].red   = max(0,min(63,(uchar)(dr + g.palette[j].red))); 
                g.palette[j].green = max(0,min(63,(uchar)(dg + g.palette[j].green)));
                g.palette[j].blue  = max(0,min(63,(uchar)(db + g.palette[j].blue)));
            }
            setpalette(g.palette);  
            memcpy(g.palette,opal,768); // restore original palette 
        }else                           // Otherwise, adjust z.img
        {
            if(g.selectedimage>=0 && ci>=0)  // Entire image
            {   bpp = z[ci].bpp;
                f = z[ci].cf;
                if(z[ci].colortype==GRAY)
                {   dr=dv;dg=dv;db=dv; 
                    int save = z[ci].gray[0];
                    int save2 = z[ci].gray[1];
                    z[ci].gray[0] = (int)(z[ci].gray[0] - dv); 
                    z[ci].gray[1] = (int)(z[ci].gray[1] - dv); 
                    z[ci].hitgray = 1;  
                    rebuild_display(ci);
                    z[ci].gray[0] =save;
                    z[ci].gray[1] =save2;
                }else
                for(j=0;j<z[ci].ysize;j++)
                for(i=0,i2=0,i3=0;i<z[ci].xsize;i++,i2+=g.off[bpp],i3+=g.off[g.bitsperpixel])
                {   
                    value = pixelat(z[ci].image[z[ci].cf][j]+i2,bpp);
                    valuetoRGB(value,rr,gg,bb,bpp);
                    convertRGBpixel(rr,gg,bb,bpp,g.bitsperpixel);
                    rr = max(0,min((int)g.maxred[g.bitsperpixel], (int)(rr+dr)));
                    gg = max(0,min((int)g.maxgreen[g.bitsperpixel], (int)(gg+dg)));
                    bb = max(0,min((int)g.maxblue[g.bitsperpixel], (int)(bb+db)));
                    if(dh || ds || dv)
                    {    RGBtoHSV(rr, gg, bb, hh, ss, vv, g.bitsperpixel);
                         hh = max(0,min(360, hh+dh));
                         ss = max(0,min(g.maxgray[g.bitsperpixel],  ss+ds));
                         vv = max(0,min(g.maxgray[g.bitsperpixel],  vv+dv));
                         HSVtoRGB(hh, ss, vv, rr, gg, bb, g.bitsperpixel);
                    }
                    value = RGBvalue(rr,gg,bb,g.bitsperpixel);
                    putpixelbytes(z[ci].img[j]+i3, value);
                }
            }else                      // Part of image
            {  
                for(j=g.uly;j<=g.lry;j++)
                for(i=g.ulx;i<=g.lrx;i++)
                {                  
                    if(!g.selected_is_square && !inside_irregular_region(i,j)) continue;
                    value = readpixelonimage(i,j,bpp,ino);
                    valuetoRGB(value,rr,gg,bb,bpp);
                    convertRGBpixel(rr,gg,bb,bpp,g.bitsperpixel);
                    rr = max(0,min((int)g.maxred[g.bitsperpixel], (int)(rr+dr)));
                    gg = max(0,min((int)g.maxgreen[g.bitsperpixel], (int)(gg+dg)));
                    bb = max(0,min((int)g.maxblue[g.bitsperpixel], (int)(bb+db)));
                    if(dh || ds || dv)
                    {    RGBtoHSV(rr, gg, bb, hh, ss, vv, g.bitsperpixel);
                         hh = max(0,min(360, hh+dh));
                         ss = max(0,min(g.maxgray[g.bitsperpixel],  ss+ds));
                         vv = max(0,min(g.maxgray[g.bitsperpixel],  vv+dv));
                         HSVtoRGB(hh, ss, vv, rr, gg, bb, g.bitsperpixel);
                    }
                    value = RGBvalue(rr,gg,bb,g.bitsperpixel);
                    setpixel(i,j,value,g.imode);
                }
            }
        }
        redraw(ci);
        redrawscreen();

   }else                                // Slow but accurate
   {    
        if(g.selectedimage>=0 && ci>=0) // Entire image
        {   bpp = z[ci].bpp;
            f = z[ci].cf;
            if(z[ci].colortype==GRAY)
            {  
                hitgray = 1;
                for(j=0;j<z[ci].ysize;j++)
                for(i=0,i2=0;i<z[ci].xsize;i++,i2+=g.off[bpp])
                {   
                    value = pixelat(z[ci].image[f][j]+i2,bpp);
                    value = min((int)g.maxvalue[bpp], (int)max(0,(dv + value)));
                    putpixelbytes(z[ci].image[f][j]+i2, value, 1, bpp, 1);
                    ////  This only needs to be done for grayscale
                    if(z[ci].floatexists || z[ci].waveletexists)
                    {   xx = i + z[ci].xpos;
                        yy = j + z[ci].ypos;
                        if(z[ci].floatexists) setfloatpixel(xx,yy,value,ci);
                        if(z[ci].waveletexists) setwaveletpixel(xx,yy,value,ci);
                    }
                }
            }else
            {   //// If part of an indexed image, must convert to color
                //// then regenerate colormap

                if(ci>=0 && z[ci].hit==0 && z[ci].colortype==INDEXED) 
                {    z[ci].hit=2;    // Must be set before change_image_depth
                     if(change_image_depth(ci,24,0)!=OK) 
                     {   message("Insufficient image buffers available",ERROR);
                         g.getout=1; 
                         return;
                     }
                     bpp=24;
                }
                for(j=0;j<z[ci].ysize;j++)
                for(i=0,i2=0;i<z[ci].xsize;i++,i2+=g.off[bpp])
                {   value = pixelat(z[ci].image[f][j]+i2,bpp);
                    valuetoRGB(value,rr,gg,bb,bpp);
                    rr = max(0,min(g.maxred[bpp],   rr+dr));
                    gg = max(0,min(g.maxgreen[bpp], gg+dg));
                    bb = max(0,min(g.maxblue[bpp],  bb+db));
                    if(dh || ds || dv)
                    {    RGBtoHSV(rr, gg, bb, hh, ss, vv, bpp);
                         hh = max(0,min(360, hh+dh));
                         ss = max(0,min(g.maxgray[bpp],  ss+ds));
                         vv = max(0,min(g.maxgray[bpp],  vv+dv));
                         HSVtoRGB(hh, ss, vv, rr, gg, bb, bpp);
                    }
                    value = RGBvalue(rr,gg,bb,bpp);
                    putpixelbytes(z[ci].image[f][j]+i2, value, 1, bpp, 1);
                }
                for(k=0; k<g.image_count; k++) 
                {   if(z[k].hit==2)
                    {     z[k].hit=1;
                          change_image_depth(k,8,0);
                    }
                }
            }
            redraw(ci);
        }else                 // Selected region only
        {
            x1 = g.ulx;
            y1 = g.uly;
            x2 = g.lrx;
            y2 = g.lry;
            for(j=y1;j<=y2;j++)
            for(i=x1;i<=x2;i++)
            {   
                if(!g.selected_is_square && !inside_irregular_region(i,j)) continue;
                value = readpixelonimage(i,j,bpp,ino);
                ////  Crossing boundary to image with different bpp
                     
                if(ino>=0 && bpp!=obpp && bpp==8)
                {    obpp=bpp; 
                     switch_palette(ino);
                }   
                    
                //// If part of an indexed image, must convert to color
                //// then regenerate colormap
                        
                if(ino>=0 && z[ino].hit==0 && z[ino].colortype==INDEXED) 
                {    
                     z[ino].hit=2;    // Must be set before change_image_depth
                     if(change_image_depth(ino,24,0)==OK) bpp=24;
                     else
                     {   message("Insufficient image buffers available",ERROR);
                         g.getout=1; 
                         break;
                     }
                }
                noscreen=1;
                  
                ////  Must convert to screen bits/pixel so the increment is the
                ////  same as the preview above. Otherwise the increase in brightness
                ////  could be doubled if, for example, a 16 bpp image was adjusted 
                ////  at 24 bpp screen depth.
                
                if(ino>=0 && z[ino].colortype==GRAY)
                {    value = min((int)g.maxvalue[bpp], (int)(value+dv));
                     hitgray = 1;
                }else
                {    valuetoRGB(value,rr,gg,bb,bpp);
                     convertRGBpixel(rr,gg,bb,bpp,g.bitsperpixel);
                     rr = max(0,min((int)g.maxred[g.bitsperpixel], (int)(rr+dr)));
                     gg = max(0,min((int)g.maxgreen[g.bitsperpixel], (int)(gg+dg)));
                     bb = max(0,min((int)g.maxblue[g.bitsperpixel], (int)(bb+db)));
                     if(dh || ds || dv)
                     {    RGBtoHSV(rr, gg, bb, hh, ss, vv, g.bitsperpixel);
                          hh = max(0,min(360, hh+dh));
                          ss = max(0,min(g.maxgray[g.bitsperpixel],  ss+ds));
                          vv = max(0,min(g.maxgray[g.bitsperpixel],  vv+dv));
                          HSVtoRGB(hh, ss, vv, rr, gg, bb, g.bitsperpixel);
                     }
                     convertRGBpixel(rr,gg,bb,g.bitsperpixel,bpp);
                     value = RGBvalue(rr,gg,bb,bpp);
                }
                setpixelonimage(i,j,value,g.imode,bpp,-1,noscreen);
            }            
           
            ////  Re-palettize any color images touched if in 8-bpp screen mode.
            ////  See invertcolors() in xmtnimage2.cc for an explanation of this code.
            for(k=0; k<g.image_count; k++) 
            {   if(z[k].hit==2) 
                {     z[k].hit=1;
                      change_image_depth(k,8,0);
                }
            }
            for(k=0; k<g.image_count; k++) 
            {  if(z[k].hit)
               {     if(k!=ci) switchto(k);
                     rebuild_display(k); 
                     redraw(k); 
                     if(z[k].colortype==INDEXED) memcpy(z[k].opalette,z[k].palette,768);
               }
            }
        }
    }
    if(hitgray && (d[0] || d[1] || d[2])) message(notcolor, WARNING);
    printstatus(NORMAL);
}


//--------------------------------------------------------------------------//
// multiplypalettecolors - multiply r,g,b,& i in palette by dr,dg,db,di     //
// Compatible with multiclickbox                                            //
// If value[6] is 1, the change is permanent, otherwise it is temporary.    //
//--------------------------------------------------------------------------//
void multiplypalettecolors(int d[10])
{ 
   RGB opal[256];
   int f,i,i2,i3,j,k,bpp,ino,value,rr,gg,bb,hh,ss,vv,xx,yy,obpp=0;
   int x1,y1,x2,y2,noscreen=1;
   double dr,dg,db,dh,ds,dv;
   printstatus(BUSY);
   dr = ((double)d[0])/100.0;
   dg = ((double)d[1])/100.0;
   db = ((double)d[2])/100.0;
   dh = ((double)d[3])/100.0;
   ds = ((double)d[4])/100.0;
   dv = ((double)d[5])/100.0;

   for(k=0; k<g.image_count; k++) z[k].hit=0;
   if(d[6]==0)                          // Fast as possible & temporary
   {    if(g.bitsperpixel==8 && dh==1.0 && ds==1.0)
        {
            memcpy(opal,g.palette,768);
            for(j=0;j<256;j++) 
            {   g.palette[j].red   = max(0,min(63,(uchar)(dr * g.palette[j].red))); 
                g.palette[j].green = max(0,min(63,(uchar)(dg * g.palette[j].green)));
                g.palette[j].blue  = max(0,min(63,(uchar)(db * g.palette[j].blue)));
            }
            setpalette(g.palette);  
            memcpy(g.palette,opal,768); // restore original palette 
        }else                           // Otherwise, adjust z.img
        {
            if(g.selectedimage>=0 && ci>=0)  // Entire image
            {   bpp = z[ci].bpp;
                f = z[ci].cf;
                if(z[ci].colortype==GRAY)
                {  
                    if(dr!=1 || dg!=1 || db!=1 || dh!=1 || ds!=1)
                    {    d[0]=d[1]=d[2]=d[3]=d[4]=100; 
                         message(notcolor); // can't have blocking message
                                            // here due to bug in motif
                         return;
                    }
                    dr=1;dg=1;db=1; 
                    int save = z[ci].gray[0];
                    int save2 = z[ci].gray[1];
                    z[ci].gray[0] = (int)(z[ci].gray[0] / dv); 
                    z[ci].gray[1] = (int)(z[ci].gray[1] * dv); 
                    z[ci].hitgray = 1;  
                    rebuild_display(ci);
                    z[ci].gray[0] =save;
                    z[ci].gray[1] =save2;
                }else
                for(j=0;j<z[ci].ysize;j++)
                for(i=0,i2=0,i3=0;i<z[ci].xsize;i++,i2+=g.off[bpp],i3+=g.off[g.bitsperpixel])
                {   value = pixelat(z[ci].image[z[ci].cf][j]+i2,bpp);
                    valuetoRGB(value,rr,gg,bb,bpp);
                    convertRGBpixel(rr,gg,bb,bpp,g.bitsperpixel);
                    rr = max(0,min((int)g.maxred[g.bitsperpixel], (int)(rr*dr)));
                    gg = max(0,min((int)g.maxgreen[g.bitsperpixel], (int)(gg*dg)));
                    bb = max(0,min((int)g.maxblue[g.bitsperpixel], (int)(bb*db)));
                    if(dh!=1.0 || ds!=1.0 || dv!=1.0)
                    {    RGBtoHSV(rr, gg, bb, hh, ss, vv, g.bitsperpixel);
                         hh = max(0,min(360, cint(hh*dh)));
                         ss = max(0,min(g.maxgray[g.bitsperpixel],  cint(ss*ds)));
                         vv = max(0,min(g.maxgray[g.bitsperpixel],  cint(vv*dv)));
                         HSVtoRGB(hh, ss, vv, rr, gg, bb, g.bitsperpixel);
                    }
                    value = RGBvalue(rr,gg,bb,g.bitsperpixel);
                    putpixelbytes(z[ci].img[j]+i3, value);
                }
            }else
            {
                for(j=g.uly;j<=g.lry;j++)
                for(i=g.ulx;i<=g.lrx;i++)
                {   
                    if(!g.selected_is_square && !inside_irregular_region(i,j)) continue;
                    value = readpixelonimage(i,j,bpp,ino);
                    valuetoRGB(value,rr,gg,bb,g.bitsperpixel);
                    convertRGBpixel(rr,gg,bb,bpp,g.bitsperpixel);
                    rr = max(0,min((int)g.maxred[g.bitsperpixel], (int)(rr*dr)));
                    gg = max(0,min((int)g.maxgreen[g.bitsperpixel], (int)(gg*dg)));
                    bb = max(0,min((int)g.maxblue[g.bitsperpixel], (int)(bb*db)));
                    if(dh!=1.0 || ds!=1.0 || dv!=1.0)
                    {    RGBtoHSV(rr, gg, bb, hh, ss, vv, g.bitsperpixel);
                         hh = max(0,min(360, cint(hh*dh)));
                         ss = max(0,min(g.maxgray[g.bitsperpixel],  cint(ss*ds)));
                         vv = max(0,min(g.maxgray[g.bitsperpixel],  cint(vv*dv)));
                         HSVtoRGB(hh, ss, vv, rr, gg, bb, g.bitsperpixel);
                    }
                    value = RGBvalue(rr,gg,bb,g.bitsperpixel);
                    setpixel(i,j,value,g.imode);
                }
            }
        }
        redraw(ci);
        redrawscreen();
   }else                                // Slow but accurate
   {    
        if(g.selectedimage>=0)          // Entire image
        {   bpp = z[ci].bpp;
            f = z[ci].cf;
            if(z[ci].colortype==GRAY)
            {  
                if(dr!=1 || dg!=1 || db!=1 || dh!=1 || ds!=1)
                {   message(notcolor); d[0]=d[1]=d[2]=d[3]=d[4]=100; return; }
                for(j=0;j<z[ci].ysize;j++)
                for(i=0,i2=0;i<z[ci].xsize;i++,i2+=g.off[bpp])
                {   value = pixelat(z[ci].image[f][j]+i2,bpp);
                    value = min((int)g.maxvalue[bpp], (int)max(0,(dv * value)));
                    putpixelbytes(z[ci].image[f][j]+i2, value, 1, bpp, 1);
                    ////  This only needs to be done for grayscale
                    if(z[ci].floatexists || z[ci].waveletexists)
                    {   xx = i + z[ci].xpos;
                        yy = j + z[ci].ypos;
                        if(z[ci].floatexists) setfloatpixel(xx,yy,value,ci);
                        if(z[ci].waveletexists) setwaveletpixel(xx,yy,value,ci);
                    }
                }
            }else
            {   //// If part of an indexed image, must convert to color
                //// then regenerate colormap

                if(ci>=0 && z[ci].hit==0 && z[ci].colortype==INDEXED) 
                {   z[ci].hit=2;    // Must be set before change_image_depth                   
                    if(change_image_depth(ci,24,0)!=OK) 
                     {   message("Insufficient image buffers available",ERROR);
                         g.getout=1; 
                         return;
                     }
                     bpp=24;
                }
                for(j=0;j<z[ci].ysize;j++)
                for(i=0,i2=0;i<z[ci].xsize;i++,i2+=g.off[bpp])
                {   value = pixelat(z[ci].image[f][j]+i2,bpp);
                    valuetoRGB(value,rr,gg,bb,bpp);
                    rr = max(0,min((int)g.maxred[bpp], (int)(rr*dr)));
                    gg = max(0,min((int)g.maxgreen[bpp], (int)(gg*dg)));
                    bb = max(0,min((int)g.maxblue[bpp], (int)(bb*db)));
                    if(dh!=1.0 || ds!=1.0 || dv!=1.0)
                    {    RGBtoHSV(rr, gg, bb, hh, ss, vv, bpp);
                         hh = max(0,min(360, cint(hh*dh)));
                         ss = max(0,min(g.maxgray[bpp],  cint(ss*ds)));
                         vv = max(0,min(g.maxgray[bpp],  cint(vv*dv)));
                         HSVtoRGB(hh, ss, vv, rr, gg, bb, bpp);
                    }
                    value = RGBvalue(rr,gg,bb,bpp);
                    putpixelbytes(z[ci].image[f][j]+i2, value, 1, bpp, 1);
                }
                for(k=0; k<g.image_count; k++) 
                {   if(z[k].hit==2)
                    {     z[k].hit=1;
                          change_image_depth(k,8,0);
                    }
                }
            }
            redraw(ci);
        }else                      // Part of image
        {   
            x1 = g.ulx;
            y1 = g.uly;
            x2 = g.lrx;
            y2 = g.lry;

            for(j=y1;j<=y2;j++)
            for(i=x1;i<=x2;i++)
            {   
                if(!g.selected_is_square && !inside_irregular_region(i,j)) continue;
                value = readpixelonimage(i,j,bpp,ino);
 
                ////  Crossing boundary to image with different bpp

                if(ino>=0 && bpp!=obpp && bpp==8)
                {    obpp=bpp; 
                     switch_palette(ino);
                }   

                //// If part of an indexed image, must convert to color
                //// then regenerate colormap

                if(ino>=0 && z[ino].hit==0 && z[ino].colortype==INDEXED) 
                {    z[ino].hit=2;    // Must be set before change_image_depth
                     if(change_image_depth(ino,24,0)!=OK) 
                     {   message("Insufficient image buffers available",ERROR);
                         g.getout=1; 
                         break;
                     }
                     bpp=24;
                }

                if(ino>=0 && z[ino].colortype==GRAY)
                {    if(dr!=1 || dg!=1 || db!=1 || dh!=1 || ds!=1)
                     {  d[0]=d[1]=d[2]=d[3]=d[4]=100; message(notcolor); return; }
                     value = min((int)g.maxvalue[bpp], (int)(dv * value));
                }else
                {    valuetoRGB(value,rr,gg,bb,bpp);
                     convertRGBpixel(rr,gg,bb,bpp,g.bitsperpixel);              
                     rr = max(0,min((int)g.maxred[g.bitsperpixel], (int)(rr*dr)));
                     gg = max(0,min((int)g.maxgreen[g.bitsperpixel], (int)(gg*dg)));
                     bb = max(0,min((int)g.maxblue[g.bitsperpixel], (int)(bb*db)));
                     if(dh!=1.0 || ds!=1.0 || dv!=1.0)
                     {    RGBtoHSV(rr, gg, bb, hh, ss, vv, g.bitsperpixel);
                          hh = max(0,min(360, cint(hh*dh)));
                          ss = max(0,min(g.maxgray[g.bitsperpixel],  cint(ss*ds)));
                          vv = max(0,min(g.maxgray[g.bitsperpixel],  cint(vv*dv)));
                          HSVtoRGB(hh, ss, vv, rr, gg, bb, g.bitsperpixel);
                     }
                     convertRGBpixel(rr,gg,bb,g.bitsperpixel,bpp);              
                     value = RGBvalue(rr,gg,bb,bpp);
                }
                setpixelonimage(i,j,value,g.imode,bpp,-1,noscreen);
                if(ino>=0 && (!z[ino].hit)) z[ino].hit=1;
            }
                               
            ////  Re-palettize any color images touched if in 8-bpp screen mode.
            ////  See invertcolors() in xmtnimage2.cc for an explanation of this code.
            for(k=0; k<g.image_count; k++) 
            {   if(z[k].hit==2) 
                {     z[k].hit=1;
                      change_image_depth(k,8,0);
                }
            }
            for(k=0; k<g.image_count; k++) 
            {  if(z[k].hit)
               {     if(k!=ci) switchto(k);
                     rebuild_display(k); 
                     redraw(k); 
                     if(z[k].colortype==INDEXED) memcpy(z[k].opalette,z[k].palette,768);
               }
            }
        }
    }
    printstatus(NORMAL);
}


//--------------------------------------------------------------------------//
// localcontrast                                                            //
//--------------------------------------------------------------------------//
void localcontrast(int noofargs, char **arg)
{
  filter ff;
  ff.filename[0] = 0;
  ff.ino = ci;
  ff.type = 0;
  ff.sharpfac = 100;
  ff.local_scale = 10;
  ff.do_filtering = 1;
  ff.background = 127;
  if(noofargs>=1) ff.local_scale = atoi(arg[1]);
  if(noofargs>=2) ff.sharpfac = atoi(arg[2]);
  if(z[ci].colortype == GRAY) localcontrast_gray(&ff);
  else  localcontrast_color(&ff);
}
void localcontrast(filter *ff)
{
   if(z[ci].colortype == GRAY) localcontrast_gray(ff);
   else  localcontrast_color(ff);
}



//--------------------------------------------------------------------------//
// localcontrast_gray - coordinates are relative to upper left of image     //
//--------------------------------------------------------------------------//
void localcontrast_gray(filter *ff)
{
   Widget www, scrollbar;
   int bpp,frame,i,i2,j,k,l,value, maxval, minval, b, increment,
       maxval2,minval2,maxval3,minval3,maxval4,minval4,maxval6,minval6,maxval8,
       minval8;
   double contrast, maxrange;
   double shnew = ((double)ff->sharpfac)/100.0;  // Fraction of new pixel to use
   double shold = 1.0-shnew;                     // Fraction of old pixel to keep
   int ino = ff->ino;
   int xsize = z[ino].xsize;
   int ysize = z[ino].ysize;
   int xpos = z[ino].xpos;
   int ypos = z[ino].ypos;
   int x1 = g.ulx - xpos;
   int x2 = g.lrx - xpos;
   int y1 = g.uly - ypos;
   int y2 = g.lry - ypos;
   x1 = max(0, min(x1, xsize-1));                // ignore ff->x1, etc 
   x2 = max(0, min(x2, xsize-1));
   y1 = max(0, min(y1, ysize-1));
   y2 = max(0, min(y2, ysize-1));
   uchar *buffer_1d;
   uchar **buffer;
   uchar **add;
   bpp = z[ino].bpp;
   b = (7+bpp)/8;
   frame = z[ino].cf;
   xsize = z[ino].xsize;
   ysize = z[ino].ysize;
   increment = max(1, 1+ff->local_scale/5);
   printstatus(CALCULATING);
   buffer_1d  = (uchar*)malloc(xsize*ysize*b);
   buffer = make_2d_alias(buffer_1d, xsize*b, ysize);
   maxrange = g.maxvalue[bpp];
   progress_bar_open(www, scrollbar);
   add = z[ino].image[frame];
   for(j=y1;j<y2;j++)
   {
      for(i=x1, i2=x1*b; i<x2; i++,i2+=b)
      if(g.selected_is_square || inside_irregular_region(i+xpos,j+ypos))
      {
           contrast = 1;
           maxval  = 0; minval  = (int)g.maxvalue[bpp];
           maxval2 = 0; minval2 = (int)g.maxvalue[bpp];
           maxval3 = 0; minval3 = (int)g.maxvalue[bpp];
           maxval4 = 0; minval4 = (int)g.maxvalue[bpp];
           maxval6 = 0; minval6 = (int)g.maxvalue[bpp];
           maxval8 = 0; minval8 = (int)g.maxvalue[bpp];
           progress_bar_update(scrollbar, j*100/ysize);
           if(g.image_count <= ino){ message("Hey!",ERROR); g.getout=1; break; }

           for(l=j-ff->local_scale; l<=j+ff->local_scale; l+=increment)
           for(k=i-ff->local_scale; k<=i+ff->local_scale; k+=increment)
           {   if(l>=ysize || k>=xsize || l<0 || k<0) continue;
               value = pixelat(add[l] + k*b, bpp);
               if(value > maxval) maxval = value;
               if(value < minval) minval = value;
           }
           for(l=j-2*ff->local_scale; l<=j+2*ff->local_scale; l+=2*increment)
           for(k=i-2*ff->local_scale; k<=i+2*ff->local_scale; k+=2*increment)
           {   if(l>=ysize || k>=xsize || l<0 || k<0) continue;
               value = pixelat(add[l] + k*b, bpp);
               if(value > maxval2) maxval2 = value;
               if(value < minval2) minval2 = value;
           }
           for(l=j-3*ff->local_scale; l<=j+3*ff->local_scale; l+=3*increment)
           for(k=i-3*ff->local_scale; k<=i+3*ff->local_scale; k+=3*increment)
           {   if(l>=ysize || k>=xsize || l<0 || k<0) continue;
               value = pixelat(add[l] + k*b, bpp);
               if(value > maxval3) maxval3 = value;
               if(value < minval3) minval3 = value;
           }
           for(l=j-4*ff->local_scale; l<=j+4*ff->local_scale; l+=4*increment)
           for(k=i-4*ff->local_scale; k<=i+4*ff->local_scale; k+=4*increment)
           {   if(l>=ysize || k>=xsize || l<0 || k<0) continue;
               value = pixelat(add[l] + k*b, bpp);
               if(value > maxval4) maxval4 = value;
               if(value < minval4) minval4 = value;
           }
           for(l=j-6*ff->local_scale; l<=j+6*ff->local_scale; l+=6*increment)
           for(k=i-6*ff->local_scale; k<=i+6*ff->local_scale; k+=6*increment)
           {   if(l>=ysize || k>=xsize || l<0 || k<0) continue;
               value = pixelat(add[l] + k*b, bpp);
               if(value > maxval6) maxval6 = value;
               if(value < minval6) minval6 = value;
           }
           for(l=j-8*ff->local_scale; l<=j+8*ff->local_scale; l+=8*increment)
           for(k=i-8*ff->local_scale; k<=i+8*ff->local_scale; k+=8*increment)
           {   if(l>=ysize || k>=xsize || l<0 || k<0) continue;
               value = pixelat(add[l] + k*b, bpp);
               if(value > maxval8) maxval8 = value;
               if(value < minval8) minval8 = value;
           }

           value = pixelat(add[j] + i2, bpp);
           maxval = (6*maxval + 5*maxval2 + 4*maxval3 + 3*maxval4 + 2*maxval6 + 1*maxval8)/21;
           minval = (6*minval + 5*minval2 + 4*minval3 + 3*minval4 + 2*minval6 + 1*minval8)/21;
           if(maxval<=minval) maxval=minval+4;
           contrast = maxrange / (double)(maxval - minval);
           value = cint(shold*value + shnew*(value - minval) * contrast); 
           value = max(0, min(value, (int)maxrange));
           putpixelbytes(buffer[j]+i2, value, 1, bpp, 1);
      }else
      {    value = pixelat(add[j] + i2, bpp);
           putpixelbytes(buffer[j]+i2, value, 1, bpp, 1);
      }
      check_event();
      if(g.getout) break;
   }
   if(!g.getout)
   for(j=y1; j<y2; j++)
   for(i=x1, i2=x1*b; i<x2; i++,i2+=b)
   {    value = pixelat(buffer[j]+i2, bpp);
        putpixelbytes(z[ino].image[frame][j]+i2, value, 1, bpp, 1);
   }
   g.getout = 0;
   progress_bar_close(www);
   repair(ino);
   rebuild_display(ino);
   redraw(ino);
   z[ino].touched = 1;
   free(buffer);
   free(buffer_1d);
   printstatus(NORMAL);
}


//--------------------------------------------------------------------------//
// RGBtoHSV  h=[0,360] s=[0,255] v=[0,255]                                  //
//--------------------------------------------------------------------------//
void RGBtoHSV(int rr, int gg, int bb, int &hh, int &ss, int &vv, int bpp)
{
   int fmin, fmax, delta;
   double h1=0.0;
   fmin = min(rr, min(gg, bb));
   fmax = max(rr, max(gg, bb));
   vv = fmax;
   delta = fmax - fmin;
   if(fmax) ss = g.maxgray[bpp]*delta/fmax; else ss = 0; 
   if(!delta) h1=0.0;
   else if(rr==fmax) h1 =     (double)(gg - bb)/(double)delta;  // between yellow & magenta
   else if(gg==fmax) h1 = 2 + (double)(bb - rr)/(double)delta;  // between cyan & yellow
   else              h1 = 4 + (double)(rr - gg)/(double)delta;  // between magenta & cyan
   hh = cint(h1*60);
   if(hh<0) hh+= 360;

}


//--------------------------------------------------------------------------//
// HSVtoRGB h=[0,360] s=[0,255] v=[0,255]                                   //
//--------------------------------------------------------------------------//
void HSVtoRGB(int hh, int ss, int vv, int &rr, int &gg, int &bb, int bpp)
{ 
  double f, p, q, t;
  double r1,g1,b1,h1,s1,v1;
  int i;
  ss = min(g.maxgray[bpp], max(ss, 1));
  vv = min((int)g.maxgray[bpp], max(vv, 1));
  h1 = (double)hh;
  s1 = (double)ss/g.maxgray[bpp];
  v1 = (double)vv/g.maxgray[bpp];
  if(s1==0){ rr=gg=bb=vv; return; }
  h1 /= 60;
  i = (int)floor(h1);
  f = h1 - i;
  p = v1 * (1 - s1);
  q = v1 * (1 - s1 * f);
  t = v1 * (1 - s1 *(1 - f));
  switch(i)
  {    case 0:  r1 = v1; g1 = t ; b1 = p ; break;
       case 1:  r1 = q ; g1 = v1; b1 = p ; break;
       case 2:  r1 = p ; g1 = v1; b1 = t ; break;
       case 3:  r1 = p ; g1 = q ; b1 = v1; break;
       case 4:  r1 = t ; g1 = p ; b1 = v1; break;
       default: r1 = v1; g1 = p ; b1 = q ; break;
  }           
  rr = cint(r1 * g.maxred[bpp]);
  gg = cint(g1 * g.maxgreen[bpp]);
  bb = cint(b1 * g.maxblue[bpp]);
  rr = max(0,min(rr, g.maxred[bpp]));
  gg = max(0,min(gg, g.maxgreen[bpp]));
  bb = max(0,min(bb, g.maxblue[bpp]));
}


//--------------------------------------------------------------------------//
// localcontrast_color                                                      //
//--------------------------------------------------------------------------//
void localcontrast_color(filter *ff)
{
   Widget www, scrollbar;
   int bpp,frame,e,f,h,i,i2,j,k,kk,l,ll,value,b,increment;
   int ino = ff->ino;
   int xsize = z[ino].xsize;
   int ysize = z[ino].ysize;
   int xpos = z[ino].xpos;
   int ypos = z[ino].ypos;
   int x1 = g.ulx - xpos;
   int x2 = g.lrx - xpos;
   int y1 = g.uly - ypos;
   int y2 = g.lry - ypos;
   x1 = max(0, min(x1, xsize-1));
   x2 = max(0, min(x2, xsize-1));
   y1 = max(0, min(y1, ysize-1));
   y2 = max(0, min(y2, ysize-1));
   uchar *buffer_1d;
   uchar **buffer;
   uchar **add;
   double shnew = ((double)ff->sharpfac)/100.0;  // Fraction of new pixel to use
   double shold = 1.0-shnew;                     // Fraction of old pixel to keep

   bpp = z[ino].bpp;
   b = (7+bpp)/8;
   frame = z[ino].cf;
   increment = max(1, 1+ff->local_scale/5);
   printstatus(CALCULATING);

   buffer_1d  = (uchar*)malloc(xsize*ysize*b);
   buffer = make_2d_alias(buffer_1d, xsize*b, ysize);
   progress_bar_open(www, scrollbar);
   add = z[ino].image[frame];

   int maxval[6][3], minval[6][3];
   int fac[6] = { 1, 2, 3, 4, 6, 8 };
   int r[3], maxr[3], mincolor[3], maxcolor[3];
   double contrast[3];
   maxr[0] = g.maxred[bpp];
   maxr[1] = g.maxgreen[bpp];
   maxr[2] = g.maxblue[bpp];
    
   for(j=y1;j<y2;j++)
   {   check_event();
       if(g.getout) break;
       progress_bar_update(scrollbar, j*100/ysize);        
       for(i=x1, i2=x1*b; i<x2; i++,i2+=b)
       {   if(g.selected_is_square || inside_irregular_region(i+xpos,j+ypos))
           {
               //// Initialize maxval and minval arrays
               for(e=0; e<3; e++)
               {   contrast[e] = 1.0;
                   for(k=0; k<6; k++)
                   {   maxval[k][e] = 0; 
                       minval[k][e] = maxr[e]; 
                   }
               }
               //// Find max & min rgb at 6 distances from the pixel, set by
               //// array fac[] x ff->local_scale (scale factor)
               for(h=0; h<6; h++)
               {   f = fac[h];
                   for(l=j-f*ff->local_scale; l<=j+f*ff->local_scale; l+=f*increment)
                   for(k=i-f*ff->local_scale; k<=i+f*ff->local_scale; k+=f*increment)
                   {   kk=k; ll=l;
                       if(ll<=0) ll = 1;
                       if(kk<=0) kk = 1;
                       if(l>=ysize-2) ll = ysize-2;
                       if(k>=xsize-2) kk = xsize-2;                 
                       value = pixelat(add[ll] + kk*b, bpp);
                       valuetoRGB(value, r[0], r[1], r[2], bpp);
                       for(e=0; e<3; e++)
                       {   if(r[e] > maxval[h][e]) maxval[h][e] = r[e];
                           if(r[e] < minval[h][e]) minval[h][e] = r[e];
                       }
                   }
               }
               
               //// Read the center pixel
               value = pixelat(add[j] + i2, bpp);
               valuetoRGB(value, r[0], r[1], r[2], bpp);

               //// Calculate contrast factor to multiply pixel by for each color e
               for(e=0; e<3; e++)
               {   maxcolor[e] = (6*maxval[0][e] + 5*maxval[1][e] + 4*maxval[2][e] + 
                                  3*maxval[3][e] + 2*maxval[4][e] + 1*maxval[5][e])/21;
                   mincolor[e] = (6*minval[0][e] + 5*minval[1][e] + 4*minval[2][e] + 
                                  3*minval[3][e] + 2*minval[4][e] + 1*minval[5][e])/21;
                   if(maxcolor[e] <= mincolor[e]) maxcolor[e] = mincolor[e] + 4;
                   if(maxcolor[e] != mincolor[e])
                       contrast[e] = maxr[e] / (double)(maxcolor[e] - mincolor[e]);
                   r[e] = cint(shold*r[e] + shnew*(r[e] - mincolor[e]) * contrast[e]); 
                   r[e] = max(0, min(r[e], maxr[e]));
              }
              value = RGBvalue(r[0], r[1], r[2], bpp); 
           }else
              value = pixelat(add[j] + i2, bpp);
          putpixelbytes(buffer[j]+i2, value, 1, bpp, 1);
       }
   }
   if(!g.getout)
   for(j=y1;j<y2;j++)
   for(i=x1, i2=x1*b; i<x2; i++,i2+=b)
   {    value = pixelat(buffer[j]+i2, bpp);
        putpixelbytes(z[ino].image[frame][j]+i2, value, 1, bpp, 1);
   }
   g.getout = 0;
   progress_bar_close(www);
   repair(ino);
   rebuild_display(ino);
   redraw(ino);
   z[ino].touched = 1;
   free(buffer);
   free(buffer_1d);
   printstatus(NORMAL);
}


//--------------------------------------------------------------------------//
// localcontrast_adaptive                                                   //
//--------------------------------------------------------------------------//
void localcontrast_adaptive(filter *ff)
{
   Widget www, scrollbar;
   int bpp,frame,i,i2,j, value, b;
   double contrast, maxrange, maxval, minval, difference, value2, value3;
   double shnew = ((double)ff->sharpfac)/100.0;  // Fraction of new pixel to use
   double shold = 1.0-shnew;                     // Fraction of old pixel to keep
   double decay = ff->decay;
   int ino = ff->ino;
   int xsize = z[ino].xsize;
   int ysize = z[ino].ysize;
   int xpos = z[ino].xpos;
   int ypos = z[ino].ypos;
   int x1 = g.ulx - xpos;
   int x2 = g.lrx - xpos;
   int y1 = g.uly - ypos;
   int y2 = g.lry - ypos;
   x1 = max(0, min(x1, xsize-1));                // ignore ff->x1, etc 
   x2 = max(0, min(x2, xsize-1));
   y1 = max(0, min(y1, ysize-1));
   y2 = max(0, min(y2, ysize-1));
   uchar *buffer_1d;
   uchar **buffer;
   uchar **add;
   bpp = z[ino].bpp;
   b = (7+bpp)/8;
   frame = z[ino].cf;
   xsize = z[ino].xsize;
   ysize = z[ino].ysize;
   printstatus(CALCULATING);
   buffer_1d = (uchar*)malloc(xsize*ysize*b);
   buffer    = make_2d_alias(buffer_1d, xsize*b, ysize);
   maxrange  = g.maxvalue[bpp];
   maxval    = maxrange;
   minval    = 0.0;
   progress_bar_open(www, scrollbar);
   add = z[ino].image[frame];
    
   for(j=y1;j<y2;j++)
   {
      progress_bar_update(scrollbar, j*100/ysize);        
      for(i=x1, i2=x1*b; i<x2; i++,i2+=b)
      if(g.selected_is_square || inside_irregular_region(i+xpos,j+ypos))
      {
           value  = pixelat(add[j] + i2, bpp);  // Read center pixel
           value2 = read_surrounding_pixels(i,j,x1,y1,x2,y2,add,bpp,b,5); 
           value3 = read_surrounding_pixels(i,j,x1,y1,x2,y2,add,bpp,b,10); 
           maxval = decay * maxval + (1.0-decay) * max(value2, value3);
           minval = decay * minval + (1.0-decay) * min(value2, value3);
           difference = max(1.0, fabs(maxval - minval));
           contrast = 0.1 * maxrange / difference;
           value = cint(shold*value + shnew*(value - minval) * contrast); 
           value = max(0, min(value, (int)maxrange));
           putpixelbytes(buffer[j]+i2, value, 1, bpp, 1);
      }else
      {    value = pixelat(add[j] + i2, bpp);
           putpixelbytes(buffer[j]+i2, value, 1, bpp, 1);
      }
      check_event();
      if(g.getout) break;
   }
   if(!g.getout)
   for(j=y1; j<y2; j++)
   for(i=x1, i2=x1*b; i<x2; i++,i2+=b)
   {    value = pixelat(buffer[j]+i2, bpp);
        putpixelbytes(z[ino].image[frame][j]+i2, value, 1, bpp, 1);
   }
   g.getout = 0;
   progress_bar_close(www);
   repair(ino);
   rebuild_display(ino);
   redraw(ino);
   z[ino].touched = 1;
   free(buffer);
   free(buffer_1d);
   printstatus(NORMAL);
}


//--------------------------------------------------------------------------//
// read_surrounding_pixels                                                  //
//--------------------------------------------------------------------------//
double read_surrounding_pixels(int i, int j, int x1, int y1, int x2, int y2,
    uchar **add, int bpp, int b, int dist)
{
   int yread1, yread2, xread1, xread2;
   double value;
   xread1 = max(x1  , i-dist);
   yread1 = max(y1  , j-dist);
   xread2 = max(x2-1, i+dist);
   yread2 = min(y2-1, j+dist);
   value = 0.25 * (double)(
            (pixelat(add[yread1] + xread1*b, bpp)) +
            (pixelat(add[yread2] + xread1*b, bpp)) +
            (pixelat(add[yread1] + xread2*b, bpp)) +
            (pixelat(add[yread2] + xread2*b, bpp)));
   return value;
}

//--------------------------------------------------------------------------//
//  force_background                                                        //
//--------------------------------------------------------------------------//
void force_background(filter *ff)
{
   //// Duplicate image
   printstatus(BUSY);
   int b,bpp,f,i,i2,j,k, noofargs=0, value, smoothed_value;
   char **arg;                // up to 20 arguments
   arg = new char*[20];
   for(k=0;k<20;k++){ arg[k] = new char[128]; arg[k][0]=0; }
   int oci = ci;
   double factor;
   bpp = z[ci].bpp;
   f = z[ci].cf;
   bpp = z[ci].bpp;
   int target_value = ff->background;
   b = g.off[bpp];
   duplicate_image(ci,0,0,0,0);
   int nci = ci;

   filter ff2;
   ff2.ino = ci;
   ff2.x1 = 0;
   ff2.y1 = 0;
   ff2.x2 = z[ci].xsize-1;
   ff2.y2 = z[ci].ysize-1;
   ff2.type = 0;
   ff2.ksize = ff->ksize;
   ff2.sharpfac = 100;
   ff2.range = 1;
   ff2.kmult = 1; 
   ff2.maxbkg = 1;
   ff2.entireimage = 1;
   ff2.diffsize    = 10;
   ff2.ithresh     = 127;
   ff2.entireimage = 1;
   ff2.filename[0] = 0;
   ff2.want_progress_bar = 1;
   ff2.local_scale  = 10;
   ff2.decay        = 0.8;
   ff2.background   = target_value;
   ff2.do_filtering = 1;
   //// Low pass filter new one with ksize
   for(k=1; k<=ff->kmult; k++) filter_region(&ff2); 

   //// Multiply each pixel in oci by factor to make the corresponding
   //// pixel in nci equal to 127

   switchto(oci);
   for(j=0; j<z[oci].ysize; j++)
   for(i=0,i2=0; i<z[oci].xsize; i++,i2+=b)
   {
       value = pixelat(z[oci].image[f][j]+i2, bpp);
       smoothed_value = pixelat(z[nci].image[f][j]+i2,bpp);
       if(smoothed_value) factor = target_value / (double) smoothed_value;
       else factor = 1.0;
       value = cint((double)value * factor);
       value = max(0, min(value, (int)g.maxvalue[bpp]));
       putpixelbytes(z[oci].image[f][j]+i2, value, 1, bpp, 1);  
   }

   //// Rescale
   sprintf(arg[1], "%d", 5);
   noofargs = 1;
   maximize_contrast(noofargs, arg);

   int obusy = g.busy;
   g.busy = 0;
   eraseimage(nci,0,0,0);
   g.busy = obusy;
   if(oci !=ci) switchto(oci);

   for(k=0;k<20;k++) delete[] arg[k];
   delete arg;  
   printstatus(NORMAL);
}

