//--------------------------------------------------------------------------//
// xmtnimage27.cc                                                           //
// Draw lines                                                               //
// Latest revision: 04-24-2001                                              //
// Copyright (C) 2001 by Thomas J. Nelson                                   //
// All rights reserved.                                                     //
//--------------------------------------------------------------------------//

#include "xmtnimage.h"

extern Globals     g;
extern Image      *z;
extern int         ci;

//-------------------------------------------------------------------//
// set_line_parameters                                               //
//-------------------------------------------------------------------//
void set_line_parameters(void)
{
  static int hit=0;
  int j,k;
  if(memorylessthan(16384)){ message(g.nomemory,ERROR); return; }
  static Dialog *dialog;
  dialog = new Dialog;
  g.getout=0;
  strcpy(dialog->title,"Line drawing parameters");
  if(!hit) g.line.color = g.fcolor;
  hit=1;

  ////  Radios

  strcpy(dialog->radio[0][0],"Transverse gradient");
  strcpy(dialog->radio[0][1],"None");
  strcpy(dialog->radio[0][2],"Single");             
  strcpy(dialog->radio[0][3],"Double");
  strcpy(dialog->radio[1][0],"Line end type");
  strcpy(dialog->radio[1][1],"None");
  strcpy(dialog->radio[1][2],"Square");             

  dialog->radioset[0] = g.line.wantgrad+1;
  dialog->radioset[1] = g.line.perp_ends+1;

  ////  Boxes
  
  for(k=0;k<DCOUNT;k++)dialog->boxset[k]=0;
  strcpy(dialog->boxes[0],"Line properties");
  strcpy(dialog->boxes[1],"Line width");
  strcpy(dialog->boxes[2],"Skew");
  strcpy(dialog->boxes[3],"Gradient");
  strcpy(dialog->boxes[4],"Center color");
  strcpy(dialog->boxes[5],"Arrowhead");
  strcpy(dialog->boxes[6],"Arrow width");
  strcpy(dialog->boxes[7],"Outer length");
  strcpy(dialog->boxes[8],"Inner length");

  dialog->boxtype[0]=LABEL; 
  dialog->boxtype[1]=STRING; 
  dialog->boxtype[2]=STRING;
  dialog->boxtype[3]=MULTICLICKBOX;
  dialog->boxtype[4]=RGBCLICKBOX;
  dialog->boxtype[5]=TOGGLE;
  dialog->boxtype[6]=STRING; 
  dialog->boxtype[7]=STRING; 
  dialog->boxtype[8]=STRING; 

  sprintf(dialog->answer[1][0],"%d", g.line.width);
  sprintf(dialog->answer[2][0],"%d", g.line.skew);

  dialog->boxmin[3] = -100;
  dialog->boxmax[3] = 100;
  strcpy(dialog->answer[3][0],"Answer");
  sprintf(dialog->answer[3][0],"%d", g.line.gradr);
  sprintf(dialog->answer[3][1],"%d", g.line.gradg);
  sprintf(dialog->answer[3][2],"%d", g.line.gradb);
  strcpy(dialog->boxpushbuttonlabel[3][0],"Red");
  strcpy(dialog->boxpushbuttonlabel[3][1],"Green");
  strcpy(dialog->boxpushbuttonlabel[3][2],"Blue");

  sprintf(dialog->answer[4][0],"%d", g.line.color);
  dialog->boxset[5] = g.line.wantarrow;
  sprintf(dialog->answer[6][0],"%d", g.line.arrow_width);
  sprintf(dialog->answer[7][0],"%d", g.line.arrow_outer_length);
  sprintf(dialog->answer[8][0],"%d", g.line.arrow_inner_length);

  dialog->bpp = 24;
  dialog->radiono[0]=4;
  dialog->radiono[1]=3;
  dialog->noofradios=2;
  dialog->noofboxes=9;
  dialog->helptopic=0;  
  for(j=0;j<10;j++) for(k=0;k<20;k++) dialog->radiotype[j][k]=RADIO;
  dialog->want_changecicb = 0;
  dialog->f1 = lineparamcheck;
  dialog->f2 = null;
  dialog->f3 = null;
  dialog->f4 = lineparamfinish;
  dialog->f5 = null;
  dialog->f6 = null;
  dialog->f7 = null;
  dialog->f8 = armboxcb; // calls f1 indirectly
  dialog->width = 0;     // calculate automatically
  dialog->height = 0;    // calculate automatically
  dialog->transient = 1;
  dialog->radiousexy = 0;
  dialog->boxusexy = 0;
  strcpy(dialog->path,".");
  g.getout=0;
  dialog->message[0] = 0;      
  dialogbox(dialog);
}


//--------------------------------------------------------------------------//
//  lineparamfinish                                                         //
//--------------------------------------------------------------------------//
void lineparamfinish(dialoginfo *a)
{
  int k;
  a=a;
  g.draw_figure = NONE;
  draw(END);
  g.getlinestate = 0;
  g.state = NORMAL;
  for(k=0;k<g.nbuttons;k++) 
  {   if(strcmp(g.button[k]->activate_cmd,"line")==SAME)
      unpush_main_button(k); 
  }
}


//--------------------------------------------------------------------------//
//  lineparamcheck                                                          //
//--------------------------------------------------------------------------//
void lineparamcheck(dialoginfo *a, int radio, int box, int boxbutton)
{
  g.line.wantgrad = a->radioset[0]-1;
  g.line.perp_ends = a->radioset[1]-1;
  g.line.width = atoi(a->answer[1][0]);
  g.line.skew = atoi(a->answer[2][0]); 
  g.line.gradr = atoi(a->answer[3][0]);
  g.line.gradg = atoi(a->answer[3][1]);
  g.line.gradb = atoi(a->answer[3][2]);
  g.line.color = atoi(a->answer[4][0]);

  g.line.wantarrow = a->boxset[5];
  if(g.line.wantarrow)
      g.draw_figure=ARROW;
  else
      g.draw_figure=LINE; 

  g.line.arrow_width = atoi(a->answer[6][0]);
  g.line.arrow_outer_length = atoi(a->answer[7][0]);
  g.line.arrow_inner_length = atoi(a->answer[8][0]);
  boxbutton=boxbutton;
  int j,k,v,ov,v6,v7,v8;
  double ratio=1;

  if(radio==0)                          // Transverse gradient radio group
  {    if(a->radioset[0]==1)            // No gradient
       {    for(k=0;k<4;k++) 
                for(j=3;j<=4;j++) 
                    if(a->boxwidget[j][k]) XtSetSensitive(a->boxwidget[j][k],False);
       }else
       {    for(k=0;k<4;k++) 
                for(j=3;j<=4;j++) 
                    if(a->boxwidget[j][k]) XtSetSensitive(a->boxwidget[j][k],True);
       }
   }
  if(box==5)
  {    if(a->boxset[5])
       {    for(k=0;k<4;k++)                // Arrow width, etc.
                for(j=6;j<=8;j++) 
                    if(a->boxwidget[j][k]) XtSetSensitive(a->boxwidget[j][k],True);
       }else
       {    for(k=0;k<4;k++) 
                for(j=6;j<=8;j++) 
                    if(a->boxwidget[j][k]) XtSetSensitive(a->boxwidget[j][k],False);
       }
  }

  ////  Scale the arrow dimensions to linewidth so shape is the same
  if(box==1)
  {    ov = atoi(a->lastanswer[box]);
       v = atoi(a->answer[1][0]);
       if(v!=0 && ov!=0) ratio = (double)v/(double)ov; 
       else { ratio=v; strcpy(a->lastanswer[box],"1"); }
       v6 = max(8,cint(ratio*atoi(a->answer[6][0])));
       v7 = max(12,cint(ratio*atoi(a->answer[7][0])));
       v8 = max(8,cint(ratio*atoi(a->answer[8][0])));
       sprintf(a->answer[6][0],"%d",v6);
       sprintf(a->answer[7][0],"%d",v7);
       sprintf(a->answer[8][0],"%d",v8);
       XmTextSetString(a->boxwidget[6][0], a->answer[6][0]);
       XmTextSetString(a->boxwidget[7][0], a->answer[7][0]);
       XmTextSetString(a->boxwidget[8][0], a->answer[8][0]);
  }
}


//--------------------------------------------------------------------------//
// draw_arrow - draws arrow head with point at x1,y1 and tail in direction  //
// of x2,y2                                                                 //
//--------------------------------------------------------------------------//
void draw_arrow(int x1, int y1, int x2, int y2, lineinfo *li)
{
//               x1,y1---> x  csize    -
//                        /|\/         |
//                       / |/\         | 
//                      /  |  \        | asize
//                     /   Xc  \       |
//                    /  / | \  \      |
//                   //    |    \\     |
//                  Xt1--- Xb-----Xt2  -
//                      
//                  |----width----|
   double dx,dy,frac,m;
   int length,w2,xc,yc,xt1,yt1,xt2,yt2,xb,yb;
   int csize, asize, width, color;
   csize = li->arrow_inner_length;
   asize = li->arrow_outer_length;
   width = li->arrow_width;
   color = li->color;

   if(x1==x2) x2=x1+10;
   length = (int)(sqrt( (y2-y1)*(y2-y1) + (x2-x1)*(x2-x1)));
   if(length) frac = (double)csize/(double)length;
   else frac=0.0;
   xc = x1 + (int)(frac * (x2-x1));
   yc = y1 + (int)(frac * (y2-y1));

   frac = (double)asize/(double)length;
   xb = x1 + (int)(frac * (x2-x1));
   yb = y1 + (int)(frac * (y2-y1));

   if(y1!=y2) m = -(double)(x2-x1)/(double)(y2-y1);
   else m=-100000;
   w2 = width/2;
   dx = sqrt((w2*w2)/(m*m+1));
   dy = dx*m;
   xt1 = xb - (int)dx;
   xt2 = xb + (int)dx;
   yt1 = yb - (int)dy;
   yt2 = yb + (int)dy;

   fill_triangle(x1,y1,xc,yc,xt1,yt1,li);
   fill_triangle(x1,y1,xc,yc,xt2,yt2,li);
}


//-------------------------------------------------------------------//
// circle                                                            //
// draw a circle                                                     //
// The optional 'win' causes box to be drawn on some window other    //
// than the drawing_area or an image (default=0).                    //
//-------------------------------------------------------------------//
void circle(int x, int y, int d, uint color, int mode, int win)
{
  int r = d/2;
  int r2 = (int) (((double)r+ 0.5) * 0.707106781186547388734);
  int row, col, px, py;
  int sum;

  py = r<<1;
  px = 0;
  sum = -(r<<1);
  while (px <= py)
  {   if ( !(px & 1))
      {  col = x + (px>>1);
         row = y + (py>>1);
         setpixelonimage(col,row,color,mode,0,-1,0,win,1);
         row = y - (py>>1);
         setpixelonimage(col,row,color,mode,0,-1,0,win,1);
         col = x - (px>>1);
         setpixelonimage(col,row,color,mode,0,-1,0,win,1);
         row = y + (py>>1);
         setpixelonimage(col,row,color,mode,0,-1,0,win,1);
         col = x + (py>>1);
         row = y + (px>>1);
         setpixelonimage(col,row,color,mode,0,-1,0,win,1);
         row = y - (px>>1);
         setpixelonimage(col,row,color,mode,0,-1,0,win,1);
         col = x - (py>>1);
         setpixelonimage(col,row,color,mode,0,-1,0,win,1);
         row = y + (px>>1);
         setpixelonimage(col,row,color,mode,0,-1,0,win,1);
      }
      sum +=px++;
      sum += px;
      if (sum >= 0)
      {  sum-=py--;
         sum -=py;
      }
  }

  if(mode==SET)    // Make sure all points are set
  { 
     setpixelonimage(x+r,y,color,SET,0,-1,0,win,1);
     setpixelonimage(x-r,y,color,SET,0,-1,0,win,1);
     setpixelonimage(x,y+r,color,SET,0,-1,0,win,1);
     setpixelonimage(x,y-r,color,SET,0,-1,0,win,1);

     setpixelonimage(x+r2,y+r2,color,SET,0,-1,0,win,1);
     setpixelonimage(x+r2,y-r2,color,SET,0,-1,0,win,1);
     setpixelonimage(x-r2,y+r2,color,SET,0,-1,0,win,1);
     setpixelonimage(x-r2,y-r2,color,SET,0,-1,0,win,1);
  }
}



//-------------------------------------------------------------------//
// box                                                               //
// Draw a box - if called from mouse loop, set inmenu non-zero first.//
// The optional 'win' causes box to be drawn on some window other    //
// than the drawing_area or an image (default=0).                    //
//-------------------------------------------------------------------//
void box(int x1, int y1, int x2, int y2, uint color, int mode, int win, int ino)
{
   lineinfo li;
   li.ino=ino;
   li.type=0;
   li.color=color;
   li.width=1;
   li.wantgrad=0;
   li.gradr=0;
   li.gradg=0;
   li.gradb=0;
   li.gradi=0;
   li.skew=0;
   li.perp_ends=0;
   li.wantarrow=0;
   li.arrow_width=0;
   li.arrow_inner_length=0;
   li.arrow_outer_length=0;
   li.window=win;
   li.wantprint=0;
   box(x1,y1,x2,y2,mode,&li);
}
void box(int x1, int y1, int x2, int y2, int mode, lineinfo *li)
{
   if(x1>x2)swap(x1,x2);
   line(x1-1,y1,x1-1,y2,mode,li);
   line(x2,y1,x2,y2,mode,li);
   line(cint(x1-li->width/2),y1,cint(x2+li->width/2),y1,mode,li);
   line(cint(x1-li->width/2),y2,cint(x2+li->width/2),y2,mode,li);
}
void xor_box(int x1, int y1, int x2, int y2)
{
   g.inmenu++;
   box(x1,y1,x2,y2,g.maxcolor,XOR);
   XFlush(g.display);
   g.inmenu--;
}


//-------------------------------------------------------------------//
// dashed_box                                                        //
//-------------------------------------------------------------------//
void dashed_box(int x1, int y1, int x2, int y2, uint color1, uint color2,
     int spacing, int mode)
{
   int i,j,s2=2*spacing;
   if(x1>x2)swap(x1,x2);
   if(y1>y2)swap(y1,y2);
   for(i=x1;i<=x2;i+=s2)
       for(j=0;j<spacing;j++)
       {   if(i+j>x2) continue;
           setpixel(i+j,y1,color1,mode);
           setpixel(i+j,y2,color1,mode);
           if(i+j+spacing>x2) continue;
           setpixel(i+j+spacing,y1,color2,mode);
           setpixel(i+j+spacing,y2,color2,mode);
       }
   for(i=y1;i<=y2;i+=s2)
       for(j=0;j<spacing;j++)
       {   if(i+j>y2) continue;
           setpixel(x1,i+j,color1,mode);
           setpixel(x2,i+j,color1,mode);
           if(i+j+spacing>y2) continue;
           setpixel(x1,i+j+spacing,color2,mode);
           setpixel(x2,i+j+spacing,color2,mode);
       }
}




//-------------------------------------------------------------------//
// line - draws a line                                               //
// Mode can be:  XOR or SET. If "SET", it uses the currently-selected//
//   pixel interaction mode (imode).                                 //
// Returns the number of pixels set.                                 //
// The optional 'win' causes box to be drawn on some window other    //
// than the drawing_area or an image (default=0).                    //
// Based on the Bresenham algorithm.                                 //
//                                                                   //
//   <45 degrees                                                     //
//   Fill direction ----->                                           //
//      __________________         ____________1_____2               //
//     4     /- _         |       4           _\     |               //
//     |    / 3   - _     |       |       _ -   \    |               //
//     5- _/          - _ |       |   _ -        \   |               //
//     |  /s - _          |       | -           e_\  |               //
//     | /       - _      /       |\         _ -   \ |               //
//     |/            - _e/|       | \ s  _ -       _\|               //
//     | - _            / |       | _\ -       _ -   |               //
//     |     - _       /  |       5-  \    _ -       |               // 
//     |__________- _/____|       |____\_-___________|               //
//                  1     2       4     3                            // 
//                                                                   //
//   >45 degrees                                                     //
//         4 -_----5-----      ------5-----_ 4       Fill direction  //
//          /   - /_   /       \     _\_ -  \            |           //
//         /     /s  -/         \_ -  s\     \           |           //
//        /     /    / 3       3 \      \     \          |           // 
//      1/_    /    /             \      \ e  _\1       \|/          //
//      /   - /e   /               \    _ \-    \        V           //
//     /_____/__-_/               2 \-_____\_____\                   //
//                 2                                                 //
//-------------------------------------------------------------------//
int line(int xs, int ys, int xe, int ye, uint color, int mode, int win, int ino)
{
   lineinfo li;
   li.ino=ino; // If 0 it can put it on any image
   li.type=0;
   li.color=color;
   li.width=1;
   li.wantgrad=0;
   li.gradr=0;
   li.gradg=0;
   li.gradb=0;
   li.gradi=0;
   li.skew=0;
   li.perp_ends=0;
   li.wantarrow=0;
   li.arrow_width=0;
   li.arrow_inner_length=0;
   li.arrow_outer_length=0;
   li.window=win;
   if(g.imode == BUFFER)
     li.wantprint=0;
   else
     li.wantprint=1;
   return line(xs,ys,xe,ye,mode,&li);
}

int line(int xs, int ys, int xe, int ye, int mode, lineinfo *li)
{
     char tempstring[128];
     double angle=0;
     int ino,bpp=0,b,c,cc=0,dx,dy,even=0,x_sign,y_sign,j,pixels=0,x,y,decision,total=0,
         jj,rr,gg,bb,rr1,gg1,bb1,ok=1,x1=0,y1=0,x2=0,y2=0,x3=0,y3=0,x4=0,
         x5=0,y5=0,e,sign=0,skew=0,sskew=0,ibpp,ii,jstart;     
     double len,m=0,m1=0,m3=0,value;
     int color = li->color;
     dx = abs(xe - xs);
     dy = abs(ye - ys);
     if(dx==0 && dy==0) return OK;   // Needed in Solaris
     if(li->perp_ends || li->width>1 || li->wantprint)
     {
        if(xe!=xs) angle = atan2(ye-ys,xe-xs); else angle = 1.570796327*sgn(ye-ys);    
     }
     if(li->wantgrad) 
     {   rr1=g.line.gradr; gg1=g.line.gradg; bb1=g.line.gradb;
     }else
     {   rr1=0; gg1=0; bb1=0; 
     }
     int fc,bc;
     Window win = li->window;
     ino = li->ino;
     if(ino) bpp = z[ino].bpp;

     if(li->wantprint)
     {   ////  Read the pixel value for information_area Widget.
         XtVaGetValues(g.info_area[0], XmNforeground, &fc, XmNbackground, &bc, NULL);         
         len = sqrt((ye-ys)*(ye-ys)+(xe-xs)*(xe-xs));
         sprintf(tempstring,"L=%4.1f %2.1f deg    ",len,-DEGPERRAD*angle);
         print(tempstring,8,84,fc,bc,&g.gc,g.info_window[3],BACKGROUND,HORIZONTAL);
     }
     if(li->skew) sskew = li->skew * sgn(xe-xs) * sgn(ye-ys);
     if(sskew==0 || dx<3 || dy<3) sskew=li->skew;
     
     if(dx > dy)         // Less than 45 degrees
     {  if(li->width>1)
        {   if(!(li->width & 1)) even=1;   
            pixels = abs(int((0.4999+(double)li->width/2)/cos(angle)));
        }
        if(xs > xe){ swap(xs,xe); swap(ys,ye); }
        if(ye - ys < 0) y_sign = -1; else y_sign = 1;        
        if(li->perp_ends)
        {   c = abs(cint((li->width/2)*sin(angle)));
            b = abs(cint((li->width/2)*cos(angle)));
            sign = sgn(ye-ys);
            x1 = xe - c;
            y1 = ye + b*sign;
            x2 = xe + c;
            y2 = y1;
            if(xe!=x1)
               m1 = -(double)(ye-y1)/(double)(xe-x1);
            else m1 = 1.0;
 
            x3 = xs + c;
            y3 = ys - b*sign;
            x4 = xs - c;
            if(xs!=x3)
               m3 = -(double)(ys-y3)/(double)(xs-x3);
            else m3 = 1.0;
            x5 = x4;
            y5 = cint(ys - c*tan(angle));
        }else
        {   x5 = xs; 
            y5 = ys;
            x2 = xe;
        }
        jstart = -pixels + even;
        for (j=-pixels+even; j<=pixels; j++)
        {   for (x=x5,y=y5,decision=0; x<=x2; x++,decision+=dy)
            {     if(decision>=dx){ decision -= dx; y+= y_sign; }
                  if(li->wantgrad && mode==SET)
                  {    valuetoRGB(color,rr,gg,bb,g.bitsperpixel);
                       if(li->wantgrad==2) jj=abs(j); else jj=j;
                       rr+=jj*rr1; gg+=jj*gg1; bb+=jj*bb1;
                       cc=RGBvalue(rr,gg,bb,g.bitsperpixel);
                  }else cc=color;
                  if(li->skew) skew = j*sskew;                 
                  if(li->perp_ends)
                  {    ok=1;
                       if(x<x3)
                       {   m = -(double)(y+j-y3)/(double)(x-x3);
                           if(sign != sgn(m-m3)) ok=0;
                       }
                       if(x>x1)
                       {   m = -(double)(y+j-y1)/(double)(x-x1);
                           if(sign != sgn(m-m1)) ok=0;
                       }
                  }
                  switch(mode)
                  {  case NONE:
                     case SET:   //1
                       total++;
                       if(ok) setpixelonimage(x+skew,y+j,cc,g.imode,bpp,-1,0,win,1,ino);
                       break;
                     case XOR:   //7
                       total++;
                       bpp = whatbpp(x,y+j);
                       if(ok) setpixelonimage(x+skew,y+j,cc,XOR,bpp,-1,0,win,1,ino);
                       break;
                     case BUFFER: 
                       total++;
                       bpp = z[ino].bpp;
                       if(ok) setpixelonimage(x+skew,y+j,cc,BUFFER,bpp,-1,1,win,0,ino);
                       break;
                     case SCAN:  
                       total++;
                       value = (double)readpixelonimage(x,y,ibpp,ii);
                       if(ok) g.scan[g.scancount++] = value / g.maxvalue[ibpp];
                       break;
                     case TRACE:  
                       total++;
                       if(ok && between(x,0,g.xres-1)) g.highest[x] = y;
                       break;
                     default:  
                       fprintf(stderr, "Error in line()\n");
                       break;
                  }
                  
            }
        }    
     }else    // more than 45 degrees
     {        
        if(li->width>1)
        {   if(!(li->width & 1)) even=1;   
            pixels = abs(int((0.4999+(double)li->width/2)/sin(angle)));
        }
        if(ys > ye){ swap(ys,ye); swap(xs,xe);  }
        if(xe - xs < 0) x_sign = -1; else x_sign = 1;                 
        if(li->perp_ends)
        {   sign = sgn(xs-xe);
            b = abs(cint((li->width/2)*cos(angle)));
            c = abs(cint(b/tan(angle)));
            e = abs(cint((li->width/2)*sin(angle)));

            x1 = xe - sign*e;
            y1 = ye - b;
            x2 = xe + sign*e;
            y2 = ye + b;
            if(xe!=x1)
               m1 = (double)(ye-y1)/(double)(xe-x1);
            else m1=1;

            x3 = xs + sign*e;
            y3 = ys + b;
            x4 = xs - sign*e;
            if(xs!=x3)
               m3 = (double)(ys-y3)/(double)(xs-x3);
            else m3=1;
            x5 = cint(xs + sign*c);
            y5 = ys - b;
        }else
        {   x5 = xs; 
            y5 = ys;
            y2 = ye;
        }
        for (j=-pixels+even; j<=pixels; j++)
        {   for(x=x5,y=y5,decision=0; y<=y2; y++,decision+=dx)
            {     if (decision>=dy){ decision -= dy; x+=x_sign; }
                  if(li->wantgrad && mode==SET)
                  {    valuetoRGB(color,rr,gg,bb,g.bitsperpixel);
                       if(li->wantgrad==2) jj=abs(j); else jj=j;
                       rr+=jj*rr1; gg+=jj*gg1; bb+=jj*bb1;
                       cc=RGBvalue(rr,gg,bb,g.bitsperpixel);
                  }else cc=color;
                  if(li->skew) skew = j*sskew;                 
                  if(li->perp_ends)
                  {    ok=1;
                       if(y<y3)
                       {   
                           if(x+j-x3 != 0) m = (double)(y-y3)/(double)(x+j-x3); else m=1.0;
                           if(sign != sgn(m3-m)) ok=0;
                           if((sign>0 && x+j>=x3) || (sign<0 && x+j<x3)) ok=0;
                       }
                       if(y>y1)
                       {   if(x+j-x1 != 0) m = (double)(y-y1)/(double)(x+j-x1); else m=1.0;
                           if(sign != sgn(m1-m)) ok=0;
                           if((sign>0 && x+j<x1) || (sign<0 && x+j>=x1)) ok=0;
                       }
                  }
                  switch(mode)
                  {  
                     case NONE:
                     case SET:   //1
                       total++;
                       if(ok)setpixelonimage(x+j,y+skew,cc,g.imode,bpp,-1,0,win,1,ino);
                       break;
                     case XOR:   // 7
                       total++;
                       bpp = whatbpp(x+j,y);
                       if(ok)setpixelonimage(x+j,y+skew,cc,XOR,bpp,-1,0,win,1,ino);
                       break;
                     case BUFFER: 
                       total++;
                       bpp = z[ino].bpp;
                       if(ok)setpixelonimage(x+j,y+skew,cc,BUFFER,bpp,-1,1,win,0,ino);
                       break;
                     case SCAN:  
                       total++;
                       value = (double)readpixelonimage(x,y,ibpp,ii);
                       if(ok)g.scan[g.scancount++] = value / g.maxvalue[ibpp];
                       break;
                     case TRACE:  
                       total++;
                       if(ok && between(x,0,g.xres-1)) g.highest[x] = y;
                       break;
                     default: 
                       fprintf(stderr, "Error in line()\n");
                       break; 
                  }
            }
        }
     }
     return(total);
}



//--------------------------------------------------------------------------//
//  sketch                                                                  //
//--------------------------------------------------------------------------//
int sketch(int xs, int ys, int xe, int ye, uint color, int mode, lineinfo *line)
{
     int cc=0,dx,dy,x_sign,y_sign,j,pixels=0,x,y,decision,total=0,h,
         jj,rr,gg,bb,rr1,gg1,bb1,skew=0,sskew=0;     
     dx = abs(xe - xs);
     dy = abs(ye - ys);
     if(dx==0 && dy==0) return OK;   // Needed in Solaris
     if(dx>100000 || dy>100000) return BADPARAMETERS;
     if(line->wantgrad) { rr1 = g.line.gradr; gg1 = g.line.gradg; bb1 = g.line.gradb;}
     else { rr1 = gg1 = bb1 = 0; }
     Window win = line->window;
     if(line->width>1) pixels = line->width;
     sskew = line->skew;    
     int sk0 = pixels*sskew;

     if(dx > dy)         // Less than 45 degrees
     {
        if(xs > xe){ swap(xs,xe); swap(ys,ye); }
        if(ye - ys < 0) y_sign = -1; else y_sign = 1;        
        for (j=-pixels,skew=-sk0; j<=pixels; j++,skew+=sskew)
        {   for (x=xs,y=ys,decision=0; x<=xe; x++,decision+=dy)
            {     if(decision>=dx){ decision -= dx; y+= y_sign; }
                  if(line->wantgrad && mode==SET)
                  {    valuetoRGB(color,rr,gg,bb,g.bitsperpixel);
                       if(line->wantgrad==2) jj=abs(j); else jj=j;
                       rr+=jj*rr1; gg+=jj*gg1; bb+=jj*bb1;
                       cc=RGBvalue(rr,gg,bb,g.bitsperpixel);
                  }else cc=color;
                  for(h=skew-sskew;h<=skew+sskew;h++)
                       setpixelonimage(x+h,y+j,cc,g.imode,0,-1,0,win,1);
            }
        }     
     }else    // more than 45 degrees
     {        
        if(ys > ye){ swap(ys,ye); swap(xs,xe);  }
        if(xe - xs < 0) x_sign = -1; else x_sign = 1;                 
        for (j=-pixels,skew=-sk0; j<=pixels; j++,skew+=sskew)
        {   for(x=xs,y=ys,decision=0; y<=ye; y++,decision+=dx)
            {     if (decision>=dy){ decision -= dy; x+=x_sign; }
                  if(line->wantgrad && mode==SET)
                  {    valuetoRGB(color,rr,gg,bb,g.bitsperpixel);
                       if(line->wantgrad==2) jj=abs(j); else jj=j;
                       rr+=jj*rr1; gg+=jj*gg1; bb+=jj*bb1;
                       cc=RGBvalue(rr,gg,bb,g.bitsperpixel);
                  }else cc=color;
                  for(h=skew-sskew;h<=skew+sskew;h++)
                       setpixelonimage(x+h,y+j,cc,g.imode,0,-1,0,line->window,1);
            }
        }
     }
     return(total);
}


//--------------------------------------------------------------------------//
//  drawline - for macros                                                   //
//--------------------------------------------------------------------------//
void drawline(int noofargs, char **arg, int whatever)
{
   int i,j, ino, bpp;
   int x1,x2,y1,y2,d=10, mode=SET;
   int color = g.fcolor;
   x1=y1=x2=y2=0;
   if(noofargs >=1) x1=atoi(arg[1]);
   if(noofargs >=2) y1=atoi(arg[2]);
   if(noofargs >=3) x2=atoi(arg[3]);
   if(noofargs >=4) y2=atoi(arg[4]);
   if(noofargs >=5) color=atoi(arg[5]);
   if(noofargs >=6) mode=atoi(arg[6]);

   switch(whatever)
   {   case LINE:   line(x1,y1,x2,y2,color,mode); break;
       case BOX:    box(x1,y1,x2,y2,color,mode); break;
       case CIRCLE: if(noofargs >=3) d = atoi(arg[3]);
                    if(noofargs >=4) color = atoi(arg[4]);
                    if(noofargs >=5) mode = atoi(arg[5]);
                    circle(x1,y1,d,color,mode); 
                    break;
       case RECTANGLE: box(x1,y1,x2,y2,color,mode); break;
       case FILLEDRECTANGLE: 
             for(j=y1; j<=y2; j++)
             for(i=x1; i<=x2; i++)
                setpixelonimage(i,j,color,mode,0,-1,0,0,1);
             break;   
       case PIXEL: 
             if(noofargs >=3) color = atoi(arg[3]);
             if(noofargs >=4) mode = atoi(arg[4]);
             setpixelonimage(x1,y1,color,mode,0,-1,0,0,1); 
             break;
   }
   ino = whichimage(x1,y1,bpp);
   if(whatever != PIXEL && ino>=0) repair(ino);
}



//--------------------------------------------------------------------------//
//  drawlabel - for macros                                                  //
//--------------------------------------------------------------------------//
void drawlabel(int noofargs, char **arg)
{
   int fcol=g.fcolor, bcol=g.bcolor, wantbkg=0, vertical=0;
   int x,y,ino,bpp;
   x=y=0;
   ino = whichimage(x,y,bpp);
   if(noofargs <1) return;
   if(noofargs >=2) x = atoi(arg[2]);
   if(noofargs >=3) y = atoi(arg[3]);
   if(noofargs >=4) vertical = atoi(arg[4]);
   if(noofargs >=5) wantbkg = atoi(arg[5]);
   if(noofargs >=6) fcol = atoi(arg[6]);
   if(noofargs >=7) bcol = atoi(arg[7]);
   print(arg[1], x, y, fcol, bcol, &g.image_gc, z[ino].win, wantbkg, vertical,0);
}


//--------------------------------------------------------------------------//
//  unsetpixel - for macros                                                 //
//--------------------------------------------------------------------------//
void unsetpixel(int noofargs, char **arg)
{
   int b,f,ino,bpp,x1,y1,pix;
   x1=y1=0;
   if(noofargs >=1) x1=atoi(arg[1]);
   if(noofargs >=2) y1=atoi(arg[2]);
   ino = whichimage(x1,y1,bpp);
   if(!between(ino, 0, g.image_count-1)) return;
   switchto(ino);
   b = g.off[bpp];
   f = z[ino].cf;
   if(!between(x1, 0, z[ino].xsize-1)) return;
   if(!between(y1, 0, z[ino].ysize-1)) return;
   pix = pixelat(z[ci].backup[f][y1] + b*x1, bpp);
   putpixelbytes(z[ino].image[f][y1] + b*x1, pix, 1, bpp, 1);   
}
