/******************************************************************************
 *
 * $Id: translator_jp.h,v 1.2 1999/07/03 22:56:05 root Exp $
 *
 * Copyright (C) 1997-1999 by Dimitri van Heesch.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation under the terms of the GNU General Public License is hereby 
 * granted. No representations are made about the suitability of this software 
 * for any purpose. It is provided "as is" without express or implied warranty.
 * See the GNU General Public License for more details.
 *
 * All output generated with Doxygen is not covered by this license.
 *
 */

#ifndef TRANSLATOR_JP_H
#define TRANSLATOR_JP_H

#include "translator.h"

class TranslatorJapanese : public Translator
{
  public:
    QCString latexBabelPackage()
    { return "a4j"; }
    QCString trInherits()
    { return "Ѿ"; }
    QCString trAnd()
    { return ""; }
    QCString trInheritedBy()
    { return "˷ѾƤޤ"; }
    QCString trRelatedFunctions()
    { return "Ϣؿ"; }
    QCString trRelatedSubscript()
    { return "ʤϥдؿǤʤȤա"; }
    QCString trDetailedDescription()
    { return ""; }
    QCString trMemberTypedefDocumentation()
    { return "зβ"; }
    QCString trMemberEnumerationDocumentation()
    { return "󷿤β"; }
    QCString trEnumerationValueDocumentation()
    { return "ͤβ"; }
    QCString trMemberFunctionDocumentation()
    { return "дؿβ"; }
    QCString trMemberDataDocumentation()
    { return "Хǡβ"; }
    QCString trGeneratedFrom(const char *s,bool)
    { 
      QCString result=(QCString)""+s+
	           "ФɥȤϰʲΥե뤫ޤ";
      return result;
    }
    QCString trMore()
    { return "ܤ..."; }
    QCString trReference()
    { return "ե"; }
    QCString trListOfAllMembers()
    { return "٤ƤΥХꥹ"; }
    QCString trMemberList()
    { return "Хꥹ"; }
    QCString trThisIsTheListOfAllMembers()
    { return "ϼХꥹȤǤ"; }
    QCString trIncludingInheritedMembers()
    { return "ѾФ٤Ƥޤǡ"; }
    QCString trGeneratedAutomatically(const char *s)
    { QCString result;
      if (s) result=(QCString)s+"Ф";
      result+="ɤ Doxygen ưŪޤ";
      return result;
    }
    QCString trEnumName()
    { return "enum "; }
    QCString trEnumValue()
    { return "enum "; }
    QCString trDefinedIn()
    { return "ޤ"; }
    QCString trIncludeFile()
    { return "󥯥롼ɥե"; }
    QCString trVerbatimText(const char *f)
    { return (QCString)"ϥ󥯥롼ɥե"+f+
	" Verbatim ƥȤǤ"; }
    QCString trModules()
    { return "⥸塼"; }
    QCString trClassHierarchy()
    { return "饹"; }
    QCString trCompoundList()
    { return "ǡ¤ꥹ"; }
    QCString trFileList()
    { return "եꥹ"; }
    QCString trHeaderFiles()
    { return "إåե"; }
    QCString trCompoundMembers()
    { return "ǡ¤"; }
    QCString trFileMembers()
    { return "ե"; }
    QCString trRelatedPages()
    { return "Ϣڡ"; }
    QCString trExamples()
    { return ""; }
    QCString trSearch()
    { return ""; }
    QCString trClassHierarchyDescription()
    { return "ηѾꥹȤϤޤˤϥȤƤޤ"
             "ե٥åȽǴ˥ȤƤϤޤ";
    }
    QCString trFileListDescription(bool extractAll)
    {
      QCString result="ΥꥹȤϡ";
      if (!extractAll) result+="ɥȲ졢";
      result+="ʰĥե뤹٤ƤΥꥹȤǤ";
      return result;
    }
    QCString trCompoundListDescription()
    { return "ϴʰġ饹¤ΡΤΥꥹȤǤ";}
    QCString trCompoundMembersDescription(bool extractAll)
    {
      QCString result="";
      if (!extractAll) result+="ɥȲ줿";
      result+="饹Ф٤ƤΥꥹȤǡ줾";
      if (extractAll) result+="°Ƥ륯饹";
      result+="βؤΥ󥯤ĥƤޤ";
      return result;
    }
    QCString trFileMembersDescription(bool extractAll)
    {
      QCString result="";
      if (!extractAll) result+="ɥȲ줿";
      result+="եФ٤ƤΥꥹȤǡ줾";
      if (extractAll) result+="°Ƥե";
      result+="βؤΥ󥯤ĥƤޤ";
      return result;
    }
    QCString trHeaderFilesDescription()
    { return "APIإåեǤ"; }
    QCString trExamplesDescription()
    { return "٤ƤΥꥹȤǤ"; }
    QCString trRelatedPagesDescription()
    { return "Ϣɥȥڡ٤ƤΥꥹȤǤ"; }
    QCString trModulesDescription()
    { return "٤ƤΥ⥸塼ΥꥹȤǤ"; }
    QCString trNoDescriptionAvailable()
    { return "ɥȤҤƤޤ"; }

    QCString trDocumentation()
    { return "ɥ"; }
    QCString trModuleIndex()
    { return "⥸塼"; }
    QCString trHierarchicalIndex()
    { return "غ"; }
    QCString trCompoundIndex()
    { return "ǡ¤"; }
    QCString trFileIndex() 
    { return "ե"; }
    QCString trModuleDocumentation()
    { return "⥸塼β"; }
    QCString trClassDocumentation()
    { return "饹β"; }
    QCString trFileDocumentation()
    { return "եβ"; }
    QCString trExampleDocumentation()
    { return "β"; }
    QCString trPageDocumentation()
    { return "ڡβ"; }
    QCString trReferenceManual()
    { return "ե󥹥ޥ˥奢"; }

    QCString trDefines()
    { return "ޥ"; }
    QCString trFuncProtos()
    { return "ؿץȥ"; }
    QCString trTypedefs()
    { return ""; }
    QCString trEnumerations()
    { return ""; }
    QCString trFunctions()
    { return "ؿ"; }
    QCString trVariables()
    { return "ѿ"; }
    QCString trEnumerationValues()
    { return ""; }
    QCString trReimplementedFrom()
    { return ""; }
    QCString trReimplementedIn()
    { return "Ǻ"; }
    QCString trAuthor()
    { return ""; }
    QCString trDefineDocumentation()
    { return "ޥβ"; }
    QCString trFunctionPrototypeDocumentation()
    { return "ؿץȥפβ"; }
    QCString trTypedefDocumentation()
    { return "β"; }
    QCString trEnumerationTypeDocumentation()
    { return "󷿤β"; }
    QCString trFunctionDocumentation()
    { return "ؿβ"; }
    QCString trVariableDocumentation()
    { return "ѿβ"; }
    QCString trCompounds()
    { return "ǡ¤"; }
    QCString trFiles()
    { return "ե"; }
    QCString trGeneratedAt(const char *date,const char *projName)
    { 
      QCString result;
      if (projName) result+=(QCString)projName+"Ф";
      result+=(QCString)date+"ޤ";
      return result;
    }
    QCString trWrittenBy()
    {
      return "ȯΤ";
    }
    QCString trClassDiagram(const char *clName)
    {
      return (QCString)clName+"Ф륯饹ؿ";
    }
    QCString trForInternalUseOnly()
    { return "ѤΤߡ"; }
    QCString trReimplementedForInternalReasons()
    { return "ŪͳˤƼޤAPIˤϱƶޤ";
    }
    QCString trWarning()
    { return ""; }
    QCString trBugsAndLimitations()
    { return "Х"; }
    QCString trVersion()
    { return "С"; }
    QCString trDate()
    { return ""; }
    QCString trAuthors()
    { return ""; }
    QCString trReturns()
    { return ""; }
    QCString trSeeAlso()
    { return ""; }
    QCString trParameters()
    { return ""; }
    QCString trExceptions()
    { return "㳰"; }
    QCString trGeneratedBy()
    { return ""; }
    
    // new since 0.49-990307 
    
    QCString trNamespaces()
    { return "̾"; }
    QCString trNamespaceList()
    { return "֥̾ꥹ"; }
    QCString trNamespaceListDescription(bool extractAll)
    {
      QCString result="ΥꥹȤϡʰĤ٤Ƥ";
      if (!extractAll) result+="ɥȲ줿";
      result+="֤̾ΥꥹȤǤ";
      return result;
    }
    QCString trFriends()
    { return "ե"; }
    
    // new since 0.49-990405
    
    virtual QCString trRelatedFunctionDocumentation()
    { return "եɤȴϢؿβ"; }
};

#endif
