IND		("#")
EIND		""

%{
#define AFTERIND {"#",NULL}
%}



%{
typedef enum { NONE, PUBLIC, PRIVATE, PROTECTED } membertype;
int echo=0,skip=0,dontskip=0,imp=0,IMP=0,lit=0;
membertype member=NONE,pmember=NONE;

char ID[1000];

char *after(char *t,char *sub);
char *trimId(char *t);
char *replaceId(char *t);
%}

%%
^({IND}"id").*\n               { printf("-id-%s\n",trimId(after(yytext,"id")));
                                 strcpy(ID,trimId(after(yytext,"id")));
                               }
^({IND}"order").*\n            { printf("-order-%s\n",
                                        trimId(after(yytext,"order"))
                                       ); 
                               }
^({IND}"lit")[ \t]*\n          { lit=1;dontskip=1;printf("\n"); }
^({IND}"ref").*\n              { printf("-ref-%s",after(yytext,"ref")); }
^({IND}"imp")[ \t]*\n          { if (IMP) { imp=dontskip=1; } }
^({IND}"endimp"|"endimp"{EIND})[ \t]*\n    { if (IMP) { imp=dontskip=0; } }
^({IND}"doc").*\n     	       { skip=0;echo=1;
                                   if (strlen(after(yytext,"doc"))<3) {
                                     printf("\n\n-doc-Algemeen\n"); 
                                   }
                                   else {
                                     printf("\n\n-doc-%s",after(yytext,"doc")); 
                                   }
                                }
^({IND}"incdoc").*\n		{ printf("-incdoc-%s",after(yytext,"incdoc"));}
^({IND}"kop").*\n   		{ printf("-kop-%s",after(yytext,"kop"));}
^({IND}"h4").*\n		{ printf("-h4-%s",after(yytext,"h4")); }
^({IND}"h3").*\n		{ printf("-h3-%s",after(yytext,"h3")); }
^({IND}"h2").*\n		{ printf("-h2-%s",after(yytext,"h2")); }
^({IND}"h1").*\n		{ printf("-h1-%s",after(yytext,"h1")); }
^({IND}"bold").*\n		{ printf("-bold-%s",after(yytext,"bold")); }
^({IND}"sec")[ \t]*\n		{ skip=0;echo=1; }
^({IND}"def")[ \t]*\n		{ skip=0;echo=1;
				  if (pmember!=member) {char *s;
				    switch(member) {
				      case PUBLIC: s="Public";
				      break;
				      case PROTECTED: s="Protected";
				      break;
				      case PRIVATE: s="Private";
				      break;
				      default: s="?";
				    }
				    pmember=member;
				    printf("-mem-%s members\n",s);
				  }
                                  printf("-def-\n");
                                }
^({IND}"end"|"end"{EIND})[ \t]*\n	{ printf("\n");
                                          echo=0;
                                          if (lit) { dontskip=0; } 
                                        }
^({IND}).*\n			{ if (echo && !skip) { 
                                    printf("%s  %s",
                                             (imp) ? "-imp-" : "",
                                             after(yytext,"")
                                          ); 
                                  } 
                                }
public:				{ member=PUBLIC;pmember=NONE; }
private:			{ member=PRIVATE;pmember=NONE; }
protected:			{ member=PROTECTED;pmember=NONE; }
^class[ ]			{ member=NONE;pmember=NONE;
                                  if (echo && !skip) { ECHO; }
                                }
[ \t]*[{]			{ if (!dontskip) { skip+=1; } 
                                  else if (echo && !skip ) { ECHO; } 
                                }
[}]([ \t]*\n)?			{ if (!dontskip) {
                                    skip-=1;if (skip<0) { skip=0; } 
                                  }
                                  else if (echo && !skip) { ECHO; }
                                }
-ID-				{ if (echo && !skip) {
                                    if (strlen(ID)==0) {
                                      ECHO;
                                    }
                                    else { 
                                      printf("%s",ID);
                                    }
                                  }
                                }
.|\n				{ if (echo && !skip) { ECHO; } }

%%

#include <string.h>

int main(int argc,char *argv[])
{
  strcpy(ID,"");
return yylex();
}

char *after(char *t,char *sub)
{
  if (strlen(sub)==0) {int i,k;
                       char *first[]=AFTERIND;
                       char *s;
     for(i=0,s=NULL;s==NULL && first[i]!=NULL;i++) {
       for(k=0,s=t;first[i][k]!='\0' && s[0]==first[i][k];k++,s++);
       if (first[i][k]!='\0') { s=NULL; }
     }
     return replaceId(s);
  }
  else {char *s;
     s=strstr(t,sub);
     return replaceId(s+strlen(sub));
  }
}

char *trimId(char *t)
{
static char line[4096];
int i,j;
  for(j=i=0;t[i]==' ' || t[i]=='\t';i++);
  for(;t[i]!='\0';i++,j++) { line[j]=t[i]; }
  for(j=strlen(line)-1;j>=0 && (line[j]==' ' || line[j]=='\t');j--);
  line[j]='\0';
return line;
}

char *replaceId(char *t)
{
static char line[4096],l1[4096];
char *s,*p;
  if (strlen(ID)==0) { return t; }
  strcpy(line,t);
  strcpy(l1,"");
  p=line;
  while ((s=strstr(line,"-ID-"),s)!=NULL) {
    s[0]='\0';
    strcat(l1,p);
    strcat(l1,ID);
    s+=4;p=s;
  }
  strcat(l1,p);
return l1;
}

