#include <stdio.h>
#include "ldbf.h"

/*
   Structure of example 'sng' table
    kod  C 6  0       - code of city
    city C 30 0       - name of city
*/

main()
{
  int sock;
  ldbfDB *sng;
  if((sock = ldbfConnect("localhost")) == -1) {
    printf("Cannot connect:%d\n",ldbf_errno);
    exit(0);
  }
  sng = ldbfOpen(sock,"sng",0);
  if(!sng) {
   printf("Cannot open sng:%d\n",ldbf_errno);
   ldbfShutdown(sock);
   exit(0);
  }
  ldbfSetTag(sng,"kod");

  /* we want to find all record that begins with 0449 in field 'kod' */
  /* set pointer to record with kod '044'
     and scans while kod begins with '044' */

  /* sets on first matching record */
  ldbfLocateFirst(sng,"044","'044'$kod","'0449'$kod");
  /* scan thru all matching records */
  while(!ldbf_errno) {

    /* print contents of fields */
    printf("%s",ldbfValue("sng","kod"));
    printf("%s \n",ldbfValue("sng","city"));

    /* Pass to next record, if we did not reach end of table  */
    if(ldbfSkip(sng,1) == -1) break;

    /* and continue locating next matching records from current record */
    ldbfLocate(sng,"'044'$kod","'0449'$kod");
  }
  ldbfShutdown(sock);
}
