#include <stdio.h>
#include "ldbf.h"

/*
   Structure of example 'sng' table
    kod  C 6  0       - code of city
    city C 30 0       - name of city
*/

int sock;
ldbfDB *sng;

void res_func(long count) 
{
  ldbfRESULT *res;
  if(!count) return;
  while((res = ldbfFetchResult())) {
    strcpy(sng->record,res->data);
    printf("%s",ldbfValue("sng","kod"));
    printf("%s \n",ldbfValue("sng","city"));
  }
}


main()
{
  if((sock = ldbfConnect("localhost")) == -1) {
    printf("Cannot connect:%d\n",ldbf_errno);
    exit(0);
  }
  sng = ldbfOpen(sock,"sng",0);
  if(!sng) {
   printf("Cannot open sng:%d\n",ldbf_errno);
   ldbfShutdown(sock);
   exit(0);
  }
  /* we want to find all records that begins with 0449 in field 'kod' */
  ldbfCall(sock,"locate","0449",res_func);
  ldbfShutdown(sock);
}
