proc applyWidgetOptions { w opts } {
	global sld frm frmv 
	foreach op $opts {
		$w config -$op [.opt.$op.e get]
	}
	switch [winfo class $w] {
	Entry {
		switch $sld(att) {
		"#tuples" {
			set frmv($w) {$sld(ntuplas)}
		}
		"#current" {
			set frmv($w) {$sld(ntuplas) ? $sld(iconsulta)+1 : 0}
		}
		default {
			set frm($w) [list $sld(class) $sld(att) [.opt.f.e get]] 
		} }
	} 
	Button {
		$w config -command "$sld(cmd) [lindex $sld(lclass) 0]"
	} }
	destroy .opt
}

proc widgetOptions { w x y } {
	global sld frm
	toplevel .opt
	wm transient .opt .	
	set dbopt {}
	foreach j [$w config] {
		lappend dbopt [lindex $j 0]
	}
	set opts {}
	set entries {}
	foreach op {image background borderwidth foreground \
			relief font justify text} {
		if {[lsearch $dbopt -$op] >= 0} {
			frame .opt.$op
			label .opt.$op.l -text $op
			entry .opt.$op.e
			.opt.$op.e insert 0 [lindex [$w config -$op] 4]
			pack .opt.$op.l .opt.$op.e -side left
			lappend opts $op
			lappend entries .opt.$op
		}
	} 
	switch [winfo class $w] {
	Entry {
#### verifica existencia desta entry
		if [info exists frm($w)] {
			set sld(class) [lindex $frm($w) 0]
			set sld(att) [lindex $frm($w) 1]
			set fmt [lindex $frm($w) 2]
		} {
			set fmt ""
		}
#### inclui atributos da classe correntemente selecionada
		combobox .opt.att -textvariable sld(att)
		set combolst "#tuples #current"

		foreach i [queryList \
			"select a.attname, t.typname, a.attlen, a.oid, c.oid \
			from pg_attribute a, pg_class c, pg_type t \
			where a.attrelid = c.oid \
				and	c.relname = '$sld(class)' \
				and a.attnum > 0 \
				and a.atttypid = t.oid \
			order by a.oid"] {
				append combolst " [lindex $i 0]"
		}
		eval combobox_setlist .opt.att $combolst
#### inclui entrada para o formato (apresentao) do atributo
		frame .opt.f
		label .opt.f.l -text format
		entry .opt.f.e
		pack .opt.f.l .opt.f.e -fill x -expand 1 -side left
#### Boto para executar comandos no formulrio
	} Button {
#### menu de opes: next,prev,first,last,retrieve,record,clean,delete
#### estes comandos usaro o sub-form corrente (no a base-class)
#### para usar a base-class (todo o formulrio) selecionar "** base **"
		menubutton .opt.att -indicatoron 1 -relief raised \
			-menu .opt.att.m 
		menu .opt.att.m -tearoff 0
		foreach {lab cmd} { next dbNext prev dbPrev first dbFirst \
			last dbLast retrieve dbRetrieve record dbRecord \
			delete dbDelete clean dbClean } {
				.opt.att.m add radiobutton -label $lab \
					-variable sld(cmd) -value $cmd
		}
		menubutton .opt.f -indicatoron 1 -relief raised \
			-menu .opt.f.m
		menu .opt.f.m -tearoff 0
		set classlist [queryList "select distinct c.relname,c.oid from \
				pg_class c, pg_attribute a \
			where c.relkind = 'r' \
				and a.attnum > 0 \
				and c.relname !~ '^pg_' \
				and a.attrelid = c.oid \
			order by c.oid"]
		foreach class $classlist {
			.opt.f.m  add radiobutton -label [lindex $class 0] \
				-variable sld(lclass) -value $class
		}
	}
	}
#### inclui buttons para os comandos 'cancel' e 'apply'
	frame .opt.bts
	button .opt.bts.cancel -text cancel -command {destroy .opt}
	button .opt.bts.apply -text apply -command "applyWidgetOptions \
		$w [list $opts]"
	pack .opt.bts.cancel .opt.bts.apply -side left -fill x -expand 1
	eval pack .opt.att .opt.f $entries .opt.bts \
		-fill x -expand 1 -side top
	centerWindow .opt
	raise .opt
	focus .opt
	grab .opt
}

proc applyObjectOptions { i opts } {
	foreach op $opts {
		.c itemconfig $i -$op [.opt.$op.e get]
	}
	destroy .opt
}

proc objectOptions { x y } {
	toplevel .opt
	wm transient .opt .	
	set i [.c find closest $x $y]
	set dbopt {}
	foreach j [.c itemconfig $i] {
		lappend dbopt [lindex $j 0]
	}
	set opts {}
	set entries {}
	foreach op {anchor fill outline width font justify text} {
		if {[lsearch $dbopt -$op] >= 0} {
			frame .opt.$op
			label .opt.$op.l -text $op
			entry .opt.$op.e
			.opt.$op.e insert 0 [lindex [.c itemconfig $i -$op] 4]
			pack .opt.$op.l .opt.$op.e -side left
			lappend opts $op
			lappend entries .opt.$op
		}
	} 
	frame .opt.bts
	button .opt.bts.cancel -text cancel -command {destroy .opt}
	button .opt.bts.apply -text apply -command "applyObjectOptions \
		$i [list $opts]"
	pack .opt.bts.cancel .opt.bts.apply -side left -fill x -expand 1
	eval pack $entries .opt.bts -side top
	centerWindow .opt
	raise .opt
	focus .opt
	grab .opt
}
