%{ // -*- awk -*-
#include <stdio.h>
#define debug 2
	    /*	    extern int yylex (); */

	    int edit_transaction;
	    int edit_tuple;
	    int send_all;
	    char* edit_domain;
	    int edit_oid;

	    extern int init_search(char* domain, int all);
	    extern int insert_condition (int i, char* name, char* value, char condition);
	    extern int search (int i, int all);

	    extern int select_tuple (int i, int n);
	    
	    extern int init_save (char* domain);
	    extern int insert_pair (char* domain, char* ,char* );
	    extern int do_save (char* domain, int oid);	  /* 0 for new tuple --- insert */

	    extern int quit_search (int i);
	    extern int quit_tuple (char*  domain, int oid);

	    extern int complete (char* name, char* prefix, int mode);
	    extern int create (char* name, char* query);
	    extern int drop (char* name);


	    extern int command ();
	    yyerror (char *s)
	      {
		printf ("yyerror: %s \n",s);
	      }
%}


%union{
  char*  string;
  int 	num;
};

%token <string> COMMAND
%token <string> QUERY
%token <string> TABLE
%token <string> NAME
%token <num> NUMBER

%token COMPLETE
%token CREATE
%token DROP

%token SEARCH
%token SEARCH_LIST
%token SELECT

%token FORGET
%token QUIT
%token SAVE

%%
program:	command 	{command ();}
|	   program command	{command ();}
;



// free-ing is not so good idea!! So, generally I free everything -- names of objects, only conditions/values.

command:  COMPLETE NAME NAME NUMBER{
  printf ("Completing prefix >%s< in %s mode %d\n", $3, $2,$4);
  complete ($2,$3,$4); 
  free ($2); free ($3);} 
| 	CREATE  NAME NAME {
  printf ("CREATING...%s AS  %s\n", $2, $3);
  create ($2, $3);
  free ($2); free ($3);}
| 	DROP NAME 	{
  printf ("DROPING...%s \n", $2);
  drop ($2); free ($2);}



| 	search_head list	{
#if debug
  printf ("searching...\n");
#endif
  search (edit_transaction, send_all);
}
| SELECT NUMBER NUMBER	{
#if debug
  printf ("selecting in slot %d position %d\n", $2, $3);
#endif
  select_tuple ($2, $3);
}
| save_head list	{	/* The list must be saved in a general way  -conditions, values ...*/
#if debug
 printf ("saving %s \n", edit_domain);
#endif
 do_save (edit_domain, edit_oid);
 free (edit_domain);
}
| FORGET NUMBER {
  printf ("forgetting slot %d\n", $2);
  quit_search ($2);
}
| QUIT NAME NUMBER {
  printf ("quitting from tuple in domain  %s, tuple %d \n", $2, $3);
  quit_tuple ($2, $3);
  free ($2);
  printf ("quitting\n");
}
;



//  HEADS


search_head: SEARCH NAME	{
  send_all=0;
  puts($2);
  edit_transaction=init_search ($2, send_all);
  free ($2);
}
| SEARCH_LIST NAME	{
  send_all=1;
  printf ("search all !!!\n");
  edit_transaction=init_search ($2, send_all);
  // free ($2);
}






save_head: SAVE NAME NUMBER	{
  edit_domain=$2;		// will be free-d later
  edit_oid=$3;
#if debug
  printf ("save head %s %d\n", edit_domain, edit_oid);
#endif
  init_save (edit_domain);
  // free ($2);
}




// LISTS



list: '(' cons ')'		{
#if debug
  printf ("list \n");
#endif
}
;







cons: '('  NAME NAME NAME ')'	{
#if debug
  printf ("cons terminal: (%s.%s)\n",  $2, $3);
#endif
  insert_condition (edit_transaction, $2, $3, $4[0]);
  // free ($2); free ($3); 
  free ($4);
}

| '('  NAME NAME NAME ')'  cons	{
#if debug
  printf ("cons: (%s.%s)\n",  $2, $3);
#endif
  insert_condition (edit_transaction, $2, $3, $4[0]);
  // free ($2); free ($3); 
  free ($4);
}




| '(' NAME NAME ')'	{
#if debug
  printf ("cons terminal: (%s %s)\n",  $2, $3);
#endif
  insert_pair (edit_domain, $2, $3);
  // free ($2); free ($3);
}

| '(' NAME NAME ')' cons	{
#if debug
  printf ("(%s %s)\n",  $2, $3);
#endif
  insert_pair (edit_domain, $2, $3);
  // free ($2); free ($3);
}
;




%%
