/* -*-c++-*-
   Conventions:
     Big structures are named in UPPERCASE, sorry
*/
#ifndef SEARCH_H
#define SEARCH_H

#include <libpq++.h>
#include <map.h>
#include <multimap.h>
#include "ios.h"

#define SELECT "select ";
#define UPDATE "update "
#define FROM " from "
#define WHERE " where "





typedef multimap<string, string, less<string> >  v_binding;
typedef v_binding::value_type  v_binding_vt;


typedef struct {
  //  int oid;
  int n_editors;
  bool terminal[MAX_CONNECTIONS]; // on which terminal is present this tuple
  string bname;
  v_binding* values;
} tuple_store;

typedef map<int,tuple_store, less<int> >  T_STORE;

// Every search keeps it's oids locally !!!  allocating 1 block seems better then many small !!
typedef struct{
  //  tuple_store*	ref;
  int		oid;
}tuple_reference;





class edit_program		// example: books/libri 
{

private:
  string name;
  SOCKET* SOC;			// write to this socket !!!
public:
  string oid_fields;		// select  ...  _"oid, title, author"_  from libri where ....<conditions> 
  string real_fields;		// 		 "oid, title, author, pages, isbn, year, publisher, category"
  string from_tables;		// from "libri X, publishers Y where"
  string bname;			// "concat ()"  query to get the name of the buffer

  string query;

  int	edited;			// number of 'open' tuples  --- i.e. being edited
  int 	nfields;
  T_STORE store;
  v_binding* values; // new ones

  edit_program(string s);		// Read-in from somewhere the description
  ~edit_program();


  bool compose_difference (v_binding* originals, v_binding* news, int oid);
  int init_save ();
  int insert_pair (string name,string value);
  int do_save (int oid);

  int second_search (int oid);
  int send_tuple (int oid);
  int quit_tuple (int oid);

  // Searches
  // Data manipulation		update libri  set  ( )   where oid=%, update publishers set () where oid=; ...
protected:

};


typedef map<string, edit_program*, less<string> >  p_binding;
p_binding EPS;	// Where I keep all the  *edit_programs*
//--------------------------
typedef pair<const string, const char> CONDITION;
typedef pair<const string, CONDITION>  PAIR;
typedef multimap<string, CONDITION, less<string> >  c_binding;
//--------------------------







//friend	
class edit_transaction		// searches/queries, example:  books by Rudin, People under 25
{
private:
  edit_program* EP;
  c_binding 	COND_MAP;
  tuple_reference* MEMORY;
  T_STORE 	*STORE;
  bool terminal[MAX_CONNECTIONS]; // owners

  //  int oid;
  string Q_condition;		// the where ** part of the query  --- it is used 2 times -- ONLY 1 !!
  string query;			// general-purpose  space 
  int    ntuples;		// 
  SOCKET* SOC;			// write to this socket !!!

  bool send_all;		// Send a list of all, even if just 1, 0
  bool editing;			// only temporary -- iff the position can be updated ---is being edited
  bool sunset;			// indicates, that quiting results in forgetting eventually; 
				// the search will never be asked, anymore
public:
  // read -in specs for this type of search
  //  edit_transaction (string name);
  edit_transaction (string name, int all);
  ~edit_transaction ();

  int insert_condition (string name, string value, char relation);
  int add_condition(PAIR P);
  int compose ();
  int exec_search (int all);

  int select_tuple (int pos);
  int send_list ();
protected:
};

#endif



