/*
  (c) 1998  Michal Maruska <mmaruska@tin.it>
  
  This file is part of postgreSQL-emacs-forms.

  postgreSQL-emacs-forms is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.



  Description:
  This file contains interface to the yacc file: several C functions that call C++ constructs
  ... and definitions of the C++ classes 
  
  
  Rougly, the server permits following ops:
  
  * make a search for records with given values/criteria and ...
  * deliver the tuple/tuples

  * update values





  How does it proceed?
  
  first collect data/triples for the query (eg.  surname 'Maruska' "=")

  Make a preliminary/first  search (just get oids, and some fields, which allow manual selection in case of
  multiple tuples)  
  
  Make the second search for a specified oid --- make apropriate indexes !!!
  ... and record the values

  on request save new values: compare with the old ones and generate a query to update + to un-update !!!  



  sentinel is used to delimit 

*/

#include "search.h"
#define debug 1


extern SOCKET S;

extern "C" {
  int init_search(char* domain, int all);
  int insert_condition (int i, char* name, char* value, char relation);
  int search (int i, int all);
  int select_tuple (int i, int pos);

  int init_save (char* domain);
  int insert_pair (char* domain, char* name,char* value); // domain not used --- in future parallelized ??
  int do_save (char* domain,int j);  // domain not used --- in future parallelized ??
  
  int quit_search (int i);
  int quit_tuple (char* domain, int oid);


  int command();
	   };



static PgDatabase	PG ("maruska");
#define MAX_SLOTS  100
static edit_transaction*  A[MAX_SLOTS];
static edit_program* ep;

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
// C interface to yacc (I'm not capable, have no experince,  to generate C++ bison/yacc). Sorry


// Not implemented !! Emacs-(client)-side  will wait
int send_error ()
{
  cerr << "Error occured";
  S.write ("(message \"An error occured (wrong id)\")");
  S.write ("#",1);		// note the terminal # !!!!   ???
  S.flush ();
}



int command()
{
  cerr <<"selecting which socket\n";
  S.select ();
}


int init_search (char* domain, int all)
{
  int i;
  const char* D;
  // find a new/free slot in the vector of transactions
  i=0;
  while (i< MAX_SLOTS &&
	 A[i]!=NULL)
    i++;
  if (i==MAX_SLOTS )
    {
      send_error ();
      return -1;		// This is a problem I should check for i in following functions !!!
    }
  else
    {
      D=strdup (domain);
      cerr << D << domain <<"\n";
      A[i]=new edit_transaction (D, all);
    }
  return i;
}



// Store the pair (name, value, relation =/is null/>/</!=/~  etc.)
int insert_condition  (int i, char* name, char* value, char relation)
{
  if (A[i]!=NULL)		// even if i<0
    {
      A[i]->insert_condition (string(name), string(value), relation);
#if debug>0
      cerr <<"insert_condition: " << name << value <<"\n";
#endif
    }
  else 
    send_error ();
}


// for saving 
int insert_pair (char* domain, char* name,char* value)
{
#if debug>0
  cerr<<"insert_pair " << name << value <<"\n";
#endif
  if (ep!=NULL)
    ep->insert_pair(string(name), string(value));
  else
    send_error ();
}



// after inserting conditions, execute the search and deliver results
int search (int i, int all)
{
  char number[4];
  int res;


  if (A[i]!=NULL)
    {
      sprintf (number,"%d", i);
#if debug>0
      cerr <<"executing the search in a new position: " << number <<"\n";
#endif
      cerr << "1\n";
      res=A[i]->exec_search (all);
      cerr << "1\n";
      S.write ("(setq TCP-id ",13);
      S.write (number);
      S.write (")#",2);		// note the terminal # !!!!

      S.flush ();

      if ((all==1) || (res==1))
	{
#if debug>0
	  cerr <<"deleting the position: " << number <<"\n";
#endif
	  delete A[i];
	  A[i]=NULL;
	}
    }
  else 
    send_error ();
}





// if the query-result was multiple, select the i-th row
int select_tuple (int i, int pos)
{
  if (A[i]!=NULL)
    {
      A[i]->select_tuple(pos);
      S.write ("#",1);		// note the terminal # !!!!
      S.flush ();
    }
  else 
    send_error ();
}


// get-ready for saving !!!
int init_save (char* domain)
{
  p_binding::iterator p;

  p=EPS.find (domain);
  if (p==EPS.end ())
    {
      send_error ();
      ep=NULL;
    }
  else 
    {
      ep=(*p).second;
      ep->init_save ();
    }
#if debug>0  
  cerr << "save started \n";
#endif
}


// after inserting new values, execute the update command
int do_save (char* domain, int oid)
{
  if (ep!=NULL)
    ep->do_save(oid);
  else 
    send_error ();
}



// forget my editing the tuple, even the _entire_ search !!!
int quit_search (int i)
{

				// Multi users ???
  if (A[i]!=NULL)
    {
      delete A[i];
      A[i]=NULL;
    }
  else
    send_error ();
}


// forget my editing the tuple, even the _entire_ search !!!

int quit_tuple (char*  domain, int oid)
{
  p_binding::iterator p;

  p=EPS.find (domain);
  if (p==EPS.end ())
    {
      send_error ();
      ep=NULL;
    }
  else
    {
      ep=(*p).second;
      ep->quit_tuple (oid);
    }
}


//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
// FASE 1 --- preparing a query/search

edit_transaction::edit_transaction (string name, int all): editing(false),  MEMORY (NULL), sunset (false)
{
  p_binding::iterator i;

  send_all=(all==1);
  SOC=&S;
  i=EPS.find (name);
  if (i==EPS.end ())
    {
      // Here used the string
      EPS[name]=new edit_program (name);
      i=EPS.find (name);
    }
  EP=(*i).second;
  STORE=&(EP->store);
}



edit_transaction::insert_condition (string name, string value, char relation)
{
  COND_MAP.insert(PAIR (name, CONDITION(value,relation)));
}




//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
// FASE 2 --- exec the query/search


// compose the query/ the where-part  out of the conditions (inserted already)
int
edit_transaction::compose ()
{
  c_binding::iterator i;
  bool first=true;

  Q_condition="";
  i=COND_MAP.begin ();
  
  while (i!=COND_MAP.end ())
    {
      if (first)
	{
	  first=false;
	}
      else
	{
	  Q_condition+=" and ";
	}
      
      add_condition (*i++);
    }

  // Now prepare the 1st query 
  query+=SELECT;
  query+=EP->oid_fields;
  query+=FROM;
  query+=EP->from_tables;
  query+=WHERE;
  query+=Q_condition;
  return 0;
}


// decide on the relation 
int 
edit_transaction::add_condition(PAIR P)
{
  string attrib, value;
  char cond;
  
  attrib=P.first;
  value=P.second.first;
  cond=P.second.second;
  
  switch(cond)
    {
    case '=': Q_condition+="("+attrib+"= "+value+")"; // cond
    case '>':;
    case '<':;
    case ':':;
    case '*':;
    case '0':; // is null
    case '~':;
    }
  return 1;
}




int
edit_transaction::exec_search (int all)
{
  int oid;



  compose ();
#if debug>0  
  cerr << "exec_search:\n\tThe query is: " <<query <<"\n";
#endif
  cerr << "exec_search:\n\tThe query is: " <<query <<"\n";
  PG.Exec (query.c_str ());
  cerr << "exec_search:\n\tThe query is: " <<query <<"\n";
  ntuples=PG.Tuples ();
#if debug>0
  cerr << "\tthe query returned " << ntuples << " tuples\n";
#endif


  if (send_all)
    send_list ();
  else
    {
      if (ntuples==1)
	{				// re-make the query, with select *
#if debug>0  
	  cerr <<"Exactly 1\n";
#endif
	  SOC->write ("1",1);
	  oid=atoi (PG.GetValue (0,"oid"));
	  EP->send_tuple (oid);
	  return 1;
	}

      else if (ntuples==0)
	{
	  SOC->write ("0",1);
#if debug>0
	  cerr <<"None\n";	
#endif
	  S.write ("0",1);		// Incomplete
	}

      else
	{				// Finally multi-result
	  SOC->write ("+",1);
	  send_list ();
#if debug>0  
	  cerr <"Multi\n";
#endif
	}
    }
  return 0;
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
// FASE 3 deliver the results,  select "manually"  a tuple,  deliver tha data

int
edit_transaction::send_list ()
{
  int	i,j;
  char  number[5];
  int fields;


#if debug>0  
  cerr<<"Allocating list\n";
#endif
  fields=PG.Fields ();
  if (!send_all)
    MEMORY=(tuple_reference* ) malloc (sizeof(tuple_reference) * ntuples);

  SOC->write ("(setq TCP-ntuples ");
  sprintf (number,"%d", ntuples);
  SOC->write (number);
  SOC->write (")(setq TCP-list (list ",22);

#if debug>0  
  cerr<<"now storing, sending\n";
#endif
  for (i=0; i<ntuples; i++)
    {
      if (!send_all)
	{
	  MEMORY[i].oid=atoi (PG.GetValue (i,"oid"));
	  // MEMORY[i].ref=NULL;
	}
      SOC->write ("\"",1);
      //      sprintf (number,"%d ", i);
      //      SOC->write (number);

      for (j=1;j<fields; j++)
	{
	  SOC->write (PG.GetValue (i,j));
	  SOC->write (" ",1);
	}
      SOC->write ("\" ",2);
    }
  SOC->write ("))",2);
#if debug>0  
  cerr<<"I sent the  list\n";
#endif
}


// transmit data of a selected tuple  upper level
int 
edit_transaction::select_tuple (int i)
{
  if ((i<ntuples) && (i>-1))
    {
      EP->send_tuple (MEMORY[i].oid);
    }
  else
    {
      send_error ();
    }
}




// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// FASE 5 --- quitting/destructor
// See if everything is closed, nobody is editing
// Should free the MEMORY, but the edited tuples. (image 1000 editing only 2, though seems unimportant)

edit_transaction::~edit_transaction ()
{
  int i;

  if (!send_all)
      ::free (MEMORY);
}




//=-=--=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// This class permits a customization of queries to gain data. Still not very flexible !!
// see search.h

edit_program::edit_program (string s):name (s), values (NULL),  edited (0)
{
  query="select *  from edit_programs where name='";
  query+=name;
  query+="'";

#if debug>0
  cerr << "reading the specs for edit_program "<< name <<"\n" << "Query:"<< query <<"\n" ;
#endif
  SOC=&S;

  PG.Exec (query.c_str ());
  if (PG.Tuples ()>0)
    {
      oid_fields=strdup(PG.GetValue (0, "oid_fields"));
      real_fields=strdup(PG.GetValue (0, "real_fields"));
      from_tables=strdup(PG.GetValue (0, "from_tables"));
      bname=strdup(PG.GetValue (0, "bname"));
    }
  else send_error ();
}





// execute the data-oriented 2nd search, retrieve  actually the data needed using oids from  the
// preliminary search
int 
edit_program::second_search (int oid)
{
  char number[10];
  int i;
  v_binding* bind;
  tuple_store* st;

  sprintf (number,"%d", oid);

  query=SELECT;
  query+=real_fields;
  query+=FROM;
  query+=from_tables;
  query+=WHERE;
  query+="oid=";
  query+=number;
#if debug>0  
  cerr << "second query is " << query << "\n";
#endif
  PG.Exec (query.c_str ());
#if debug>0
  cerr << "\tthe query returned " << PG.Tuples () << " tuples\n";
#endif



  nfields=PG.Fields();		// Should be always the same (for different tuples/oids)

  
  // it=STORE->find(MEMORY[index].oid);
  /*
    if (it==STORE->end ())	// Have to insert !
  */



  bind=new v_binding;
  st=new tuple_store;
  st->values=bind;
  
  for (i=1;i<nfields;i++)	// 0 is oid 
    bind->insert(v_binding_vt(string(strdup(PG.FieldName (i))),string(strdup(PG.GetValue (0,i)))));
  //PG.free ()



  //bname
  query=SELECT;
  query+=bname;
  query+=FROM;
  query+=from_tables;
  query+=WHERE;
  query+="oid=";
  query+=number;
#if debug>0  
  cerr << "third query is " << query << "\n";
#endif
  PG.Exec (query.c_str ());
  
  st->bname=strdup(PG.GetValue (0,0));
  for (i=0;i<S.get_max ();i++)
    st->terminal[i]=false;
  store[oid]=*st;
}




// transmit data of a selected tuple - lower level
int
edit_program::send_tuple (int oid)
{
  int i;
  char number[10];

  T_STORE::iterator  s;
  tuple_store* st;
  v_binding::iterator p;

  s=store.find(oid);

  // if the tuple is already being edited, don't re-send the values, just indicate the buffer !!!
  if (s==store.end ())
    {
      second_search (oid);
      s=store.find(oid);
    }
  
  st=&((*s).second);
  
  if (st->terminal[S.get_current()])
    {
#if debug>0  
      cerr << "tuple already edited\n";
#endif
    }
  else
    {
      SOC->write ("(setq TCP-record (list ",22);
      for (i=1,p=(st->values)->begin();i<nfields;i++, p++)	// 0 is oid not ???
	{
	  SOC->write ("'(",2);
	  SOC->write ("\"",1);
      
	  SOC->write ((*p).first);
	  SOC->write ("\" \"",3);
	  SOC->write ((*p).second);
	  SOC->write ("\")",2);
	}
      SOC->write ("))",2);

      sprintf (number,"%d", oid);
      SOC->write ("(setq TCP-oid ");
      SOC->write (number);
      SOC->write (")");
      st->terminal[S.get_current()]=true;
    }
  
  // name of the buffer is a function af the tuple (attribute) values
  SOC->write ("(setq TCP-bname \"");
  SOC->write (st->bname);
  SOC->write ("\")");

}







edit_program::init_save ()
{
  values=new v_binding;
}

int edit_program::insert_pair (string name,string value)
{
#if debug>0
  cerr<< name << value <<"\n";
#endif
  //if (editing)
  values->insert(v_binding_vt(name,value));
}



bool
edit_program::compose_difference (v_binding* originals, v_binding* news, int oid)
{
  bool first=true;
  v_binding::iterator p, q;  
  char  number[10];  


  query=UPDATE;
  query+=from_tables;	// multiple !!!
  query+=" set ";

  for (p=originals->begin (), q=news->begin();
       q!=news->end () && p!=originals->end ();
       p++,q++)
    {
      if (!((*p).second == (*q).second) )
	{
	  cerr<< "difference noted " <<(*p).second << "->"  << (*q).second <<"\n";
	  if (first)
	    first=false;
	  else 
	    query+=", ";
	  query+= (*p).first;
	  query+="=\'";
	  query+= (*q).second;
	  query+="\' ";
	}
    }
  
  if (!first)
    {
      query+=WHERE;
      query+="oid=";
      sprintf (number,"%d", oid);
      query+=number;
      cerr << "second query is " << query << "\n";
    }
  return (!first);
}



// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// FASE 4 --- saving the tuple (updating)

int
edit_program::do_save (int oid)
{
  // 1 st version: the same maps
  v_binding::iterator it;
  tuple_store* st;
  T_STORE::iterator  s;

  
  cerr << "do save " << oid << "\n";
  s=store.find(oid);
  if (s!=store.end ())
    {
      st=&(*s).second;
      if (compose_difference (st->values, values, oid))
	{
	  updates << query <<";\n";
	  PG.Exec (query.c_str ());
	  updates.sync ();
	}

      if (compose_difference (values, st->values, oid) )
	{
	  restores << query <<";\n";
	  restores.sync ();
	}

      
      // Shift new ->old
      delete st->values;
      st->values=values;
      values=NULL;
    }
  else
    {
      send_error ();
    }
}




// A terminal quits editing the tuple. If the last one, free the position/memory
edit_program::quit_tuple (int oid)
{
  T_STORE::iterator  s;
  char msg[100];
  int i; 
  v_binding::iterator it;
  tuple_store* st;

#if debug>0  
  cerr << "edit_program: quit_tuple " << oid << "\n";
#endif
  
  s=store.find(oid);
  if (s!=store.end ())
    {
      st=&(*s).second;
      if (st->terminal[S.get_current()])
	{
	  bool erase=true;
	  st->terminal[S.get_current()]=false;
	  for (i=0;i<S.get_max ();i++)
	    if (st->terminal[S.get_current()])
	      erase=false;
	  if (erase)
	    {
	      //edited--;
	      delete ((*s).second).values;
	      store.erase(s);
	      
	      SOC->write ("(message \"Nobody editing forgetting\")#");
	      SOC->flush ();
	      
	    }
	  else
	    {
	      // sprintf (msg, "(message \"still editing %d tuples\")#", edited);
	      SOC->write ("(message \"Somebody still editing\")#");
	      SOC->flush ();
	    }
	}
      else
	{
	  send_error ();
	} 
    }
  else
    {
      send_error ();
    }
}


