;; -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;;; CREATING


(defun MM-create-tuple-buffer (name bname oid)	;oid not used !!!
  "return & create  the buffer (still inexistent !!) "
  (let (
	(buffer (get-buffer-create  bname)) ; this is the formula for the name !!
	(new-buffer-file (format "/tmp/%s"  bname))
	)
    (set-buffer buffer)
    (set-visited-file-name new-buffer-file)

    (message "forming")
    (MM-form name)

    ;; strictly personal
    (setq ET-oid  oid)
    (setq ET-name name)
    (setq MM-tuples-list (append (list bname) MM-tuples-list))
    (MM-update-tuples-map)
    ;;(message (format "setting ET-oid %d" ET-oid ))

    ;; now searches containg it:
    ;;(setq ET-tuple tuple)
    ;;(setq ET-id id)

    ;;(message "assigning")
    (MM-assign  name  TCP-record)
    (set-buffer-modified-p nil)
    buffer
    )
  )

;; If exists ??? --- this procedure doesn't care !! just go to the buffer and ...
;; return the buffer containg 
(defun MM-present-tuple (name bname oid)
  "make the buffer current --- initialize/create if neccesary"
  (if (buffer-live-p (get-buffer bname))
      ()
    ;; else generate
    (progn
      (MM-create-tuple-buffer name bname  oid)	;and go there
      )
    )
  (switch-to-buffer (get-buffer bname))
  (get-buffer bname)
  )


;;; Fase 3 --- create the form-buffer present the tuple (selected, or the only query result)

(defun MM-assign-one (pair)
  "Assign a value to the widget ---both specified as strings"
  (let (
	(name (format "%s%s" MM-field-prefix (car pair)))
	(value (car (cdr pair)))
	)
    (widget-value-set (symbol-value (intern-soft name)) value)
    (widget-setup)
    )
  )


(defun MM-assign (Bname values)
  "assign values to the fields"
  (mapcar 'MM-assign-one values)
  )



;;; Widgets

(defvar MM-field-prefix  "MM-f-"
  "the prefix to generate unique names of fields in MM-forms (the fields are _still_ accessed under plain names)"
  )
					;(mapcar 'MM-generate-widgets widlist)

(defun MM-generate-widgets (description)
  "generate a widget-prepare... a sort of dispatcher. Here a list of constructs:\
const  plain text
title  bold text
MM-field  field with completion aided with db/postgreSQL
MM-menu   
MM-integer
MM-string
see MM-descriptions.el for explanation/list of properties
"
  (let ( 
	(type (car description))
	)

    (cond 
     ((equal type "const")
      (widget-insert (nth 1 description))
      )
     (
      (equal type "title")
      (let (
	    (text  (nth 1 description))
	    )
	(widget-create
	 (list 'default
	       :button-face 'font-lock-def-face
	       :value text :format "\n%[%t%]\n")
	 ))
      )
     (
      (equal type "face-def")
      (let (
	    (name  (nth 1 description))
	    (fore  (nth 2 description))
	    (back  (nth 3 description))
	    )
	(set-face-colors name fore back)
	)
      )
     ('t
      ;; else
      (let (
	    (name (format "%s%s" MM-field-prefix (nth 1 description)))
	    widget
	    )
	(cond
	 (
	  (eq type 'MM-field)
	  ;; MM-field
	  (let (
		(tag  (nth 2 description))
		(len  (nth 3 description))
		(help (nth 4 description))
		(domain (nth 5 description))
		(def-val (nth 6 description))
		)
	    (setq widget
		  (widget-create
		   (list 'MM-field
			 :tag tag
			 :size len
			 :help-echo help
			 :domain domain
			 ""
			 )
		   )))
	  )
	 (
	  (eq type 'MM-integer)
	  ;; MM-integer
	  (let (
		(tag  (nth 2 description))
		(len  (nth 3 description))
		(help (nth 4 description))
		(def-val (nth 5 description))
		)
	    ;;(message (format "name %s len %d  tag %s  help %s" name len tag help))
	    (setq widget
		  (widget-create
		   (list 'MM-field
			 :tag tag
			 :size len
			 :help-echo help
			 ""
			 )
		   )))
	  )
	 (
	  (eq type 'MM-menu)
	  ;; MM-menu
	  (let*(
		(tag  (nth 2 description))
		(len  (nth 3 description))
		(help (nth 4 description))
		(item-list (nth 5 description))
		(items 
		 (mapcar (lambda (name) (list 'item name) )
			 item-list))
		)
					;	    (message  items)
	    (setq widget
		  (widget-create
		   (apply 'list 'menu-choice
			  :tag tag
			  :size len
			  :help-echo help
			  items
			  )
		   )))
	  )
	 (
	  (eq type 'MM-string)
	  ;; MM-string
	  (let*(
		(tag  (nth 2 description))
		(len  (nth 3 description))
		(help (nth 4 description))
		(value (nth 5 description))
		)
	    (setq widget
		  (widget-create
		   (list 'string
			 :tag tag
			 :size len
			 :help-echo help
			 :value value
			 )
		   )))
	  )
	 (
	  t
	  ;; direct description:
	  (setq widget
		(apply 'widget-create type
					;		      (list :tag "sex"  :size 5
					;			    :help-echo "sex (read-only)"
					;			    '(item :tag "m" :value "m")
					;			    '(item :tag "f" :value "f")
					;			    )
		       (nthcdr 2  description)
		       ))
	  ));;cond

	(widget-insert "  ")
	(widget-setup)
	(make-local-variable (intern name))
	(set (intern-soft name)  widget)
	));;let
     )))



(defun MM-form (name)
  "Create a form, read the description, generate widgets, generate standard widgets, bind keys... "
  (interactive)
  (let (
	(widlist (symbol-value (intern-soft (format "%s-widlist" name))))
	)
    (kill-all-local-variables)
    (setq ET-name name)			; remember  the name
    
    (let ((inhibit-read-only t))
      (erase-buffer))
    (let ((all (overlay-lists)))
					; Delete all the overlays.
      (mapcar 'delete-overlay (car all))
      (mapcar 'delete-overlay (cdr all)))
    

    (mapcar 'MM-generate-widgets widlist)
  
    (widget-insert "\n")
    (widget-create (list 'push-button :tag "save"  :form name :button-face 'highlight
			 :action (lambda (widget &rest ignore)
				   ;;MM-save-int    here it's a bit more subtle, I sould have 2 forms
				   (let (
					 (name (widget-get widget :form))
					 )
				     (MM-save name)
				     )
				   )))
    (widget-create (list 'push-button :tag "reset"  :form name 
			 :action  (lambda (widget &rest ignore)
				    (let (
					  (name (widget-get widget :form))
					  )
				      (MM-reset name)
				      )
				    )))
    (widget-create (list 'push-button :tag "kill"  :form name 
			 :action  (lambda (widget &rest ignore)
				    (let (
					  (name (widget-get widget :form))
					  )
				      (MM-quit-tuple ET-id ET-tuple)
				      )
				    )))
    (widget-create (list 'push-button :tag "search"  :form name 
			 :action (lambda (widget &rest ignore)
				   (let (
					 (name (widget-get widget :form))
					 )
				     (MM-search name)
				     )
				   )))
    (widget-create (list 'push-button :tag "next"  :form name 
			 :action (lambda (widget &rest ignore)
				   (MM-next 1)
				   )))
    (widget-create (list 'push-button :tag "prev"  :form name 
			 :action (lambda (widget &rest ignore)
				   (MM-next -1)
				   )))
    (use-local-map widget-keymap)

    ;;(define-key widget-keymap "\C-x\C-s" 'MM-save-int)
    ;;(define-key ctl-x-map  "\C-s" 'save-buffer)
    ;;(define-key widget-keymap "\C-x\C-r" 'MM-reset-int)
    ;;(local-set-key "\C-x\C-s" 'MM-save-int)
    (local-set-key "\C-x\C-r" 'MM-reset-int)

    (make-local-hook 'kill-buffer-hook )
    (add-hook 'kill-buffer-hook 'MM-quit-tuple-int nil 't)

					;(add-hook 'local-write-file-hooks 'MM-save-int)
    (add-hook 'write-contents-hooks 'MM-save-int)

    (widget-setup)
    )
  )

					;(remove-hook 'write-file-hooks 'MM-save-int )
					;(remove-hook 'kill-buffer-hook 'MM-quit-tuple )
					;(remove-hook 'kill-buffer-hook 'MM-forget-int )




;; -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;;; SAVING
(defun MM-value-get (name)
  ""
  (let (
	(namewidget (format "%s%s" MM-field-prefix name))
	)
    (widget-value (symbol-value (intern-soft namewidget)) )
    ))


;; Common condition: is it a value-carrier
(defun MM-value-carrier (type)
  "decide if this widget-type contains a value"
  (if (stringp type)
      nil
					;    (
					;     (string= type "const")
					;     nil
					;     )
					;    (
					;     (string= type "title")
					;     nil
					;     )
    ;;else
    (cond
     (
      (equal type 'push-button)
      nil
      )
     (
      (equal type 'contatti-button)
      nil
      )
     (
      (equal type 'default)
      nil
      )
     (
      't
      ))
    ))
					;(MM-value-carrier 'MM-field)  debug

(defun MM-save-widget (description)
  ""
  (let ( 
	(type (car description))
	)
    (if (MM-value-carrier type)
	(let* (
	       (name (nth 1 description))
	       (cmd (format "( %S %S ) " name (MM-value-get name)))
	       )
	  ;;(message cmd)
	  (process-send-string TCP-completerP  cmd)
	  )
      )
    ))




(defun MM-save (name oid)
  "save (via TCP-channel) the values in the form\
we re-seek the description !!! modifying it in between is dangerous/useful (once I'll make it buffer-specific ?)"
  (interactive)
  (if (buffer-modified-p)
      (let* (
					;	(name "person")
	     (widlist (symbol-value (intern-soft (format "%s-widlist" name))))
	     (cmd (format "save  \"%s\" %d (" name oid) )
	     )

	(message cmd)
	(process-send-string TCP-completerP cmd)
	(mapcar 'MM-save-widget  widlist)
	(process-send-string TCP-completerP ")" )
	(set-buffer-modified-p nil)
	)
    )
  )

;; For the hook, keys, mouse, button
(defun MM-save-int ()
  "interactive"
  (interactive)
  ;;(message "saving 1")
  (MM-save ET-name ET-oid)
  ;;(message "saving 2")
  't
  )



;;; QUITTING
;; -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=


(defun MM-quit-tuple (name oid)
  "not interactive"
  (if (MM-process-OK TCP-completerP)
      (let (
	    (cmd (format "quit \"%s\" %d " name oid))
	    (bname (buffer-name))
	    )
	;;(message cmd)
	(process-send-string TCP-completerP  cmd)
	(setq MM-tuples-list (delete bname MM-tuples-list))
	(MM-update-tuples-map)
	;;(message "order sent")
	(MM-wait-end-and-eval)
	)
    )
  )

(defun MM-quit-tuple-int ()
  "interactive"
  (interactive)
  (MM-quit-tuple ET-name ET-oid)
  )




;;; Fase 0 --- QBE (query by example) 



;; reset values in the form, quit editing the tuple,  drop the changes !!!
(defun MM-reset (name)
  "not interactive"
  (MM-quit-tuple ET-id ET-tuple);; inform the server
  (rename-buffer (format "%s-QBE" name))
  (MM-form name)
  )

(defun MM-reset-int ()
  "interactive"
  (interactive)
  (MM-reset ET-name)
  )


(defun MM-formulate-condition (description)
  "extract the name, value and type of relation"
  (let ( 
	(type (car description))
	)
    (if (MM-value-carrier type)
	(let* (
	       (name (nth 1 description))
	       (namewidget (format "%s%s" MM-field-prefix name))
	       (value (widget-value (symbol-value (intern namewidget ))))	      
	       )
	  (if (or
	       (string= value "")
	       (string= value "nil")
	       )
	      ()
	    ;;else
					;(message name)
					;(message value)
	    (list name (format "'%s'"  value)  "=")
	    )
	  )
					;(message "not carrier")
      )))


(defun MM-search (name)
  "extract the values/relations from a QBE-form"
					;(interactive) ;debug
  (let* (
	 (widlist (symbol-value (intern-soft (format "%s-widlist" name))))
	 (conditions (mapcar 'MM-formulate-condition  widlist))
	 (real-conditions nil)
	 c
	 )
    ;; The problem is, that mapcar returns "nil" .. it's impossible to return really nothing
    ;; i.e. skip that member, 
    ;; So now I filter out these nils
					;(print conditions)
    (while conditions
      (setq
       c (car conditions)
       conditions (cdr conditions)
       )
      (if (not (equal c nil))
	  (setq real-conditions (nconc  real-conditions  (list c)) )
	)
      )
					;(print real-conditions)
    (if real-conditions
	(progn
					;(message "----")
	  (MM-edit name real-conditions)
	  )
      )))




(provide 'MM-tuple-buffer)
