;;; MM-commands.el --- function to connect widgets/forms  with   an sql database;  c++-program-interface
;; (server) enclosed 

;;; Copyright notice:

;; Author: Michal Maruka <mmaruska@tin.it>   
;;         that's Maruska where   stays for "s check" in Emacs coding.
;; Keywords:  widgets, database, forms, server/client, postgreSQL
;; Version: 1.0

;; For full copyright notice see the file MM-form.el

;;; Commentary



;;; Code:



;;;  Fase 2 --- presenting the results - a list of rows in a "set buffer"

(defun MM-print (string)
  "output string with newline---a row of results, in the future make special face, mouse-sensitive etc."
  (let (
	(M (point))
	)
    (insert string "\n")
    (put-text-property (1+ M) (- (point) 2) 'mouse-face 'highlight)
    )
  )

;;(put-text-property 1 (point) 'mouse-face 'highlight)




;; formerly  MM-select-list
(defun MM-present-list  (name id List card)	;called from MM-edit to
  "Switch to set-buffer, assign keys, list possibilities, make read-only"
  (let
      (
       (bname (format "%s-%d" name id))
       )
    (set-buffer (get-buffer-create bname))
    (setq buffer-read-only nil)
    (erase-buffer)
    (insert "Results of the search:\n click (mouse/RET) on line which interests you\n")
    (put-text-property 1 (1- (point)) 'face 'font-lock-section-face)
    (message "1")
    (setq ET-preamble (current-line (point)))
    (mapcar 'MM-print List)
					;(display-completion-list  List)
					;(select-window (get-buffer-window bname)); ???
    (setq ET-id id)
    (setq ET-name name)
    (setq ET-ntuples card)
    (setq MM-searches-ring (append (list bname) MM-searches-ring))
;;;********    ;;(setq result (cons (car tail) result)))
    (MM-update-searches-map)

    (setq ET-bnames (make-vector card nil)) ;; to be cancelled !!! ???    PROBLEM: oid/key
    ;; A usefull array of buffers !!! but big ? autonomous 


    ;; HOOKS
    (make-local-hook 'kill-buffer-hook)
    (add-hook 'kill-buffer-hook 'MM-quit-search-int nil 't)


    ;; KEYS
    (local-set-key "
" 'MM-select-tuple-line) ; What is the symbolic name?  enter [RET] ??
    (local-set-key  [mouse-1] 'MM-select-tuple-line-mouse)
    (local-set-key  [mouse-2] 'MM-select-tuple-line-mouse)

    (setq buffer-read-only 't)
    (switch-to-buffer bname)
    )
  )


;; -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;;; Selecting tuples

(defun MM-select-tuple (name id tuple)
  "look if already edited, otherwise communicate to TCP the selection, and edit.."
  (set-buffer (format "%s-%d" name id))	;there is the local ET-bnames !!!!
  (setq tuple (- tuple  ET-preamble))
  (message "%d" tuple)
  ;; Control, look  in the memory 
  (if (and (< tuple ET-ntuples) (> tuple -1))
      (let (
	    (buffer (aref ET-bnames tuple))	;nil at the beginning !!!
	    )
	(if (buffer-live-p buffer)
	    (switch-to-buffer buffer)

	  ;;else we have to request data... maybe the tuple is already edited, we don't know the buffer
	  (progn
	    (let ((cmd (format "select   %d %d " id tuple) ) )
	      ;;(message cmd)
	      (process-send-string TCP-completerP cmd)
	      ;; Here I could do same preparations --- and give the server time to compute.
	      (MM-wait-end-and-eval)
	      
;;; **********
	      (aset ET-bnames tuple 
		    (MM-present-tuple name TCP-bname TCP-oid)
		    )
	      )
	    )))
    ;;else 
    (message "tuples over-flow")
    )
  )


;; Not used
(defun MM-current-line (p)
  "Return the vertical position of point...  line 0,1 ... [many] "
  ;; (interactive "d")
  (+ (count-lines (window-start) p)
     (if 
	 (= (current-column) 0) 
	 1
       0)
     )
  )
;;(MM-current-line)   --debug

(defun current-line (point)
  "Return the vertical position of point..."
  (+ (count-lines 1 point)
     (if (= (current-column) 0) 1 0)
     -1)
  )



(defun MM-select-tuple-line (p)
  "to be bound to [RET] in the completion buffer, to select 1 of possible records/rows"
  (interactive "p")
  (let ( 
	(index (current-line (point)))
	)
    (MM-select-tuple ET-name ET-id index)
    )
  )


(defun MM-select-tuple-line-mouse (mouse-event)
  "to be bound to mouse-down-1 in the completion buffer, to select 1 of possible records/rows"
  (interactive "e")
  (message "Mouse")
  (let* ( 
	 ;;(x (car (cdr (mouse-position))))
	 ;;(sx (window-edges))
	 ;;(wx (window-start))
	 (window (nth 0 (nth 1 mouse-event)))
	 (buffer (window-buffer window))
	 (pos (nth 1 (nth 1 mouse-event)))
	 (item (current-line pos)))
    (set-buffer buffer)
    (message (format "%d" pos))
    ;;(set-window-point )

    (MM-select-tuple ET-name ET-id (1- item) )
    )
  )




(defun MM-select-line ()
  "This presents results in case they are too much --more than ??? (1000)."
  ;; not implemented  --- called from MM-edit !!
  (message "too many result-rows, can't handle !")
  )


(defun MM-next (offset)
  ""
  (interactive "p")
  (MM-select-tuple ET-name ET-id  (+ ET-tuple offset))
  )





;;; Quitting
;; -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

(defun MM-quit-search-int ()
  "interactive"
  (interactive)
  ;;(message "forgetting 1")
  (MM-quit-search ET-id)
  ;;(message "forgetting 2")
  )

(defun MM-quit-search (id)
  "not interactive"
  (if (MM-process-OK TCP-completerP)
      (let (
	    (bname (buffer-name))
	    (cmd (format "forget %d " id))
	    )
	(process-send-string TCP-completerP  cmd)
	(setq MM-searches-ring (delete bname MM-searches-ring))
	(MM-update-searches-map)
	;;(MM-wait-end-and-eval)
	)
    (message "TCP not running, killing anyway")
    )
  )




(provide 'MM-search-buffer)
