;;; MM-form.el --- function to connect widgets/forms  with   an sql database;  c++-program-interface
;; (server) enclosed 

;;; Copyright notice:

;; Author: Michal Maruka <mmaruska@tin.it>   
;;         that's Maruska where   stays for "s check" in Emacs coding.
;; Keywords:  widgets, database, forms, server/client, postgreSQL
;; Version: 1.0

;; This file is part of postgreSQL-emacs-forms.

;; postgreSQL-emacs-forms is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; postgreSQL-emacs-forms is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with postgreSQL-emacs-forms; see the file COPYING.  If not, write to
;; the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.



;;; Acknowledgement:
;; _Emacs_ is (extract from the copyright notice):

;; Copyright (C) 1996, 1997 Free Software Foundation, Inc.

;; _Widgets_ is:

;; Copyright (C) 1996, 1997 Free Software Foundation, Inc.
;; Author: Per Abrahamsen <abraham@dina.kvl.dk>

;; _PostgreSQL_ is:

;; PostgreSQL Data Base Management System (formerly known as Postgres, then
;; as Postgres95).
;; Copyright (c) 1994-7 Regents of the University of California








;;; Commentary -general:
;; The reason for this program was the lack of a (free) user-friendly environment to edit
;; database/tables. The great potential of Emacs seems _inevitably_ the right platform.
;;
;; THE FILE IS being developed for my own activity---something is useless for public !!!
;; I'll sweep it out, when things/concepts  become clearer.


;;; What I need from emacs: 
;; group buffers into work-clusters---I expect the number of open buffers to grow significantly, so
;; jumping/switching among -- say "friends", i.e. related buffers would be welcome.

;; Hidden buffers --- if *narrow* command is not for novice, well, temporary/process-owned buffers
;; neither. 



;;; usage:
;; The related buffers are of 3 kinds: 
;; 1) tuples --- for editing the data, making QBE-queries
;; 2) searches --- represent rows-results of a query, select which one to edit
;; 3) tmp,  --- for communication with the server


;;; A general chart of work-flow:


;;; Entry points --- to be bound to keys
;; in form-buffer:
;; by now, associated with buttons, because they need the name of the form in future see ET-name
;; buffer-variable (but maybe it's better: in a buffer there may be more forms !!!) .
;;   MM-save		(after editing) return data to database, bind to  "c-x c-s" !!!
;;   MM-drop-trans      (not implemented) tell the server you no longer edit the tuple
;;   MM-search          QBE

;; in set-form:
;;   MM-select-tuple		select 1 from list (after an ambiguous/incomplete search)


(require 'MM-completer)			;The core of the TCP-channel
(require 'MM-descriptions)		;description of forms
(require 'MM-widgets)			;specialized widgets
(require 'MM-mouse)			;definition of menus
(require 'MM-search-buffer)		;OPs in the 
(require 'MM-tuple-buffer)		;
;(require 'MM-utils)		;
(require 'MM-person)			;'person' specific !!!



(defvar MM-searches-ring  nil "a list of all searches-buffers")
(defvar MM-tuples-list  () "a list of all tuples buffer-names, needed for MM-save-all, MM-kill-all")
;;(setq MM-tuples-list ())
;;(setq MM-searches-ring ())

;; These are communicated from the TCP-channel/fifo/socket
(defvar TCP-oid)			;id of the tuple
(defvar TCP-id)				;id of the search
(defvar TCP-options)			;a list of options (read-only,  )  NOT USED


;(defvar TCP-tuple)			;number of a tuple in a search
(defvar TCP-record)			;contains data of a tuple
(defvar TCP-bname)			;name of the buffer containing the tuple
(defvar TCP-list)			;list of results of a query/search
(defvar TCP-query)			;list of results of a query/search



;;; Buffer variables     

;; These contain info for a tuple buffer ET stays for edit-transaction:

(defvar ET-oid nil  "identification of a tuple")
(defvar ET-name nil "identification of a program") ;even in search buffer
(make-variable-buffer-local 'ET-oid)	;in domain
(make-variable-buffer-local 'ET-name)	;name of the domain



;; These contain info for a search buffer
(defvar ET-id  nil "identification of a search") ;assigned be the server/recycled !!
(defvar ET-preamble nil "lenght in lines of the preamble in the search buffer-to be substracted when..")
(defvar ET-ntuples nil "number of tuples in this search")
(defvar ET-bnames nil "an array of objects---buffers, contating tuples corresponding to the search") 
					;should be changed to buffers--they are buffer not names !!!

(make-variable-buffer-local 'ET-id)	;identification of edit_transaction
;;(make-variable-buffer-local 'ET-tuple)	;position in a search !!
(make-variable-buffer-local 'ET-preamble)
(make-variable-buffer-local 'ET-ntuples) ;in a search --- associated with search-buffer
(make-variable-buffer-local 'ET-bnames)	



;;; Code:

;;;  Fase 1 --- sending a query to the server; these functions are not called directly

(defun MM-send-condition (condition)
  "send a tripple/condition to the TCP-channel. Condition consists of (name_attribute  value relation)"
  (let  (
	 (cmd (format "( %S %S %S ) "   (car condition)  (nth 1 condition ) (nth 2 condition) ))
	 )
    (message cmd)
    (process-send-string TCP-completerP  cmd)
    )
  )


(defun MM-send-conditions (conditions)
  "send a list of tripples to the TCP-channel"
  (mapcar  'MM-send-condition  conditions)
  )



(defun MM-wait-end ()
  "wait for the # sign from the TCP-connection"
  (save-excursion
    ;;(message "1")
    (set-buffer (process-buffer TCP-completerP))
    ;;(message "2")
    (accept-process-output TCP-completerP )
    ;;(message (format "waiting: %c" (char-before (marker-position (process-mark TCP-completerP)))))
    (while (not (char-equal ?# (char-before (marker-position (process-mark TCP-completerP)))
			    ))
					;(message "still waiting")
      (accept-process-output TCP-completerP)
      )
    ;;(message "no more waiting")
    )
  )




(defun MM-wait-end-and-eval ()
  "wait and execute"
  (save-excursion
    (let (
	  (M (marker-position (process-mark TCP-completerP)))
	  )
      (set-buffer (process-buffer TCP-completerP))
      (MM-wait-end)
      (eval-region M (- (marker-position (process-mark TCP-completerP)) 1))
      )
    ))


(defun MM-edit  (name conditions)
  ""
  (interactive)
  (let  (
	 (cmd (format "search  %S (" name) )
	 (M (marker-position (process-mark TCP-completerP)))
	 )
    (process-send-string TCP-completerP cmd)
    (MM-send-conditions  conditions)
    (process-send-string TCP-completerP ")" )
    ;; Here I could do same preparations --- and give the server time to compute.
    
    (set-buffer (process-buffer TCP-completerP))
    (MM-wait-end)
    ;;(message "examining")
    (let (
	  (c (char-after M))
	  (N (+ M 1))			;(marker-position
	  )
      (message (format "pointers M=%d N=%d in %s  point-max=%d TCP: %d"  M N  (buffer-name)
		       (point-max) (marker-position (process-mark TCP-completerP))))
      ;;(message (format "cond %c"  (char-after M)))
      ;;(message (format "%c" (char-after M)))
      ;;(message "examining")
      ;;-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
      (cond (				;successful search: exactly 1 tuple.
	     (char-equal c ?1)		;Grab it, correct the values in the template form, start editing
	     ;;(message "exactly 1")
	     (eval-region N (- (marker-position (process-mark TCP-completerP)) 1))
	     ;;(message "presenting")
	     (MM-present-tuple name TCP-bname TCP-oid)
	     )

	    ;; multi-choice
	    (				;The search is not complete --- proceed manually
	     (char-equal c ?+)
	     ;;(message "multi")
	     
	     (eval-region N (- (marker-position (process-mark TCP-completerP)) 1))
	     (cond			;Decide whether ...
	      (
	       (< TCP-ntuples 1000)	;Display the list, let edit/decide the right one
	       (MM-present-list name TCP-id TCP-list TCP-ntuples)
	       )
	      (t
	       (MM-select-line)
	       )
	      )
	     )
	    (				; The search is empty !!!! do nothing. (just complain!)
	     (char-equal c ?0)
	     (message "no record !"))
	    (t
	     (message "error !")
	     )
	    )
      )
    )
  )




(defun atom-list (atom)
  ""
  (list atom)
  )


(defun MM-switch-tuple ()
  ""
  (interactive)
  (let* (
	 (L (mapcar 'atom-list MM-tuples-list))
	 (bname (completing-read "which tuple: " L))
	)
    (switch-to-buffer  bname)
    )
  )
;;;  Utilities

;; Is the tcp-process open/running ?
(defun MM-process-OK (process)
  (and
   (processp process)

   (let (
	 (status (process-status TCP-completerP) )
	 )
     (not 
      (or 
       (equal status nil)
       (equal status 'closed)
       )
      )
     )
   )
  )

;; I include this little proc, 
(defun set-face-colors (face fore back)
  "combines in 1 command all those related to colors of a face"
  (set-face-foreground face fore)
  (set-face-background face back)
  )
;;; MM-form.el ends here

;;; some simple commands to debug
;; START
;; (progn (completer-start))
;;(MM-edit  "person"   '(("cognome" "'Belyak'" "=")) )
;;(MM-edit  "person"   '(("numero" "12527" "=")) )



;;(MM-edit  "libri"   (list 
;;		      '("author" "'Conway, John'::text" "=")
;;					;'("category" "'Algebra'" "=")
;;		      ))

;;(MM-edit  "person"   (list 
;;		       ;'("numero" "3905" "=")
;;		      '("sex" "'s'" "=")
;;		      ))



