;;; MM-field.el --- a new class derived from edit-field

;; Copyright (C) 1998 by Free Software Foundation, Inc.

;; Author: Michal Maruka <mmc@linux4.maruska.tin.it>
;; Keywords: extensions, data, tools, oop

;; This file is part of GNU Emacs.

;; GNU Emacs is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to
;; the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Commentary:

;; 

;;; Code:

;;; Database-oriented field:
(define-widget 'MM-field 'editable-field
  "editable field with a customized completing --- to be used with TCP-completer."
  :complete 'MM-field-complete
  :action 'MM-field-action
  ;; :notify 'MM-field-notify
  :format "%{%t%}: %v"

  :history ()
  :domain ""
  )


(defun MM-field-complete (widget)
  "Complete the MM-field value in WIDGET."
  (let* ((prefix (buffer-substring-no-properties (widget-field-start widget)
						 (point)))
	 (domain (widget-get widget :domain))
	 (completion (try-completion prefix  'MM-complete  domain)))
    (cond ((eq completion t)
	   (message "Exact match."))
	  ((null completion)
	   (error "Can't find completion for \"%s\"" prefix))
	  ((not (string-equal prefix completion))
	   (insert-and-inherit (substring completion (length prefix))))
	  (t
	   (message "Making completion list...")
	   (let ((list (all-completions prefix 'MM-complete domain nil)))
	     (with-output-to-temp-buffer "*Completions*"
	       (display-completion-list list)))
	   (message "Making completion list...done")))))


(defun MM-field-action (widget &optional event)
  ;; Prompt for a the value.
  (let* ((tag (widget-apply widget :menu-tag-get)) ;mode-line is  name: Mar_
	 (prompt (concat tag ": "))
	 (value (widget-value widget))
	 (start (widget-field-start widget)) ;
	 (pos (cond ((< (point) start)	;    1   ++++3+++    2
		     0)
		    ((> (point) (+ start (length value)))
		     (length value))
		    (t
		     (- (point) start))))
	 (answer (if (commandp 'read-color)
		     (read-color prompt)
		   (completing-read prompt ;???   (concat tag ": ")
				    'MM-complete ;Trik !!!
				    (widget-get widget :domain)
				    nil
				    (cons value pos) ; germ
				    (widget-get widget :history) ;
				    ""	;default value
				    t	;INHERIT-INPUT-METHOD
				    ))))
    (unless (zerop (length answer))
      (widget-value-set widget answer)
      (widget-setup)
      (widget-apply widget :notify widget event))))


(provide 'MM-field)
;;; MM-field.el ends here

;;; Local Variables: ***
;;; coding:no-conversion ***
;;; enable-multibyte-characters: t ***
;;; input-method: "czech" ***
;;; local-abbrev-table-list: () ***
;;; End: ***
