(defun MM-print-item (string)
  ""
  (widget-create 'push-button :tag string :value string
		 :action 'MM-contatto-go)
  )




;;; A bit more about buttons

(define-widget 'contatti-button 'push-button
  ""
  :status nil
  ;;:data-from nil
  ;;:data-to nil
  :action (lambda (widget &rest ignore)
	    (let ((sex  (sex-uniform (MM-value-get "sex")))
		  (m (buffer-modified-p)))
	      (MM-insert-search 
	       widget
	       (format "contatti_%c" sex)
	       (if (equal sex ?m)
		   (format "(\"tipo\" \"%s\" \"=\") (\"uomo\" \"%s\" \"=\")"
			   (widget-get widget :value)
			   (MM-value-get "numero"))
		 (format "(\"tipo\" \"%s\" \"=\") (\"donna\" \"%s\" \"=\")"
			 (widget-get widget :value)
			 (MM-value-get "numero"))
		 
		 ))
	      (set-buffer-modified-p m)
	      ))
  )


;; 
(defun MM-insert-search (widget name conditions)
  (if (widget-get widget :status)
      (let ((inhibit-read-only t)) ;;clean
	(delete-region (widget-get widget :data-from) (1- (widget-get widget :data-to)))
	(widget-put widget :status nil)
	(widget-setup)
	)
    ;; else
    (progn
      (widget-put widget :status 't)
      (goto-char (widget-get widget :to))
      (forward-char)
      (widget-put widget :data-from (copy-marker (point)))
      (forward-char)
      (widget-put widget :data-to (copy-marker (point)))
      (backward-char)
      (message "1")
      (let 
	  (
	   (cmd (format "search_list \"%s\"  (%s)"   name conditions))
	   )
	(process-send-string TCP-completerP cmd)
	(MM-wait-end-and-eval)
	;;
	;; HERE
	(mapcar 'MM-print-item TCP-list)
	(widget-setup)
	)
      )
    )
  )



(defun MM-contatto-go (widget &rest ignore)
  (let* (
	(s  (sex-uniform (MM-value-get "sex")))
	(antisex (cond ((equal s ?m) ?f)
		       ((equal s ?f) ?m)))
	)
    ;;(message (format "'%c'" s))
    ;;(message (format "'%c'" antisex))
    ;;(message "contatto 2")
    (MM-edit "person" (list (list "numero" (widget-value widget)  "=") 
			    (list "sex" (format "'%c'" antisex) "=" ))  )
    )
  )

(provide 'MM-contatti)