;;; completer.el --- client-server oriented completer build around postgreSQL & Emacs

;; Author: Michal Maruka <mmaruska@tin.it>
;; Keywords: extensions, data, processes, unix

;; This file is part of postgreSQL-emacs-forms

;; postgreSQL-emacs-forms is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; postgreSQL-emacs-forms is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with postgreSQL-emacs-forms; see the file COPYING.  If not, write to
;; the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.


;; CUSTOMIZE YOUR SERVER/SERVICE !!!  (search-forward "linux")


;;; Commentary:
;; Note: This was developed independently of MM-form.el !!!  But routines here are indispensable for
;; latter.
;;
;; Usage:
;; ======
;; The idea is to use Emacs for editing records of a database --- now it's usefulrozpes of
;; docs. So to exploit fully the abrevs/completion features of Emacs I made these tools. 

;; There are several parts. Here is the Elisp side -- completion routines. It communicates with a
;; server through a TCP-chanel. The user/ tells the server he is going to write words/term from a
;; certain domain (set) --- I store it in  postgreSQL tables.

;; So there are basically  2 operations (--- apart from starting):

;; 1) defining a domain (eg. "define domain algebraists as select author from books where
;; category='Algebra') 

;; 2)  Query for the completion. (complete in algebraists 'Van der W')





;;; Technical details:
;; ==================
;; predicate - is used to hold information on the domain




;;; Code:

;; Variables (global)
(defvar TCP-completerP nil
  "Global process to interface a server for completion"
  )

(defvar	TCP-completeL nil
  "Global list to contain the possibilities delivered from the server"
  )

(put 'completer-start 'menu-enable '(not (MM-process-OK TCP-completerP)) )

;; Interface to the server   (built around postgreSQL, flex, bison, g++ & STL)

(defun completer-start (&optional server  service)
  "start TCP-process args: server  is a string-name of the server, service is a string-name of the port"
  (interactive )
  (if server () (setq server "linux1"))
  (if service () (setq service "MM"))
  (setq TCP-completerP (open-network-stream  "TCP-completer" "TCP-complete" server service))
  (set-buffer (process-buffer TCP-completerP))
  (set-marker (process-mark TCP-completerP) (point-max))
  (set-process-coding-system TCP-completerP 'no-conversion) 
  )

(defun completer-program (name query)
  "program the completer-server to create a new domain named name, to contain results of query"
  (interactive)
  (process-send-string TCP-completerP (format "create \"%s\" \"%s\""  name query))
  )


(defun completer-deprogram (name)
  "drop the named program (a domain, created with the completer-program command)"
  (interactive)
  (process-send-string TCP-completerP (format "drop  \"%s\""  name))
  )




;;; Customized completion (see Elisp Reference manual)

;; for debugging
(defun  LOG (string)
  "log a string to the buffer *Messages* without disturbing work in minibufer"
  (set-buffer "*Messages*")
  (insert string)
)
;(LOG "hello \n")


(defun MM-complete (prefix predicate mode)
  "Customized completer to co-operate via a TCP-connection process --- with a server\
   invoke completer"
  ;; NOT  (interactive)
  (save-excursion
    (if (equal mode 'nil)
	(let  (
	       (cmd (format "complete \"%s\" \"%s\" 0 " predicate prefix))
	       (M (marker-position (process-mark TCP-completerP)))
	       )
	  (LOG cmd)
	  (process-send-string TCP-completerP cmd)

	  (accept-process-output TCP-completerP 1 1)
	  (LOG (format "%d %d" M (marker-position (process-mark TCP-completerP))))
	  (set-buffer (process-buffer TCP-completerP))
	  (setq S (buffer-substring M (- (marker-position (process-mark TCP-completerP)) 0)))
	  (LOG S)
	  S
	  )
      ;; else
      (let  (
	     (cmd (format "complete \"%s\" \"%s\" 1 " predicate prefix))
	     (M (marker-position (process-mark TCP-completerP)))
	     )
	(process-send-string TCP-completerP cmd)
	(accept-process-output TCP-completerP 1 1)

	(set-buffer (process-buffer TCP-completerP))
	(eval-region M (marker-position (process-mark TCP-completerP)))
	TCP-completeL
	)
      )
    )
  )

(provide 'MM-completer)
;;; Example sequence 
;(completer-start)
;(completer-program "citta" "select nome from city")
;(completer-program "surname" "select iname from enum_surname")
; (completer-deprogram "citta")
; low-level playing
; (try-completion "Pra"  'MM-complete "citta")
; (all-completions "Pr"  'MM-complete "citta")

; a more direct one --- lowest level
; (MM-complete "Pr" "citta"  nil)


; example to be executed from widget form ?!!
; (setq citta-hist (list "Praha" "Brno" "Tbor"))
; (completing-read "What city: "  'MM-complete "citta" nil "Pr" '(citta-hist . 0))


;;; completer.el ends here
