#include "PGsql.h"

// geisler@primus.baynet.de
// Sat May 23 14:51:46 MEST 1998

#ifndef SQL_CPP
#define SQL_CPP

///////////////////////////////////////////
// constructor

sql::sql()
{
  conn=NULL;
  res=NULL;
};


///////////////////////////////////////////
// destructor

sql::~sql()
{
#ifdef DEBUG
cout << "destroy sql\n";
#endif
};

void sql::setData(char *PGhost, char *PGport, char *PGuser, char *PGpassword, char *PGdatabase, KResultBox *tmp_box)
{
  box=tmp_box;
  PGHOST=strdup(PGhost);
  PGPORT=strdup(PGport);
  PGUSER=strdup(PGuser);
  PGPASSWORD=strdup(PGpassword);
  PGOPTIONS=NULL;
  PGTTY=NULL;
  PGDATABASE=strdup(PGdatabase);
};


///////////////////////////////////////////
// connect to database

void sql::db_connect()
{

#ifdef DEBUG
printf("DEBUG: database connect<BR>\n");
#endif

  conn=PQsetdb(PGHOST,PGPORT,PGOPTIONS,PGTTY,PGDATABASE);             // connect to db  
};


///////////////////////////////////////////
// make normal execute

char *sql::db_execute()
{
  if(conn)
  {
#ifdef DEBUG
printf("DEBUG: making : %s<BR>\n",sql_statement);
#endif
    res=PQexec(conn,sql_statement);                               // send query to db
    switch(PQresultStatus(res))
    {
      case PGRES_EMPTY_QUERY :
      {
//        return(strdup("PGRES_EMPTY_QUERY"));
        return(strdup("Empty Query"));
        break;
      };
      case PGRES_COMMAND_OK :
      {
//        return(strdup("PGRES_COMMAND_OK"));
        return(strdup("Command ok"));
        break;
      };
      case PGRES_TUPLES_OK :
      {
//        return(strdup("PGRES_TUPLES_OK"));
        return(strdup("Tuples ok"));
        break;
      };
      case PGRES_COPY_OUT :  
      {
//        return(strdup("PGRES_COPY_OUT"));
        return(strdup("Postgres copy out"));
        break;
      };
      case PGRES_COPY_IN :
      {
//        return(strdup("PGRES_COPY_IN"));
        return(strdup("Postgres copy in"));
        break;
      };
      case PGRES_BAD_RESPONSE : 
      {
//        return(strdup("PGRES_BAD_RESPONSE"));
        return(strdup("Bad Response"));
        break;
      };
      case PGRES_NONFATAL_ERROR :
      {
//        return(strdup("PGRES_NONFATAL_ERROR"));
        return(strdup("Nonfatal Error"));
        break;
      };
      case PGRES_FATAL_ERROR :
      {
//        return(strdup("PGRES_FATAL_ERROR"));
        return(strdup("Fatal Error"));
        break;
      };
    };
    return(strdup("Ok"));
  };
  return(strdup("Fatal Error"));
};


///////////////////////////////////////////
// make transaction execute

int sql::db_execute_transaction()
{
  PGresult *db_open;
  PGresult *db_close;
  char tmp[1000];
  char *tmp_statement;

  if(conn)
  {
    db_open=PQexec(conn,"BEGIN");
    if (PQresultStatus(db_open) != PGRES_COMMAND_OK)          // exception
    {
      PQclear(db_open);                                       // clear result
      db_exit();                                              // exit db session
      return(0);
    };
  
    PQclear(db_open);                                         // clear result
    sprintf(tmp,"DECLARE myportal CURSOR FOR %s",sql_statement);  // make tmp string
    tmp_statement=strdup(tmp);                            // make real query
    res=PQexec(conn,tmp_statement);                       // fetch from db
  
    if (PQresultStatus(res) != PGRES_COMMAND_OK)          // exception
    {
      PQclear(res);                                       // clear result
      db_exit();                                          // exit db session
      return(0);
    };
  
    PQclear(res);                                         // clear result
  
#ifdef DEBUG
printf("DEBUG: making select: %s<BR>\n",tmp_statement);
#endif

    res=PQexec(conn,"FETCH ALL in myportal");             // open portal

    if (PQresultStatus(res) != PGRES_TUPLES_OK)           // exception
    {
      PQclear(res);                                       // clear result
      return(0);
    };                 

    nFields = PQnfields(res);                             // get # of fields
    if(!nFields)
    {
      PQclear(res);                                       // clear result
      return(0);
    };

#ifdef DEBUG
printf("DEBUG: number of tuples: %i<BR>\n",PQntuples(res));
#endif

    if(PQntuples(res)==0)
    {
      PQclear(res);                                       
      return(0);
    };  

    db_close=PQexec(conn,"CLOSE myportal");               // close portal
    PQclear(db_close);                                    // clear result
    db_close=PQexec(conn,"END");                          // end transaction
    PQclear(db_close);                                    // clear result         
    return(1);
  };
  return(0);
};


///////////////////////////////////////////
// disconnect database

int sql::db_exit()
{

#ifdef DEBUG
printf("DEBUG: database exit<BR>\n");
#endif 

  PQfinish(conn);                                  // disconnect database 
  return(0);
};


///////////////////////////////////////////
// reload sql-statement

void sql::reload(char *statement)
{
#ifdef DEBUG
printf("DEBUG: statement: %s<BR>\n",statement);
#endif
  sql_statement=strdup(statement);
};


///////////////////////////////////////////
// clear result

void sql::db_clear()
{
  PQclear(res);
};

///////////////////////////////////////////
// print result

void sql::db_printresult()
{
  int i,j;
  int newsize;

  if(res)
  {
    nFields= PQnfields(res);
#ifdef DEBUG
cout << "Tuples: " << PQntuples(res) << " nFields: " << nFields << "\n";
#endif 

    box->init(PQntuples(res)+1,nFields);
    for (i=0; i < nFields; i++)
    {
      box->insertItem(PQfname(res,i),0,i);
      newsize=(strlen(PQfname(res,i))*9);
      if(newsize>box->getSize(i)) 
      {
        box->setSize(newsize,i);
      };
    };

    for (i=0; i < PQntuples(res); i++)                    // for all tuples
    {
      for (j=0  ; j < nFields; j++)                       // for all items
      {                                                                     
        box->insertItem(PQgetvalue(res,i,j),i+1,j);
        newsize=(strlen(PQgetvalue(res,i,j))*9);
        if(newsize>box->getSize(j)) 
        {
          box->setSize(newsize,j);
        };
      };
#ifdef DEBUG
cout << "\n";
#endif
    }
  }
  else
  {
    box->init(1,1);
    box->insertItem("No Results",0,0);
    box->setSize(strlen("No Results")*9,0);
  };
};

#endif
