#include "KResultBox.h"

// geisler@primus.baynet.de
// Sat May 23 14:51:46 MEST 1998

#ifndef _KRESULTBOX_CPP
#define _KRESULTBOX_CPP                          

KResultBox::KResultBox(QWidget *parent, const char *name):QTableView(parent,name)
{
  setCellHeight( 20 );

  setFrameStyle( WinPanel | Sunken );
  setBackgroundColor( colorGroup().base() );

  setAutoUpdate( TRUE );
  setFocusPolicy( StrongFocus );
  setTableFlags( Tbl_autoScrollBars |
                 Tbl_clipCellPainting |
                 Tbl_smoothScrolling);
};

KResultBox::~KResultBox()
{
  delete[] Krows;
  delete[] size;
#ifdef DEBUG
cout << "destroy KResultBox\n";
#endif
};

void KResultBox::init(int rows, int cols)
{
  int i=0;
  num_rows=rows;
  num_cols=cols;
  Krows = new KResultRow[rows](cols);
  size = new int[cols];
  for(i=0; i!=cols; i++)
  {
    size[i]=0;
  }; 
#ifdef DEBUG
cout << "init: " << num_rows << "," << num_cols << "\n";
#endif
};

int KResultBox::cellWidth(int col)
{
  return(size[col]);
};

void KResultBox::insertItem(char *tmp,int row,int colum)
{
#ifdef DEBUG
cout << "insertItem: " << tmp << "," << row << "," << colum << "\n";
#endif
  Krows[row].insertItem(colum,tmp);
};

void KResultBox::paintCell(class QPainter *p, int row, int col)
{
  int w = cellWidth(col);
  int h = cellHeight(row);
  int x2=w-1;
  int y2=h-1;
  if(!row)
  {
    p->setPen(SolidLine);
  }
  else 
  {
    p->setPen(DotLine);
  };
  p->drawLine(x2,0,x2,y2);
  p->drawLine(0,y2,x2,y2);
  p->setPen(SolidLine);
  p->drawText(5,15,Krows[row].getItem(col));
};

void KResultBox::showCells()
{
  setNumCols(num_cols);
  setNumRows(num_rows);
  repaint();
};

void KResultBox::mousePressEvent(QMouseEvent *e)
{
  int old_row=cur_row;
  int old_col=cur_col;
  if((num_cols) && (num_rows))
  {
    QPoint clickedPos=e->pos();
    cur_row=findRow(clickedPos.y());
    cur_col=findCol(clickedPos.y());
    if(cur_row<0) cur_row=0;
    if(cur_col<0) cur_col=0;

#ifdef DEBUG
cout << "cur_row: " << cur_row << ", cur_col: " << cur_col << "\n";
cout << "click-Result: " << Krows[cur_row].getItem(cur_col) << "\n";
#endif
 
  
    if ((cur_row!=old_row) || (cur_col!=old_col))
    {  
      updateCell(old_row, old_col);
      updateCell(cur_row, cur_col);
    }
    emit selected(cur_row); 
  };
};

char *KResultBox::getItem(int row, int col)
{
  if((row<=num_rows) && (col<=num_cols))
  {
    return(strdup(Krows[row].getItem(col)));
  };
  return(NULL);
};

int KResultBox::getSize(int col)
{
  return(size[col]);
};

void KResultBox::setSize(int tmp_size, int col)
{
#ifdef DEBUG
cout << "setSize size[" << col << "] = " << tmp_size << "\n";
#endif
  size[col]=tmp_size+5;
};

int KResultBox::numCols()
{
  return(num_cols);
};

int KResultBox::numRows()
{
  return(num_rows);
};

#include "KResultBox.moc"

#endif
