/* Call Solution processor/Database front end libpq */
/* will be used. This program will take HTML input  */
/* and windows input (X/9x) and added it to the     */
/* prob_entry database the users database is        */ 
/* read-only and only grabs the user info...        */
/* loc/ext/dept etc. we might even want to do a bit */
/* of inline documentation... this is a big program */
/* estimate 5000 lines of new code. Good Luck       */

/* this is the headers for all web programs (default includes)*/
#include "web.h"

/* some basic handlers */
void exit_nicely(PGconn *conn);

/* basic table structs... for reading/writing the database */
struct prob_entry {
       int prob_num;
       char prob_desc[2048];
       char prob_type[128];
       char username[128];
       char useremail[128];
       char telephone[15];
       char timeentered[17];
       char closed[1];
       char prob_user[128];
       char prob_short_desc[128];
       char timeclosed[17];
} problem;

struct users {
       char ssn[11];
       char lname[50];
       char fname[50];
       char mi[2];
       char extension[10], location[128];
       char email[128], hardware[128],notes[255];
       char username[128];
       char login[64], pwd[64];
} user;

struct prob_solutions {
       int prob_num;
       char prob_sol[2048];
       char timeentered[17];
       char solvedby[128];
} solution;
struct techs {
      char techid[15];
      char techname[128];
      char techarea[128];
} tech;
/* Startup and run-baby!        */
int main(int argc, char *argv[]) {

/* counters and field options */
    int nv_entry_number = 0, i, j, nFields;
    char nField[64];

/* Database connection options and other values */
    char *pghost, *pgport, *pgoptions, *pgtty, *dbName, *login, *pwd;
/* full table record buffer<jifc> */    
    char query[256], tmp_buffer1[FIELD_LEN + 1], tmp_buffer2[FIELD_LEN + 1];

    struct tm *tm_ptr;
    time_t timeval;    

    PGconn *conn;
    PGresult *res;    
    
/* set options for database connection */
   pghost = "192.168.1.1";
   pgport = NULL;
   pgoptions = NULL;
   pgtty = NULL;
   dbName = "helldesk";  
   login = NULL;
   pwd = NULL;

/* this is a check to see if the web page has data returning to the program */
    if (!get_input()) {
      exit(EXIT_FAILURE);
    }

/* setup time functions for timestamping the problem entries */
    (void) time(&timeval);
    tm_ptr = localtime(&timeval);

/* Open a file elsewhere to make sure we keep a second copy */
    sprintf(solution.timeentered,"%02d%02d%04d %02d:%02d:%02d",
            tm_ptr->tm_mon+1, tm_ptr->tm_mday, tm_ptr -> tm_year,
            tm_ptr->tm_hour, tm_ptr->tm_min,tm_ptr->tm_sec);

    i = 0;
/* read and decode the data. Also, insert it into the struct varibles */
/* note that the field names could be used instead of the nested if   */
/* that does not mean it is better to do so. might cut the time down  */
    while (name_val_pairs[nv_entry_number].name[0] != '\0') {
         sprintf(tmp_buffer1,"%s",name_val_pairs[nv_entry_number].name);
         sprintf(tmp_buffer2,"%s",name_val_pairs[nv_entry_number].value);
         if (i == 0) {
           sprintf(nField,name_val_pairs[nv_entry_number].value);
         } else {
         }
         nv_entry_number++;
         i++;
    }

    login = "nobody";
    pwd = "";
    
/* database connection and check if true */
   conn = PQsetdbLogin(pghost, pgport, pgoptions, pgtty, dbName, login, pwd);
      if (PQstatus(conn) == CONNECTION_BAD) {
        printf("Content type: text/html\r\n\r\n");
        printf("Connection to database %s failed. \n", dbName);
        printf("%s", PQerrorMessage(conn));
        printf("Connection not made: please report this error to Sys Admin\r\n");
        exit_nicely(conn);
      }

/* Begin the transaction and make SURE that the database is open */
    res = PQexec(conn,"BEGIN");
    if (PQresultStatus(res) != PGRES_COMMAND_OK) {
      printf("Content type: text/html\r\n\r\n");
      printf("BEGIN 0 FAILED!");
      printf("%s", PQerrorMessage(conn));
      printf("Notify the System Administrator");
      exit_nicely(conn);
    }
    PQclear(res);
    sprintf(query,"DECLARE mycursor CURSOR FOR SELECT * FROM prob_entry WHERE prob_num = '%s'", nField);
    res = PQexec(conn, query);
    if (PQresultStatus(res) != PGRES_COMMAND_OK) {
      printf("Content type: text/html\r\n\r\n");
      printf("BEGIN FAILED!");
      printf("%s", PQerrorMessage(conn));
      printf("Notify the System Administrator");
      exit_nicely(conn);
    }
    PQclear(res);

/* This grabs username and builds the fisrt form and writes it to the */
/* stdout (redirected to the HTML PAGE)                               */
    res = PQexec(conn, "FETCH ALL in mycursor");
    if (PQresultStatus(res) != PGRES_TUPLES_OK) {
      printf("Content-type: text/html\r\n\r\n");
      printf("BEGIN 0 FAILED!");
      printf("%s", PQerrorMessage(conn));
      printf("Notify the System Administrator");
      exit_nicely(conn);
    }
    nFields = PQnfields(res);

    html_content();
    html_start("View Closed Calls","/image5.gif");
    html_body("<P><CENTER><FONT SIZE = +2>Current Call</CENTER><B><P>");
    html_body("<BR>");
    for (i = 0; i < PQntuples(res); i++) {
       for (j = 0; j < nFields; j++){
          if (j == 0) {
            sprintf(nField,PQgetvalue(res,i,j));
          } else if (j == 1) {
            sprintf(problem.prob_desc,PQgetvalue(res,i,j));
          } else if (j == 2) {
            sprintf(problem.prob_type,PQgetvalue(res,i,j));
          } else if (j == 3) {
            sprintf(problem.username,PQgetvalue(res,i,j));
          } else if (j == 4) {
            sprintf(problem.useremail,PQgetvalue(res,i,j));
          } else if (j == 5) {
            sprintf(problem.telephone,PQgetvalue(res,i,j));
          } else if (j == 6) {
            sprintf(problem.timeentered,PQgetvalue(res,i,j));
          } else if (j == 7) {
            sprintf(problem.closed,PQgetvalue(res,i,j));
          } else if (j == 8) {
            sprintf(problem.prob_user,PQgetvalue(res,i,j));
          } else if (j == 9) {
            sprintf(problem.prob_short_desc,PQgetvalue(res,i,j));
          } else if (j == 10) {
            sprintf(problem.timeclosed,PQgetvalue(res,i,j));
          } else {
          }
       }
    }
    printf("<BR>Call Number: %s  User: %s<BR>", nField, problem.username);
    printf("Problem Type: %s<BR><HR>", problem.prob_type);
    printf("Short Description:<br><Center>%s</center><hr>",problem.prob_short_desc);
    printf("Description:<BR><CENTER>%s</CENTER><HR>",problem.prob_desc);
    printf("<BR>User's E-Mail Address: %s<BR>",problem.useremail);
    printf("User's Telephone Extension: %s<BR>",problem.telephone);
    printf("Date and Time this call was logged: %s",problem.timeentered);
    printf("<BR>Call Closed? : %s", problem.closed);
    printf("<BR>Time Closed: %s",problem.timeclosed);
    printf("<BR><HR><BR>");
    printf("Solution Information Follows: <BR><BR>");

    PQclear(res);
    res = PQexec(conn, "CLOSE mycursor");
    PQclear(res);

/* This sets up the insert statement that is written next */
    res = PQexec(conn, "END");
    if (PQresultStatus(res) != PGRES_COMMAND_OK) {
      printf("Content-type: text/html\r\n\r\n");
      printf("END 0 FAILED!");
      printf("%s", PQerrorMessage(conn));
      printf("Notify the System Administrator");
      exit_nicely(conn);
    }
    PQclear(res);

    res = PQexec(conn,"BEGIN");
    if (PQresultStatus(res) != PGRES_COMMAND_OK) {
      printf("Content type: text/html\r\n\r\n");
      printf("BEGIN 1 FAILED!");
      printf("%s", PQerrorMessage(conn));
      printf("Notify the System Administrator");
      exit_nicely(conn);
    }
    PQclear(res);
    sprintf(query,"DECLARE mycursor CURSOR FOR SELECT * FROM prob_solutions WHERE prob_num = '%s'", nField);
    res = PQexec(conn, query);
    if (PQresultStatus(res) != PGRES_COMMAND_OK) {
      printf("Content type: text/html\r\n\r\n");
      printf("BEGIN FAILED!");
      printf("%s", PQerrorMessage(conn));
      printf("Notify the System Administrator");
      exit_nicely(conn);
    }
    PQclear(res);
    res = PQexec(conn, "FETCH ALL in mycursor");
    if (PQresultStatus(res) != PGRES_TUPLES_OK) {
      printf("Content-type: text/html\r\n\r\n");
      printf("BEGIN 0 FAILED!");
      printf("%s", PQerrorMessage(conn));
      printf("Notify the System Administrator");
      exit_nicely(conn);
    }
    nFields = PQnfields(res);
    for (i = 0; i < PQntuples(res); i++) {
       for (j = 0; j < nFields; j++){
          if (j == 0) {
            sprintf(nField,PQgetvalue(res,i,j));
          } else if (j == 1) {
            sprintf(solution.prob_sol,PQgetvalue(res,i,j));
          } else if (j == 2) {
            sprintf(solution.timeentered,PQgetvalue(res,i,j));
          } else if (j == 3) {
            sprintf(solution.solvedby,PQgetvalue(res,i,j));
          } else {
          }
       }
       printf("<BR>Reference: %s<BR>", nField);
       printf("%s <BR>", solution.prob_sol);
       printf("<BR> This call solved at: %s <BR>", solution.timeentered);
       printf("<BR> This call Solved By: %s <BR><HR>", solution.solvedby);
    }
    printf("</CENTER><BR>");
    PQclear(res);
    res = PQexec(conn, "CLOSE mycursor");
    PQclear(res);

/* This sets up the insert statement that is written next */
    res = PQexec(conn, "END");
    if (PQresultStatus(res) != PGRES_COMMAND_OK) {
      printf("Content-type: text/html\r\n\r\n");
      printf("END 0 FAILED!");
      printf("%s", PQerrorMessage(conn));
      printf("Notify the System Administrator");
      exit_nicely(conn);
    }
    PQclear(res);

    PQfinish(conn);

    html_body("<BR><BR>");
    html_body("<BR><BR><BR><center><FONT SIZE = +1><a href=\"/cgi-bin/query\">");
    html_body("Call Log</a> | ");
    html_body("<a href=\"/cgi-bin/query1\">Call Solutions</a> | ");
    html_body("<a href=\"/cgi-bin/rquery\">Report Query</a>");
    html_body("</FONT></center>");
    html_end();
    exit(EXIT_SUCCESS);
}

void exit_nicely(PGconn *conn){   
    
   PQfinish(conn);
   exit(1);
}
