/* Query processor/Database front end libpq         */
/* will be used. This program will take HTML input  */
/* and windows input (X/9x) and retrieve the prob_entry */
/* and the user's information from the tables in helldesk*/
/* loc/ext/dept etc. we might even want to do a bit */
/* of inline documentation... this is a big program */
/* estimate 5000 lines of new code. Good Luck       */

/* this is the headers for all web programs (default includes)*/
#include "web.h"

/* some basic handlers */
void exit_nicely(PGconn *conn);

/* basic table structs... for reading/writing the database */
struct prob_entry {
       int prob_num;
       char prob_desc[2048];
       char prob_type[128];
       char username[128];
       char useremail[128];
       char telephone[15];
       char timeentered[17];
       char closed[1];
       char user[128];
       char prob_short_desc[128];
       char timeclosed[17];
} problem;

struct users {
       char ssn[11];
       char lname[50];
       char fname[50];
       char mi[2];
       char extension[10], location[128];
       char email[128], hardware[128],notes[255];
       char username[128];
       char login[64], pwd[64];
} user;

/* Startup and run-baby!        */
int main(int argc, char *argv[]) {

/* counters and field options */
    int  i, j, nFields;
/*  int ntuples, nv_entry_number = 0,  */
    char nField[64];

/* Database connection options and other values */
    char *pghost, *pgport, *pgoptions, *pgtty, *dbName, *login, *pwd;
/* full table record buffer<jifc> */    
/*  char query[256] tmp_buffer1[FIELD_LEN + 1], tmp_buffer2[FIELD_LEN + 1]; */

    struct tm *tm_ptr;
    time_t timeval;    

    PGconn *conn;
    PGresult *res;    
    
/* set options for database connection */
   pghost = "192.168.1.1";
   pgport = NULL;
   pgoptions = NULL;
   pgtty = NULL;
   dbName = "helldesk";
   login = "nobody";
   pwd = "";


/* setup time functions for timestamping the problem entries */
    (void) time(&timeval);
    tm_ptr = localtime(&timeval);

    sprintf(problem.timeentered,"%02d%02d%04d %02d:%02d:%02d",
            tm_ptr->tm_mon+1, tm_ptr->tm_mday, tm_ptr -> tm_year,
            tm_ptr->tm_hour, tm_ptr->tm_min,tm_ptr->tm_sec);

    i = 0;
    
/* database connection and check if true */
   conn = PQsetdbLogin(pghost, pgport, pgoptions, pgtty, dbName, login, pwd);
      if (PQstatus(conn) == CONNECTION_BAD) {
        printf("Content type: text/html\r\n\r\n");
        printf("Connection to database %s failed. \n", dbName);
        printf("%s", PQerrorMessage(conn));
        printf("Connection not made: please report this error to Sys Admin\r\n");
        exit_nicely(conn);
      }

/* Begin the transaction and make SURE that the database is open */
    res = PQexec(conn,"BEGIN");
    if (PQresultStatus(res) != PGRES_COMMAND_OK) {
      printf("Content type: text/html\r\n\r\n");
      printf("BEGIN 0 FAILED!");
      printf("%s", PQerrorMessage(conn));
      printf("Notify the System Administrator");
      exit_nicely(conn);
    }
    PQclear(res);

    res = PQexec(conn, "DECLARE mycursor CURSOR FOR SELECT * FROM prob_entry WHERE closed = 'Y' ORDER BY prob_num ASC");
    if (PQresultStatus(res) != PGRES_COMMAND_OK) {
      printf("Content type: text/html\r\n\r\n");
      printf("BEGIN FAILED!");
      printf("%s", PQerrorMessage(conn));
      printf("Notify the System Administrator");
      exit_nicely(conn);
    }
    PQclear(res);

/* This grabs username and builds the fisrt form and writes it to the */
/* stdout (redirected to the HTML PAGE)                               */
    res = PQexec(conn, "FETCH ALL in mycursor");
    if (PQresultStatus(res) != PGRES_TUPLES_OK) {
      printf("Content-type: text/html\r\n\r\n");
      printf("BEGIN 0 FAILED!");
      printf("%s", PQerrorMessage(conn));
      printf("Notify the System Administrator");
      exit_nicely(conn);
    }
    nFields = PQnfields(res);

    html_content();
    printf("<HTML>\r\n");
    printf("<HEAD>\r\n");
    printf("<TITLE>Call Selection- View Closed Calls</TITLE>\r\n");
    printf("<META HTTP-EQIV=\"refresh\" content=\"300,url=/cgi-bin/rquery\">");
    printf("</HEAD>\r\n");
    printf("<BODY LINK=\"#0000FF\" BACKGROUND=\"/image5.gif\">\r\n");
    html_body("<form action=\"/cgi-bin/rquery1\" METHOD=POST>");
    html_body("<P><CENTER><FONT SIZE = +2><B>Please select the problem entry from the list");
    html_body("then click the <BR> Submit Query Button. If the entry");
    html_body("does not appear on this listing it has <BR> not been closed");
    html_body("</FONT></B></CENTER><BR><BR>");
    html_body("<center><select NAME=\"prob_num\" size=15>");
    for (i = 0; i < PQntuples(res); i++) {
       for (j = 0; j < nFields; j++){
          if (j == 0) {
             sprintf(nField,PQgetvalue(res,i,j));
             problem.prob_num = (int *)PQgetvalue(res,i,j);
          } else if (j == 1) {
             sprintf(nField,PQgetvalue(res,i,j));
             sprintf(problem.prob_desc,PQgetvalue(res,i,j));
          } else if (j == 2) {
             sprintf(nField,PQgetvalue(res,i,j));
             sprintf(problem.prob_type,PQgetvalue(res,i,j));
          } else if (j == 3) {
             sprintf(nField,PQgetvalue(res,i,j));
             sprintf(problem.username,PQgetvalue(res,i,j));
          } else if (j == 4) {
             sprintf(nField,PQgetvalue(res,i,j));
             sprintf(problem.useremail,PQgetvalue(res,i,j));             
          } else if (j == 5) {
             sprintf(nField,PQgetvalue(res,i,j));
             sprintf(problem.telephone,PQgetvalue(res,i,j));             
          } else if (j == 6) {
             sprintf(nField,PQgetvalue(res,i,j));
             sprintf(problem.timeentered,PQgetvalue(res,i,j));             
          } else if (j == 7) {
             sprintf(nField,PQgetvalue(res,i,j));
             sprintf(problem.closed,PQgetvalue(res,i,j));             
          } else if (j == 8) {
             sprintf(nField,PQgetvalue(res,i,j));
             sprintf(problem.user,PQgetvalue(res,i,j));             
          } else if (j == 9) {
             sprintf(nField,PQgetvalue(res,i,j));
             sprintf(problem.prob_short_desc,PQgetvalue(res,i,j));             
          } else if (j == 10) {
             sprintf(nField,PQgetvalue(res,i,j));
             sprintf(problem.timeclosed,PQgetvalue(res,i,j));             
          } else {
          }  
       }
         printf("<option VALUE=\"%s\">%s, %s, %s, %s, %s",
                problem.prob_num, problem.prob_num, problem.prob_type,
                problem.username, problem.prob_short_desc,
                problem.timeclosed);
    }
    printf("</SELECT></CENTER<BR>");
    PQclear(res);
    res = PQexec(conn, "CLOSE mycursor");
    PQclear(res);

/* This sets up the insert statement that is written next */
    res = PQexec(conn, "END");
    if (PQresultStatus(res) != PGRES_COMMAND_OK) {
      printf("Content-type: text/html\r\n\r\n");
      printf("END 0 FAILED!");
      printf("%s", PQerrorMessage(conn));
      printf("Notify the System Administrator");
      exit_nicely(conn);
    }
    PQclear(res);

    PQfinish(conn);

    html_body("<center>");
    html_body("<input TYPE=\"SUBMIT\">");
    html_body("<input type=\"RESET\"></center>");
    html_body("<BR><BR><BR><center><FONT SIZE = +1>");
    html_body("<a href=\"/cgi-bin/query\">Call Log Center </a> | ");
    html_body("<a href=\"/cgi_bin/query1\">Call Solutions</a>");
    html_body("</FONT></center>");
    html_end();
    exit(EXIT_SUCCESS);
}


void exit_nicely(PGconn *conn){   
    
   PQfinish(conn);
   exit(1);
}
