/* Call log processor/Database front end libpq      */
/* will be used. This program will take HTML input  */
/* and windows input (X/9x) and added it to the     */
/* prob_entry database the users database is        */ 
/* read-only and only grabs the user info...        */
/* loc/ext/dept etc. we might even want to do a bit */
/* of inline documentation... this is a big program */
/* estimate 5000 lines of new code. Good Luck       */

/* this is the headers for all web programs (default includes)*/
#include "web.h"

/* some basic handlers */
void exit_nicely(PGconn *conn);

/* basic table structs... for reading/writing the database */
struct prob_entry {
       int prob_num;
       char prob_desc[2048];
       char prob_type[128];
       char username[128];
       char useremail[128];
       char telephone[15];
       char timeentered[17];
} problem;

struct users {
       char ssn[11];
       char lname[50];
       char fname[50];
       char mi[2];
       char extension[10], location[128];
       char email[128], hardware[128],notes[255];
       char username[128];
       char login[64], pwd[64];
} user;

/* Startup and run-baby!        */
int main(int argc, char *argv[]) {

/* counters and field options */
    int i, j, nFields;
    char nField[64];

/* Database connection options and other values */
    char *pghost, *pgport, *pgoptions, *pgtty, *dbName, *login, *pwd;
/* full table record buffer<jifc> */    

    struct tm *tm_ptr;
    time_t timeval;    

    PGconn *conn;
    PGresult *res;    
    
/* set options for database connection */
   pghost = "192.168.1.1";
   pgport = NULL;
   pgoptions = NULL;
   pgtty = NULL;
   dbName = "helldesk";  
   login = "nobody";
   pwd = "";


/* setup time functions for timestamping the problem entries */
    (void) time(&timeval);
    tm_ptr = localtime(&timeval);

    sprintf(problem.timeentered,"%02d%02d%04d %02d:%02d:%02d",
            tm_ptr->tm_mon+1, tm_ptr->tm_mday, tm_ptr -> tm_year,
            tm_ptr->tm_hour, tm_ptr->tm_min,tm_ptr->tm_sec);

    i = 0;
    
/* database connection and check if true */
   conn = PQsetdbLogin(pghost, pgport, pgoptions, pgtty, dbName, login, pwd);
      if (PQstatus(conn) == CONNECTION_BAD) {
        printf("Content type: text/html\r\n\r\n");
        printf("Connection to database %s failed. \n", dbName);
        printf("%s", PQerrorMessage(conn));
        printf("Connection not made: please report this error to Sys Admin\r\n");
        exit_nicely(conn);
      }

/* Begin the transaction and make SURE that the database is open */
    res = PQexec(conn,"BEGIN");
    if (PQresultStatus(res) != PGRES_COMMAND_OK) {
      printf("Content type: text/html\r\n\r\n");
      printf("BEGIN 0 FAILED!");
      printf("%s", PQerrorMessage(conn));
      printf("Notify the System Administrator");
      exit_nicely(conn);
    }
    PQclear(res);

    res = PQexec(conn, "DECLARE mycursor CURSOR FOR SELECT username FROM users ORDER BY username ASC");
    if (PQresultStatus(res) != PGRES_COMMAND_OK) {
      printf("Content type: text/html\r\n\r\n");
      printf("BEGIN FAILED!");
      printf("%s", PQerrorMessage(conn));
      printf("Notify the System Administrator");
      exit_nicely(conn);
    }
    PQclear(res);

/* This grabs username and builds the fisrt form and writes it to the */
/* stdout (redirected to the HTML PAGE)                               */
    res = PQexec(conn, "FETCH ALL in mycursor");
    if (PQresultStatus(res) != PGRES_TUPLES_OK) {
      printf("Content-type: text/html\r\n\r\n");
      printf("BEGIN 0 FAILED!");
      printf("%s", PQerrorMessage(conn));
      printf("Notify the System Administrator");
      exit_nicely(conn);
    }
    nFields = PQnfields(res);

    html_content();
    html_start("Query Selection","/image5.gif");
    html_body("<form action=\"/cgi-bin/callentry\" METHOD=POST>");
    html_body("<P><CENTER><FONT SIZE = +2><B>Please select your username from the list");
    html_body("then click the <BR> Submit Query Button. If your name");
    html_body("does not appear on this listing please <BR> contact the Sys. Admin");
    html_body("</FONT></B></CENTER><BR><BR>");
    html_body("<center><select NAME=\"username\">");
    for (i = 0; i < PQntuples(res); i++) {
       for (j = 0; j < nFields; j++){
          sprintf(nField,PQgetvalue(res,i,j));
          printf("<option VALUE=\"%s\">%s", nField, nField);
       }
    }
    printf("</SELECT></CENTER<BR>");
    PQclear(res);
    res = PQexec(conn, "CLOSE mycursor");
    PQclear(res);

/* This sets up the insert statement that is written next */
    res = PQexec(conn, "END");
    if (PQresultStatus(res) != PGRES_COMMAND_OK) {
      printf("Content-type: text/html\r\n\r\n");
      printf("END 0 FAILED!");
      printf("%s", PQerrorMessage(conn));
      printf("Notify the System Administrator");
      exit_nicely(conn);
    }
    PQclear(res);

    PQfinish(conn);

    html_body("<center>");
    html_body("<input TYPE=\"SUBMIT\">");
    html_body("<input type=\"RESET\"></center>");
    html_body("<BR><BR><BR><center><FONT SIZE = +1><a href=\"/cgi-bin/query\">");
    html_body("Call Log | </a>");
    html_body("<a href=\"/callsol.html\">Call Solutions</a>");
    html_body("</FONT></center>");
    html_end();
    exit(EXIT_SUCCESS);
}


void exit_nicely(PGconn *conn){   
    
   PQfinish(conn);
   exit(1);
}
