/* Call log processor/Database front end libpq      */
/* will be used. This program will take HTML input  */
/* and windows input (X/9x) and added it to the     */
/* prob_entry database the users database is        */ 
/* read-only and only grabs the user info...        */
/* loc/ext/dept etc. we might even want to do a bit */
/* of inline documentation... this is a big program */
/* estimate 5000 lines of new code. Good Luck       */

/* this is the headers for all web programs (default includes)*/
#include "web.h"

/* some basic handlers */
void exit_nicely(PGconn *conn);

/* basic table structs... for reading/writing the database */
struct prob_entry {
       int prob_num;
       char prob_desc[2048];
       char prob_type[128];
       char username[128];
       char useremail[128];
       char telephone[15];
       char timeentered[17];
       char closed[1];
       char prob_user[128];
       char prob_short_desc[128];
       char timeclosed[17];
       char userid[11];
} problem;

struct users {
       char ssn[11];
       char lname[50];
       char fname[50];
       char mi[2];
       char extension[10], location[128];
       char email[128], hardware[128],notes[255];
       char username[128];
       char timeentered[17];
} user;

/* Startup and run-baby!        */
int main(int argc, char *argv[]) {

/* counters and field options */
    int nv_entry_number = 0, i, ntuples;
    int chars_processed = 0;
    char *src_char_ptr;
    char *dest_char_ptr;
    char tmp_buffer[(FIELD_LEN * 2) + 2];
    
/* Database connection options and other values */
    char *pghost, *pgport, *pgoptions, *pgtty, *dbName, *login, *pwd;

/* full table record buffer<jifc> */    
    char query[256], tmp_buffer1[FIELD_LEN + 1], tmp_buffer2[FIELD_LEN + 1];
    char buffer[FIELD_LEN +1], buffer1[FIELD_LEN +1];
    
    struct tm *tm_ptr;
    time_t timeval;    

    PGconn *conn;
    PGresult *res;    
    FILE *write_fp;

    memset(buffer, '\0', strlen(buffer));
    memset(buffer1, '\0', strlen(buffer1));
    
/* set options for database connection */
/* set this to the ip address of the database server or leave it as localhost */
   pghost = "localhost";
   pgport = NULL;
   pgoptions = NULL;
   pgtty = NULL;
   dbName = "helldesk";  
   login = "nobody";
   pwd = "";
/* this is a check to see if the web page has data returning to the program */
    if (!get_input()) {
      exit(EXIT_FAILURE);
    }

/* setup time functions for timestamping the problem entries */
    (void) time(&timeval);
    tm_ptr = localtime(&timeval);

    sprintf(problem.timeentered,"%02d%02d%02d %02d:%02d:%02d",
            tm_ptr->tm_mon+1, tm_ptr->tm_mday, tm_ptr -> tm_year,
            tm_ptr->tm_hour, tm_ptr->tm_min,tm_ptr->tm_sec);

    i = 0;
    
/* read and decode the data. Also, insert it into the struct varibles */
/* note that the field names could be used instead of the nested if   */
/* that does not mean it is better to do so. might cut the time down  */
    while (name_val_pairs[nv_entry_number].name[0] != '\0') {
         sprintf(tmp_buffer1,"%s",name_val_pairs[nv_entry_number].name);
         sprintf(tmp_buffer2,"%s",name_val_pairs[nv_entry_number].value);
         if (i == 0) {
           sprintf(problem.prob_short_desc, name_val_pairs[nv_entry_number].value);      
         } else if (i == 1) {
           sprintf(problem.prob_desc, name_val_pairs[nv_entry_number].value);      
         } else if (i == 2) {
           sprintf(problem.prob_type, name_val_pairs[nv_entry_number].value);
         } else if (i == 3) {
           sprintf(problem.username, name_val_pairs[nv_entry_number].value);
         } else if (i == 4) {
           sprintf(problem.prob_user,name_val_pairs[nv_entry_number].value);
         } else if (i == 5) {
           sprintf(problem.telephone,name_val_pairs[nv_entry_number].value);
         } else if (i == 6) {
           sprintf(problem.useremail,name_val_pairs[nv_entry_number].value);
         } else if (i == 7) {
           sprintf(problem.userid,name_val_pairs[nv_entry_number].value);
         } else {
         }
         nv_entry_number++;
         i++;
    }
/* database connection and check if true */
   conn = PQsetdbLogin(pghost, pgport, pgoptions, pgtty, dbName, login, pwd);
      if (PQstatus(conn) == CONNECTION_BAD) {
        printf("Content type: text/html\r\n\r\n");
        printf("Connection to database %s failed. \n", dbName);
        printf("%s", PQerrorMessage(conn));
        printf("Connection not made: please report this error to Sys Admin\r\n");
        exit_nicely(conn);
      }

/* Begin the transaction and make SURE that the database is open */
    res = PQexec(conn,"BEGIN");
    if (PQresultStatus(res) != PGRES_COMMAND_OK) {
      printf("Content type: text/html\r\n\r\n");
      printf("BEGIN 0 FAILED!");
      printf("%s", PQerrorMessage(conn));
      printf("Notify the System Administrator");
      exit_nicely(conn);
    }
    PQclear(res);
    sprintf(query,"DECLARE mycursor CURSOR FOR select * FROM prob_entry");
    res = PQexec(conn, query);
    if (PQresultStatus(res) != PGRES_COMMAND_OK) {
      printf("Content type: text/html\r\n\r\n");
      printf("BEGIN FAILED!");
      printf("%s", PQerrorMessage(conn));
      printf("Notify the System Administrator");
      exit_nicely(conn);
    }
    PQclear(res);

/* This grabs the row count adds ONE  to it and writes it to the */
/* problem.prob_num struct item for a unquie prob_num primary key*/
    res = PQexec(conn, "FETCH ALL in mycursor");
    if (PQresultStatus(res) != PGRES_TUPLES_OK) {
      printf("Content type: text/html\r\n\r\n");
      printf("BEGIN 0 FAILED!");
      printf("%s", PQerrorMessage(conn));
      printf("Notify the System Administrator");
      exit_nicely(conn);
    }
    ntuples = PQntuples(res);
    problem.prob_num = ntuples + 1;
    sprintf(problem.closed,"N");

    PQclear(res);
    res = PQexec(conn, "CLOSE mycursor");
    PQclear(res);

/* these check for odd characters in the input namely: ' % \ */
    sprintf(tmp_buffer,problem.prob_desc);
    src_char_ptr = tmp_buffer;
    dest_char_ptr = problem.prob_desc;
    while(*src_char_ptr && *src_char_ptr != '\0' && chars_processed < FIELD_LEN) {
         if (*src_char_ptr == '\''){
           *dest_char_ptr = '\\';
           dest_char_ptr++;
           *dest_char_ptr = '\'';
         } else if (*src_char_ptr == '\\'){
           *dest_char_ptr = '\\';
           dest_char_ptr++;
           *dest_char_ptr = '\\';
         } else if (*src_char_ptr == '\%'){
           *dest_char_ptr = '\\';
           dest_char_ptr++;
           *dest_char_ptr = '\%';
         } else *dest_char_ptr = *src_char_ptr;
           dest_char_ptr++;
           src_char_ptr++;
           chars_processed++;
    }

    sprintf(tmp_buffer,problem.prob_short_desc);
    src_char_ptr = tmp_buffer;
    dest_char_ptr = problem.prob_short_desc;
    while(*src_char_ptr && *src_char_ptr != '\0' && chars_processed < FIELD_LEN) {
         if (*src_char_ptr == '\''){
           *dest_char_ptr = '\\';
           dest_char_ptr++;
           *dest_char_ptr = '\'';
         } else if (*src_char_ptr == '\\'){
           *dest_char_ptr = '\\';
           dest_char_ptr++;
           *dest_char_ptr = '\\';
         } else if (*src_char_ptr == '\%'){
           *dest_char_ptr = '\\';
           dest_char_ptr++;
           *dest_char_ptr = '\%';
         } else *dest_char_ptr = *src_char_ptr;
           dest_char_ptr++;
           src_char_ptr++;
           chars_processed++;
    }
      
/* This sets up the insert statement that is written next */
    sprintf(query,"INSERT INTO prob_entry VALUES (%d,'%s','%s','%s','%s','%s','%s','%s','%s','%s')",
                  problem.prob_num,
                  problem.prob_desc,
                  problem.prob_type,
                  problem.username,
                  problem.useremail,
                  problem.telephone,
                  problem.timeentered,
                  problem.closed,
                  problem.prob_user,
                  problem.prob_short_desc);
                  
    res = PQexec(conn,query);    

    if (PQresultStatus(res) != PGRES_COMMAND_OK) {
      printf("Content type: text/html\r\n\r\n");
      printf("INSERT FAILED!\r\nFATAL ERROR!!!\r\n");
      printf("%s", PQerrorMessage(conn));
      printf("Notify the System Administrator");
      exit_nicely(conn);
    }
    PQclear(res);

/* as always, it is all about commitment! */
/* commit the changes before the end */
    res = PQexec(conn, "COMMIT");
    if (PQresultStatus(res) != PGRES_COMMAND_OK) {
      printf("Content type: text/html\r\n\r\n");
      printf("COMMIT FAILED!\r\n");
      printf("%s\r\n", PQerrorMessage(conn));
      printf("Notify the System Administrator");
      exit_nicely(conn);
    }
    PQclear(res);

/* Close up the files */
    PQfinish(conn);

/* this is where the auto-email notification should be */
  memset(buffer, '\0', sizeof(buffer));
  write_fp = popen("/usr/lib/sendmail -t -U", "w");
  if (write_fp == NULL) {
    html_content();
    html_start("ERROR","");
    html_body("Could not open mailer");
    html_body("<BR>Notify the System Administrator");
    html_body("<mailto: root@localhost");
    html_end();
  } else {
    memset(buffer, '\0', sizeof(buffer));
/* change this to your email addresses... */
    sprintf(buffer,"To:helpdesk,root\r\n");
    fwrite(buffer, sizeof(char), strlen(buffer), write_fp);
    sprintf(buffer,"Cc:%s\r\n", problem.useremail);
    fwrite(buffer, sizeof(char), strlen(buffer), write_fp);
    sprintf(buffer,"From:%s\r\n", problem.useremail);
    fwrite(buffer, sizeof(char), strlen(buffer), write_fp);
    sprintf(buffer,"Subject:%s\r\n", problem.prob_type);
    fwrite(buffer, sizeof(char), strlen(buffer), write_fp);
    sprintf(buffer,"Problem Number: %d\r\n", problem.prob_num);
    fwrite(buffer, sizeof(char), strlen(buffer), write_fp);
    sprintf(buffer,"User: %s\r\n", problem.username);
    fwrite(buffer, sizeof(char), strlen(buffer), write_fp);
    sprintf(buffer,"E-Mail Address: %s\r\n", problem.useremail);    
    fwrite(buffer, sizeof(char), strlen(buffer), write_fp);
    sprintf(buffer,"%s\r\n", problem.prob_desc);
    fwrite(buffer, sizeof(char), strlen(buffer), write_fp);
    memset(buffer, '\0', sizeof(buffer));
    pclose(write_fp);
  }

/*redirect the client back to the home page*/
    printf("Status: 302\r\n");
/* This should be set to whatever page has the link to the Call Center
   Normally the home page in document root */
    printf("Location: /\r\n");
    exit(EXIT_SUCCESS);
}

void exit_nicely(PGconn *conn){   
    
   PQfinish(conn);
   exit(1);
}
