/* Call log processor/Database front end libpq      */
/* will be used. This program will take HTML input  */
/* and windows input (X/9x) and added it to the     */
/* prob_entry database the users database is        */ 
/* read-only and only grabs the user info...        */
/* loc/ext/dept etc. we might even want to do a bit */
/* of inline documentation... this is a big program */
/* estimate 5000 lines of new code. Good Luck       */

/* this is the headers for all web programs (default includes)*/
#include "web.h"

/* some basic handlers */
void exit_nicely(PGconn *conn);

/* basic table structs... for reading/writing the database */
struct prob_entry {
       int prob_num;
       char prob_desc[2048];
       char prob_type[128];
       char username[128];
       char useremail[128];
       char telephone[15];
       char timeentered[17];
       char closed[1];
       char userid[11];
} problem;

struct users {
       char ssn[11];
       char lname[50];
       char fname[50];
       char mi[2];
       char extension[10], location[128];
       char email[128], hardware[128],notes[255];
       char username[128];
       char timeentered[17];
} user;

struct techs {
      char techid[15];
      char techname[128];
      char techarea[128];
      char username[128];
} tech;

struct solutions {
      int prob_num;
      char probsol[2048];
      char timeentered[17];
      char solvedby[128];
      char username[64];
      char pwd[64];
} solution;

/* Startup and run-baby!        */
int main(int argc, char *argv[]) {

/* counters and field options */
    int nv_entry_number = 0, i;
    int chars_processed = 0;
    char *src_char_ptr;
    char *dest_char_ptr;
    char tmp_buffer[(FIELD_LEN * 2) + 2];

/* Database connection options and other values */
    char *pghost, *pgport, *pgoptions, *pgtty, *dbName, *login, *pwd;

/* full table record buffer<jifc> */    
    char query[256], tmp_buffer1[FIELD_LEN + 1], tmp_buffer2[FIELD_LEN + 1];
    char nField[128], solvedby[128];

    struct tm *tm_ptr;
    time_t timeval;    

    PGconn *conn;
    PGresult *res;    

/* set options for database connection */
   pghost = "192.168.1.1";
   pgport = NULL;
   pgoptions = NULL;
   pgtty = NULL;
   dbName = "helldesk";  
   login = NULL;
   pwd = NULL;
 
/* this is a check to see if the web page has data returning to the program */
    if (!get_input()) {
      exit(EXIT_FAILURE);
    }

/* setup time functions for timestamping the problem entries */
    (void) time(&timeval);
    tm_ptr = localtime(&timeval);

    i = 0;

/* read and decode the data. Also, insert it into the struct varibles */
/* note that the field names could be used instead of the nested if   */
/* that does not mean it is better to do so. might cut the time down  */
    while (name_val_pairs[nv_entry_number].name[0] != '\0') {
         sprintf(tmp_buffer1,"%s",name_val_pairs[nv_entry_number].name);
         sprintf(tmp_buffer2,"%s",name_val_pairs[nv_entry_number].value);
         if (i == 0) {
           sprintf(nField,name_val_pairs[nv_entry_number].value);
         } else if (i == 1) {
           sprintf(solution.probsol, name_val_pairs[nv_entry_number].value);
         } else if (i == 2) {
           sprintf(problem.closed,name_val_pairs[nv_entry_number].value);
         } else if (i == 3) {
           sprintf(solution.solvedby, name_val_pairs[nv_entry_number].value);
           sprintf(solvedby, name_val_pairs[nv_entry_number].value);
         } else if (i == 4) {
           sprintf(solution.username, name_val_pairs[nv_entry_number].value);
         } else if (i == 5) {
           sprintf(solution.pwd, name_val_pairs[nv_entry_number].value);
         } else {
         }
         nv_entry_number++;
         i++;
    }
    login=solution.username;
    pwd=solution.pwd;
    
/* database connection and check if true */
   conn = PQsetdbLogin(pghost, pgport, pgoptions, pgtty, dbName, login, pwd);
      if (PQstatus(conn) == CONNECTION_BAD) {
        printf("Content type: text/html\r\n\r\n");
        printf("Connection to database %s failed. \n", dbName);
        printf("%s", PQerrorMessage(conn));
        printf("Connection not made: please report this error to Sys Admin\r\n");
        exit_nicely(conn);
      }

/* Begin the transaction and make SURE that the database is open */
    res = PQexec(conn,"BEGIN");
    if (PQresultStatus(res) != PGRES_COMMAND_OK) {
      printf("Content type: text/html\r\n\r\n");
      printf("BEGIN 0 FAILED!");
      printf("%s", PQerrorMessage(conn));
      printf("Notify the System Administrator");
      exit_nicely(conn);
    }
    PQclear(res);

/* This sets up the insert statement that is written next */
    sprintf(solution.timeentered,"%02d%02d%02d %02d:%02d:%02d",
            tm_ptr->tm_mon+1, tm_ptr->tm_mday, tm_ptr -> tm_year,
            tm_ptr->tm_hour, tm_ptr->tm_min,tm_ptr->tm_sec);

      sprintf(tmp_buffer,solution.probsol);
      src_char_ptr = tmp_buffer;
      dest_char_ptr = solution.probsol;
      while(*src_char_ptr && *src_char_ptr != '\0' && chars_processed < FIELD_LEN) {
         if (*src_char_ptr == '\''){
           *dest_char_ptr = '\\';
           dest_char_ptr++;
           *dest_char_ptr = '\'';
         } else if (*src_char_ptr == '\\'){
           *dest_char_ptr = '\\';
           dest_char_ptr++;
           *dest_char_ptr = '\\';
         } else if (*src_char_ptr == '\%'){
           *dest_char_ptr = '\\';
           dest_char_ptr++;
           *dest_char_ptr = '\%';
         } else *dest_char_ptr = *src_char_ptr;
           dest_char_ptr++;
           src_char_ptr++;
           chars_processed++;
    }

    sprintf(query,"INSERT INTO prob_solutions VALUES ('%s', '%s', '%s','%s')",
                   nField,
                   solution.probsol,
                   solution.timeentered,
                   solvedby);
                  
    res = PQexec(conn,query);    
    if (PQresultStatus(res) != PGRES_COMMAND_OK) {
      printf("Content type: text/html\r\n\r\n");
      printf("INSERT FAILED!\r\nFATAL ERROR!!!\r\n");
      printf("%s", PQerrorMessage(conn));
      printf("Notify the System Administrator");
      exit_nicely(conn);
    }
    PQclear(res);

    sprintf(query,"UPDATE prob_entry SET closed = '%s' WHERE prob_num ='%s' ", problem.closed, nField);               
    res = PQexec(conn,query);    
    if (PQresultStatus(res) != PGRES_COMMAND_OK) {
      printf("Content type: text/html\r\n\r\n");
      printf("UPDATE FAILED!\r\nFATAL ERROR!!!\r\n");
      printf("%s", PQerrorMessage(conn));
      printf("Notify the System Administrator");
      exit_nicely(conn);
    }
    PQclear(res);

    res = PQexec(conn, "END");
    if (PQresultStatus(res) != PGRES_COMMAND_OK) {
      printf("Content type: text/html\r\n\r\n");
      printf("END 0 FAILED!");
      printf("%s", PQerrorMessage(conn));
      printf("Notify the System Administrator");
      exit_nicely(conn);
    }
    PQclear(res);

    PQfinish(conn);
    printf("Status: 302\r\n");
    printf("Location: /cgi-bin/query1\r\n");
    exit(EXIT_SUCCESS);
}


void exit_nicely(PGconn *conn){   
    
   PQfinish(conn);
   exit(1);
}
