/* ADDUSER Database front end written in libpq      */
/* will be used. This program will take HTML input  */
/* and windows input (X/9x) and added it to the     */
/* user database the users database is              */ 
/* read-only and only grabs the user info...        */
/* loc/ext/dept etc. we might even want to do a bit */
/* of inline documentation... this is a big program */
/* estimate 5000 lines of new code. Good Luck       */

/* this is the headers for all web programs (default includes)*/
#include "web.h"

/* some basic handlers */
void exit_nicely(PGconn *conn);

/* basic table structs... for reading/writing the database */
struct users {
       char ssn[11];
       char lname[50];
       char fname[50];
       char mi[2];
       char extension[10], location[128];
       char email[128], hardware[128],notes[255];
       char username[128], timeentered[17];
       char login[64], pwd[64];
} user;

/* Startup and run-baby!        */
int main(int argc, char *argv[]) {

/* counters and field options */
    int nv_entry_number = 0, i;

/* Database connection options and other values */
    char *pghost, *pgport, *pgoptions, *pgtty, *dbName;
    char *login, *pwd;

/* full table record buffer<jifc> */    
    char query[256], tmp_buffer1[FIELD_LEN + 1], tmp_buffer2[FIELD_LEN + 1];

    struct tm *tm_ptr;
    time_t timeval;    

    PGconn *conn;
    PGresult *res;    
    
/* set options for database connection */
   pghost = "192.168.1.1";
   pgport = NULL;
   pgoptions = NULL;
   pgtty = NULL;
   dbName = "helldesk";
   login = NULL;
   pwd = NULL;

/* this is a check to see if the web page has data returning to the program */
    if (!get_input()) {
      exit(EXIT_FAILURE);
    }

/* setup time functions for timestamping the problem entries */
    (void) time(&timeval);
    tm_ptr = localtime(&timeval);

    sprintf(user.timeentered,"%02d%02d%04d %02d:%02d:%02d",
            tm_ptr->tm_mon+1, tm_ptr->tm_mday, tm_ptr -> tm_year,
            tm_ptr->tm_hour, tm_ptr->tm_min,tm_ptr->tm_sec);

    i = 0;
/* read and decode the data. Also, insert it into the struct varibles */
/* note that the field names could be used instead of the nested if   */
/* that does not mean it is better to do so. might cut the time down  */
    while (name_val_pairs[nv_entry_number].name[0] != '\0') {
         sprintf(tmp_buffer1,"%s",name_val_pairs[nv_entry_number].name);
         sprintf(tmp_buffer2,"%s",name_val_pairs[nv_entry_number].value);
         if (i > 1) {
         }
         if (i == 0) {
          sprintf(user.login,name_val_pairs[nv_entry_number].value);
         } else if (i == 1) {
          sprintf(user.pwd,name_val_pairs[nv_entry_number].value);
         } else if (i == 2) {
          sprintf(user.ssn,name_val_pairs[nv_entry_number].value);
         } else if (i == 3) {
          sprintf(user.fname,name_val_pairs[nv_entry_number].value);
         } else if (i == 4) {
          sprintf(user.lname,name_val_pairs[nv_entry_number].value);
         } else if (i == 5) {
          strcat(user.mi,name_val_pairs[nv_entry_number].value);
         } else if (i == 6) {
          sprintf(user.extension,name_val_pairs[nv_entry_number].value);
         } else if (i == 7) {
          sprintf(user.email,name_val_pairs[nv_entry_number].value);
         } else if (i == 8) {
          sprintf(user.hardware,name_val_pairs[nv_entry_number].value);
         } else if (i == 9) {
          sprintf(user.notes,name_val_pairs[nv_entry_number].value);
         } else if (i == 10) {
          sprintf(user.username,name_val_pairs[nv_entry_number].value);
         } else if (i == 11) {
          sprintf(user.location,name_val_pairs[nv_entry_number].value);
         } else {
         }
         nv_entry_number++;
         i++;
    }

    login = user.login;
    pwd = user.pwd;
/* database connection and check if true */
      conn = PQsetdbLogin(pghost, pgport, pgoptions, pgtty, dbName, login, pwd);
      if (PQstatus(conn) == CONNECTION_BAD) {
        printf("Content type: text/html\r\n\r\n");
        printf("Connection to database %s failed. \n", dbName);
        printf("%s", PQerrorMessage(conn));
        printf("Connection not made: please report this error to Sys Admin\r\n");
        exit_nicely(conn);
      }

/* Begin the transaction and make SURE that the database is open */
    res = PQexec(conn,"BEGIN");
    if (PQresultStatus(res) != PGRES_COMMAND_OK) {
      printf("Content type: text/html\r\n\r\n");
      printf("BEGIN 0 FAILED!");
      printf("%s", PQerrorMessage(conn));
      printf("Notify the System Administrator");
      exit_nicely(conn);
    }
    PQclear(res);
    

/* This sets up the insert statement that is written next */
    sprintf(query,"INSERT INTO users VALUES ('%s','%s',
                  '%s','%s','%s','%s', '%s','%s','%s','%s','%s')",
                  user.ssn, user.lname, user.fname, user.mi, user.extension,
                  user.location, user.email, user.hardware, user.notes,
                  user.username,user.timeentered);
                  
    res = PQexec(conn,query);    

    if (PQresultStatus(res) != PGRES_COMMAND_OK) {
      printf("Content type: text/html\r\n\r\n");
      printf("INSERT FAILED!\r\nFATAL ERROR!!!\r\n");
      printf("%s", PQerrorMessage(conn));
      printf("Notify the System Administrator");
      exit_nicely(conn);
    }

    res = PQexec(conn, "COMMIT");
    if (PQresultStatus(res) != PGRES_COMMAND_OK) {
      printf("Content type: text/html\r\n\r\n");
      printf("COMMIT FAILED!");
      printf("%s", PQerrorMessage(conn));
      printf("Notify the System Administrator");
      exit_nicely(conn);
    }
    PQclear(res);

    res = PQexec(conn, "END");
    if (PQresultStatus(res) != PGRES_COMMAND_OK) {
      printf("Content type: text/html\r\n\r\n");
      printf("END 0 FAILED!");
      printf("%s", PQerrorMessage(conn));
      printf("Notify the System Administrator");
      exit_nicely(conn);
    }
    PQclear(res);
    PQfinish(conn);

/* Here the page is generated on the FLY and returned to the client */
html_content();
html_start("User Entry Form","/image5.gif");
html_body("<body link=\"#0000FF\" background=\"image5.gif\">");
html_body("<form ACTION=\"/cgi-bin/adduser\" METHOD=POST>");
html_body("User Information Entry<BR>Type in the users information and click submit.<BR>USER DETAILS<BR>");
printf("<input TYPE=\"hidden\" SIZE=12 MAXLENGTH=\"12\" NAME=\"login\" VALUE=%s>",user.login);
printf("<input type=\"hidden\" SIZE=12 MAXLENGTH=\"12\" NAME=\"password\" VALUE=%s><BR>Employee ID",user.pwd);
html_body("<input TYPE=\"TEXT\" SIZE=12 MAXLENGTH=\"12\" NAME=\"ssn\"><BR><BR>First Name");
html_body("<input TYPE=\"TEXT\" MAXLENGTH=\"50\" NAME=\"fname\"><BR><BR>Last Name");
html_body("<input TYPE=\"TEXT\" MAXLENGTH=\"50\" NAME=\"lname\"><BR><BR>Middle Initial");
html_body("<input TYPE=\"TEXT\" SIZE=5 MAXLENGTH=\"2\" NAME=\"mi\"><BR><BR>Extension");
html_body("<input TYPE=\"TEXT\" SIZE=5 MAXLENGTH=\"5\" NAME=\"extension\"><BR><BR>E-Mail");
html_body("</font><input TYPE=\"TEXT\" SIZE=50 MAXLENGTH=\"50\" NAME=\"email\"><BR><BR>Hardware");
html_body("<TEXTAREA NAME=\"hardware\" rows = 5 cols=30 ></TEXTAREA><BR><BR>Notes"); 
html_body("<TEXTAREA NAME=\"notes\" rows=5 cols=30></TEXTAREA><BR><BR>Username");
html_body("<input TYPE=\"TEXT\" MAXLENGTH=\"50\" NAME=\"username\"><BR><BR>Department");
html_body("<select NAME=\"location\"><option VALUE=\"Accounting\">Accounting");
html_body("<option VALUE=\"General Ledger\">General Ledger <option VALUE=\"Executive\">Executive");
html_body("<option VALUE=\"Purchasing\">Purchasing<option VALUE=\"Accounts Payable\">Accounts Payable");
html_body("<option VALUE=\"Property and Supply\">Property and Supply");
html_body("<option VALUE=\"Grants and Contracts\"> Grants and Contracts</select><BR><BR><input TYPE=\"SUBMIT\">");
html_body("<Input type=\"RESET\"><BR><BR><center><a href=\"/cgi-bin/query\">Call Log</a>");
html_body("</font></font></center></form></body></html>");
/* EXIT BECAUSE WE ARE DONE */    
    exit(EXIT_SUCCESS);
}

void exit_nicely(PGconn *conn){   
    
   PQfinish(conn);
   exit(1);
}
