/* Copyright 1996 Andrew Whaley (andrew@arthur.smuht.nwest.nhs.uk */

#include <stdio.h>
#include <string.h>
#include <unistd.h>

typedef struct dbf_header {
	char version;
	char year;
	char month;
	char day;
	int records;
	unsigned char header_length_l;
	unsigned char header_length_h;
	unsigned char record_length_l;
	unsigned char record_length_h;
	char reserved[20];
	} dbf_header; 

typedef struct field_descriptor {
	char name[11]; 
	char type; 
	int  address;
	unsigned char length;
	char decs;
	char reserved[14];
	} field_descriptor;

char *lower(char[]);
char *clean(char[]);
char *fnumber(char[]);

void main(int argc, char *argv[])
{

	FILE *dbf;
	int a,b;
	char buffer[256];
	unsigned int fields;
	dbf_header header;
	field_descriptor field[256];
	char table[16];

	if (argc!=2) {
		printf("Usage: dbf2sql <filename.dbf>\n\n");
		printf("dbf2sql Converts DBase III compatible DBF files to an \n");
		printf("SQL script consisting of a CREATE TABLE clause and INSERT \n");
		printf("clauses for each record in the DBF file.\n");
		printf("(c) 1996, Andrew Whaley (andrew@arthur.smuht.nwest.nhs.uk)\n");
		exit(1);
		 }

	dbf=fopen(argv[1],"rb");
	if (dbf==NULL) {
		fprintf(stderr,"Can't open %s.\n",argv[1]);
		exit(1);
		}
	
	fread(&header,sizeof(header),1,dbf);
	fields=(((header.header_length_h * 256)+header.header_length_l)/32)-1;	
	fread(&field,32,fields,dbf);
	strcpy(table,argv[1]);
			for (a=0; ((a<16) && (a<strlen(argv[1]))); a++) {
		if (table[a]=='.') table[a]=NULL;
		}
	printf("CREATE TABLE %s (\n",table);
	for (a=0; a<fields; a++) {
		printf("    %s ",lower(field[a].name));
		if (field[a].type=='C') printf("char(%d)",field[a].length);
		if ((field[a].type=='N') && (field[a].decs==0)) printf("int");
		if ((field[a].type=='N') && (field[a].decs>0)) printf("float");
		if (field[a].type=='D') printf("date");
		if (field[a].type=='L') printf("char");
		if (field[a].type=='M') printf("char(10)");
		if (a==fields-1) printf(" );\n\n");
		else printf(",\n");
		}
	fgetc(dbf);
	for(a=0; a<header.records; a++) {
		printf("INSERT INTO %s VALUES (",table);
		fgetc(dbf);
		for (b=0; b<fields; b++) {
			fgets(buffer, field[b].length+1, dbf);
			if (field[b].type=='D') {
				if ((strlen(buffer)==8)&&(buffer[0]!=' '))  printf("'%c%c-%c%c-%c%c%c%c'",buffer[6],buffer[7],buffer[4],buffer[5],buffer[0],buffer[1],buffer[2],buffer[3]);
				else printf("'01-01-1980'");
				}
			else if (field[b].type=='N') printf("%s",fnumber(buffer));
			else printf("'%s'",clean(buffer));
			if (b==fields-1) printf(");\n");
			else printf(",");
			}
		}

	fclose(dbf);
}


char *lower(char input[])
{
	int a;
	for (a=0; a<strlen(input); a++) {
		if ((input[a]>='A') && (input[a]<='Z')) input[a]+='a'-'A';
		}
	return(input);
}

char *clean(char input[])
{
	int a;
	for (a=0; a<strlen(input); a++) {
		if ((input[a]=='\'') || (input[a]=='\"')) input[a]=' ';
		}
	return(input);
}

char *fnumber(char input[])
{
	int a,f=0;
	for (a=0; a<strlen(input); a++) {
		if ((input[a]>='0')&&(input[a]<='9')) f=1;
		}
	if (f==1) return(input);
	else return(" 0");
}
