
import java.applet.Applet;
import java.awt.Graphics;
import java.awt.Color;
import java.awt.Dimension;
import java.lang.System;


public class graph extends Applet {
	int AppletHeight, AppletWidth;
	int rows;
	float[] y = new float[64];
	String[] x = new String[64];
	String type;
	float yscale;
	float xscale;
	int ten;

	public void init() {
		int a;
		String xp;
		String yp;
		Dimension d = size();		
		AppletHeight = d.height;
		AppletWidth = d.width;
		type=getParameter("type");
		rows=Integer.valueOf(getParameter("rows")).intValue();	
		for (a=1; a<=rows; a++) {
			xp="x" + String.valueOf(a);
			yp="y" + String.valueOf(a);		
			y[a]=Float.valueOf(getParameter(yp)).floatValue();
			x[a]=getParameter(xp);
			}
		}
		
	public void paint(Graphics g) {
		border(g,AppletHeight,AppletWidth);
		axis(g);
		chart_bar(g);
		axis(g);
		}

	public void border(Graphics g, int AppletHeight, int AppletWidth) {
		g.setColor(Color.white);
		g.fillRect(0,0,AppletWidth-1,AppletHeight-1);
		g.setColor(Color.black);
		g.drawRect(2,2,AppletWidth-5,AppletHeight-5);
		}

	public void axis(Graphics g) {
		float upper = 0;
		float lower = 0;
		float yrange;
		int a;
		ten = AppletWidth / 10;
		for (a=1; a<=rows; a++) {
			if ( y[a] > upper ) upper = y[a];
			if ( y[a] < lower ) lower = y[a];
			}
		yrange = upper - lower;
		yscale = (AppletHeight-(ten*2)) / yrange;
		xscale = (AppletWidth-ten) / rows;
		g.setColor(Color.black);
		g.drawLine(ten/2,AppletHeight-ten,ten/2,ten/2);
		g.drawLine(AppletWidth-ten,AppletHeight-ten,ten/2,AppletHeight-ten);
		g.drawLine((ten/2)-1,AppletHeight-ten,(ten/2)-1,ten/2);
		g.drawLine(AppletWidth-ten,AppletHeight-ten-1,ten/2,AppletHeight-ten-1);
	
		}  

	public void chart_bar(Graphics g) {
		int a;
		int x1,x2,y1,y2;
		Color c = Color.blue;
		for (a=1; a<=rows; a++) {
			g.setColor(c);
			x1=(int) (ten/2 + (xscale * (a-1)));
			y1=(int) ((AppletHeight-ten) - (yscale * y[a]));
			x2=(int) xscale-(ten/2);
			y2=(int) (yscale * y[a]);
			g.fillRect(x1,y1,x2,y2);
			g.setColor(Color.black);
			g.drawString(x[a],x1+(ten/3),AppletHeight-(ten/2));
			g.drawString(Float.toString(y[a]),x1+(ten/3),y1-(ten/3));
			}
	
		}	
}

