#include <stdio.h>
#include <string.h>
#include <unistd.h>

#define MAX_MENUS 32
#define MAX_FORMS 2
#define MAX_PATH 256
#define WORD_SIZE 800 
#define LINE_SIZE 800
#define INT 1
#define STRING 2
#define DATA 3
#define FLOAT 4
#define TEST 0
#define ACTION 1
#define GLOBAL 1
#define LOCAL 2

int create_tmp(FILE*, char*, int);
void firstpass(char*);
void modulepass(char*, int);
void parseglobal(char*);
char *getword(int, char*, char*);
void gotoline(FILE*, int);
int freadln(FILE*, char*);
char *caps(char[]);
char *stripquotes(char[]);
int checkin(char*, char*);
void check_set(char*, char*);
void menubuild(int, char*);
void modulebuild(int, char*);
void def_var(char*, FILE*, int, int);
void findtools(FILE*, int);
void createform(FILE*, FILE*, int, int);
void createprocess(FILE*, FILE*, int, int);
void createoutput(FILE*, FILE*, int, int);
int countword(char*);
int resolve(FILE*, char[], int, int, int);

struct sections {
	int global_line;
	int no_menus;
	int no_modules;
	struct menu {
		char name[WORD_SIZE];
		int line;
		} menu[MAX_MENUS];
	struct module {
		char name[WORD_SIZE];
		int line;
		int no_forms;
		int no_process;
		int no_outputs;
		struct form {
			char name[WORD_SIZE];
			int line;
			} form[MAX_MENUS];
		struct process {
			char name[WORD_SIZE];
			int line;
			} process[MAX_MENUS];
		struct output {
			char name[WORD_SIZE];
			int line;
			} output[MAX_MENUS];

		} module[MAX_MENUS];
	}; 

struct toolbar {
	char name[WORD_SIZE];
	int p_m;
	int a_d;
	char process[WORD_SIZE];
	char module[WORD_SIZE];
	char value[WORD_SIZE];
	int form;
	} toolbar[MAX_MENUS];

int no_tools;

struct variable {
	char name[WORD_SIZE];
	int type;
	int g_l; 
	int module;
	int process;
	} variable[MAX_MENUS];

int no_vars;

char pghost[WORD_SIZE];
char pgdatabase[WORD_SIZE];
char pgport[WORD_SIZE];
char pgoptions[WORD_SIZE];
char pgtty[WORD_SIZE];
char cgi_url[WORD_SIZE];
char cgi_dir[WORD_SIZE];
char doc_url[WORD_SIZE];
char doc_dir[WORD_SIZE];
char src_dir[WORD_SIZE];
char pgdir[WORD_SIZE];
char httpd_dir[WORD_SIZE];
int no_lines;
struct sections section;
int cline=0;

main (int argc, char *argv[])
{
	FILE *input,*tmp;
	char tmp_filename[MAX_PATH];
	int a;
	if (argc!=2) {
		fprintf(stderr,"Usage: appgen <filename>\n");
		exit(1);
		}
	input=fopen(argv[1],"rt");
	if (input==NULL) {
		fprintf(stderr,"ERROR: Cannot open input file %s\n",argv[1]);
		exit(1);
		}
	fclose(input);
	printf("AppGen Compiler v0.2\nCopyright 1996, Andrew Whaley\nCompiling file %s\n",argv[1]);
	strcpy(tmp_filename,"/tmp/appgen01");
	tmp=fopen(tmp_filename,"wt");
	if (tmp==NULL) {
		fprintf(stderr,"ERROR: Cannot create temporary file %s\n",tmp_filename);
		exit(1);
		}
	create_tmp(tmp,argv[1],1);
	fclose(tmp);
	strcpy(tmp_filename,"/tmp/appgen02");
	tmp=fopen(tmp_filename,"wt");
	if (tmp==NULL) {
		fprintf(stderr,"ERROR: Cannot create temporary file %s\n",tmp_filename);
		exit(1);
		}
	no_lines=create_tmp(tmp,"/tmp/appgen01",2);
	fclose(tmp);
	firstpass("/tmp/appgen02");
	parseglobal("/tmp/appgen02");
	for (a=0; a<section.no_menus; a++) {
		menubuild(a,"/tmp/appgen02");
		}
	for (a=0; a<section.no_modules; a++) {
		modulepass("/tmp/appgen02",a);
		modulebuild(a,"/tmp/appgen02");
		}
	strcpy(tmp_filename,src_dir);
	strcat(tmp_filename,"/makefile");
	tmp=fopen(tmp_filename,"wt");
	if (tmp==NULL) {
		fprintf(stderr,"ERROR: Cannot create makefile %s\n",tmp_filename);
		exit(1);
		}
	fprintf(tmp,"HTTPD=%s\n",httpd_dir);
	fprintf(tmp,"POSTGRES=%s\n",pgdir);
	fprintf(tmp,"APPGEN=/usr/local/AppGEN\n");
	fprintf(tmp,"all:\n");
	for (a=0; a<section.no_modules; a++) {
		fprintf(tmp,"	gcc %s.c -o %s -I$(POSTGRES)/include -I$(APPGEN)/include -L$(POSTGRES)/lib -L$(APPGEN)/lib -lappgen -lpq\n",section.module[a].name,section.module[a].name);
		}
	for (a=0; a<section.no_modules; a++) {
		fprintf(tmp,"	cp %s %s/%s\n",section.module[a].name,cgi_dir,section.module[a].name);
		}
	for (a=0; a<section.no_menus; a++) {
		fprintf(tmp,"	cp %s.html %s/%s.html\n",section.menu[a].name,doc_dir,section.menu[a].name);
		}
	fclose(tmp);
	printf("Compile complete, no errors found.\n");
}

void modulebuild(int m, char *inputfile)
{
	FILE *input,*cout;
	char line[LINE_SIZE],word[WORD_SIZE],title[WORD_SIZE];
	char filename[MAX_PATH];
	char set_section[WORD_SIZE];
	char def_process[WORD_SIZE];
	int def=0;
	int elsev=0;
	char type[WORD_SIZE];
	int a,b;
	no_vars=0;
	printf("	Creating module - %s\n",section.module[m].name);
	strcpy(filename,src_dir);
	strcat(filename,"/");
	strcat(filename,section.module[m].name);
	strcat(filename,".c");
	strcpy(set_section,"MODULE ");
	strcat(set_section,section.module[m].name);
	input=fopen(inputfile,"rt");
	if (input==NULL) {
		fprintf(stderr,"ERROR: Cannot open temporary file %s\n",inputfile);
		exit(1);
		}
	cout=fopen(filename,"wt");
	if (cout==NULL) {
		fprintf(stderr,"ERROR: Cannot create menu file %s\n",filename);
		exit(1);
		}
	fprintf(cout,"/* %s created by AppGEN Compiler */\n\n",filename);
	fprintf(cout,"#include <AppGEN.h>\n");
	fprintf(cout,"#include <libpq-fe.h>\n\n");
	for (a=0; a<section.module[m].no_forms; a++) {
		fprintf(cout,"void form_%s(int, PGresult*);\n",section.module[m].form[a].name);
		}
	for (a=0; a<section.module[m].no_process; a++) {
		fprintf(cout,"void process_%s();\n",section.module[m].process[a].name);
		}
	for (a=0; a<section.module[m].no_outputs; a++) {
		fprintf(cout,"void output_%s(PGresult*);\n",section.module[m].output[a].name);
		}
	fprintf(cout,"\nPGconn *ag_sock;\n");
	fprintf(cout,"PGresult* ag_blank;\n");
	fprintf(cout,"PGresult* ag_result;\n");
	fprintf(cout,"\nvoid main(int argc, char *argv[])\n");
	fprintf(cout,"{\n");
/* Global Variables */
	gotoline(input,section.module[m].line+1);
	freadln(input,line);
	while ((line[0]!='[') && (!feof(input))) {
		if (strcmp(getword(1,line,word),"SET")==0) {
			check_set(line,set_section);
			if (strcmp(getword(2,line,word),"default_process")==0) {
				strcpy(def_process,stripquotes(getword(4,line,word)));
				def=1;
				}
			}
		else def_var(line,cout,m,999);
		freadln(input,line);	
		}

	fprintf(cout,"	ag_sock=PQsetdb(\"%s\",NULL,NULL,NULL,\"%s\");\n",pghost,pgdatabase);
	fprintf(cout,"	if (PQstatus(ag_sock)==CONNECTION_BAD) {\n");
	fprintf(cout,"		printf(\"Content-Type: text/plain\\n\\nError: Cannot connect to Postgres95.\\n\");\n");
	fprintf(cout,"		exit(0);\n");
	fprintf(cout,"		}\n");
/* TOOLBARS : */
	findtools(input,m);
	for (a=0; a<no_tools; a++) {
		if (elsev==1) fprintf(cout,"	else ");
		else fprintf(cout,"	"); 
		fprintf(cout,"if (strcmp(\"\'%s\'\",ag_parse(ag_buff,\"AG_PROCESS\",0))==0) ",toolbar[a].name);
		if (toolbar[a].p_m==1) fprintf(cout,"process_%s();\n",toolbar[a].process);
		if (toolbar[a].p_m==2) fprintf(cout,"ag_get_html(\"%s/%s.html\");\n",doc_dir,toolbar[a].process);
		if (toolbar[a].p_m==3) {
			fprintf(cout,"ag_jump_module(\"%s/%s\",\"%s\",\"%s\",ag_parse(ag_buff,\"%s\",1));\n",cgi_dir,toolbar[a].module,caps(toolbar[a].process),toolbar[a].value,toolbar[a].value);
			}
		elsev=1;
		}
	for (a=0; a<section.module[m].no_process; a++) {
		if (elsev==1) fprintf(cout,"	else ");
		else fprintf(cout,"	"); 
		fprintf(cout,"if (strcmp(\"\'%s\'\",ag_parse(ag_buff,\"AG_PROCESS\",0))==0) ",caps(section.module[m].process[a].name));
		fprintf(cout,"process_%s();\n",section.module[m].process[a].name);
		elsev=1;
		}
	if (elsev==1) fprintf(cout,"	else ");
	else fprintf(cout,"	"); 
	fprintf(cout,"if (strcmp(\"\'AG_ABOUT\'\",ag_parse(ag_buff,\"AG_PROCESS\",0))==0) ag_about();\n");
	if (def==1) {
		fprintf(cout,"	else process_%s();\n",def_process);
		}
	fprintf(cout,"	PQfinish(ag_sock);\n");
	fprintf(cout,"}\n\n");
/* FORMS */
	for (a=0; a<section.module[m].no_forms; a++) {
		createform(input,cout,m,a);	
		}
	for (a=0; a<section.module[m].no_process; a++) {
		createprocess(input,cout,m,a);
		}
	for (a=0; a<section.module[m].no_outputs; a++) {
		createoutput(input,cout,m,a);
		}
	fclose(cout);
}

void createprocess(FILE *input, FILE *cout, int m, int f)
{
	int a,b,c,d,i,mw,nc;
	int no_datas=0;
	char datas[MAX_MENUS][WORD_SIZE];
	char invar[WORD_SIZE],index[WORD_SIZE];
	char x[WORD_SIZE],y[WORD_SIZE];
	char word[WORD_SIZE],line[LINE_SIZE],set_section[WORD_SIZE],worda[WORD_SIZE];
	fprintf(cout,"void process_%s()\n{\n",section.module[m].process[f].name);
	fprintf(cout,"	char ag_query[4096];\n");
	gotoline(input,section.module[m].process[f].line+1);
	freadln(input,line);
	while((line[0]!='[')&&(!feof(input))) {	
/* Variables */
		if (strcmp(getword(1,line,word),"DATA")==0) {
			def_var(line,cout,m,f);
			strcpy(datas[no_datas],getword(2,line,word));
			no_datas++;
			}
		if (strcmp(getword(1,line,word),"INT")==0) def_var(line,cout,m,f);
		if (strcmp(getword(1,line,word),"STRING")==0) def_var(line,cout,m,f);
/* DISPLAY form */
		if (strcmp(getword(1,line,word),"DISPLAY")==0) {
			b=countword(line);
			if (b==2) fprintf(cout,"	form_%s(AG_NEW,ag_blank);\n",getword(2,line,word));
			else if (b==4) {
				if (strcmp(getword(4,line,word),"input")==0) fprintf(cout,"	form_%s(AG_PARSE,ag_blank);\n",getword(2,line,worda));
				else fprintf(cout,"	form_%s(AG_FULL,%s);\n",getword(2,line,word),getword(4,line,worda));
				}
			else {

				fprintf(cout,"	ag_errors[%s].error=1;\n",getword(8,line,word));
				fprintf(cout,"	strcpy(ag_errors[%s].message,%s);\n",getword(8,line,worda),getword(6,line,word));
				if (strcmp(getword(4,line,word),"input")==0) fprintf(cout,"	form_%s(AG_ERROR,ag_blank);\n",getword(2,line,worda));
				else fprintf(cout,"	form_%s(AG_FULL,%s);\n",getword(2,line,word),getword(4,line,worda));
				}
			}
/* MOVE */
		if (strcmp(getword(1,line,word),"MOVE")==0) {
			for (a=0; a<no_vars; a++) if (strcmp(getword(4,line,word),variable[a].name)==0) {
				if (variable[a].type==INT) fprintf(cout,"	%s=%s;\n",variable[a].name,getword(2,line,word));
				if (variable[a].type==STRING) fprintf(cout,"	strcpy(%s,%s);\n",variable[a].name,getword(2,line,word));
				if (variable[a].type==DATA) {
					fprintf(stderr,"ERROR: Can't MOVE to DATA variable type.\n");
					exit(1);
					}
				}
			}
/* LEFT */ 	if (strcmp(getword(1,line,word),"LEFT")==0) {
			getword(4,line,worda);
			if (resolve(cout, worda, m, f, TEST)!=STRING) {
						fprintf(stderr,"Can't LEFT to non-string variable: %s\n",worda);
						exit(1);
						}
			getword(2,line,word);
			fprintf(cout,"	strcpy(ag_temp_string,");
			resolve(cout,word,m,f,ACTION);
			fprintf(cout,");\n");
			fprintf(cout,"	for (ag_i=0; ag_i<%s; ag_i++) %s[ag_i]=ag_temp_string[ag_i];\n",getword(5,line,word),worda);
			fprintf(cout,"	%s[%s]=0;\n",worda,getword(5,line,word));
				
			
			}			

/* OUTPUT */
		if (strcmp(getword(1,line,word),"OUTPUT")==0) {
			fprintf(cout,"	output_%s(%s);\n",getword(2,line,word),getword(4,line,worda));
			}
/* ROWS */
		if (strcmp(getword(1,line,word),"ROWS")==0) {
			fprintf(cout,"	%s=PQntuples(%s);\n",getword(4,line,word),getword(2,line,worda));
			}
/* IF */
		if (strcmp(getword(1,line,word),"IF")==0) {
			b=countword(line);
			for (a=1; a<=b; a++) {
				if (strcmp(getword(a,line,word),"THEN")==0) c=a;
				}
			fprintf(cout,"	if (");
			for (a=2; a<c; a++) {
				getword(a,line,worda);
				if (strcmp(worda,"NOT")==0) fprintf(cout,"!");
				else if ((worda[0]=='B')&&(worda[1]=='L')) {
					fprintf(cout,"(strlen(");
					if ((worda[6]=='i') && (worda[7]=='n') && (worda[8]=='p') && (worda[9]=='u') && (worda[10]=='t')) {
						i=0;
						for (b=12; ((b<strlen(worda))&&(worda[b]!=')')); b++) {
							invar[i]=worda[b];
							i++;
							}
						invar[i]=0;
						fprintf(cout,"ag_parse(ag_buff,\"%s\",0)",caps(invar));			
						}	
					else {
						for (b=6; ((b<strlen(worda))&&(worda[b]!=')')); b++) fprintf(cout,"%c",worda[b]);
						}
					fprintf(cout,")<1)");
		
					}
				else if ((worda[0]=='i') && (worda[1]=='n') && (worda[2]=='p') && (worda[3]=='u') && (worda[4]=='t')) {
					i=0;
					for (b=6; ((c<strlen(worda))&&(worda[b]!=' ')); b++) {
						invar[i]=worda[b];
						i++;
						}
					invar[i]=0;	
					fprintf (cout,"atoi(ag_parse(ag_buff,\"%s\",1))",caps(invar));
					}
				else {
					if (worda[0]=='=') fprintf(cout,"=");
					fprintf(cout,"%s ",worda);
					}
				}
			fprintf(cout,") ");
			}
/* PROCESS */
		if (strcmp(getword(1,line,word),"PROCESS")==0) {
			fprintf(cout,"	process_%s();\n",getword(2,line,word));
			}


/* FOR */	if (strcmp(getword(1,line,word),"FOR")==0) {
			strcpy(index,getword(2,line,word));
			strcpy(invar,getword(6,line,word));
			fprintf(cout,"	for (%s=%s; %s<=%s; %s++)\n",index,getword(4,line,word),index,invar,index);
			}


/* BEGIN */
		if (strcmp(getword(1,line,word),"BEGIN")==0) {
			fprintf(cout,"	{\n");
			}


/* END */
		if (strcmp(getword(1,line,word),"END")==0) {
			fprintf(cout,"	}\n");
			}
/* SYSDATE */
		if (strcmp(getword(1,line,word),"SYSDATE")==0) {
			fprintf(cout,"	ag_sysdate(%s);\n",getword(2,line,word));
			if (countword(line)>2) fprintf(cout,"	ag_systime(%s);\n",getword(3,line,word));
			}
/* SHOWLN */
		if (strcmp(getword(1,line,word),"SHOWLN")==0) {
			nc=countword(line);
			for (a=2; a<nc; a++) {
				getword(a,line,worda);				
				if (worda[0]=='\"') fprintf(cout,"	printf(%s);\n",worda);
				else {
					if ((resolve(cout, worda, m, f, TEST)==INT)||(resolve(cout, worda, m, f, TEST)==FLOAT)) {
						fprintf (cout,"	printf(\"%%d\",");
						}
					else fprintf (cout," printf(\"%%s\",");
					resolve(cout,worda, m, f, ACTION);
					fprintf(cout,");\n");
					}	
				}
			fprintf(cout,"	printf(\"\\n\");\n");
			}
					
/* CALC */
		if (strcmp(getword(1,line,word),"CALC")==0) {
			b=999;
			c=countword(line);
			for (a=0; a<no_vars; a++) if (strcmp(variable[a].name,getword(c,line,word))==0) b=a;
			if (b==999) { 
				fprintf(stderr,"ERROR: Variable not found %s\n",getword(c,line,word));
				exit(1);
				}
			if (variable[b].type!=INT) {
				fprintf(stderr,"ERROR: Variable %s is not of type INT in CALC.\n",getword(c,line,word));
				exit(1);
				}
			fprintf(cout,"	%s=(",variable[b].name);
			mw=c-2;
			for (a=2; a<=mw; a++) {
				getword(a,line,worda);
				if ((worda[0]=='i') && (worda[1]=='n') && (worda[2]=='p') && (worda[3]=='u') && (worda[4]=='t')) {
					i=0;
					for (c=6; ((c<strlen(worda))&&(worda[c]!=' ')); c++) {
						invar[i]=worda[c];
						i++;
						}
					invar[i]=0;	
					fprintf (cout,"atoi(ag_parse(ag_buff,\"%s\",1)))",caps(invar));
					}
				else if ((worda[strlen(worda)-2]=='.')||(worda[strlen(worda)-3]=='.')) {
					i=0;
					for (c=0; ((c<strlen(worda))&&(worda[c]!='.')); c++) {
						invar[i]=worda[c];
						i++;
						}
					invar[i]=0;
					i=0;
					for (c=c+1; ((c<strlen(worda))&&(worda[c]!='.')); c++) {
						x[i]=worda[c];
						i++;
						}
					x[i]=0;
					i=0;
					for (c=c+1; ((c<strlen(worda))&&(worda[c]!='.')); c++) {
						y[i]=worda[c];
						i++;
						}
					y[i]=0;
					fprintf (cout,"atoi(PQgetvalue(%s,%s,%s))",invar,x,y);
					}	

				else fprintf(cout,"%s ",worda);
				}
			fprintf(cout,");\n");

			}

/* APPEND */
		if (strcmp(getword(1,line,word),"APPEND")==0) {
			b=countword(line);
			getword(2,line,worda);
			for (a=0; a<b-3; a++) {
				fprintf(cout,"	strcat(%s,",worda);
				getword(3+a,line,word);
				if (word[0]=='\"') fprintf(cout,"%s);\n",word);
				else if ((word[0]=='i') && (word[1]=='n') && (word[2]=='p') && (word[3]=='u') && (word[4]=='t')) {
					i=0;
					for (c=a+5; ((c<strlen(word))&&(word[c]!=' ')); c++) {
						invar[i]=word[c];
						i++;
						}
					invar[i]=0;	
					fprintf (cout,"ag_parse(ag_buff,\"%s\",1));\n",caps(invar));
					}
				}
			}

/* SQL */
		if (strcmp(getword(1,line,word),"SQL")==0) {
			getword(2,line,worda);
			if (worda[0]=='\"') {
				fprintf(cout,"	strcpy(ag_query,\"");
				for (a=1; a<strlen(worda); a++) { 
					if ((worda[a]!='$') && (worda[a]!='\"')) fprintf(cout,"%c",worda[a]);
					if (worda[a]=='$') {
						fprintf(cout,"\");\n");
						fprintf(cout,"	strcat(ag_query,");
						a++;
						if ((worda[a]=='i') && (worda[a+1]=='n')) {
							i=0;
							for (b=a+6; ((b<strlen(worda)) && (worda[b]!=' ') && (worda[b]!=',') && (worda[b]!=';') && (worda[b]!=')') && (worda[b]!='\'')); b++) {
								invar[i]=worda[b];
								i++;
								}
							invar[i]=0;
							a=a+i+5;
							i=0;
							for (b=0; ((b<strlen(invar))&&(invar[b]!='.')); b++); 
							if (b==strlen(invar)) {	
								fprintf(cout,"ag_parse(ag_buff,\"%s\",1));\n",caps(invar));
								fprintf(cout,"	strcat(ag_query,\"");
								}
							else {
								d=b;
								b++;
								while (b<strlen(invar)) {
									index[i]=invar[b];
									i++;
									b++;
									}
								invar[d]=0;
								index[i]=0;	
								fprintf(cout,"ag_parse(ag_buff,ag_sprintf(ag_buff,\"%s_%%d\",%s),1));\n",caps(invar),index);
								fprintf(cout,"	strcat(ag_query,\"");	
								}		
							}
						else {
							i=0;
							for (b=a; ((b<strlen(worda)) && (worda[b]!=' ') && (worda[b]!=',') && (worda[b]!=';') && (worda[b]!=')') && (worda[b]!='\'')); b++) {
								invar[i]=worda[b];
								i++;
								}
							invar[i]=0;
							b=999;
							for (c=0; c<no_vars; c++) if (strcmp(invar,variable[c].name)==0) b=c;
							if (b==999) {
								fprintf(stderr,"ERROR: Variable %s not found in SQL.\n",invar);
								exit(1);
								}
							if (variable[b].type==INT) 
							fprintf(cout,"ag_itoa(ag_buff,%s));\n",invar);
							else {
								fprintf(cout,"\"\");\n"); 
								fprintf(cout,"	strcat(ag_query,%s);\n",invar);
								fprintf(cout,"	strcat(ag_query,\"\");\n"); 
								} 
							fprintf(cout,"	strcat(ag_query,\"");
							a=a+i-1;
							}
						}
					if (worda[a]=='\"') {
						fprintf(cout,"\");\n");
						}
					}
				}
			if (countword(line)!=4) fprintf(cout,"	ag_result=");
			else fprintf(cout,"	%s=",getword(4,line,word));
			getword(2,line,worda);
			if (worda[0]=='\"') fprintf(cout,"PQexec(ag_sock,ag_query);\n");
			else fprintf(cout,"PQexec(ag_sock,%s);\n",getword(2,line,word));
			if (countword(line)!=4) fprintf(cout,"	if (ag_result==NULL) ag_error(PQerrorMessage(ag_sock),");
			else fprintf(cout,"	if (%s==NULL) ag_error(PQerrorMessage(ag_sock),",getword(4,line,word));
			if (worda[0]=='\"') fprintf(cout,"ag_query);\n");
			else fprintf(cout,"%s);\n",getword(2,line,word));
			}

		
		freadln(input,line);
		}
	for (a=0; a<no_datas; a++) fprintf(cout,"	PQclear(%s);\n",datas[a]);
	fprintf(cout,"}\n\n");
}

int resolve(FILE *cout, char var[WORD_SIZE], int m, int p, int action)
{
	int a,b,c,i;
	char invar[WORD_SIZE],x[WORD_SIZE],y[WORD_SIZE];

/* INPUT TYPE */

	if ((var[0]=='i') && (var[1]=='n') && (var[2]=='p') && (var[3]=='u') && (var[4]=='t')) {
				i=0;
				for (c=6; ((c<strlen(var))&&(var[c]!=' ')); c++) {
				invar[i]=var[c];
				i++;
				}
			invar[i]=0;	
			if (action==ACTION) fprintf (cout,"ag_parse(ag_buff,\"%s\",1)",caps(invar));
			return(STRING);			
			}

/* DATA TYPE WITH INDEX */ 

	else if ((var[strlen(var)-2]=='.')||(var[strlen(var)-3]=='.')) {
					i=0;
					for (c=0; ((c<strlen(var))&&(var[c]!='.')); c++) {
						invar[i]=var[c];
						i++;
						}
					invar[i]=0;
					i=0;
					for (c=c+1; ((c<strlen(var))&&(var[c]!='.')); c++) {
						x[i]=var[c];
						i++;
						}
					x[i]=0;
					i=0;
					for (c=c+1; ((c<strlen(var))&&(var[c]!='.')); c++) {
						y[i]=var[c];
						i++;
						}
					y[i]=0;
					if (action=ACTION) fprintf (cout,"PQgetvalue(%s,%s,%s)",invar,x,y);
					return(STRING);
					}	





/* REGULAR VARIABLES */

	else { 
			b=999;
			for (c=0; c<no_vars; c++) if (strcmp(variable[c].name,var)==0) b=c;
				if (b==999) { 
					fprintf(stderr,"ERROR: Variable \"%s\" not found in MODULE %s PROCESS %s\n",var,section.module[m].name,section.module[m].process[p].name);
					exit(1);
					}
			if (action==ACTION) fprintf (cout,"%s",var);	
			return (variable[b].type); 
			}
	
}	


void createoutput(FILE *input, FILE *cout, int m, int f)
{
	int a,b;
	struct field {
		char name[WORD_SIZE];
		char align[WORD_SIZE];
		char description[WORD_SIZE];
		int  total;
		} field[WORD_SIZE];
	char word[WORD_SIZE],line[LINE_SIZE],set_section[WORD_SIZE],worda[WORD_SIZE],title[WORD_SIZE];
	char type[WORD_SIZE];
	int screen=1;
	int graph=0;
	int title_yn=0;
	int link_yn=0;
	int total_yn=0;
	int col;
	int once=0;
	int total[MAX_MENUS];
	char link[WORD_SIZE];
	fprintf(cout,"void output_%s(PGresult *ag_res)\n{\n",section.module[m].output[f].name);
	fprintf(cout,"	int a,b,n_cols,n_rows;\n");
	fprintf(cout,"	int total[%d];\n",MAX_MENUS);
	fprintf(cout,"	char ag_args[1024];\n");
	fprintf(cout,"	for (a=0; a<%d; a++) total[a]=0;\n",MAX_MENUS);
	fprintf(cout,"	strcpy(ag_args,getenv(\"QUERY_STRING\"));\n");
	fprintf(cout,"	printf(\"Content-Type: text/html\\n\\n\");\n");
	strcpy(set_section,"OUTPUT ");
	strcat(set_section,section.module[m].output[f].name);
	strcat(set_section," in MODULE ");
	strcat(set_section,section.module[m].name);
	gotoline(input,section.module[m].output[f].line+1);
	freadln(input,line);
	while((line[0]!='[')&&(!feof(input))) {
		if (strcmp(getword(1,line,word),"SET")==0) {
			if (strcmp(getword(2,line,word),"title")==0) {
				strcpy(title,stripquotes(getword(4,line,word)));
				title_yn=1;
				if (title_yn==1) fprintf(cout,"	printf(\"<HTML><TITLE>%s</TITLE>\\n\");\n",title);
				fprintf(cout,"	printf(\"<BODY BACKGROUND=\\\"/ag/ag_texture.gif\\\">\\n\");\n");
				if (title_yn==1) fprintf(cout,"	printf(\"<H1>%s</H1>\\n\");\n",title);
				fprintf(cout,"	printf(\"<HR>\\n\");\n");
				once=1;
				}
			if (strcmp(getword(2,line,word),"type")==0) {
				strcpy(type,stripquotes(getword(4,line,word)));
				if (strcmp(type,"screen")==0) {
					screen=1;
					graph=0;
					}
				if (strcmp(type,"graph")==0) {
					screen=0;
					graph=1;
					}	
				}	
			}
		else if (once==0) {
			fprintf(cout,"	printf(\"<HTML><TITLE>%s</TITLE>\\n\");\n",section.module[m].output[f].name);
			fprintf(cout,"	printf(\"<BODY>\\n\");\n");
			fprintf(cout,"	printf(\"<H1>%s</H1>\\n\");\n",section.module[m].output[f].name);
			fprintf(cout,"	printf(\"<HR>\\n\");\n");
			once=1;
			}
		if (strcmp(getword(1,line,word),"PROCESS")==0) {
			fprintf(cout,"	process_%s();\n",getword(2,line,word));
			}



		if ((strcmp(getword(1,line,word),"DEFINE")==0)&&(strcmp(getword(2,line,worda),"OUTPUT")==0)) {
			freadln(input,line);
			b=0;
			while(line[0]!='}') {
				strcpy(field[b].name,getword(1,line,word));
				strcpy(field[b].align,getword(3,line,word));
				strcpy(field[b].description,stripquotes(getword(5,line,word)));
				field[b].total=0;
				if (countword(line)>6) {
					field[b].total=1;
					total_yn=1;
					}
				b++;
				freadln(input,line);
				}
			if ((line[0]=='}') && (countword(line)>2)) {
				link_yn=1;
				strcpy(link,cgi_url);
				strcat(link,"/");
				strcat(link,section.module[m].name);
				strcat(link,"?AG_PROCESS=");
				strcat(link,caps(getword(5,line,word)));
				strcat(link,"&");
				strcat(link,caps(getword(8,line,word)));
				for (a=0; a<b; a++) if (strcmp(field[a].name,getword(8,line,word))==0) col=a;
				}	
			if (screen) {
				fprintf(cout,"	printf(\"<TABLE BORDER=\\\"1\\\">\\n\");\n");
				fprintf(cout,"	printf(\"<TR>");
				for (a=0; a<b; a++) {
					fprintf(cout,"<TH>%s",field[a].description);
					}
				fprintf(cout,"\\n\");\n");
				}
			if (graph) {
				fprintf(cout,"	printf(\"<APPLET CODEBASE=\\\"/ag\\\" CODE=\\\"graph.class\\\" WIDTH=400 HEIGHT=300>\\n\");\n");
				}	
			fprintf(cout,"	n_rows=PQntuples(ag_res);\n");
			if (graph) fprintf(cout,"	printf(\"<PARAM NAME=rows VALUE=%%d>\\n\",n_rows);\n");
			fprintf(cout,"	n_cols=%d;\n",b);
			fprintf(cout,"	for (a=0; a<n_rows; a++) {\n");
			if (screen) {
				fprintf(cout,"		printf(\"<TR>\");\n");
				for (a=0; a<b; a++) {
					if (link_yn) {
						if (a==col) fprintf(cout,"			printf(\"<TD ALIGN=\\\"%s\\\"><A HREF=%s=%%s&%%s>%%s</A>\",ag_encode(ag_buff,PQgetvalue(ag_res,a,%d)),ag_args,PQgetvalue(ag_res,a,%d));\n",field[a].align,link,a,a);
						else fprintf(cout,"			 printf(\"<TD ALIGN=\\\"%s\\\">%%s\",PQgetvalue(ag_res,a,%d));\n",field[a].align,a);	
						}
					else fprintf(cout,"			printf(\"<TD ALIGN=\\\"%s\\\">%%s\",PQgetvalue(ag_res,a,%d));\n",field[a].align,a);
					if (total_yn) if (field[a].total) fprintf(cout,"	total[%d] += atoi(PQgetvalue(ag_res,a,%d));\n",a,a);
					fprintf(cout,"		printf(\"\\n\");\n");
					}
				}
			if (graph) {
				fprintf(cout,"			 printf(\"<PARAM NAME=x%%d VALUE=%%s>\\n\",a+1,PQgetvalue(ag_res,a,0));\n");	
				fprintf(cout,"			 printf(\"<PARAM NAME=y%%d VALUE=%%s>\\n\",a+1,PQgetvalue(ag_res,a,1));\n");	
				}
				
					
			fprintf(cout,"		}\n");		
			
			if ((screen)&&(total_yn)) {
				fprintf(cout,"	printf(\"<TR><TR>\");\n");
				for (a=0; a<b; a++) {
					fprintf(cout,"	printf(\"<TH ALIGN=\\\"%s\\\">\");\n",field[a].align);
					if (field[a].total) fprintf(cout,"	printf(\"%%d\",total[%d]);\n",a);
					}
				}	
			if (screen) fprintf(cout,"	printf(\"</TABLE>\\n\");\n");
			if (graph) fprintf(cout,"	printf(\"</APPLET>\\n\");\n");
	

			}
		freadln(input,line);	
		}

	fprintf(cout,"	printf(\"</BODY></HTML>\\n\");\n");
	fprintf(cout,"	PQclear(ag_res);\n");
	fprintf(cout,"	exit(0);\n");
	fprintf(cout,"}\n\n");
}


void createform(FILE *input, FILE *cout, int m, int f)
{
	int a,b,c,d,i;
	char title[WORD_SIZE],word[WORD_SIZE],line[LINE_SIZE],set_section[WORD_SIZE],worda[WORD_SIZE];
	int title_yn=0;
	int no_forms=0;
	int fc=0;
	struct form {
		char type[WORD_SIZE];
		int rows;
		int fields; 
		struct field {
			char name[WORD_SIZE];
			char description[WORD_SIZE];
			char length[WORD_SIZE];
			char type[WORD_SIZE];
			} field[MAX_MENUS];
		} form[MAX_FORMS];
			
	struct choices {
		int no;
		char val[MAX_MENUS][WORD_SIZE];
		} choices[MAX_FORMS][MAX_MENUS];
		
	fprintf(cout,"void form_%s(int ag_data, PGresult* ag_res)\n{\n",section.module[m].form[f].name);
	fprintf(cout,"	printf(\"Content-Type: text/html\\n\\n\");\n");

	strcpy(set_section,"FORM ");
	strcat(set_section,section.module[m].form[f].name);
	strcat(set_section," in MODULE ");
	strcat(set_section,section.module[m].name);
	gotoline(input,section.module[m].form[f].line+1);
	freadln(input,line);
	while((line[0]!='[')&&(!feof(input))) {
		if (strcmp(getword(1,line,word),"SET")==0) {
			check_set(line,set_section);
			if (strcmp(getword(2,line,word),"title")==0) {
				strcpy(title,stripquotes(getword(4,line,word)));
				title_yn=1;
				}
			}
		if ((strcmp(getword(1,line,word),"DEFINE")==0)&&(strcmp(getword(2,line,worda),"FORM")==0)) {
			freadln(input,line);
			b=0;
			while(line[0]!='}') {
				strcpy(form[no_forms].field[b].name,getword(1,line,word));
				strcpy(form[no_forms].field[b].description,stripquotes(getword(5,line,word)));
				strcpy(form[no_forms].field[b].length,getword(3,line,word));
				strcpy(form[no_forms].field[b].type,getword(7,line,word));
				if (strcmp(form[no_forms].field[b].type,"CHOICE")==0) {
					i=countword(line);
					for (c=0; c<i-7; c++) strcpy(choices[no_forms][b].val[c],stripquotes(getword(c+8,line,word)));
					choices[no_forms][b].no=c-1;
					}
				if (strcmp(form[no_forms].field[b].type,"PICK")==0) {
					i=countword(line);
					strcpy(choices[no_forms][b].val[0],stripquotes(getword(9,line,word)));
					}						
				if (strcmp(form[no_forms].field[b].type,"SEQUENCE")==0) {
					i=countword(line);
					if (i > 12) {
						for(c=0; c<i-12; c++) {
							strcpy(choices[no_forms][b].val[c],stripquotes(getword(c+12,line,word)));
							}
						choices[no_forms][b].no=c-1;
						}
					else choices[no_forms][b].no=0;
					}
				b++;
				freadln(input,line);
				}
			form[no_forms].fields=b;	
			strcat(form[no_forms].type,getword(3,line,word));
			if (strcmp(form[no_forms].type,"TABLE")==0) form[no_forms].rows=atoi(getword(5,line,word));
			no_forms++;	
			}
		freadln(input,line);
		}		
	if (title_yn==1) fprintf(cout,"	printf(\"<HTML><TITLE>%s</TITLE>\\n\");\n",title);
	else fprintf(cout,"	printf(\"<HTML><TITLE>%s</TITLE>\\n\");\n",section.module[m].form[f].name);
	fprintf(cout,"	printf(\"<BODY BACKGROUND=\\\"/ag/ag_texture.gif\\\">\\n\");\n");
	fprintf(cout,"	if (ag_data==AG_ERROR) printf(\"<H1>* ERRORS FOUND *</H1>\\n\");\n");
	if (title_yn==1) fprintf(cout,"	else printf(\"<H1>%s</H1>\\n\");\n",title);
	else fprintf(cout,"	else printf(\"<H1>%s</H1>\\n\");\n",section.module[m].form[f].name);
	fprintf(cout,"	printf(\"<HR>\\n\");\n");
	fprintf(cout,"	printf(\"<FORM ACTION=\\\"%s/%s\\\">\\n\");\n",cgi_url,section.module[m].name);
	for (d=0; d<no_forms; d++) {	
		fprintf(cout,"	printf(\"<TABLE>\\n\");\n");
		if (form[d].type[0]=='T') {
			fprintf(cout,"	printf(\"<TR>");
			for (a=0; a<form[d].fields; a++) fprintf(cout,"<TH>%s",form[d].field[a].description);
			fprintf(cout,"\");\n");
			for (b=0; b<form[d].rows; b++) {
				fprintf(cout,"	printf(\"<TR>\");\n");
				for (a=0; a<form[d].fields; a++) {
					if (strcmp(form[d].field[a].type,"CHOICE")==0) {
						fprintf(cout,"	printf(\"<TD><SELECT NAME=\\\"%s_%d\\\">\\n\");\n",caps(form[d].field[a].name),b);
						for (c=0; c<choices[d][a].no; c++) {
							fprintf(cout,"	printf(\"<OPTION VALUE=\\\"%d\\\"\");\n",c);
							fprintf(cout,"	if (ag_data==AG_FULL) if (atoi(PQgetvalue(ag_res,%d,%d))==%d) printf(\" SELECTED\");\n",b,fc+a,c);
							fprintf(cout,"	if (ag_data>AG_FULL) if (atoi(ag_parse(ag_buff,\"%s_%d\",1))==%d) printf(\" SELECTED\");\n",caps(form[d].field[a].name),b,c);
							fprintf(cout,"	printf(\">%s\");\n",choices[d][a].val[c]);
							}
						fprintf(cout,"	printf(\"</SELECT>\");\n");
						fprintf(cout,"	if ((ag_data==AG_ERROR)&&(ag_errors[%d].error==1)) printf(\"<B> Error: %%s</B>\",ag_errors[%d].message);\n",a,a);
						fprintf(cout,"	printf(\"\\n\");\n");
						}
					else {
						if (strcmp(form[d].field[a].type,"SEQUENCE")==0) {
							fprintf(cout,"	printf(\"<TD><INPUT TYPE=\\\"HIDDEN\\\" NAME=\\\"%s_%d\\\" SIZE=%s MAXLENGTH=%s\");\n",caps(form[d].field[a].name),b,form[d].field[a].length,form[d].field[a].length);
							if (choices[d][a].no>0) fprintf(cout,"	printf(\" VALUE=\\\"%d\\\"><CODE>%s</CODE\");\n",b+1,choices[d][a].val[b]);
							else fprintf(cout,"	printf(\" VALUE=\\\"%d\\\"><CODE>%d</CODE\");\n",b+1,b+1);
							}
						else fprintf(cout,"	printf(\"<TD><INPUT TYPE=\\\"%s\\\" NAME=\\\"%s_%d\\\" SIZE=%s MAXLENGTH=%s\");\n",form[d].field[a].type,caps(form[d].field[a].name),b,form[d].field[a].length,form[d].field[a].length);
						fprintf(cout,"	if (ag_data==AG_FULL) printf(\" VALUE=\\\"%%s\\\"\",PQgetvalue(ag_res,%d,%d));\n",b,fc+a);
						fprintf(cout,"	if (ag_data>AG_FULL) printf(\" VALUE=\\\"%%s\\\"\",ag_parse(ag_buff,\"%s_%d\",1));\n",caps(form[d].field[a].name),b);
						fprintf(cout,"	printf(\">\");\n");
						fprintf(cout,"	if ((ag_data==AG_ERROR)&&(ag_errors[%d].error==1)) {\n",a);
						fprintf(cout,"		printf(\"<B> Error: %%s</B>\",ag_errors[%d].message);\n",a);
						fprintf(cout,"		ag_errors[%d].error=0;\n",a);
						fprintf(cout,"		}\n");
						fprintf(cout,"	printf(\"\\n\");\n");
						}
					}
				}
			}
		else {	
			for (a=0; a<form[d].fields; a++) {
				if (strcmp(form[d].field[a].type,"CHOICE")==0) {
					fprintf(cout,"	printf(\"<TR><TD>%s<TD><SELECT NAME=\\\"%s\\\">\\n\");\n",form[d].field[a].description,caps(form[d].field[a].name));
					for (c=0; c<choices[d][a].no; c++) {
						fprintf(cout,"	printf(\"<OPTION VALUE=\\\"%d\\\"\");\n",c);
						fprintf(cout,"	if (ag_data==AG_FULL) if (atoi(PQgetvalue(ag_res,0,%d))==%d) printf(\" SELECTED\");\n",a,c);
						fprintf(cout,"	if (ag_data>AG_FULL) if (atoi(ag_parse(ag_buff,\"%s\",1))==%d) printf(\" SELECTED\");\n",caps(form[d].field[a].name),c);
						fprintf(cout,"	printf(\">%s\");\n",choices[d][a].val[c]);
						}
					fprintf(cout,"	printf(\"</SELECT>\");\n");
					fprintf(cout,"	if ((ag_data==AG_ERROR)&&(ag_errors[%d].error==1)) printf(\"<B> Error: %%s</B>\",ag_errors[%d].message);\n",a,a);
					fprintf(cout,"	printf(\"\\n\");\n");
					fc++;
					}
				else {
					fprintf(cout,"	printf(\"<TR><TD>%s<TD><INPUT TYPE=\\\"%s\\\" NAME=\\\"%s\\\" SIZE=%s MAXLENGTH=%s\");\n",form[d].field[a].description,form[d].field[a].type,caps(form[d].field[a].name),form[d].field[a].length,form[d].field[a].length);
					fprintf(cout,"	if (ag_data==AG_FULL) printf(\" VALUE=\\\"%%s\\\"\",PQgetvalue(ag_res,0,%d));\n",a);
					fprintf(cout,"	if (ag_data>AG_FULL) printf(\" VALUE=\\\"%%s\\\"\",ag_parse(ag_buff,\"%s\",1));\n",caps(form[d].field[a].name));
					fprintf(cout,"	printf(\">\");\n");
					if (strcmp(form[d].field[a].type,"PICK")==0) {
						fprintf(cout,"	printf(\"<INPUT TYPE=submit NAME=\\\"AG_PROCESS\\\" VALUE=\\\"%s\\\">\");\n",caps(choices[d][a].val[0]));
						}
					fprintf(cout,"	if ((ag_data==AG_ERROR)&&(ag_errors[%d].error==1)) {\n",a);
					fprintf(cout,"		printf(\"<B> Error: %%s</B>\",ag_errors[%d].message);\n",a);
					fprintf(cout,"		ag_errors[%d].error=0;\n",a);
					fprintf(cout,"		}\n");
					fprintf(cout,"	printf(\"\\n\");\n");
					fc++;
					}
				}
			}
		fprintf(cout,"	printf(\"</TABLE>\\n\");\n");
		}
		
	fprintf(cout,"	printf(\"<HR>\\n\");\n");
	fprintf(cout,"	printf(\"<TABLE><TR>\\n\");\n");
	for (a=0; a<no_tools; a++) {
		if (toolbar[a].form==f) {
			if (toolbar[a].a_d==1) fprintf(cout,"	if (ag_data) ");
			else fprintf(cout,"	");
			fprintf(cout,"printf(\"<TD><INPUT TYPE=submit NAME=\\\"AG_PROCESS\\\" VALUE=\\\"%s\\\">\");\n",toolbar[a].name);
			}
		}
	fprintf(cout,"	printf(\"</TABLE><HR></FORM><A HREF=\\\"%s/%s?AG_PROCESS=AG_ABOUT\\\"><IMG SRC=\\\"/ag/ag_grey.gif\\\" BORDER=0></A></BODY></HTML>\");\n",cgi_url,section.module[m].name);
	fprintf(cout,"	if (ag_data==AG_FULL) PQclear(ag_res);\n");
	fprintf(cout,"	exit(0);\n");
	fprintf(cout,"}\n\n");	
}

void findtools(FILE *input,int m)
{
	int a,b=0;
	char line[LINE_SIZE],word[WORD_SIZE],worda[WORD_SIZE];
	for (a=0; a<section.module[m].no_forms; a++) {
		gotoline(input,section.module[m].form[a].line+1);
		freadln(input,line);
		while ((strcmp(getword(1,line,word),"DEFINE")!=0) || (strcmp(getword(2,line,worda),"TOOLBAR")!=0)) freadln(input,line);
		freadln(input,line);
		while(line[0]!='}') {
			strcpy(toolbar[b].name,stripquotes(getword(1,line,word)));
			if (strcmp(getword(3,line,word),"ALL")==0) toolbar[b].a_d=0;
			if (strcmp(getword(3,line,word),"DATA")==0) toolbar[b].a_d=1;
			if (strcmp(getword(5,line,word),"PROCESS")==0) toolbar[b].p_m=1;
			if (strcmp(getword(5,line,word),"MENU")==0) toolbar[b].p_m=2;
			if (strcmp(getword(5,line,word),"MODULE")==0) {
				toolbar[b].p_m=3;
				if (countword(line)>6) strcpy(toolbar[b].process,stripquotes(getword(8,line,word)));
				if (countword(line)>8) {
					strcpy(worda,stripquotes(getword(10,line,word)));
					strcpy(toolbar[b].value,caps(worda));
					}
				else strcpy(toolbar[b].process,"");
				strcpy(toolbar[b].module,stripquotes(getword(6,line,word)));
				}
			else strcpy(toolbar[b].process,stripquotes(getword(6,line,word)));
			toolbar[b].form=a;
			b++;
			freadln(input,line);
			}
		}
	no_tools=b;
}



void def_var(char *line, FILE *out, int m, int p)
{
	char type[WORD_SIZE],word[WORD_SIZE];
	getword(1,line,type);
	if (strcmp(type,"DATA")==0) {
		fprintf(out,"	PGresult* %s;\n",getword(2,line,word));
		strcpy(variable[no_vars].name,getword(2,line,word));
		variable[no_vars].type=DATA;
		if (p=999) variable[no_vars].g_l=GLOBAL;
		else {
			variable[no_vars].g_l=LOCAL;
			variable[no_vars].process=p;
			}
		variable[no_vars].module=m;
		no_vars++;
		return;
		}
	if (strcmp(type,"INT")==0) {
		fprintf(out,"	int %s;\n",getword(2,line,word));
		strcpy(variable[no_vars].name,getword(2,line,word));
		variable[no_vars].type=INT;
		if (p=999) variable[no_vars].g_l=GLOBAL;
		else {
			variable[no_vars].g_l=LOCAL;
			variable[no_vars].process=p;
			}
		variable[no_vars].module=m;
		no_vars++;
		return;
		}
	if (strcmp(type,"STRING")==0) {
		fprintf(out,"	char %s[%d];\n",getword(2,line,word),WORD_SIZE);
		strcpy(variable[no_vars].name,getword(2,line,word));
		variable[no_vars].type=STRING;
		if (p=999) variable[no_vars].g_l=GLOBAL;
		else {
			variable[no_vars].g_l=LOCAL;
			variable[no_vars].process=p;
			}
		variable[no_vars].module=m;
		no_vars++;
		return;
		}
	fprintf(stderr,"ERROR: Unknown variable type: %s\n", type);
	exit(1);

}

void menubuild(int m, char *inputfile)
{
	FILE *input,*htmlout;
	char line[LINE_SIZE],word[WORD_SIZE],title[WORD_SIZE];
	char filename[MAX_PATH];
	char set_section[WORD_SIZE];
	char type[WORD_SIZE];
	int a,b;
	printf("	Creating menu - %s\n",section.menu[m].name);
	strcpy(filename,src_dir);
	strcat(filename,"/");
	strcat(filename,section.menu[m].name);
	strcat(filename,".html");
	strcpy(set_section,"MENU ");
	strcat(set_section,section.menu[m].name);
	input=fopen(inputfile,"rt");
	if (input==NULL) {
		fprintf(stderr,"ERROR: Cannot open temporary file %s\n",inputfile);
		exit(1);
		}
	htmlout=fopen(filename,"wt");
	if (htmlout==NULL) {
		fprintf(stderr,"ERROR: Cannot create menu file %s\n",filename);
		exit(1);
		}
	fprintf(htmlout,"<HTML>\n");
	gotoline(input,section.menu[m].line+1);
	freadln(input,line);
	while ((line[0]!='[') && (!feof(input))) {
		if (strcmp(getword(1,line,word),"SET")==0) {
			check_set(line,set_section);
			if (strcmp(getword(2,line,word),"title")==0) {
				fprintf(htmlout,"<HEAD><TITLE>%s</TITLE></HEAD><BODY BACKGROUND=\"/ag/ag_texture.gif\">\n",stripquotes(getword(4,line,word)));
				fprintf(htmlout,"<H1 ALIGN=center>%s</H1><HR>\n",stripquotes(getword(4,line,word)));
				}
			}
		if (strcmp(getword(1,line,word),"SHOWLN")==0) fprintf(htmlout,"%s<BR>\n",stripquotes(getword(2,line,word)));
		if (strcmp(getword(1,line,word),"SHOW")==0) fprintf(htmlout,"%s",stripquotes(getword(2,line,word)));
		if ((strcmp(getword(1,line,word),"DEFINE")==0)&&(strcmp(getword(2,line,word),"MENU")==0)) {
			fprintf(htmlout,"<H2 ALIGN=center>\n");
			freadln(input,line);
			while((line[0]!='}') && (!feof(input)) && (line[0]!='[')) {
				if (strcmp(getword(3,line,word),"MENU")==0) fprintf(htmlout,"<A HREF=\"%s/%s.html\">",doc_url,stripquotes(getword(4,line,word)));
				if (strcmp(getword(3,line,word),"MODULE")==0) fprintf(htmlout,"<A HREF=\"%s/%s\">",cgi_url,stripquotes(getword(4,line,word)));
				fprintf(htmlout,"%s</A><BR><BR>\n",stripquotes(getword(1,line,word)));
				freadln(input,line);
				}
			fprintf(htmlout,"</H2>\n");
			}
		freadln(input,line);
		}
	fprintf(htmlout,"</BODY></HTML>\n");
	fclose(input);
	fclose(htmlout);
}

void parseglobal(char *filename)
{
	FILE *input;
	char line[LINE_SIZE],word[WORD_SIZE],temp[WORD_SIZE];
	int a,b,done=0;
	input=fopen(filename,"rt");
	if (input==NULL) {
		fprintf(stderr,"ERROR: Cannot open temporary file %s\n",filename);
		exit(1);
		}
	gotoline(input,section.global_line+1);
	freadln(input,line);
	do {
		if (strcmp(getword(1,line,word),"SET")!=0) {
			fprintf(stderr,"ERROR: Unrecognised command %s in GLOBAL section.\n",word);
			exit(1);
			}
		check_set(line,"GLOBAL");
		if (strcmp(getword(2,line,word),"pgdir")==0) strcpy(pgdir,stripquotes(getword(4,line,word)));
		if (strcmp(getword(2,line,word),"pghost")==0) strcpy(pghost,stripquotes(getword(4,line,word)));
		if (strcmp(getword(2,line,word),"pgdatabase")==0) strcpy(pgdatabase,stripquotes(getword(4,line,word)));
		if (strcmp(getword(2,line,word),"httpd-dir")==0) strcpy(httpd_dir,stripquotes(getword(4,line,word)));
		if (strcmp(getword(2,line,word),"cgi-url")==0) {
			strcpy(cgi_url,stripquotes(getword(4,line,word)));
			b=0;
			for (a=0; ((a<strlen(cgi_url))&&(b<3)); a++) {
				if (cgi_url[a]=='/') b++;
				}
			strcpy(cgi_dir,httpd_dir);
			for (b=a; b<strlen(cgi_url); b++) temp[b-a]=cgi_url[b];
			temp[b-a]=0;
			strcat(cgi_dir,"/");
			strcat(cgi_dir,temp);
			}
		if (strcmp(getword(2,line,word),"doc-url")==0) {
			strcpy(doc_url,stripquotes(getword(4,line,word)));
			b=0;
			for (a=0; ((a<strlen(doc_url))&&(b<3)); a++) {
				if (doc_url[a]=='/') b++;
				}
			strcpy(doc_dir,httpd_dir);
			for (b=a; b<strlen(doc_url); b++) temp[b-a]=doc_url[b];
			temp[b-a]=0;
			strcat(doc_dir,"/");
			strcat(doc_dir,temp);
			}
		if (strcmp(getword(2,line,word),"src-dir")==0) strcpy(src_dir,stripquotes(getword(4,line,word)));
		freadln(input,line);
		} while ((line[0]!='[') && (!feof(input)));	
	if (strlen(pgdir)==0) {
		printf("WARNING: pgdir not set in GLOBAL section, assuming \"/usr/local/postgres95\"\n");
		strcpy(pgdir,"/usr/local/postgres95");
		}
	if (strlen(pghost)==0) {
		printf("WARNING: pghost not set in GLOBAL section, assuming \"localhost\"\n");
		strcpy(pghost,"localhost");
		}
	if (strlen(pgdatabase)==0) {
		printf("WARNING: pgdatabase not set in GLOBAL section, assuming \"root\"\n");
		strcpy(pgdatabase,"root");
		}
	if (strlen(httpd_dir)==0) {
		printf("WARNING: httpd-dir not set in GLOBAL section, assuming \"/usr/local/httpd\"\n");
		strcpy(httpd_dir,"/usr/local/httpd");
		}
	if (strlen(cgi_url)==0) {
		printf("WARNING: cgi_url not set in GLOBAL section, assuming \"http://localhost/cgi-bin\"\n");
		strcpy(cgi_url,"http://localhost/cgi-bin");
		}
	if (strlen(doc_url)==0) {
		printf("WARNING: doc_url not set in GLOBAL section, assuming \"http://localhost/docs\"\n");
		strcpy(doc_url,"http://localhost/docs");
		}
	if (strlen(src_dir)==0) {
		printf("WARNING: src_dir not set in GLOBAL section, assuming \".\"\n");
		strcpy(src_dir,".");
		}
}

void check_set(char *line, char *section)
{
	char variable[WORD_SIZE], as[WORD_SIZE], value[WORD_SIZE],spare[WORD_SIZE];
	getword(2,line,variable);
	getword(3,line,as);
	getword(4,line,value);
	if (strcmp(section,"GLOBAL")==0) {
		if (checkin(variable,"pgdir*pghost*pgdatabase*httpd-dir*cgi-url*doc-url*src-dir")!=1) {
			fprintf(stderr,"> %s\nERROR: Invalid entity \"%s\" to SET in GLOBAL section\n",line,variable);
			exit(1);
			}
		}
	if (section[1]=='E') {
		if (strcmp(variable,"title")!=0) {
			fprintf(stderr,"> %s\nERROR: Invalid entity \"%s\" to SET in section %s\n",line,variable,section);
			exit(1);
			}
		}
	if (strcmp(as,"AS")!=0) {
			fprintf(stderr,"> %s\nERROR: Expecting AS in SET in section %s\n",line,section);
			exit(1);
			}
	if ((value[0]!='\"')||(value[strlen(value)-1]!='\"')) {
			fprintf(stderr,"> %s\nERROR: Value should be in quotes in SET in section %s\n",line,section);
			exit(1);
			}
}

int checkin(char *value, char *range)
{
	int found=0,a,b;
	for (b=0; ((b<strlen(range))&&(!found)); b++) {
		found=1;
		for (a=0; ((a<strlen(value))&&(a+b<strlen(range))); a++) if (value[a]!=range[b+a]) found=0;
 		}	
	return(found);
}

char *stripquotes(char *word) 
{
	char output[WORD_SIZE];
	int a,b;
	b=0;
	a=0; 
	while ((word[a]!='\"') && (a<strlen(word))) a++;
	a++;
	while ((word[a]!='\"') && (a<strlen(word))) {
		output[b]=word[a];
		a++;
		b++;
		}
	output[b]=0;
	strcpy(word,output);
	return(word);
}

void modulepass(char *filename, int m)
{
	FILE *input;
	char line[LINE_SIZE],word[WORD_SIZE];
	int a,b;
	input=fopen(filename,"rt");
	if (input==NULL) {
		fprintf(stderr,"ERROR: Cannot open temporary file %s\n",filename);
		exit(1);
		}
	section.module[m].no_forms=0;
	section.module[m].no_process=0;
	section.module[m].no_outputs=0;
	a=section.module[m].line+1; 
	gotoline(input,a);
	while (!feof(input)) {	
		freadln(input,line);
		if (strcmp(getword(1,line,word),"[FORM")==0) {
			section.module[m].form[section.module[m].no_forms].line=a;
			strcpy(section.module[m].form[section.module[m].no_forms].name,getword(2,line,word));
			for (b=0; b<strlen(section.module[m].form[section.module[m].no_forms].name); b++) if (section.module[m].form[section.module[m].no_forms].name[b]==']') section.module[m].form[section.module[m].no_forms].name[b]=0;
			section.module[m].no_forms++;
			}
		if (strcmp(getword(1,line,word),"[PROCESS")==0) {
			section.module[m].process[section.module[m].no_process].line=a;
			strcpy(section.module[m].process[section.module[m].no_process].name,getword(2,line,word));
			for (b=0; b<strlen(section.module[m].process[section.module[m].no_process].name); b++) if (section.module[m].process[section.module[m].no_process].name[b]==']') section.module[m].process[section.module[m].no_process].name[b]=0;
			section.module[m].no_process++;
			}
		if (strcmp(getword(1,line,word),"[OUTPUT")==0) {
			section.module[m].output[section.module[m].no_outputs].line=a;
			strcpy(section.module[m].output[section.module[m].no_outputs].name,getword(2,line,word));
			for (b=0; b<strlen(section.module[m].output[section.module[m].no_outputs].name); b++) if (section.module[m].output[section.module[m].no_outputs].name[b]==']') section.module[m].output[section.module[m].no_outputs].name[b]=0;
			section.module[m].no_outputs++;
			}
		if (strcmp(getword(1,line,word),"[MODULE")==0) return; 
		if (strcmp(getword(1,line,word),"[MENU")==0) return; 

		a++;
		}
	fclose(input);
}


void firstpass(char *filename)
{
	FILE *input;
	char line[LINE_SIZE],word[WORD_SIZE];
	int a,b,globals=0;
	input=fopen(filename,"rt");
	if (input==NULL) {
		fprintf(stderr,"ERROR: Cannot open temporary file %s\n",filename);
		exit(1);
		}
	cline=0;	
	section.no_menus=0;
	section.no_modules=0;
	gotoline(input,1);
	a=0;	
	while (!feof(input)) {
		freadln(input,line);
		a++;
		if (strcmp(getword(1,line,word),"[GLOBAL]")==0) {
			section.global_line=a;
			globals++;
			}
		if (strcmp(getword(1,line,word),"[MENU")==0) {
			section.menu[section.no_menus].line=a;
			strcpy(section.menu[section.no_menus].name,getword(2,line,word));
			for (b=0; b<strlen(section.menu[section.no_menus].name); b++) if (section.menu[section.no_menus].name[b]==']') section.menu[section.no_menus].name[b]=0;
			section.no_menus++;
			}
		if (strcmp(getword(1,line,word),"[MODULE")==0) {
			section.module[section.no_modules].line=a;
			strcpy(section.module[section.no_modules].name,getword(2,line,word));
			for (b=0; b<strlen(section.module[section.no_modules].name); b++) if (section.module[section.no_modules].name[b]==']') section.module[section.no_modules].name[b]=0;
			section.no_modules++;	
			}
		}
	if (globals==0) {
		fprintf(stderr,"ERROR: No GLOBAL section found in input file.\n");
		exit(1);
		}
	if (globals>1) {
		printf("WARNING: More than one GLOBAL section found, using latest.\n");
		}
	if ((section.no_menus==0) && (section.no_modules==0)) {
		fprintf(stderr,"ERROR: No menus or modules found in input file.\n");
		exit(1);
		}
	fclose(input);
}

char *getword(int word_number, char *line, char *word)
{
	int a,b,c,in_quotes=0;
	b=0;
	for (a=0; a<WORD_SIZE; a++) word[a]=0;
	a=0;
	c=0;
	while(a<strlen(line)) {
		if (!in_quotes) if ((line[a]==' ') || (line[a]=='\t')) {
			while (((line[a]==' ')||(line[a]=='\t'))&&(a<strlen(line))) a++;
			word[b]=0;
			b=0;
			c++;
			if (c==word_number) return(word);
			}
		if (in_quotes) if (line[a]=='\"') {
			a++;
			while (((line[a]==' ')||(line[a]=='\t'))&&(a<strlen(line))) a++;
			word[b]='\"';
			b++;
			word[b]=0;
			b=0;
			c++;
			in_quotes=0;
			if (c==word_number) return(word);
			}
		if (line[a]=='\"') {
			if (in_quotes==1) in_quotes=0;
			else in_quotes=1;
			}
		word[b]=line[a];
		b++;
		a++;
		}
	word[b]=0;
	return(word);
}

int countword(char *line)
{
	int a,b,c,in_quotes=0;
	char word[WORD_SIZE];
	int word_number=99;
	b=0;
	for (a=0; a<WORD_SIZE; a++) word[a]=0;
	a=0;
	c=0;
	while(a<strlen(line)) {
		if (!in_quotes) if ((line[a]==' ') || (line[a]=='\t')) {
			while (((line[a]==' ')||(line[a]=='\t'))&&(a<strlen(line))) a++;
			word[b]=0;
			b=0;
			c++;
			}
		if (in_quotes) if (line[a]=='\"') {
			a++;
			while (((line[a]==' ')||(line[a]=='\t'))&&(a<strlen(line))) a++;
			word[b]='\"';
			b++;
			word[b]=0;
			b=0;
			c++;
			in_quotes=0;
			}
		if (line[a]=='\"') {
			if (in_quotes==1) in_quotes=0;
			else in_quotes=1;
			}
		word[b]=line[a];
		b++;
		a++;
		}
	word[b]=0;
	return(c+1);
}


void gotoline(FILE *input, int line_number)
{
	int a,d;
	char spare[LINE_SIZE];
	d = (line_number - 1);
	fseek(input,0,SEEK_SET);
	for (a=0; a<d; a++) freadln(input,spare);
}	

int create_tmp(FILE *tmp,char *input_file,int pass) 
{
	FILE *input;
	char line[LINE_SIZE],filename[MAX_PATH],word[WORD_SIZE];
	int a,b,no_lines=0;
	input=fopen(input_file,"rt");
	if (input==NULL) {
		fprintf(stderr,"ERROR: Cannot open INCLUDE file %s\n",input_file);
		exit(1);
		}
	while (!feof(input)) {
		freadln(input,line);
		if ((line[0]=='I') && (line[1]=='N') && (line[2]=='C') && (line[3]=='L') && (line[4]=='U') && (line[5]=='D') && (line[6]=='E')) {
			a=0; 
			while ((a<strlen(line))&&(line[a]!='\"')) a++;
			a++;
			b=0;
			while ((a<strlen(line))&&(line[a]!='\"')) {
				filename[b]=line[a];
				a++;
				b++;
				}
		 	filename[b]=0;
			create_tmp(tmp,filename,pass);
			}
		else if (strlen(line)>0) {
			for (b=0; b<strlen(line); b++) {
				if ((pass==1)&&(line[b]=='B')&&(line[b+1]=='E')&&(line[b+2]=='G')&&(line[b+3]=='I')&&(line[b+4]=='N')) fprintf(tmp,"\n");
				fprintf(tmp,"%c",line[b]);
				if ((pass==1)&&(line[b+2]!='B')&&(line[b]=='N')&&(line[b-1]=='E')&&(line[b-2]=='H')&&(line[b-3]=='T')&&(b>4)) fprintf(tmp,"\n"); 
				}
			fprintf(tmp,"\n");
			no_lines++;
			}
		}
	fclose(input);
	return(no_lines);
}

int freadln(FILE *input,char *output)
{
	int a,c,size=0;
	cline++;
	for (a=0; a<LINE_SIZE; a++) output[a]=0;
	c=fgetc(input);
	if (feof(input)) return(0);
	if (c=='#') {
		while(fgetc(input)!='\n');
		return(0);
		}
	if (c=='\n') return(0);
	while ((c==' ') || (c=='\t')) c=fgetc(input);	
	output[0]=c;
	a=1;
	do {
		c=fgetc(input);
		output[a]=c;
		a++;
		} while((a<LINE_SIZE) && (c!='\n') && (!feof(input))); 
	a--;
	output[a]=0;
	return(a);
}


char *caps(char* var1)
{
	int a;
	char var[WORD_SIZE];
	strcpy(var, var1);
	for (a=0; a<strlen(var); a++) if (var[a]>=97) var[a]-=97-65;
	return(var);
}
		
