static const char AUTHOR[] = "@(#)$Id: readhead.c,v 1.2 1999/09/24 00:04:36 rk Exp $";
#include <stdio.h>
#include <string.h>
#include "reflex.h"
/*
 *********************************************************************
 *
 *     This software is copyrighted by R.K.Owen,Ph.D. 1995
 *
 * The author, R.K.Owen, of this software is not liable for any
 * problems WHATSOEVER which may result from use  or  abuse  of
 * this software. The author, R.K.Owen, grants unlimited rights
 * to anyone who uses and modifies this  software  for  private
 * non-commercial  use  as  long  as  this copyright and rights
 * notice remains in this software and is made available to all
 * recipients of this software.
 *
 * last known email: rk@owen.sj.ca.us
 *                   libreflex@kooz.sj.ca.us
 *
 *********************************************************************
 */

/* Specially defined constants */
const char *SectionNameStr[NUM_SECTIONS] = {
	"FieldDir",	"MasterRec",	"DataRecs",	"GFilter",
	"GMode",	"OverVec",	"ViewState",	"ViewScale",
	"FormView",	"ListView",	"CrossTab",	"GraphView"};

const int2 Sections[NUM_SECTIONS] = {
	2, 9, 1, 17, 11, 21, 5, 24, 12, 13, 14, 15
};

const char *DataFields[6] = {
	"Untyped", "Text", "Repeating Text", "Date", "Numeric", "Integer"
};

/* THE routine that must be called */

int ReadReflexHeader(FILE *In, RefHeader *H, char *ErrMsg) {
	size_t sum = 0;
	int i;

	rewind(In);
	memset(H, 0, sizeof(RefHeader));
#if 0
	BlocksRead = fread(H, 1, sizeof(RefHeader), In);
	if (BlocksRead != sizeof(RefHeader)) {
		(void) strcpy(ErrMsg,
		"ReadReflexHeader: The Reflex File Header is the wrong size");
		return -1;
	}
#else
	/* because of "holes" in data structs must read member at a time */
	sum += sizeof(H->HdrSz) * fread(&(H->HdrSz), sizeof(H->HdrSz), 1, In);
	sum += fread(&(H->Stamp), sizeof(char), 12, In);
	sum += sizeof(H->Dirty) * fread(&(H->Dirty), sizeof(H->Dirty), 1, In);
	sum += sizeof(H->VerViews) * fread(&(H->VerViews), sizeof(H->VerViews), 1, In);
	sum += sizeof(H->VerModels) * fread(&(H->VerModels), sizeof(H->VerModels), 1, In);
	sum += sizeof(H->VerData) * fread(&(H->VerData), sizeof(H->VerData), 1, In);
	sum += sizeof(H->fRecalc) * fread(&(H->fRecalc), sizeof(H->fRecalc), 1, In);
	sum += fread(&(H->ScreenType), sizeof(uchar), 1, In);
	sum += fread(&(H->CheckSum), sizeof(uchar), 1, In);
	sum += fread(&(H->Reserved), sizeof(uchar), 38, In);
	sum += sizeof(H->SectionCt) * fread(&(H->SectionCt), sizeof(H->SectionCt), 1, In);
	for (i = 0; i < 44; ++i) {
	sum += sizeof(H->DfSection[i].SectionType) * fread(&(H->DfSection[i].SectionType), sizeof(H->DfSection[i].SectionType), 1, In);
	sum += sizeof(H->DfSection[i].SectionAddr) * fread(&(H->DfSection[i].SectionAddr), sizeof(H->DfSection[i].SectionAddr), 1, In);
	sum += sizeof(H->DfSection[i].SectionLen) * fread(&(H->DfSection[i].SectionLen), sizeof(H->DfSection[i].SectionLen), 1, In);
	}
	sum += fread(&(H->buffer), sizeof(char), 6, In);
	if (sum != H->HdrSz) {
		(void) strcpy(ErrMsg,
		"ReadReflexHeader: The Reflex File Header is the wrong size");
		return -1;
	}
#endif
	if (strncmp(H->Stamp, "3Q.!&@#$!&&" , 12)) {
		(void) strcpy(ErrMsg,
		"ReadReflexHeader: Not Reflex File Header - wrong stamp");
		return -1;
	}
	return 0;
}
