/* rdata.c
 *	dumps out a REFLEX RXD file field names to stdout
 */

static const char AUTHOR[] = "@(#)$Id: rdata.c,v 1.2 1999/09/24 00:04:36 rk Exp $";
#include <stdio.h>
#include "reflex.h"
/*
 *********************************************************************
 *
 *     This software is copyrighted by R.K.Owen,Ph.D. 1996
 *
 * The author, R.K.Owen, of this software is not liable for any
 * problems WHATSOEVER which may result from use  or  abuse  of
 * this software. The author, R.K.Owen, grants unlimited rights
 * to anyone who uses and modifies this  software  for  private
 * non-commercial  use  as  long  as  this copyright and rights
 * notice remains in this software and is made available to all
 * recipients of this software.
 *
 * last known email: rk@owen.sj.ca.us
 *                   libreflex@kooz.sj.ca.us
 *
 *********************************************************************
 */

extern int errno;
char Delimiter = '\0';

#define MAXERRBUF	1024

/*----------------------------------------------------------------------*/

void DumpDRf(FILE *out, int num, char **FNvec, FieldDesc **FDvec,
		VarLenBuf **RepTPvec, VarLenBuf *D) {
	char ErrMsg[200];
	char format[6][20] = {
		"",		/* Untyped */
		"\"%s\"",	/* LocalText */
		"\"%s\"",	/* RepText */
		"%m/%d/%Y",	/* Date */
		"%g",		/* Numeric */
		"%d"};		/* intval */
	char *fptr;
	char *optr;
	int i = 0;

	while (FNvec[i] != (char *) NULL) {
		fptr = format[FDvec[i]->DataType];
		optr = OutputDataType(fptr, FDvec[i], RepTPvec, D, ErrMsg);
		if (optr != (char *) NULL) (void) fprintf(out, "%s", optr);
		++i;
		if (FNvec[i] != (char *) NULL) {
			if (Delimiter) {
				(void) printf("%c", Delimiter);
			} else {
				(void) printf(",");
			}
		} else {
			(void) printf("\n");
		}
	}
}

/*----------------------------------------------------------------------*/

void usage(char *PrgNm) {
	(void) fprintf(stderr,
"%s - dumps a REFLEX data file to stdout in a CSV format\n"
"\n"
"usage: %s [-h][-dC][--] reflex_file.rxd [...] \n"
"where\n"
"	-h	this helpful info\n"
"	-dC	use character 'C' as a delimiter instead of a CSV format\n"
"	--	stop option parsing (useful if filenames begin with '-')\n"
"\n",
			PrgNm, PrgNm);
}

int main(int argc, char **argv) {
	char *ProgName;
	FILE *ReflexFile;
	char *FileName;
	char ErrMessage[MAXERRBUF];
	RefHeader *ReflexFileHeader;
	char **FNvec;
	FieldDesc **FDvec;
	int FNnum, RECnum;
	VarLenBuf **RepTPvec;
	VarLenBuf **DataRecsVec;
	int HeadFlag = 0;
	int DashFlag = 0;
	int i;

	ProgName = *argv++;
	if (*argv == (char *) NULL) {
		usage(ProgName);
		return 1;
	}
/* cycle through commandline list */
	while ((FileName = *argv++) != (char *) NULL) {

/* check for option */
		if (!DashFlag && *FileName == '-') {
			FileName++;
			if (*FileName == '-') {
				DashFlag = 1;
				continue;
			} else if (*FileName == 'h' || *FileName == 'H') {
				HeadFlag = 1;
			} else if (*FileName == 'd' || *FileName == 'D') {
				FileName++;
				Delimiter = *FileName;
				if (Delimiter == 0) {
					usage(ProgName);
					return 2;
				}
			}
			continue;
		}
/* open file */
		if ((ReflexFile = fopen(FileName,"r")) == (FILE *) NULL) {
			(void) sprintf(ErrMessage,
				"%s - Could not open '%s'",
				ProgName, FileName);
			perror(ErrMessage);
		}
/* read & dump reflex file into vectors */
		if (BuildReflex(ReflexFile, &ReflexFileHeader, &FNvec,
		&FNnum, &FDvec, &RepTPvec, &DataRecsVec, &RECnum,
		ErrMessage)) {
			(void) fprintf(stderr,"%s : %s for '%s'\n",
				ProgName, ErrMessage, FileName);
			continue;
		}

/* dump out records */
		for (i = 0; i < RECnum; ++i) {
			DumpDRf(stdout, i, FNvec, FDvec, RepTPvec,
			DataRecsVec[i]);
		}

		QuitReflex(&ReflexFileHeader, &FNvec, &FDvec, &RepTPvec,
			&DataRecsVec);

		(void) fclose(ReflexFile);
	}
	return 0;
}
