static const char AUTHOR[] = "@(#)$Id: bldreflex.c,v 1.1 1999/09/24 00:04:36 rk Exp $";
#include <stdio.h>
#include "reflex.h"
/*
 *********************************************************************
 *
 *     This software is copyrighted by R.K.Owen,Ph.D. 1996
 *
 * The author, R.K.Owen, of this software is not liable for any
 * problems WHATSOEVER which may result from use  or  abuse  of
 * this software. The author, R.K.Owen, grants unlimited rights
 * to anyone who uses and modifies this  software  for  private
 * non-commercial  use  as  long  as  this copyright and rights
 * notice remains in this software and is made available to all
 * recipients of this software.
 *
 * last known email: rk@owen.sj.ca.us
 *                   libreflex@kooz.sj.ca.us
 *
 *********************************************************************
 */

int BuildReflex(FILE *ReflexFile, RefHeader **ReflexFileHeader,
	char ***FNvec, int *FNnum, FieldDesc ***FDvec, VarLenBuf ***RepTPvec,
	VarLenBuf ***DataRecsVec, int *RECnum, char *ErrMsg) {

	if (BuildReflexHeader(ReflexFile, ReflexFileHeader, ErrMsg)) {
		(void) PasteMessage("BuildReflex : ", ErrMsg);
		return -1;
	}

	if (BuildFieldNameVec(ReflexFile, *ReflexFileHeader,
		FNnum, FNvec, FDvec, RepTPvec, ErrMsg)) {
		(void) PasteMessage("BuildReflex : ", ErrMsg);
		return -1;
	}

	if (BuildMasterRecord(ReflexFile, *ReflexFileHeader, RECnum, ErrMsg)) {
		(void) PasteMessage("BuildReflex : ", ErrMsg);
		return -1;
	}

	if (DataRecsVec != (VarLenBuf ***) NULL) {
		if (BuildDataRecordsVec(ReflexFile, *ReflexFileHeader,
			*RECnum, DataRecsVec, ErrMsg)) {
			(void) PasteMessage("BuildReflex : ", ErrMsg);
			return -1;
		}
	}

	return 0;
}
