static const char AUTHOR[] = "@(#)$Id: bldmr.c,v 1.2 1999/09/24 00:04:36 rk Exp $";
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "reflex.h"
/*
 *********************************************************************
 *
 *     This software is copyrighted by R.K.Owen,Ph.D. 1995
 *
 * The author, R.K.Owen, of this software is not liable for any
 * problems WHATSOEVER which may result from use  or  abuse  of
 * this software. The author, R.K.Owen, grants unlimited rights
 * to anyone who uses and modifies this  software  for  private
 * non-commercial  use  as  long  as  this copyright and rights
 * notice remains in this software and is made available to all
 * recipients of this software.
 *
 * last known email: rk@owen.sj.ca.us
 *                   libreflex@kooz.sj.ca.us
 *
 *********************************************************************
 */

extern int errno;

int BuildMasterRecord(FILE *ReflexFile, RefHeader *ReflexFileHeader,
	int *RECc, char *ErrMsg) {
/* Gets the Master Record and returns the number of records */
/* ... assumes nothing about file position */

	long4 SecAddr, SecLen;
	int2 Num, Filter;	/* Master Record structure */

/* Get Master Record address from Header */
	if (GetSectionAddr(ReflexFileHeader, MasterRec, &SecAddr, &SecLen,
		ErrMsg)) {
		(void) PasteMessage("BuildMasterRecord : ", ErrMsg);
		return -1;
	}
	if (fseek(ReflexFile, SecAddr, SEEK_SET)) {
		(void) strcpy(ErrMsg, "BuildMasterRecord : fseek error :");
		(void) strcat(ErrMsg, strerror(errno));
		return -1;
	}
	if (fread(&Num, sizeof(int2), 1, ReflexFile) != 1) {
		(void) strcpy(ErrMsg, "BuildMasterRecord : fread Num error");
		return -1;
	}
	*RECc = (int) Num;
	/* unnecessary, but done for completeness */
	if (fread(&Filter, sizeof(int2), 1, ReflexFile) != 1) {
		(void) strcpy(ErrMsg, "BuildMasterRecord : fread Filter error");
		return -1;
	}

	return 0;
}
