static const char AUTHOR[] = "@(#)$Id: blddrvec.c,v 1.2 1999/09/24 00:04:36 rk Exp $";
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "reflex.h"
/*
 *********************************************************************
 *
 *     This software is copyrighted by R.K.Owen,Ph.D. 1995
 *
 * The author, R.K.Owen, of this software is not liable for any
 * problems WHATSOEVER which may result from use  or  abuse  of
 * this software. The author, R.K.Owen, grants unlimited rights
 * to anyone who uses and modifies this  software  for  private
 * non-commercial  use  as  long  as  this copyright and rights
 * notice remains in this software and is made available to all
 * recipients of this software.
 *
 * last known email: rk@owen.sj.ca.us
 *                   libreflex@kooz.sj.ca.us
 *
 *********************************************************************
 */

extern int errno;

int BuildDataRecordsVec(FILE *ReflexFile, RefHeader *ReflexFileHeader,
	int RECc, VarLenBuf ***Dvec, char *ErrMsg) {
/* Gets the Data Records */
/* ... assumes nothing about file position */

	long4 SecAddr, SecLen;
	int i;

/* Get Data Record address from Header */
	if (GetSectionAddr(ReflexFileHeader, DataRecs, &SecAddr, &SecLen,
		ErrMsg)) {
		(void) PasteMessage("BuildDataRecordsVec : ", ErrMsg);
		return -1;
	}
	/* note that must skip the first 2 bytes */
	if (fseek(ReflexFile, SecAddr + 2, SEEK_SET)) {
		(void) strcpy(ErrMsg, "BuildDataRecordsVec : fseek error :");
		(void) strcat(ErrMsg, strerror(errno));
		return -1;
	}

	/* get Dvec memory space set up */
	if ((*Dvec = (VarLenBuf **) malloc((RECc + 1) * sizeof(VarLenBuf *)))
		== (VarLenBuf **) NULL) {
		(void) strcpy(ErrMsg, "BuildDataRecordsVec : Dvec* malloc error");
		return -1;
	}
	for (i = 0; i < RECc; ++i) {
		if (((*Dvec)[i] = (VarLenBuf *) malloc(
			sizeof(VarLenBuf))) == (VarLenBuf *) NULL) {
			(void) strcpy(ErrMsg,
				"BuildDataRecordsVec : Dvec malloc error");
			return -1;
		}
		if (BuildBuffer(ReflexFile, (*Dvec)[i], ErrMsg)) {
			(void) PasteMessage(
				"BuildDataRecordsVec : Dvec read error : ",
				ErrMsg);
			return -1;
		}
	}
	(*Dvec)[RECc] = (VarLenBuf *) NULL;

	return 0;
}
