#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/sem.h>
#include <assert.h>
#include "kernel/config.h"

#ifdef _SEM_SEMUN_UNDEFINED
union semun {
	int val;
	struct semid_ds *buf;
	unsigned short int *array;
	void *__buf;
};
#endif

//
// It's better to assert and fail on semaphore failures than corrupt
// the database. Assertions here will be checked before calls to kernel/
// Even after permanent semaphores damage, lndbase can be killed and
// the data can be retrieved from the temporiaries.
//
#ifdef MULTITHREADED
extern int Semaphore;
#define READ_SEM 0
#define WRITE_SEM 1
#define CLIENT_SEM 2
#define SYNC_RTW {\
	if (max_clients > 1) {\
	sem_operation.sem_op = -1;\
	sem_operation.sem_num = WRITE_SEM;\
	assert (semop (Semaphore, &sem_operation, 1) == 0);\
	sem_operation.sem_op = -MRC;\
	sem_operation.sem_num = READ_SEM;\
	assert (semop (Semaphore, &sem_operation, 1) == 0); } }
#define SYNC_WF {\
	if (max_clients > 1) {\
	sem_operation.sem_op = 1;\
	sem_operation.sem_num = WRITE_SEM;\
	assert (semop (Semaphore, &sem_operation, 1) == 0);\
	sem_operation.sem_op = MRC;\
	sem_operation.sem_num = READ_SEM;\
	assert (semop (Semaphore, &sem_operation, 1) == 0); } }
#define SYNC_SR {\
	if (max_clients > 1) {\
	sem_operation.sem_op = -1;\
	sem_operation.sem_num = WRITE_SEM;\
	assert (semop (Semaphore, &sem_operation, 1) == 0);\
	sem_operation.sem_op = 1;\
	sem_operation.sem_num = WRITE_SEM;\
	assert (semop (Semaphore, &sem_operation, 1) == 0);\
	sem_operation.sem_op = -1;\
	sem_operation.sem_num = READ_SEM;\
	assert (semop (Semaphore, &sem_operation, 1) == 0); } }
#define SYNC_RF {\
	if (max_clients > 1) {\
	sem_operation.sem_op = 1;\
	sem_operation.sem_num = READ_SEM;\
	assert (semop (Semaphore, &sem_operation, 1) == 0); } }
#define SYNC_CLI {\
	sem_operation.sem_op = -1;\
	sem_operation.sem_num = CLIENT_SEM;\
	assert (semop (Semaphore, &sem_operation, 1) == 0); }
#define SYNC_CF {\
	sem_operation.sem_op = 1;\
	sem_operation.sem_num = CLIENT_SEM;\
	assert (semop (Semaphore, &sem_operation, 1) == 0); }

#else
#define SYNC_RTW ;
#define SYNC_CLI ;
#define SYNC_SR ;
#define SYNC_WF ;
#define SYNC_RF ;
#define SYNC_CF ;
#endif
