/******************************************************************************

	sync.c

	Use SYS V IPC semaphores to synchronize between threads.

******************************************************************************/
#include <stdlib.h>
#include <stdio.h>
#include "sync.h"

int Semaphore;

#define START_KEY 1234

void init_sync ()
{
	union semun smun;
	key_t k;

	for (k = START_KEY; k < START_KEY + 100 &&
	    (Semaphore = semget (k, 3, 0600 | IPC_CREAT)) == -1; k++);

	if (Semaphore == -1)
	{
		perror ("Creating semaphore");
		exit (1);
	}

	smun.val = MRC;
	if (semctl (Semaphore, READ_SEM, SETVAL, smun) == -1)
	{
		perror ("semctl");
		exit (1);
	}

	smun.val = 1;
	if (semctl (Semaphore, WRITE_SEM, SETVAL, smun) == -1
	|| semctl (Semaphore, CLIENT_SEM, SETVAL, smun) == -1)
	{
		perror ("semctl");
		exit (1);
	}
}

void term_sync ()
{
	union semun smun;

	semctl (Semaphore, 0, IPC_RMID, smun);
}
