/*****************************************************************************
	parser.c

	Our simple command line parser.

*****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "kernel/config.h"

#define TYPE_BOOL 0
#define TYPE_INT 1
#define TYPE_STRING 2

#define DFLT_DATADIR "/.lndbase/"
#define DFLT_MFIFO "mfifo"
#define DFLT_PORT 838
#define DFLT_MAXCLIENTS 100

char *main_fifo;
unsigned int max_clients, denywrite;
int read_only;
char *lndb_home, *datafile, *groupfile, *linkfile;

#define OPTNUM sizeof options / sizeof (struct option)

int parser (int argc, char **argv)
{
	extern char *user_pass;
	extern void init (int, int, unsigned int, char*);
	extern void socket_tcp (short int), socket_unix (char*);

	int displ = 0;
	short int port, thresh = CWT;
	char *rpat = NULL;
	struct option {
		char *opt_name;
		int type;
		int invoked;
		union {
			void *vd;
			char **str;
			unsigned int *num;
		} val_un; 
	} options [] = {
		"-d", TYPE_STRING, 0, &lndb_home,
		"-s", TYPE_BOOL, 0, NULL,
		"-t", TYPE_INT, 0, (unsigned int*)&port,
		"-f", TYPE_STRING, 0, &main_fifo,
		"-m", TYPE_INT, 0, (unsigned int*)&max_clients,
		"-a", TYPE_BOOL, 0, NULL,
		"-p", TYPE_STRING, 0, &user_pass,
		"-C", TYPE_BOOL, 0, NULL,
		"-th", TYPE_INT, 0, &thresh,
		"-ro", TYPE_BOOL, 0, NULL,
		"-u", TYPE_STRING, 0, &main_fifo,
		"-reserve", TYPE_INT, 0, &displ,
		"-rstr", TYPE_STRING, 0, &rpat,
		"-dw", TYPE_INT, 0, &denywrite,
		"-Cx", TYPE_BOOL, 0, NULL
	};
	int i, j;

	port = DFLT_PORT;
	main_fifo = DFLT_MFIFO;
	max_clients = DFLT_MAXCLIENTS;

	for (i = 0; i < argc; i++)
	{
		for (j = 0; j < OPTNUM; j++)
			if (!strcmp (argv [i], options [j].opt_name))
				break;

		if (j == OPTNUM)
		{
			fprintf (stderr, "Unknown option %s\n", argv [i]);
			exit (1);
		}
		options [j].invoked = 1;
		if (options [j].type == TYPE_BOOL)
			continue;
		++i;
		if (i == argc)
		{
			fprintf (stderr, "Incomplete option %s\n",
				 argv [i - 1]);
			exit (1);
		}
		if (options [j].type == TYPE_INT)
			*(options [j].val_un.num) = atoi (argv [i]);
		else
			*(options [j].val_un.str) = argv [i];
	}

	i = options [1].invoked + options [2].invoked + options [3].invoked
	   + options [10].invoked;

	if (options [1].invoked)
		max_clients = 1;

	if (i != 1)
	{
		fputs ("One operation mode from -s, -t, -f, -u "
		       "must be selected!\n", stderr);
		exit (1);
	}
	if (thresh >= BIG_ELEMENT)
		thresh = BIG_ELEMENT - 1;

	read_only = (options [9].invoked);

	if (lndb_home == NULL)
	{
		lndb_home = (char*) malloc (strlen (getenv ("HOME"))
					    + strlen (DFLT_DATADIR) + 1);
		sprintf (lndb_home, "%s" DFLT_DATADIR, getenv ("HOME"));
	}
	if (lndb_home [strlen (lndb_home) - 1] != '/')
	{
		char *pp = (char*) malloc (strlen (lndb_home) + 2);
		strcat (strcpy (pp, lndb_home), "/");
		lndb_home = pp;
	}

	if (options [2].invoked)
		socket_tcp (port);
	else if (options [10].invoked)
		socket_unix (main_fifo);

	if (options [14].invoked || options [7].invoked)
	{
		int rr = (options [14].invoked) ? 'y' : '?';
		while (rr != 'y' && rr != 'n')
		{
			printf ("WARNING! The '-C' option will result in"
				" new datafiles created. Any existing data in"
				" %s* datafiles shall be lost!\n"
				"Are you sure (y/n)?", lndb_home);
			rr = fgetc (stdin);
		}
		if (rr == 'n') exit (0);
		init (1, 10, displ, rpat);
	}
	else init (0, thresh, displ, rpat);

	return options [1].invoked + 2 * options [2].invoked + 3 * options [3].invoked + 2 * options [10].invoked;
}
