#include "kernel/global.h"

typedef struct x
{
	Group *cwd;
	int sue;
	FILE *reply, *readf;
	struct x *prev, *next;
} client_params;

extern client_params *first_client, *last_client;

extern int LNDB_links	(unsigned int, client_params*);
extern int LNDB_sh	(unsigned int, client_params*);
extern int LNDB_find	(char*, client_params*);
extern int LNDB_dir	(char*, client_params*);
extern int LNDB_cd	(char*, client_params*);
extern int LNDB_pwd	(client_params*);
extern int LNDB_locate	(char *[], char*, unsigned int, char*, client_params*);
extern int LNDB_lenof	(unsigned int, client_params*);
extern int LNDB_groupof	(unsigned int, client_params*);
extern int LNDB_ls	(char*, client_params*);
extern int LNDB_nls	(char*, client_params*);
extern int LNDB_link	(unsigned int, unsigned int, short int, client_params*);
extern int LNDB_unlink	(unsigned int, unsigned int, client_params*);
extern int LNDB_new	(char*, unsigned int, client_params*);
extern int LNDB_nlinks	(unsigned int, client_params*);
extern int LNDB_alt	(unsigned int, char*, unsigned int, client_params*);
extern int LNDB_idof	(char*, unsigned int, client_params*);
extern int LNDB_typesof	(unsigned int, client_params*);
extern int LNDB_del	(unsigned int, client_params*);
extern int LNDB_chgrp	(unsigned int, char*, client_params*);
extern int LNDB_mkgrp	(char*, client_params*);
extern int LNDB_rengrp	(char*, char*, client_params*);
extern int LNDB_rmgrp	(char*, client_params*);
extern int LNDB_set	(unsigned int, const char*, client_params*);
extern int LNDB_unset	(unsigned int, const char*, client_params*);
extern int LNDB_stats	(client_params*);
extern int LNDB_save	(client_params*);
extern int LNDB_vlink	(unsigned int, unsigned int, client_params*);
extern int LNDB_glinks	(unsigned int, char*, client_params*);
