#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_LINE 100

char *user_pass, *sue_pass;

static void get_auth (char *line, char *st, char **dst)
{
	if (*dst) return;
	if (!strncmp (line, st, strlen (st)))
	{
		*dst = (char*) malloc (strlen (line) - strlen (st));
		line [strlen (line) - 1] = 0;
		strcpy (*dst, line + strlen (st));
	}
}

void init_auth (char *auth_file)
{
	FILE *f;
	char tmp [MAX_LINE];

	user_pass = sue_pass = NULL;

	if (!(f = fopen (auth_file, "r")))
	{
		perror ("fopen");
		fprintf (stderr, "Can't open passwd file %s\n", auth_file);
		exit (1);
	}

	while (!feof (f))
		if (fgets (tmp, MAX_LINE, f))
		{
			get_auth (tmp, "user: ", &user_pass);
			get_auth (tmp, "sue: ", &sue_pass);
		}

	if (!sue_pass)
		fprintf (stderr, "No password specified for user with "
			 "permission to modify the database (sue)!\n");

	fclose (f);
}
