/******************************************************************************

	digest.c

	An http-digest-authentication like scheme.
	Much more secure than sending the password in plaintext.

******************************************************************************/

#include <sys/time.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "md5.h"

#define MD5_CTX struct md5_ctx
#define MD5Init md5_init_ctx
#define MD5Update md5_process_bytes
#define MD5Final md5_finish_ctx

#define MAX_LINE 100

#define MD5_DIGEST(xx) \
	MD5Init (&context);\
	MD5Update (line, strlen (line), &context);\
	MD5Final (&context, CTX);\
	for (xx [0] = 0, i = 0; i < 16; i++)\
	{\
		sprintf (tmp, "%02x", CTX [i]);\
		strcat (xx, tmp);\
	}

static void make_realm (char *c)
{
	char cc [5];
	int i;

	for (i = 0; i < 4; i++)
		cc [i] = (char) (rand () % 64 + 32);
	cc [4] = 0;
	sprintf (c, "%lu%s", time (NULL), cc);
}

/*
 * Return 1 if authentication ok.
 */
int auth (int user, FILE *getclient, FILE *sendclient)
{
	extern char *user_pass, *sue_pass;
	char line [MAX_LINE], realm [10], digested [33], tmp [8];
	char *pass = (user) ? sue_pass : user_pass;
	unsigned char CTX [16];
	int i;
	MD5_CTX context;

	if (!pass) return 1;

	make_realm (realm);
	fprintf (sendclient, "MD5 Digest authentication.\nRealm: %s\n", realm);
	sprintf (line, "%s%s", pass, realm);
	MD5_DIGEST(digested);

	fputs ("* 9 Authorization Expected\n", sendclient);

	if (!fgets (line, MAX_LINE, getclient))
		return 0;

	/* Avoid long lines */
	if (line [strlen (line) - 1] != '\n')
	{
		do fgets (line, MAX_LINE, getclient);
		while (strlen (line) > 0 && line [strlen (line) - 1] != '\n');
		return 0;
	}

	line [strlen (line) - 1] = 0;

	return strcmp (digested, pass) == 0;
}
