#include <sys/socket.h>
#include <stdio.h>
#include <stdlib.h>
#include "common.h"

extern int connectlnsh ();

int main (int argc, char **argv)
{
	FILE *f;
	char reply [100];
	unsigned int id;

	switch (argc) {
	case 1:
		fputs ("No arguments!\n", stderr);
		return 1;
	case 2:
		id = 1;
		break;
	case 3:
		sprintf (reply, LNSH_CD " > /dev/null", argv [1]);
		if (system (reply) != 0)
		{
			fprintf (stderr, "Changing to group: %s failed\n",
				 argv [1]);
			return 1;
		}
		id = 2;
		break;
	default:
		fputs ("More than two arguments.\n"
		       "The usage is: lnshnew [[GROUP] STRING]\n", stderr);
		return 1;
	}

	if (strlen (argv [id]) == 0)
		return 1;

	f = fdopen (connectlnsh (), "r+");
	fprintf (f, "newcl %u\n%s\n", strlen (argv [id]), argv [id]);
	fflush (f);

	if (!fgets (reply, 100, f))
	{
		perror ("new:fgets");
		return 1;
	}
	if (reply [0] == '-')
	{
		fprintf (stderr, "Failure reply: %s", reply);
		return 1;
	}
	id = atoi (reply);
	fgets (reply, 100, f);
	if (reply [0] == '-')
	{
		fprintf (stderr, "An element with this content already exists "
			"with id: %u\n", id);
		return 1;
	}
	printf ("%u\n", id);

	return 0;
}
